/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.vo;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.TaxLogMaterialLineDto;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlog.TaxLogService;
import kd.taxc.bdtaxr.common.refactor.tax.utils.TaxCalLoggerUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.TaxLogUtils;

public class BillTaxVo {
    private long orgId;
    private long country;
    private Date date;
    private String currentBillKey;
    private String billKey;
    private long billId;
    private String taxBillEntryKey;
    private String entrySourceKey;
    private String billEntryKey;
    private DynamicObject dos;
    private String entityNumber;
    private Map<String, DynamicObjectCollection> sourceData;
    private DynamicObject taxBillEntry;
    private TaxCalLoggerUtils logger;
    private String taxcodeProperty;
    private AtomicInteger atomicInteger = new AtomicInteger(0);
    private TaxLogService taxLogService;

    public BillTaxVo(long orgId, long country, Date date, String billKey, long billId, String taxBillEntryKey, String entrySourceKey, String billEntryKey, DynamicObject dos, Map<String, DynamicObjectCollection> sourceData, String taxcodeProperty, String currentBillKey, TaxLogService taxLogService) {
        this.orgId = orgId;
        this.country = country;
        this.date = date;
        this.billKey = billKey;
        this.billId = billId;
        this.taxBillEntryKey = taxBillEntryKey;
        this.entrySourceKey = entrySourceKey;
        this.billEntryKey = billEntryKey;
        this.dos = dos;
        this.entityNumber = dos.getDataEntityType().getName();
        this.sourceData = sourceData;
        this.taxcodeProperty = taxcodeProperty;
        this.currentBillKey = currentBillKey;
        this.taxLogService = taxLogService;
        this.logger = new TaxCalLoggerUtils();
    }

    public long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public long getCountry() {
        return this.country;
    }

    public void setCountry(long country) {
        this.country = country;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getBillKey() {
        return this.billKey;
    }

    public String getTaxBillEntryKey() {
        return this.taxBillEntryKey;
    }

    public DynamicObject getDos() {
        return this.dos;
    }

    public void setDos(DynamicObject dos) {
        this.dos = dos;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public Map<String, DynamicObjectCollection> getSourceData() {
        return this.sourceData;
    }

    public DynamicObject getTaxBillEntry() {
        return this.taxBillEntry;
    }

    public void setTaxBillEntry(DynamicObject taxBillEntry) {
        this.taxBillEntry = taxBillEntry;
    }

    public TaxCalLoggerUtils getLogger() {
        return this.logger;
    }

    public String getEntrySourceKey() {
        return this.entrySourceKey;
    }

    public String getBillEntryKey() {
        return this.billEntryKey;
    }

    public String getTaxcodeProperty() {
        return this.taxcodeProperty;
    }

    public AtomicInteger getAtomicInteger() {
        return this.atomicInteger;
    }

    public String getCurrentBillKey() {
        return this.currentBillKey;
    }

    public TaxLogMaterialLineDto getTaxLogMaterialLineDto() {
        int total = this.taxLogService.getMaterialLineDtos().size();
        if (total > 0) {
            return this.taxLogService.getMaterialLineDtos().get(total - 1);
        }
        TaxLogMaterialLineDto dto = new TaxLogMaterialLineDto(TaxLogUtils.isCloseWriteLog("uselog"));
        this.taxLogService.getMaterialLineDtos().add(dto);
        return dto;
    }

    public String toString() {
        return "BillTaxVo [orgId=" + this.orgId + ", country=" + this.country + ", date=" + this.date + ", billKey=" + this.billKey + ", billId=" + this.billId + ", taxBillEntryKey=" + this.taxBillEntryKey + ",entrySourceKey=" + this.entrySourceKey + ",billEntryKey=" + this.billEntryKey + ", entityNumber=" + this.entityNumber + ",taxcodeProperty=" + this.taxcodeProperty + "]";
    }
}

