/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.domain.Style;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;

public class SpreadUtils {
    private static Log LOGGER = LogFactory.getLog(SpreadUtils.class);

    public static String getJson(String spreadJson) {
        if (spreadJson.startsWith("base64")) {
            spreadJson = spreadJson.substring(6);
        }
        byte[] bb = Base64.decodeBase64((String)spreadJson);
        byte[] bb2 = SpreadUtils.unCompress(bb);
        return new String(bb2, StandardCharsets.UTF_8);
    }

    private static byte[] unCompress(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            int n;
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return out.toByteArray();
    }

    public static List<Sheet> getSheets(String jsonString, String sheetName) {
        JSONObject json = JSONObject.parseObject((String)jsonString);
        Map<String, Style> styleMap = SpreadUtils.parseStyles(json);
        LinkedHashMap<String, LinkedHashMap> jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString(jsonString);
        return SpreadUtils.getSheetsByTemplateMap(jsonMap, styleMap, sheetName);
    }

    public static List<Sheet> getSheetsByTemplateMap(LinkedHashMap<String, LinkedHashMap> templateMap, Map<String, Style> styleMap, String sheetName) {
        Set<Map.Entry<String, LinkedHashMap>> set = templateMap.entrySet();
        ArrayList<Sheet> sheetList = new ArrayList<Sheet>(set.size());
        if (StringUtils.isNotEmpty((CharSequence)sheetName)) {
            String newName = null;
            int lev = Integer.MAX_VALUE;
            for (Map.Entry<String, LinkedHashMap> entry : templateMap.entrySet()) {
                if (SpreadUtils.isSheetInvisible(entry)) continue;
                String name = (String)entry.getValue().get("name");
                if (sheetName.equalsIgnoreCase(name)) {
                    newName = name;
                    break;
                }
                int length = name.toLowerCase().replace(sheetName.toLowerCase(), "").length();
                if (length >= lev || length >= name.length()) continue;
                lev = length;
                newName = name;
            }
            if (newName != null) {
                sheetName = newName;
            } else {
                return sheetList;
            }
        }
        for (Map.Entry<String, LinkedHashMap> entry : set) {
            if (SpreadUtils.isSheetInvisible(entry)) continue;
            String name = (String)entry.getValue().get("name");
            if (sheetName != null && !sheetName.equals(name)) continue;
            Sheet sheet = SpreadUtils.generateSheet(entry);
            Map<String, Cell> dataMap = SpreadUtils.parseData(sheet, entry, styleMap);
            Map<String, String> collectEntityMap = dataMap.entrySet().stream().filter(v -> StringUtils.isNotBlank(v.getValue()) && StringUtils.isNotBlank((CharSequence)((Cell)v.getValue()).getEntityId())).collect(Collectors.toMap(k -> ((Cell)k.getValue()).getEntityId(), v -> ((Cell)v.getValue()).getEntityId(), (k1, k2) -> k1));
            HashSet<String> existIdSet = new HashSet<String>();
            List<Integer> colWidthList = SpreadUtils.parseColumns(entry, sheet.getColNum());
            sheet.setColWidthList(colWidthList);
            Map<Integer, List<Cell>> rowMap = SpreadUtils.parseSpans(sheet, entry, dataMap, existIdSet);
            for (int i = 0; i < sheet.getRowNum(); ++i) {
                List listCell = rowMap.getOrDefault(i, new ArrayList());
                Collections.sort(listCell, Comparator.comparingInt(Cell::getCol));
                for (int index = 0; index < sheet.getColNum(); ++index) {
                    String id = i + "_" + index;
                    if (existIdSet.contains(id)) continue;
                    Cell cell = dataMap.get(id);
                    if (cell == null) {
                        cell = new Cell();
                    }
                    cell.setSheetId(sheet.getId());
                    cell.setRow(i);
                    cell.setRowCount(1);
                    cell.setCol(index);
                    cell.setColCount(1);
                    listCell.add(cell);
                }
                Collections.sort(listCell, Comparator.comparingInt(Cell::getCol));
                if (listCell.isEmpty()) continue;
                sheet.addRow(listCell);
            }
            sheet.setEntityMap(collectEntityMap);
            sheetList.add(sheet);
        }
        Collections.sort(sheetList, Comparator.comparingInt(Sheet::getIndex));
        return sheetList;
    }

    private static Sheet generateSheet(Map.Entry<String, LinkedHashMap> entry) {
        JSONArray rows;
        Sheet sheet = new Sheet();
        String name = (String)entry.getValue().get("name");
        sheet.setName(name);
        sheet.setIndex(Integer.parseInt(entry.getValue().get("index").toString()));
        sheet.setId(entry.getValue().get("index").toString());
        if (entry.getValue().get("frozenRowCount") != null) {
            sheet.setFrozenRowCount(Integer.parseInt(entry.getValue().get("frozenRowCount").toString()));
        }
        if (entry.getValue().get("frozenColCount") != null) {
            sheet.setFrozenColumnCount(Integer.parseInt(entry.getValue().get("frozenColCount").toString()));
        }
        if ((rows = (JSONArray)entry.getValue().get("rows")) != null) {
            sheet.setRowNum(rows.size());
        }
        return sheet;
    }

    private static Map<Integer, List<Cell>> parseSpans(Sheet sheet, Map.Entry<String, LinkedHashMap> entry, Map<String, Cell> dataMap, Set<String> existIdSet) {
        HashMap<Integer, List<Cell>> rowMap = new HashMap<Integer, List<Cell>>(16);
        JSONArray spans = (JSONArray)entry.getValue().get("spans");
        for (int i = 0; spans != null && i < spans.size(); ++i) {
            JSONObject jon = (JSONObject)spans.get(i);
            Integer row = jon.getInteger("row");
            Integer rowCount = jon.getInteger("rowCount");
            Integer col = jon.getInteger("col");
            Integer colCount = jon.getInteger("colCount");
            Cell cell = dataMap.get(row + "_" + col);
            if (cell == null) {
                cell = new Cell();
            } else {
                cell.setSpan(true);
            }
            cell.setSheetId(sheet.getId());
            cell.setRow(row);
            cell.setRowCount(rowCount);
            cell.setCol(col);
            cell.setColCount(colCount);
            List listCell = rowMap.getOrDefault(row, new ArrayList());
            listCell.add(cell);
            rowMap.put(row, listCell);
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    existIdSet.add(row + rowIndex + "_" + (colIndex + col));
                }
            }
        }
        return rowMap;
    }

    public static List<Cell> getSpanCell(Map.Entry<String, LinkedHashMap> entry) {
        ArrayList<Cell> list = new ArrayList<Cell>();
        JSONArray spans = (JSONArray)entry.getValue().get("spans");
        for (int i = 0; spans != null && i < spans.size(); ++i) {
            JSONObject jon = (JSONObject)spans.get(i);
            Integer row = jon.getInteger("row");
            Integer rowCount = jon.getInteger("rowCount");
            Integer col = jon.getInteger("col");
            Integer colCount = jon.getInteger("colCount");
            Cell cell = new Cell();
            cell.setRow(row);
            cell.setRowCount(rowCount);
            cell.setCol(col);
            cell.setColCount(colCount);
            list.add(cell);
        }
        return list;
    }

    public static Map<Integer, List<Cell>> getDataCell(Map.Entry<String, LinkedHashMap> entry, Map<String, Style> styleMap) {
        LinkedHashMap<Integer, List<Cell>> cellMap = new LinkedHashMap<Integer, List<Cell>>();
        JSONObject data = (JSONObject)entry.getValue().get("data");
        JSONObject dataTable = (JSONObject)data.get((Object)"dataTable");
        if (dataTable != null) {
            Set keySet = dataTable.keySet();
            for (String key : keySet) {
                Integer rownum = SpreadUtils.getInteger(key);
                JSONObject colObject = (JSONObject)dataTable.get((Object)key);
                Set colKeySet = colObject.keySet();
                Iterator colIt = colKeySet.iterator();
                ArrayList<Cell> list = new ArrayList<Cell>(colKeySet.size());
                while (colIt.hasNext()) {
                    String colKey = (String)colIt.next();
                    Integer colNum = SpreadUtils.getInteger(colKey);
                    JSONObject col = (JSONObject)colObject.get((Object)colKey);
                    Object valObj = col.get((Object)"value");
                    Cell cell = new Cell();
                    cell.setRow(rownum);
                    cell.setCol(colNum);
                    if (valObj != null) {
                        SpreadUtils.handleCellRichText(valObj, cell);
                    }
                    SpreadUtils.parseCellStyle(styleMap, cell, col.getString("style"));
                    list.add(cell);
                }
                cellMap.put(rownum, list);
            }
        }
        return cellMap;
    }

    public static Map<String, List<Cell>> getDataCell(Map.Entry<String, LinkedHashMap> entry, Map<String, Style> styleMap, List<String> dynRowList) {
        LinkedHashMap<String, List<Cell>> cellMap = new LinkedHashMap<String, List<Cell>>();
        JSONObject data = (JSONObject)entry.getValue().get("data");
        JSONObject dataTable = (JSONObject)data.get((Object)"dataTable");
        if (dataTable != null) {
            JSONArray comments = (JSONArray)entry.getValue().get("comments");
            HashMap commentsMap = EmptyCheckUtils.isNotEmpty(comments) ? comments.stream().map(a -> (JSONObject)a).collect(Collectors.toMap(a -> a.get((Object)"rowIndex") + "_" + a.get((Object)"colIndex"), b -> (String)b.get((Object)"text"))) : new HashMap(0);
            List keyList = dataTable.keySet().stream().map(TemplateShowUtils::getInteger).sorted().collect(Collectors.toList());
            for (Integer key : keyList) {
                int rownum = key;
                JSONObject colObject = (JSONObject)dataTable.get((Object)key.toString());
                Set colKeySet = colObject.keySet();
                Iterator colIt = colKeySet.iterator();
                ArrayList<Cell> list = new ArrayList<Cell>(colKeySet.size());
                String dynamicRowNo = null;
                while (colIt.hasNext()) {
                    String colKey = (String)colIt.next();
                    Integer colNum = SpreadUtils.getInteger(colKey);
                    JSONObject col = (JSONObject)colObject.get((Object)colKey);
                    Object valObj = col.get((Object)"value");
                    Cell cell = new Cell();
                    cell.setRow(rownum);
                    cell.setCol(colNum);
                    if (commentsMap.containsKey(rownum + "_" + colNum)) {
                        cell.setComment((String)commentsMap.get(rownum + "_" + colNum));
                    }
                    if (valObj != null) {
                        String dynRowNo;
                        String content = valObj.toString();
                        if (content.startsWith("${") && content.endsWith("}") && dynRowList.contains(dynRowNo = content.substring(2, content.lastIndexOf(35)))) {
                            dynamicRowNo = dynRowNo;
                        }
                        SpreadUtils.handleCellRichText(valObj, cell);
                    }
                    SpreadUtils.parseCellStyle(styleMap, cell, col.getString("style"));
                    list.add(cell);
                }
                if (StringUtils.isNotBlank(dynamicRowNo)) {
                    int colNum = colKeySet.size();
                    Cell cell = new Cell();
                    cell.setRow(rownum);
                    cell.setCol(colNum);
                    cell.setText("dynRow#" + dynamicRowNo);
                    list.add(cell);
                    cellMap.put("dynRow#" + rownum, list);
                    continue;
                }
                cellMap.put(rownum + "", list);
            }
        }
        return cellMap;
    }

    public static void parseCellStyle(Map<String, Style> styleMap, Cell cell, String style) {
        if (style != null && null != cell) {
            cell.setStyle(styleMap.get(style));
            try {
                if (cell.getStyle() == null) {
                    JSONObject jj = JSON.parseObject((String)style);
                    Style style1 = new Style();
                    style1.sethAlign(jj.getInteger("hAlign"));
                    style1.setvAlign(jj.getInteger("vAlign"));
                    style1.setLocked(jj.getBoolean("locked"));
                    style1.setFormatter(jj.getString("formatter"));
                    style1.setFont(jj.getString("font"));
                    style1.setBorderRight((Map)jj.get((Object)"borderRight"));
                    style1.setBorderLeft((Map)jj.get((Object)"borderLeft"));
                    style1.setBorderTop((Map)jj.get((Object)"borderTop"));
                    style1.setBorderBottom((Map)jj.get((Object)"borderBottom"));
                    style1.setBackColor(jj.getString("backColor"));
                    style1.setForeColor(jj.getString("foreColor"));
                    cell.setStyle(style1);
                }
            }
            catch (Exception e) {
                LOGGER.error("getDataCell style json parse error" + e);
            }
        }
    }

    public static void handleCellRichText(Object valObj, Cell cell) {
        if (null != valObj && null != cell) {
            String content = valObj.toString();
            if ((content = StringUtil.escapeText(content)).contains("richText") && content.contains("text")) {
                try {
                    Map map = JsonUtil.fromJson(content, Map.class);
                    cell.setText(StringUtils.isNotBlank(map.get("text")) ? map.get("text").toString() : null);
                }
                catch (Exception e) {
                    LOGGER.error("parseData parse cell content error:" + e);
                }
            } else {
                cell.setText(content);
            }
        }
    }

    public static List<Integer> parseColumns(Map.Entry<String, LinkedHashMap> entry, int colNums) {
        ArrayList<Integer> dataMap = new ArrayList<Integer>();
        JSONArray columns = (JSONArray)entry.getValue().get("columns");
        for (int i = 0; columns != null && i < columns.size() && i < colNums; ++i) {
            JSONObject jon = (JSONObject)columns.get(i);
            Integer size = 1;
            if (jon != null && jon.getInteger("size") != null && (size = jon.getInteger("size")) < 0) {
                size = 1;
            }
            dataMap.add(size);
        }
        return dataMap;
    }

    private static Map<String, Cell> parseData(Sheet sheet, Map.Entry<String, LinkedHashMap> entry, Map<String, Style> styleMap) {
        HashMap<String, Cell> dataMap = new HashMap<String, Cell>(16);
        JSONObject data = (JSONObject)entry.getValue().get("data");
        JSONObject dataTable = (JSONObject)data.get((Object)"dataTable");
        if (dataTable == null) {
            return dataMap;
        }
        Set keySet = dataTable.keySet();
        for (String key : keySet) {
            Integer rownum = SpreadUtils.getInteger(key) + 1;
            if (rownum > sheet.getRowNum()) {
                sheet.setRowNum(rownum);
            }
            JSONObject colObject = (JSONObject)dataTable.get((Object)key);
            Set colKeySet = colObject.keySet();
            for (String colKey : colKeySet) {
                Integer colNum = SpreadUtils.getInteger(colKey) + 1;
                if (colNum > sheet.getColNum()) {
                    sheet.setColNum(colNum);
                }
                JSONObject col = (JSONObject)colObject.get((Object)colKey);
                Object valObj = col.get((Object)"value");
                Cell cell = new Cell();
                cell.setSheetId(sheet.getId());
                cell.setId(key + "_" + colKey);
                if (valObj != null) {
                    SpreadUtils.handleCellRichText(valObj, cell);
                    SpreadUtils.parseCellEntityId(cell);
                }
                SpreadUtils.parseCellStyle(styleMap, cell, col.getString("style"));
                SpreadUtils.parseCellTip(cell, (Map)col.get((Object)"cellTipParam"));
                dataMap.put(cell.getId(), cell);
            }
        }
        if (sheet.getRowNum() < keySet.size()) {
            sheet.setRowNum(keySet.size());
        }
        return dataMap;
    }

    private static void parseCellEntityId(Cell cell) {
        String text;
        if (null != cell && StringUtils.isNotBlank((CharSequence)(text = cell.getText()))) {
            if (text.contains("${")) {
                String[] str;
                for (String s : str = text.split("\\$\\{")) {
                    int index = s.indexOf(125);
                    if (index <= 0) continue;
                    String cellKey = s.substring(0, index);
                    if (StringUtil.isContainChinese(text) || !cellKey.contains("#") || cellKey.split("#").length <= 0) continue;
                    cell.setEntityId(cellKey.split("#")[0]);
                }
            } else if (!StringUtil.isContainChinese(text) && text.contains("#") && text.split("#").length > 0) {
                cell.setEntityId(text.split("#")[0]);
            }
        }
    }

    public static Map<String, Style> parseStyles(JSONObject json) {
        HashMap<String, Style> dataMap = new HashMap<String, Style>(16);
        JSONArray namedStyles = json.getJSONArray("namedStyles");
        for (int i = 0; namedStyles != null && i < namedStyles.size(); ++i) {
            JSONObject jon = (JSONObject)namedStyles.get(i);
            String name = jon.getString("name");
            Integer hAlign = jon.getInteger("hAlign");
            Integer vAlign = jon.getInteger("vAlign");
            String formatter = json.getString("formatter");
            Style style = new Style();
            style.setName(name);
            style.sethAlign(hAlign);
            style.setvAlign(vAlign);
            style.setFormatter(formatter);
            dataMap.put(name, style);
        }
        return dataMap;
    }

    private static Integer getInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isSheetInvisible(Map.Entry<String, LinkedHashMap> entry) {
        if (entry.getValue().get("visible") instanceof Boolean) {
            Boolean visible = (Boolean)entry.getValue().get("visible");
            return visible != null && visible == false;
        }
        if (entry.getValue().get("visible") != null) {
            Boolean visible = "1".equals(entry.getValue().get("visible").toString());
            return visible == false;
        }
        return false;
    }

    public static boolean isSheetInvisible(Map.Entry<String, LinkedHashMap> entry, List<String> hideSheets) {
        if (CollectionUtils.isNotEmpty(hideSheets) && hideSheets.contains(entry.getKey())) {
            return true;
        }
        return SpreadUtils.isSheetInvisible(entry);
    }

    public static LinkedHashMap<String, LinkedHashMap> getTemplateSheetMapFromJsonString(String jsonString) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return new LinkedHashMap<String, LinkedHashMap>();
        }
        JSONObject sheets = JSONObject.parseObject((String)jsonString).getJSONObject("sheets");
        return (LinkedHashMap)JSON.parseObject((String)sheets.toJSONString(), (TypeReference)new TypeReference<LinkedHashMap<String, LinkedHashMap>>(){}, (Feature[])new Feature[0]);
    }

    public static Map<String, String> getMetadataNumberMap(List<Sheet> sheets) {
        return sheets.stream().flatMap(v -> v.getEntityMap().entrySet().stream()).collect(Collectors.toMap(k -> (String)k.getKey(), v -> (String)v.getValue(), (k1, k2) -> k1));
    }

    public static Map<String, FormulaVo> convertSpreadFormatter(List<Sheet> sheetList, Map<String, EntityField> fieldMap) {
        HashMap<String, FormulaVo> cellTypeFormulaMap = new HashMap<String, FormulaVo>();
        if (EmptyCheckUtils.isNotEmpty(sheetList)) {
            for (Sheet sheet : sheetList) {
                for (List<Cell> cellList : sheet.getRowList()) {
                    for (Cell cell : cellList) {
                        EntityField entityField = fieldMap.get(StringUtil.getMatchContent(cell.getText()));
                        if (!EmptyCheckUtils.isNotEmpty(entityField)) continue;
                        FormulaVo vo = new FormulaVo();
                        if (!EmptyCheckUtils.isNotEmpty(cell.getStyle())) continue;
                        vo.setCellType(cell.getStyle().getFormatter());
                        vo.setFormulaType("3");
                        vo.setFormulaKey(entityField.getFieldId());
                        vo.setContent("");
                        vo.setFormulaName("");
                        cellTypeFormulaMap.put(entityField.getFieldId(), vo);
                    }
                }
            }
        }
        return cellTypeFormulaMap;
    }

    public static Map<String, String> getTemplateKeys(List<Sheet> sheets) {
        HashMap<String, String> keys = new HashMap<String, String>();
        for (Sheet sheet : sheets) {
            List<List<Cell>> rowList = sheet.getRowList();
            for (List<Cell> cells : rowList) {
                for (Cell cell : cells) {
                    if (!EmptyCheckUtils.isNotEmpty(cell.getEntityId())) continue;
                    keys.put(cell.getCellKey(), cell.getCellKey());
                }
            }
        }
        return keys;
    }

    public static void parseCellTip(Cell cell, Map<String, Object> cellTipParam) {
        if (cellTipParam == null) {
            return;
        }
        String cellTipText = (String)cellTipParam.get("cellTipText");
        Boolean enableCellTip = (Boolean)cellTipParam.get("enableCellTip");
        if (enableCellTip != null && cellTipText != null) {
            try {
                cell.setCellTipMessage(cellTipText);
                cell.setEnableCellTip(enableCellTip);
            }
            catch (Exception e) {
                LOGGER.error("getDataCell cellTip json parse error" + e);
            }
        }
    }

    public static Map<String, Object> getNestedMap(Map<String, Object> parent, String key) {
        if (parent == null) {
            return null;
        }
        Object value = parent.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new IllegalArgumentException(key + " does not map to a Map<String, Object>");
    }

    public static Map<String, Object> parseCellTipFromJson(String json, Map<String, Object> cellTipMap) {
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        Map<String, Object> sheets = SpreadUtils.getNestedMap((Map<String, Object>)jsonObj, "sheets");
        if (kd.taxc.bdtaxr.common.utils.EmptyCheckUtils.isEmpty(cellTipMap)) {
            cellTipMap = new HashMap<String, Object>();
        }
        if (sheets != null) {
            for (Map.Entry<String, Object> sheet : sheets.entrySet()) {
                String sheetName = sheet.getKey();
                Map<String, Object> sheetData = SpreadUtils.getNestedMap((Map)sheet.getValue(), "data");
                Map<String, Object> dataTable = null;
                if (sheetData != null) {
                    dataTable = SpreadUtils.getNestedMap(sheetData, "dataTable");
                }
                if (dataTable == null) continue;
                for (Map.Entry<String, Object> rowDataEntry : dataTable.entrySet()) {
                    String selectedRow = rowDataEntry.getKey();
                    Map colData = (Map)rowDataEntry.getValue();
                    for (Map.Entry cellDataEntry : colData.entrySet()) {
                        String selectedCol = (String)cellDataEntry.getKey();
                        Map cellData = (Map)cellDataEntry.getValue();
                        Map cellTipParam = (Map)cellData.get("cellTipParam");
                        if (kd.taxc.bdtaxr.common.utils.EmptyCheckUtils.isEmpty((Object)cellTipParam)) continue;
                        String tipMessage = (String)cellTipParam.get("cellTipText");
                        Boolean enableCellTip = (Boolean)cellTipParam.get("enableCellTip");
                        Map<String, Object> singleCellTipMap = SpreadUtils.createSingleCellTipMap(selectedCol, selectedRow, enableCellTip, tipMessage, sheetName);
                        String keyForCellTip = SpreadUtils.createKeyForCellTip(sheetName, selectedRow, selectedCol);
                        cellTipMap.put(keyForCellTip, singleCellTipMap);
                    }
                }
            }
        }
        return cellTipMap;
    }

    private static Map<String, Object> createSingleCellTipMap(String selectedCol, String selectedRow, Boolean enableCellTip, String tipMessage, String sheetName) {
        HashMap<String, Object> singleCellTipMap = new HashMap<String, Object>();
        singleCellTipMap.put("selectedCol", selectedCol);
        singleCellTipMap.put("selectedRow", selectedRow);
        singleCellTipMap.put("enableCellTip", enableCellTip);
        singleCellTipMap.put("tipMessage", tipMessage);
        singleCellTipMap.put("selectedSheetName", sheetName);
        return singleCellTipMap;
    }

    public static String createKeyForCellTip(String sheetName, String selectedRow, String selectedCol) {
        return sheetName + "#" + selectedRow + "#" + selectedCol + "#cellTip";
    }

    public static String handleParseSpreadJsonForCellTip(Map<String, Object> cellTipsMap, String spreadJson) {
        if (kd.taxc.bdtaxr.common.utils.EmptyCheckUtils.isEmpty(cellTipsMap)) {
            return null;
        }
        if (kd.taxc.bdtaxr.common.utils.EmptyCheckUtils.isEmpty((Object)spreadJson)) {
            return null;
        }
        JSONObject json = JSONObject.parseObject((String)spreadJson);
        for (Map.Entry<String, Object> entry : cellTipsMap.entrySet()) {
            Map singleCellTipMap = (Map)entry.getValue();
            String selectedCol = (String)singleCellTipMap.get("selectedCol");
            String selectedRow = (String)singleCellTipMap.get("selectedRow");
            Boolean enableCellTip = (Boolean)singleCellTipMap.get("enableCellTip");
            String tipMessage = (String)singleCellTipMap.get("tipMessage");
            String sheetName = (String)singleCellTipMap.get("selectedSheetName");
            Map<String, Object> sheets = SpreadUtils.getNestedMap((Map<String, Object>)json, "sheets");
            Map<String, Object> sheet = SpreadUtils.getNestedMap(sheets, sheetName);
            Map<String, Object> sheetData = SpreadUtils.getNestedMap(sheet, "data");
            Map<String, Object> dataTable = SpreadUtils.getNestedMap(sheetData, "dataTable");
            Map<String, Object> rowData = SpreadUtils.getNestedMap(dataTable, selectedRow);
            Map<String, Object> cellData = SpreadUtils.getNestedMap(rowData, selectedCol);
            if (cellData == null) continue;
            HashMap<String, Object> cellTipParam = new HashMap<String, Object>(1);
            cellTipParam.put("enableCellTip", enableCellTip);
            cellTipParam.put("cellTipText", tipMessage);
            cellData.put("cellTipParam", cellTipParam);
        }
        return json.toJSONString();
    }
}

