/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.template;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IPageCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.domain.Style;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.BasePointInfo;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TemplateShowUtils {
    private static final int COMMENT_OFF = 3;
    private static Log LOGGER = LogFactory.getLog(TemplateShowUtils.class);
    public static final String SHOW_TYPE_READ = "read";
    public static final String SHOW_TYPE_EDIT = "edit";
    public static final String BASE_PATH = System.getProperty("user.home") + File.separator + "template" + File.separator;
    public static final String BUILD_ORIGIN = "origin";
    public static final String BUILD_IMPORT = "IMPORT";
    public static final String BUILD_RESULT = "RESULT";
    public static final String PARA_PAGE_ID = "{PAGE_ID}";
    public static final String CELL_HYPER_LINK_DETAIL = "cellHyperLinkDetail";
    public static final String RULE_ID = "ruleId";
    private static final boolean parseHyperLink = false;
    public static final String DYN_ROW_NO_PRE = "dynRow#";
    public static final String HIDDEN_SHEET_NAME = "TEMPLATE_ID";
    private static final String[] DECIMAL_SCALE_SUFFIX = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000", "0000000000000", "00000000000000", "000000000000000", "0000000000000000", "00000000000000000", "000000000000000000", "0000000000000000000", "00000000000000000000"};

    public static InputStream getbuildExcel(String buildType, Long templateId) {
        String templateHtml = TemplateShowUtils.buildExcel(buildType, templateId);
        FileInputStream in = null;
        File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)templateHtml))));
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
        }
        return in;
    }

    public static String buildExcel(String buildType, Long templateId) {
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"bdtaxr_template_main");
        String fileName = templateId.toString();
        if (templateObject != null) {
            Date updateTime = (Date)templateObject.get("updateTime");
            if (updateTime != null) {
                fileName = fileName + DateUtils.format(updateTime, "yyyyMMddHHmmssSS");
            }
            fileName = fileName + ".xlsx";
            File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)fileName))));
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                String jsonString = templateObject.getString("content_tag");
                Map<String, EntityField> fieldMap = TemplateUtils.getAllEntityShow(SpreadUtils.getMetadataNumberMap(SpreadUtils.getSheets(jsonString, null)));
                Map<String, FormulaVo> formulaVoMap = CacheFormulaService.getCellFormulas(templateId);
                List<String> dynRowList = DynamicRowService.getDynRowNoList(templateId);
                TemplateShowUtils.buildExcel(buildType, templateId, jsonString, null, fieldMap, file, formulaVoMap, TemplateShowUtils.getDownLoadDefaultData(), dynRowList);
            }
        }
        return fileName;
    }

    private static Map<String, String> getDownLoadDefaultData() {
        HashMap<String, String> valMap = new HashMap<String, String>();
        valMap.put("tccit_qysds_ext_dyn_1_rownumber", "7.1");
        valMap.put("tccit_qysds_ext_dyn2_1_rownumber", "8.1");
        valMap.put("tccit_qysds_ext_dyn3_1_rownumber", "13.1");
        valMap.put("tccit_qysds_a201020_dyn1_1_rownumber", "1.1");
        valMap.put("tccit_qysds_a201020_dyn2_1_rownumber", "2.1");
        valMap.put("tccit_qysds_fzjgxx_dyn_1_rownumber", "1");
        return valMap;
    }

    @Deprecated
    public static String downResultExcel(Long templateId, Map<String, String> valMap) {
        DynamicObject templateObject = TemplateUtils.getTemplateDynamicObjectById(templateId);
        return TemplateShowUtils.downResultExcel(templateObject, null, valMap);
    }

    public static String downResultExcel(Long templateId, List<String> hideSheets, Map<String, String> valMap) {
        DynamicObject templateObject = TemplateUtils.getTemplateDynamicObjectById(templateId);
        return TemplateShowUtils.downResultExcel(templateObject, hideSheets, valMap);
    }

    public static String downResultExcel(DynamicObject templateObject, List<String> hideSheets, Map<String, String> valMap) {
        String fileName = UUID.randomUUID().toString() + ".xlsx";
        if (templateObject != null) {
            File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)fileName))));
            file.getParentFile().mkdirs();
            String jsonString = templateObject.getString("content_tag");
            Map<String, EntityField> fieldMap = TemplateUtils.getAllEntityShow(SpreadUtils.getMetadataNumberMap(SpreadUtils.getSheets(jsonString, null)));
            Long templateId = templateObject.getLong("id");
            Map<String, FormulaVo> formulaVoMap = CacheFormulaService.getCellFormulas(templateId);
            List<String> dynRowList = DynamicRowService.getDynRowNoList(templateId);
            TemplateShowUtils.buildExcel(BUILD_RESULT, templateId, jsonString, hideSheets, fieldMap, file, formulaVoMap, valMap, dynRowList);
        }
        return fileName;
    }

    public static String downResultExcelNew(DynamicObject template, List<String> hideSheets, Map<String, String> valMap, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeFormulas) {
        String fileName = UUID.randomUUID().toString() + ".xlsx";
        if (template != null) {
            File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)fileName))));
            file.getParentFile().mkdirs();
            String jsonString = template.getString("content_tag");
            Long templateId = template.getLong("id");
            List<String> dynRowList = DynamicRowService.getDynRowNoList(templateId);
            fileName = TemplateShowUtils.buildExcel(BUILD_RESULT, templateId, jsonString, hideSheets, fieldMap, file, cellTypeFormulas, valMap, dynRowList);
        }
        return fileName;
    }

    @Deprecated
    public static InputStream getDownResultExcelFile(DynamicObject template, Map<String, String> valMap) {
        boolean exists;
        ArrayList<String> hideSheets = new ArrayList<String>();
        if (Lists.newArrayList((Object[])new String[]{"CITQR2023", "CITQR2023-HUBEI"}).contains(template.getString("number")) && !(exists = QueryServiceHelper.exists((String)"tccit_qysds_a06779_bill", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)valMap.get("tcvat_nsrxx_1_id"))}))) {
            hideSheets.add("A06779");
        }
        return TemplateShowUtils.getDownResultExcelFile(template, hideSheets, valMap);
    }

    public static InputStream getDownResultExcelFile(DynamicObject template, List<String> hideSheets, Map<String, String> valMap) {
        String templateHtml = TemplateShowUtils.downResultExcel(template, hideSheets, valMap);
        FileInputStream in = null;
        File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)templateHtml))));
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
        }
        return in;
    }

    public static InputStream getDownResultExcelFileNew(DynamicObject template, List<String> hideSheets, Map<String, String> valMap, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeFormulas) {
        String templateHtml = TemplateShowUtils.downResultExcelNew(template, hideSheets, valMap, fieldMap, cellTypeFormulas);
        FileInputStream in = null;
        File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)templateHtml))));
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
        }
        return in;
    }

    @Deprecated
    public static InputStream getDownResultExcelFile(Long templateId, Map<String, String> valMap) {
        return TemplateShowUtils.getDownResultExcelFile(templateId, null, valMap);
    }

    public static InputStream getDownResultExcelFile(Long templateId, List<String> hideSheets, Map<String, String> valMap) {
        String templateHtml = TemplateShowUtils.downResultExcel(templateId, hideSheets, valMap);
        FileInputStream in = null;
        File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)templateHtml))));
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
        }
        return in;
    }

    public static Map<String, EntityField> queryTemplateField(Long templateId) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"bdtaxr_template_main");
        if (templateObject != null) {
            DynamicObject typeObject = (DynamicObject)templateObject.get("type");
            String type = typeObject.getString("id");
            HashMap<String, EntityField> fieldMap = new HashMap<String, EntityField>(16);
            Map<String, String> listTab = TemplateUtils.queryEntityByTypeId(type);
            for (Map.Entry<String, String> entity : listTab.entrySet()) {
                fieldMap.putAll(TemplateUtils.getEntityFieldMapForAllImportCheck(entity.getKey(), "#", null));
            }
            String jsonString = templateObject.getString("content_tag");
            return TemplateShowUtils.queryTemplateField(fieldMap, jsonString);
        }
        return map;
    }

    public static Map<String, String> queryData(Long orgId, String templateTypeId, Date startdate, Date enddate) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (templateTypeId == null) {
            return dataMap;
        }
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getDayFirst(startdate));
        QFilter skssqzFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast(enddate));
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        Map<String, String> mainMap = TemplateUtils.dataToMap(mainTable, "_", new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, templateFilter});
        dataMap.putAll(mainMap);
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        String mainId = mainMap.get(mainTable + "_" + "1" + "_" + "id");
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)mainId);
        if (entityList != null && !entityList.isEmpty()) {
            for (DynamicObject dobj : entityList) {
                String entityId = dobj.getString("entityid");
                if (mainTable.equals(entityId)) continue;
                Map<String, String> dMap = TemplateUtils.dataToMap(entityId, "_", new QFilter[]{sbbIdFilter});
                dataMap.putAll(dMap);
            }
        }
        return dataMap;
    }

    public static Map<String, String> queryData(Long templateId, String mainPk, String splitStr) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"bdtaxr_template_main");
        if (templateObject == null) {
            return dataMap;
        }
        String mainTable = "";
        DynamicObject type = templateObject.getDynamicObject("type");
        if (type != null) {
            mainTable = type.getString("maintable");
        }
        QFilter pkIdFilter = new QFilter("id", "=", (Object)Long.parseLong(mainPk));
        Map<String, String> mainMap = TemplateUtils.dataToMapForExport(mainTable, splitStr, new QFilter[]{pkIdFilter});
        dataMap.putAll(mainMap);
        Map<String, String> metadataMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId(templateId);
        if (metadataMap != null && !metadataMap.isEmpty()) {
            QFilter stringSbbIdFilter = new QFilter("sbbid", "=", (Object)mainPk);
            QFilter longSbbIdFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(mainPk));
            for (String entityId : metadataMap.keySet()) {
                Map<String, String> dMap;
                if (mainTable.equals(entityId)) continue;
                if (DeclareConstant.LONG_SBBID_ENTITIES.contains(entityId)) {
                    dMap = TemplateUtils.dataToMapForExport(entityId, splitStr, new QFilter[]{longSbbIdFilter});
                    dataMap.putAll(dMap);
                    continue;
                }
                dMap = TemplateUtils.dataToMapForExport(entityId, splitStr, new QFilter[]{stringSbbIdFilter});
                dataMap.putAll(dMap);
            }
        }
        return dataMap;
    }

    public static Map<String, String> queryData(String templateTypeId, String mainPk, String splitStr) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (templateTypeId == null) {
            return dataMap;
        }
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        QFilter orgFilter = new QFilter("id", "=", (Object)Long.parseLong(mainPk));
        Map<String, String> mainMap = TemplateUtils.dataToMapForExport(mainTable, splitStr, new QFilter[]{orgFilter});
        dataMap.putAll(mainMap);
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)mainPk);
        QFilter sbbIdFilter1 = new QFilter("sbbid", "=", (Object)Long.parseLong(mainPk));
        if (entityList != null && !entityList.isEmpty()) {
            for (DynamicObject dobj : entityList) {
                String entityId = dobj.getString("entityid");
                if (mainTable.equals(entityId)) continue;
                QFilter qFilter = DeclareConstant.LONG_SBBID_ENTITIES.contains(entityId) ? sbbIdFilter1 : sbbIdFilter;
                Map<String, String> dMap = TemplateUtils.dataToMapForExport(entityId, splitStr, new QFilter[]{qFilter});
                dataMap.putAll(dMap);
            }
        }
        return dataMap;
    }

    public static Integer getInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            return 0;
        }
    }

    /*
     * Exception decompiling
     */
    public static Map<String, String> getTemplateExcelDataMap(Long templateId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, EntityField> queryTemplateFieldByTmpId(Long templateId, String entityTemplate) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)entityTemplate);
        if (templateObject != null) {
            HashMap<String, EntityField> fieldMap = new HashMap<String, EntityField>(16);
            Map<String, String> listTab = TemplateFormulaServiceHelper.getMetaDataListByTmpId(templateId);
            for (Map.Entry<String, String> entity : listTab.entrySet()) {
                fieldMap.putAll(TemplateUtils.getEntityFieldMapForAllImportCheck(entity.getKey(), "#", null));
            }
            String jsonString = templateObject.getString("content_tag");
            return TemplateShowUtils.queryTemplateField(fieldMap, jsonString);
        }
        return map;
    }

    public static Map<String, EntityField> queryTemplateField(Long templateId, String entityTemplate) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)entityTemplate);
        if (templateObject != null) {
            DynamicObject typeObject = (DynamicObject)templateObject.get("type");
            String type = typeObject.getString("id");
            HashMap<String, EntityField> fieldMap = new HashMap<String, EntityField>(16);
            Map<String, String> listTab = TemplateUtils.queryEntityByTypeId(type);
            for (Map.Entry<String, String> entity : listTab.entrySet()) {
                fieldMap.putAll(TemplateUtils.getEntityFieldMapForAllImportCheck(entity.getKey(), "#", null));
            }
            String jsonString = templateObject.getString("content_tag");
            return TemplateShowUtils.queryTemplateField(fieldMap, jsonString);
        }
        return map;
    }

    public static Map<String, EntityField> queryTemplateField(Map<String, EntityField> fieldMap, String jsonString) {
        LinkedHashMap<String, EntityField> map = new LinkedHashMap<String, EntityField>(16);
        LinkedHashMap<String, LinkedHashMap> jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString(jsonString);
        for (Map.Entry<String, LinkedHashMap> entry : jsonMap.entrySet()) {
            if (null == entry || TemplateShowUtils.isContainsExcludeSheet(entry) || SpreadUtils.isSheetInvisible(entry)) continue;
            String sheetName = (String)entry.getValue().get("name");
            Map<String, List<Cell>> dataMap = SpreadUtils.getDataCell(entry, SpreadUtils.parseStyles(JSONObject.parseObject((String)jsonString)), new ArrayList<String>());
            for (Map.Entry<String, List<Cell>> data : dataMap.entrySet()) {
                for (Cell cell : data.getValue()) {
                    EntityField entityField;
                    String text = cell.getText();
                    if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)text) && !text.startsWith("${")) {
                        text = "${" + text + "}";
                    }
                    if (null != text && text.endsWith("}%")) {
                        text = text.substring(0, text.length() - 1);
                    }
                    if ((entityField = fieldMap.get(text)) == null) continue;
                    if (cell.getStyle() != null) {
                        entityField.setExcelFormatter(cell.getStyle().getFormatter());
                    }
                    map.put(sheetName + "#" + cell.getRow() + "#" + cell.getCol(), entityField);
                }
            }
        }
        return map;
    }

    private static boolean isContainsExcludeSheet(Map.Entry<String, LinkedHashMap> entry) {
        boolean check = false;
        if (null != entry) {
            HashSet<String> set = new HashSet<String>();
            set.add(ResManager.loadKDString((String)"\u540d\u518c\u4fe1\u606f\u8868", (String)"TemplateShowUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            check = set.contains(entry.getKey());
        }
        return check;
    }

    public static String buildSbbHtml(List<Sheet> listSheet, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, String pageId) {
        return TemplateShowUtils.buildSbbHtml(listSheet, fieldMap, cellTypeMap, showType, pageId, true, true, Collections.emptyList(), null);
    }

    public static String buildSbbHtml(List<Sheet> listSheet, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, String pageId, boolean needWarn, boolean needRemark, List<BasePointInfo> floatBasePointList, List<DynamicRowModel> dynamicRowModelList) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"taxDeclaration\">");
        sb.append("<div class=\"declareTable\">");
        if (needWarn) {
            sb.append(TemplateShowUtils.buildRiskEarlyWarning(pageId));
        }
        String style = "margin-top: 20px;";
        if (listSheet.size() > 1) {
            sb.append("<div class=\"_3kovUH3b\">");
            sb.append("  <div style=\"border-bottom:1px solid rgba(227, 227, 227, 0.9)\" class=\"_14gRBkXY\">");
            sb.append("    <div class=\"_9IbcKm6A\">");
            sb.append("      <div style=\"display: flex\" class=\"_2jmOZxVo\">");
            for (int i = 0; listSheet.size() > 1 && i < listSheet.size(); ++i) {
                Sheet sheet = listSheet.get(i);
                sb.append("<div style=\"display: flex;height: 24px;align-items: center;cursor: pointer;\" class=\"_39ZryrqT tab-item-hover tab-item-content theme ").append(i == 0 ? "tab-active" : "").append("\" ");
                sb.append(" id=\"tab-item-content").append(pageId).append(sheet.getId()).append('\"');
                sb.append(" pageid=\"").append(pageId).append('\"');
                sb.append(" tabid=\"").append(sheet.getId()).append("\">");
                sb.append("<span style=\"padding:0 12px;white-space: nowrap\" class=\"_11249s7w\">").append(sheet.getName()).append("<span class=\"riskCircle\"></span></span>");
                sb.append("</div>");
            }
            sb.append("      </div>");
            sb.append("    </div>");
            sb.append("  </div>");
            sb.append("  <ul class=\"_2hLXwAlh\"/>");
            sb.append("</div>");
            style = "margin-top: 10px;";
        }
        sb.append("<div class=\"tcvat-content\" style=\"height: calc(100% - 20px);").append(style).append('\"').append(" pageid=\"").append(pageId).append("\">");
        boolean show = true;
        for (Sheet sheet : listSheet) {
            sb.append(TemplateShowUtils.getTableHtml(sheet, show, fieldMap, cellTypeMap, showType, pageId, needRemark, dynamicRowModelList));
            show = false;
        }
        sb.append("</div>");
        sb.append("</div>");
        sb.append("</div>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildExcel(String buildType, Long templateId, String jsonString, List<String> hideSheets, Map<String, EntityField> fieldMap, File file, Map<String, FormulaVo> formulaVoMap, Map<String, String> valMap, List<String> dynRowList) {
        String filePath = "";
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFCellStyle cellStyle = wb.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            XSSFColor color = new XSSFColor(Color.BLACK, null);
            cellStyle.setBottomBorderColor(color);
            cellStyle.setLeftBorderColor(color);
            cellStyle.setTopBorderColor(color);
            cellStyle.setRightBorderColor(color);
            LinkedHashMap<String, LinkedHashMap> jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString(jsonString);
            Iterator<Map.Entry<String, LinkedHashMap>> iterator = jsonMap.entrySet().iterator();
            TreeMap<Integer, Map.Entry<String, LinkedHashMap>> sheetMap = new TreeMap<Integer, Map.Entry<String, LinkedHashMap>>();
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            HashMap<String, XSSFCellStyle> cellStyleMap = new HashMap<String, XSSFCellStyle>(16);
            while (iterator.hasNext()) {
                Map.Entry<String, LinkedHashMap> entry = iterator.next();
                if (null == entry || TemplateShowUtils.isContainsExcludeSheet(entry) || SpreadUtils.isSheetInvisible(entry, hideSheets)) continue;
                sheetMap.put(Integer.valueOf(entry.getValue().getOrDefault("index", "0").toString()), entry);
            }
            ArrayList rowList = new ArrayList();
            for (Map.Entry sheetEntry : sheetMap.entrySet()) {
                Map.Entry entry = (Map.Entry)sheetEntry.getValue();
                String name = (String)((LinkedHashMap)entry.getValue()).get("name");
                XSSFSheet sheet = wb.createSheet(name);
                sheet.setDefaultColumnWidth(20);
                Map<String, List<Cell>> dataMap = SpreadUtils.getDataCell(entry, SpreadUtils.parseStyles(jsonObject), dynRowList);
                List<Integer> colWidthList = SpreadUtils.parseColumns(entry, 30);
                int index = 0;
                for (Integer n : colWidthList) {
                    int w = n * 30;
                    if (w > 65280) {
                        sheet.setColumnWidth(index++, 65280);
                        continue;
                    }
                    sheet.setColumnWidth(index++, w);
                }
                HashMap<Integer, List<Integer>> rowTemplateRowMap = new HashMap<Integer, List<Integer>>();
                if (BUILD_RESULT.equals(buildType)) {
                    TemplateShowUtils.buildExport(wb, sheet, dataMap, fieldMap, formulaVoMap, valMap, rowTemplateRowMap, cellStyleMap);
                } else {
                    for (Map.Entry<String, List<Cell>> data : dataMap.entrySet()) {
                        String dataRow = data.getKey();
                        int createRow = dataRow.contains("#") ? Integer.parseInt(dataRow.substring(dataRow.indexOf(35) + 1)) : Integer.parseInt(dataRow);
                        TemplateShowUtils.createSheetRow(wb, sheet, createRow, data, fieldMap, formulaVoMap, valMap, null, cellStyleMap);
                    }
                }
                List<Cell> list = SpreadUtils.getSpanCell(entry);
                if (BUILD_RESULT.equals(buildType)) {
                    for (Cell cell : list) {
                        rowList.clear();
                        int row = cell.getRow();
                        int rowCount = cell.getRowCount();
                        for (int i = 0; i < rowCount; ++i) {
                            List integers = (List)rowTemplateRowMap.get(row);
                            if (integers == null) continue;
                            rowList.addAll(integers);
                        }
                        if (rowList.size() <= 0) continue;
                        Integer firstRow = (Integer)rowList.get(0);
                        if (rowCount == 1) {
                            for (Integer fr : rowList) {
                                CellRangeAddress region = new CellRangeAddress(fr.intValue(), fr.intValue(), cell.getCol(), cell.getCol() + cell.getColCount() - 1);
                                sheet.addMergedRegion(region);
                            }
                            continue;
                        }
                        int lastRow = firstRow + rowList.size() - 1;
                        CellRangeAddress region = new CellRangeAddress(firstRow.intValue(), lastRow, cell.getCol(), cell.getCol() + cell.getColCount() - 1);
                        sheet.addMergedRegion(region);
                    }
                    continue;
                }
                for (Cell cell : list) {
                    CellRangeAddress region = new CellRangeAddress(cell.getRow(), cell.getRow() + cell.getRowCount() - 1, cell.getCol(), cell.getCol() + cell.getColCount() - 1);
                    sheet.addMergedRegion(region);
                }
            }
            TemplateShowUtils.createHiddenSheet(wb, templateId);
            FileItem fi = null;
            FileInputStream fileInputStream = null;
            try {
                FileOutputStream fout = new FileOutputStream(file);
                wb.write((OutputStream)fout);
                fout.close();
                FileService fileService = FileServiceFactory.getAttachmentFileService();
                String path = File.separator + "template" + File.separator + file.getName();
                fileInputStream = new FileInputStream(file);
                fi = new FileItem(file.getName(), path, (InputStream)fileInputStream);
                fi.setCreateNewFileWhenExists(true);
                filePath = fileService.upload(fi);
            }
            catch (Exception e) {
                LOGGER.error("\u751f\u6210\u6a21\u677f\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("close\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("fileInputStream close\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        }
        return filePath;
    }

    private static void createHiddenSheet(XSSFWorkbook wb, Long templateId) {
        XSSFSheet sheet = wb.createSheet(HIDDEN_SHEET_NAME);
        sheet.setDefaultColumnWidth(20);
        XSSFRow row = sheet.createRow(0);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue(templateId.toString());
        wb.setSheetHidden(wb.getSheetIndex(HIDDEN_SHEET_NAME), true);
    }

    private static void buildExport(XSSFWorkbook wb, XSSFSheet sheet, Map<String, List<Cell>> dataMap, Map<String, EntityField> fieldMap, Map<String, FormulaVo> formulaVoMap, Map<String, String> valMap, Map<Integer, List<Integer>> rowTemplateRowMap, Map<String, XSSFCellStyle> cellStyleMap) {
        String newSplitStr;
        String oldSplitStr = "_";
        String splitStr = newSplitStr = "#";
        Set<Object> rowSet = new HashSet(0);
        if (valMap != null && !valMap.isEmpty()) {
            String k2;
            Iterator<String> iterator = valMap.keySet().iterator();
            if (iterator.hasNext() && !(k2 = iterator.next()).contains(newSplitStr)) {
                splitStr = oldSplitStr;
            }
            String splitStr1 = splitStr;
            rowSet = valMap.keySet().stream().map(s -> s.substring(0, s.lastIndexOf(splitStr1))).collect(Collectors.toSet());
        }
        int index = -1;
        for (Map.Entry<String, List<Cell>> data : dataMap.entrySet()) {
            int createRow;
            String dataRow = data.getKey();
            boolean isDynRow = false;
            if (dataRow.contains("#")) {
                createRow = Integer.parseInt(dataRow.substring(dataRow.indexOf(35) + 1));
                isDynRow = true;
            } else {
                createRow = Integer.parseInt(dataRow);
            }
            if (index == -1) {
                index = createRow;
            }
            if (isDynRow) {
                List<Cell> cells = data.getValue();
                Cell cell = cells.get(cells.size() - 1);
                String text = cell.getText();
                String dynRowNo = text.substring(text.indexOf(35) + 1);
                if (!kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)dynRowNo)) continue;
                String[] split = dynRowNo.split("#");
                int ewblxh = Integer.parseInt(split[1]);
                String dynRowId = split[0] + splitStr + ewblxh;
                while (rowSet.contains(dynRowId)) {
                    TemplateShowUtils.createSheetRow(wb, sheet, index, data, fieldMap, formulaVoMap, valMap, ewblxh, cellStyleMap);
                    List integers = rowTemplateRowMap.computeIfAbsent(createRow, k -> new ArrayList());
                    integers.add(index);
                    ++index;
                    dynRowId = split[0] + splitStr + ++ewblxh;
                }
                continue;
            }
            TemplateShowUtils.createSheetRow(wb, sheet, index, data, fieldMap, formulaVoMap, valMap, null, cellStyleMap);
            List integers = rowTemplateRowMap.computeIfAbsent(createRow, k -> new ArrayList());
            integers.add(index);
            ++index;
        }
    }

    private static void createSheetRow(XSSFWorkbook wb, XSSFSheet sheet, int index, Map.Entry<String, List<Cell>> data, Map<String, EntityField> fieldMap, Map<String, FormulaVo> formulaVoMap, Map<String, String> valMap, Integer ewblxh, Map<String, XSSFCellStyle> cellStyleMap) {
        String oldSplitStr = "_";
        String newSplitStr = "#";
        XSSFRow row = sheet.createRow(index);
        XSSFCreationHelper creationHelper = wb.getCreationHelper();
        for (Cell cell : data.getValue()) {
            XSSFCell hSSFCell = row.createCell(cell.getCol());
            String text = cell.getText();
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)text)) {
                text = text.trim();
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)text) && text.endsWith("%")) {
                text = text.substring(0, text.length() - 1);
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)text) && text.startsWith(DYN_ROW_NO_PRE)) continue;
            EntityField field = null;
            String cellKey = text;
            String cellKeyOld = text;
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)text) && text.startsWith("${") && text.endsWith("}")) {
                cellKeyOld = cellKey = text.replace("${", "").replace("}", "");
            }
            String[] cellKeys = null;
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)text) && cellKey.contains(newSplitStr) && ewblxh != null) {
                cellKeys = cellKey.split(newSplitStr);
                cellKey = cellKeys[0] + newSplitStr + ewblxh + newSplitStr + cellKeys[cellKeys.length - 1];
            }
            if (fieldMap != null && !fieldMap.isEmpty()) {
                field = fieldMap.get(cellKey);
            }
            if (field == null && ewblxh != null && fieldMap != null && cellKeys != null) {
                String newKey = cellKeys[0] + newSplitStr + "1" + newSplitStr + cellKeys[cellKeys.length - 1];
                field = fieldMap.get(newKey);
            }
            TemplateShowUtils.setComment((org.apache.poi.ss.usermodel.Sheet)sheet, (CreationHelper)creationHelper, (org.apache.poi.ss.usermodel.Cell)hSSFCell, cell.getComment());
            XSSFCellStyle xssfCellStyle = null;
            if (field != null) {
                String colkey = field.getEntityId() + "#" + field.getFieldId();
                if (cellStyleMap != null) {
                    xssfCellStyle = cellStyleMap.get(colkey);
                }
                if (xssfCellStyle == null) {
                    xssfCellStyle = TemplateShowUtils.getCellStyle(wb, field, cell.getStyle());
                    cellStyleMap.put(colkey, xssfCellStyle);
                }
            } else {
                xssfCellStyle = TemplateShowUtils.getCellStyle(wb, field, cell.getStyle());
            }
            hSSFCell.setCellStyle((CellStyle)xssfCellStyle);
            if (field == null) {
                hSSFCell.setCellValue(text);
                continue;
            }
            FormulaVo formulaVo = null;
            if (formulaVoMap != null && !formulaVoMap.isEmpty()) {
                formulaVo = formulaVoMap.get(cellKey);
            }
            if (formulaVo == null && ewblxh != null && formulaVoMap != null && cellKeys != null) {
                String newKey = cellKeyOld;
                formulaVo = formulaVoMap.get(newKey);
            }
            String getValueKey = cellKey;
            if (valMap != null && !valMap.isEmpty()) {
                String k;
                Iterator<String> iterator = valMap.keySet().iterator();
                if (iterator.hasNext() && !(k = iterator.next()).contains(newSplitStr)) {
                    getValueKey = getValueKey.replace(newSplitStr, oldSplitStr);
                }
                text = valMap.getOrDefault(getValueKey, "");
            }
            String cobovalue = text;
            if (formulaVo != null && ("2".equals(formulaVo.getCellType()) || "3".equals(formulaVo.getCellType()) || "4".equals(formulaVo.getCellType()))) {
                Map<String, String> stringStringMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                text = stringStringMap.getOrDefault(text, "");
                if (stringStringMap.values().stream().collect(Collectors.joining()).length() > 200) {
                    TemplateShowUtils.setDropDownBox(wb, sheet.getSheetName(), stringStringMap.values().toArray(new String[0]), cell.getRow(), cell.getRow(), cell.getCol(), cell.getCol());
                } else {
                    CellRangeAddressList regions = new CellRangeAddressList(cell.getRow(), cell.getRow(), cell.getCol(), cell.getCol());
                    DataValidationHelper helper = sheet.getDataValidationHelper();
                    DataValidationConstraint constraint = helper.createExplicitListConstraint(stringStringMap.values().toArray(new String[0]));
                    DataValidation validation = helper.createValidation(constraint, regions);
                    sheet.addValidationData(validation);
                }
            }
            if ("Combo".equals(field.getFieldType())) {
                String v = "[" + cobovalue.replaceAll(",", "],[") + "]";
                ArrayList<String> itemList = new ArrayList<String>();
                for (ValueMapItem item : field.getComboItems()) {
                    if (!v.contains("[" + item.getValue() + "]")) continue;
                    itemList.add(item.getName().getLocaleValue());
                }
                text = String.join((CharSequence)",", itemList);
            } else if (null != formulaVo && "5".equals(formulaVo.getCellType()) && "Basedata".equals(field.getFieldType()) || null != formulaVo && "Unit".equals(field.getFieldType())) {
                String dataBaseKey = getValueKey + "_text";
                if (valMap != null && !valMap.isEmpty()) {
                    if (valMap.containsKey(dataBaseKey)) {
                        text = valMap.getOrDefault(dataBaseKey, "");
                    } else {
                        if (formulaVo == null) continue;
                        Map<String, String> itemMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                        if (itemMap != null) {
                            Map.Entry<String, String> cellTypeEntry = itemMap.entrySet().iterator().next();
                            String key = cellTypeEntry.getKey();
                            List<String> selectFieldList = TemplateShowUtils.parseBaseDataFieldList(cellTypeEntry.getValue());
                            DynamicObject object = QueryServiceHelper.queryOne((String)key, (String)String.join((CharSequence)",", selectFieldList), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(kd.bos.dataentity.utils.StringUtils.isNumeric((CharSequence)text) ? Long.parseLong(text) : 0L))});
                            text = TemplateShowUtils.getDisplayText(cellTypeEntry.getValue(), object);
                        }
                    }
                }
            }
            hSSFCell.setCellValue(text);
        }
    }

    private static void setComment(org.apache.poi.ss.usermodel.Sheet sheet, CreationHelper creationHelper, org.apache.poi.ss.usermodel.Cell excelCell, String comment) {
        if (StringUtil.isNotBlank((CharSequence)comment)) {
            ClientAnchor clientAnchor = creationHelper.createClientAnchor();
            clientAnchor.setCol1(excelCell.getColumnIndex());
            clientAnchor.setRow1(excelCell.getRowIndex());
            clientAnchor.setCol2(excelCell.getColumnIndex() + 3);
            clientAnchor.setRow2(excelCell.getRowIndex() + 3);
            Comment cellComment = sheet.createDrawingPatriarch().createCellComment(clientAnchor);
            cellComment.setString(creationHelper.createRichTextString(comment));
            excelCell.setCellComment(cellComment);
        }
    }

    public static void setDropDownBox(XSSFWorkbook wb, String typeName, String[] values, Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol) {
        int sheetTotal = wb.getNumberOfSheets();
        if (values != null && values.length != 0) {
            String hiddenSheetName = "hiddenSheet";
            XSSFSheet hiddenSheet = wb.getSheet(hiddenSheetName);
            if (hiddenSheet == null) {
                hiddenSheet = wb.createSheet(hiddenSheetName);
                for (int i = 0; i < values.length; ++i) {
                    XSSFRow row = hiddenSheet.createRow(i);
                    XSSFCell cell = row.createCell(0);
                    cell.setCellValue(values[i]);
                }
                wb.setSheetHidden(sheetTotal, true);
            }
            String strFormula = hiddenSheetName + "!$A$1:$A$65535";
            XSSFDataValidationConstraint constraint = new XSSFDataValidationConstraint(3, strFormula);
            CellRangeAddressList regions = new CellRangeAddressList(firstRow.intValue(), lastRow.intValue(), firstCol.intValue(), lastCol.intValue());
            XSSFDataValidationHelper help = new XSSFDataValidationHelper(hiddenSheet);
            DataValidation validation = help.createValidation((DataValidationConstraint)constraint, regions);
            XSSFSheet sheet1 = wb.getSheet(typeName);
            sheet1.addValidationData(validation);
        }
    }

    private static String buildRiskEarlyWarning(String pageId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"warn_open_").append(pageId).append("\" class=\"{{riskwarningSize==0?\"taxRiskWarningImgNo\":\"taxRiskWarningImg\"}}\" style=\"height:26px;width:26px;top:10px;\"></div>");
        sb.append("<div class=\"riskWarning\" style=\"display:none;\" id=\"taxDeclarationWarn_").append(pageId).append("\">");
        sb.append("<div style=\"background:white;position: relative;\" class=\"riskTitle {{riskwarningSize==0?\"norisk\":\"\"}}\"><div class=\"titleContent\" style=\" padding-left: 20px\">");
        sb.append(ResManager.loadKDString((String)"\u98ce\u9669\u9884\u8b66\u4e8b\u9879\uff08{{riskwarningSize}}\uff09", (String)"TemplateShowUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        sb.append("<span id=\"warn_close_");
        sb.append(pageId);
        sb.append("\" class=\"taxRiskWarningClose\" style=\"float: right;width: 40px;height:40px;\"></span></div></div>");
        sb.append("<ul class=\"riskContent {{riskwarningSize==0?\"contentno\":\"\"}}\">").append("<div class=\"contentimg\"></div>").append("<div class=\"{{riskwarningSize==0?\"contentnotext\":\"contenthave\"}}\">");
        sb.append(ResManager.loadKDString((String)"\u4f18\u79c0\uff01\u6682\u65e0\u98ce\u9669\u9884\u8b66\uff5e", (String)"TemplateShowUtils_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        sb.append("</div>").append("{{each riskwarning as risk}}").append("<li id=\"riskItem").append(pageId).append("{{$index}}\">").append("<div class=\"contentTitle\" riskjump={{risk.jump}}>{{risk.title}}</div>").append("<div class=\"content\">{{risk.content}}</div><span class=\"items\">{{risk.items}}</span>").append("</li>").append("{{/each}}").append("</ul>");
        sb.append("</div>");
        return sb.toString();
    }

    private static String getTableHtml(Sheet sheet, boolean show, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, String pageId, boolean needRemark, List<DynamicRowModel> dynamicRowModelList) {
        StringBuilder sb = new StringBuilder();
        List<List<Cell>> rowList = sheet.getRowList();
        if (!rowList.isEmpty()) {
            int i;
            int maxWidth = 1500;
            int sumWidth = sheet.getColWidthList().stream().filter(a -> a > 0).mapToInt(Integer::intValue).sum();
            int count = (int)sheet.getColWidthList().stream().filter(a -> a > 0).count();
            int defaultWidth = -1;
            if (sheet.getColNum() > count) {
                defaultWidth = (maxWidth - sumWidth) / (sheet.getColNum() - count);
            } else {
                maxWidth = sumWidth;
            }
            sb.append("<table id=\"sbb_tab").append(pageId).append(sheet.getId()).append("\" ");
            sb.append(" pageid=\"").append(pageId).append('\"');
            sb.append(" style=\"table-layout:fixed;width=").append(maxWidth).append("px;");
            if (!show) {
                sb.append("display:none;");
            }
            sb.append("\">");
            sb.append("<thead><tr style=\"visibility: hidden;\" mce_style=\"display:none\">");
            for (i = 0; i < sheet.getColNum(); ++i) {
                Integer width = defaultWidth;
                if (sheet.getColWidthList().size() >= i + 1) {
                    width = sheet.getColWidthList().get(i);
                }
                sb.append("<th");
                if (width > 0) {
                    sb.append("  style=\"width: ").append(width).append("px;\"");
                }
                sb.append('>');
                sb.append("<div style=\"width:").append(width).append("px;height:1px;\">&nbsp;</div>");
                sb.append("</th>");
            }
            sb.append("</tr></thead>");
            for (i = 0; i < rowList.size(); ++i) {
                List<Cell> cellList = rowList.get(i);
                DynamicRowModel dynamicRow = TemplateShowUtils.getDynRowData(cellList, dynamicRowModelList);
                if (null != dynamicRow) {
                    List<Map<String, String>> dynRowData = dynamicRow.getRowList();
                    if (CollectionUtils.isEmpty(dynRowData)) continue;
                    for (int j = 0; j < dynRowData.size(); ++j) {
                        Map<String, String> map = dynRowData.get(j);
                        sb.append(TemplateShowUtils.getDynRowHtml(sheet, fieldMap, map, showType, cellList, needRemark, cellTypeMap, (long)j + dynamicRow.getStartRow()));
                    }
                    continue;
                }
                sb.append(TemplateShowUtils.getRowHtml(sheet, fieldMap, cellTypeMap, showType, cellList, needRemark));
            }
            sb.append("</table>");
        }
        return sb.toString();
    }

    private static DynamicRowModel getDynRowData(List<Cell> cellList, List<DynamicRowModel> dynamicRowModelList) {
        for (Cell cell : cellList) {
            if (!kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)cell.getText()) || dynamicRowModelList == null) continue;
            for (DynamicRowModel rowModel : dynamicRowModelList) {
                if (!cell.getText().contains(rowModel.getDynRowNo())) continue;
                return rowModel;
            }
        }
        return null;
    }

    private static String getDynRowHtml(Sheet sheet, Map<String, EntityField> fieldMap, Map<String, String> map, String showType, List<Cell> cellList, boolean needRemark, Map<String, FormulaVo> cellTypeMap, long rowIndex) {
        StringBuilder sb = new StringBuilder();
        sb.append("<tr style=\"height:40px;");
        sb.append("\">");
        for (int i = 0; i < cellList.size(); ++i) {
            Cell cell = cellList.get(i);
            String text = StringUtil.getMatchContent(cell.getText());
            EntityField entityField = fieldMap.get(StringUtil.getMatchContent(cell.getText()));
            sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
            Style style = cell.getStyle();
            boolean locked = false;
            if (style != null) {
                if (style.gethAlign() != null) {
                    if (0 == style.gethAlign()) {
                        sb.append(" align=\"left\"");
                    }
                    if (1 == style.gethAlign()) {
                        sb.append(" align=\"center\"");
                    }
                    if (2 == style.gethAlign()) {
                        sb.append(" align=\"right\"");
                    }
                }
                if (style.getLocked() != null && style.getLocked().booleanValue()) {
                    locked = true;
                }
            }
            if (entityField != null) {
                sb.append(" id=\"td_").append(entityField.getFieldId()).append('\"');
                sb.append(" sheetid=\"").append(sheet.getId()).append('\"');
            }
            sb.append('>');
            sb.append(TemplateShowUtils.getDynCellHtml(sheet.getId(), cell, fieldMap, cellTypeMap, showType, locked, needRemark, rowIndex, map));
            sb.append("</td>");
        }
        sb.append("</tr>");
        return sb.toString();
    }

    private static String getRowHtml(Sheet sheet, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, List<Cell> cellList, boolean needRemark) {
        StringBuilder sb = new StringBuilder();
        int colNum = sheet.getColNum();
        if (cellList.size() == 1 && cellList.get(0).getColCount() == colNum) {
            Cell cell1 = cellList.get(0);
            sb.append("<tr style=\"height:40px;");
            sb.append("\">");
            TemplateShowUtils.createTd(sb, sheet, cell1, fieldMap, cellTypeMap, showType, needRemark);
            sb.append("</tr>");
            int placeHolderRow = cell1.getRowCount() - 1;
            for (int i = 0; i < placeHolderRow; ++i) {
                sb.append("<tr style=\"height:40px;\"></tr>");
            }
            return sb.toString();
        }
        sb.append("<tr style=\"height:40px;");
        sb.append("\">");
        for (Cell cell : cellList) {
            TemplateShowUtils.createTd(sb, sheet, cell, fieldMap, cellTypeMap, showType, needRemark);
        }
        sb.append("</tr>");
        return sb.toString();
    }

    public static void createTd(StringBuilder sb, Sheet sheet, Cell cell, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, boolean needRemark) {
        EntityField entityField = fieldMap.get(StringUtil.getMatchContent(cell.getText()));
        sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
        Style style = cell.getStyle();
        boolean locked = false;
        if (style != null) {
            if (style.gethAlign() != null) {
                if (0 == style.gethAlign()) {
                    sb.append(" align=\"left\"");
                }
                if (1 == style.gethAlign()) {
                    sb.append(" align=\"center\"");
                }
                if (2 == style.gethAlign()) {
                    sb.append(" align=\"right\"");
                }
            }
            if (style.getLocked() != null && style.getLocked().booleanValue()) {
                locked = true;
            }
        }
        if (entityField != null) {
            sb.append(" id=\"td_").append(entityField.getFieldId()).append('\"');
            sb.append(" sheetid=\"").append(sheet.getId()).append('\"');
        }
        sb.append('>');
        sb.append(TemplateShowUtils.getCellHtml(sheet.getId(), cell, fieldMap, cellTypeMap, showType, locked, needRemark));
        sb.append("</td>");
    }

    private static String getDynamicTableHtml(Sheet sheet, boolean show, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, String pageId, boolean needRemark, Map<String, BasePointInfo> pointInfoMap) {
        StringBuilder sb = new StringBuilder();
        List<List<Cell>> rowList = sheet.getRowList();
        if (!rowList.isEmpty()) {
            int maxWidth = 1500;
            int sumWidth = sheet.getColWidthList().stream().filter(a -> a > 0).mapToInt(Integer::intValue).sum();
            int count = (int)sheet.getColWidthList().stream().filter(a -> a > 0).count();
            int defaultWidth = -1;
            if (sheet.getColNum() > count) {
                defaultWidth = (maxWidth - sumWidth) / (sheet.getColNum() - count);
            } else {
                maxWidth = sumWidth;
            }
            sb.append("<table id=\"sbb_tab").append(pageId).append(sheet.getId()).append("\" ");
            sb.append(" pageid=\"").append(pageId).append('\"');
            sb.append(" style=\"table-layout:fixed;width=").append(maxWidth).append("px;");
            if (!show) {
                sb.append("display:none;");
            }
            sb.append("\">");
            sb.append("<thead><tr style=\"visibility: hidden;\" mce_style=\"display:none\">");
            for (int i = 0; i < sheet.getColNum(); ++i) {
                Integer width = defaultWidth;
                if (sheet.getColWidthList().size() >= i + 1) {
                    width = sheet.getColWidthList().get(i);
                }
                sb.append("<th");
                if (width > 0) {
                    sb.append("  style=\"width: ").append(width).append("px;\"");
                }
                sb.append('>');
                sb.append("<div style=\"width:").append(width).append("px;height:1px;\">&nbsp;</div>");
                sb.append("</th>");
            }
            sb.append("</tr></thead>");
            for (List<Cell> cellList : rowList) {
                sb.append("<tr style=\"height:40px;\"operation=\"dynamic");
                sb.append("\">");
                boolean addFlag = false;
                boolean addAndDeleteFlag = false;
                for (Cell cell : cellList) {
                    EntityField entityField = fieldMap.get(StringUtil.getMatchContent(cell.getText()));
                    if (null == entityField) {
                        sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
                    } else {
                        String fieldId = cell.getText().replace("${", "").replace("}", "");
                        String[] split = fieldId.split("#");
                        String rowIndex = split[1];
                        if (pointInfoMap.containsKey(split[0])) {
                            if ("1".equals(rowIndex)) {
                                sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
                            } else if ("2".equals(rowIndex)) {
                                if (!addFlag) {
                                    sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"').append("\"operate=\"add\"");
                                } else {
                                    sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
                                }
                                addFlag = true;
                            } else {
                                if (!addAndDeleteFlag) {
                                    sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"').append("\"operate=\"addanddelete\"");
                                } else {
                                    sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
                                }
                                addAndDeleteFlag = true;
                            }
                        } else {
                            sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
                        }
                    }
                    Style style = cell.getStyle();
                    boolean locked = false;
                    if (style != null) {
                        if (style.gethAlign() != null) {
                            if (0 == style.gethAlign()) {
                                sb.append(" align=\"left\"");
                            }
                            if (1 == style.gethAlign()) {
                                sb.append(" align=\"center\"");
                            }
                            if (2 == style.gethAlign()) {
                                sb.append(" align=\"right\"");
                            }
                        }
                        if (style.getLocked() != null && style.getLocked().booleanValue()) {
                            locked = true;
                        }
                    }
                    if (entityField != null) {
                        sb.append(" id=\"td_").append(entityField.getFieldId()).append('\"');
                        sb.append(" sheetid=\"").append(sheet.getId()).append('\"');
                    }
                    sb.append('>');
                    sb.append(TemplateShowUtils.getCellHtml(sheet.getId(), cell, fieldMap, cellTypeMap, showType, locked, needRemark));
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
        }
        return sb.toString();
    }

    private static String getDynCellHtml(String sheetId, Cell cell, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, boolean locked, boolean needRemark, long rowIndex, Map<String, String> map) {
        String text = cell.getText();
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)text)) {
            return TemplateShowUtils.toNbsp(cell.getText());
        }
        ArrayList<String> fieldKeyList = new ArrayList<String>();
        if (text.contains("${")) {
            String[] str;
            for (String s : str = text.split("\\$\\{")) {
                int index = s.indexOf(125);
                if (index <= 0) continue;
                String key = s.substring(0, index);
                fieldKeyList.add(key);
            }
        }
        if (fieldKeyList.isEmpty()) {
            return TemplateShowUtils.toNbsp(cell.getText());
        }
        boolean readOnly = !SHOW_TYPE_EDIT.equals(showType) || locked;
        Map<Object, Object> itemMap = new LinkedHashMap();
        for (String fieldKey : fieldKeyList) {
            StringBuilder sb = new StringBuilder();
            String[] ary = fieldKey.split("#");
            String newFieldKey = String.format("%s_%s_%s", ary[0], rowIndex, ary[ary.length - 1]);
            EntityField entityField = fieldMap.get(fieldKey);
            if (!SHOW_TYPE_EDIT.equals(showType)) {
                sb.append("<div class=\"tcvat-read-cell\" style=\"display:inline\" id=\"read_").append(newFieldKey).append("\">");
            }
            FormulaVo formulaVo = cellTypeMap.get(fieldKey);
            String celltype = "1";
            String title = "";
            if (formulaVo != null) {
                celltype = formulaVo.getCellType();
                try {
                    itemMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5355\u5143\u683c\u683c\u5f0f\u914d\u7f6e\u9519\u8bef[%2$s]", (String)"TemplateShowUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), formulaVo.getFormulaKey(), formulaVo.getFormulaName()), e);
                }
                if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)formulaVo.getContent()))) {
                    title = " title=\"{{" + newFieldKey + "_title}}\" ";
                }
            }
            if ("1".equals(celltype)) {
                sb.append("<div class=\"tcvat-bor\" style=\"display:inline\" ").append(title).append('>');
                if (readOnly) {
                    sb.append("{{").append(newFieldKey).append("}}");
                } else {
                    if (locked) {
                        sb.append("<div style=\"width:100%;");
                        sb.append(" cellid=\"").append(newFieldKey).append("\" ");
                        sb.append(" sheetid=\"").append(sheetId).append("\" ");
                        sb.append(" >{{").append(newFieldKey).append("}}</div> ");
                    } else {
                        sb.append("<input type=\"text\" style=\"width:100%;\" ");
                        if ("Decimal".equals(entityField.getFieldType())) {
                            sb.append(" oninput =\"value=value.replace(/[^\\d.-]/g,'')\"");
                        }
                        sb.append(" cellid=\"").append(newFieldKey).append("\" ");
                        sb.append(" sheetid=\"").append(sheetId).append("\" ");
                        sb.append(" value=\"{{").append(newFieldKey).append("}}\" /> ");
                    }
                    if (needRemark) {
                        sb.append("<a href=\"javascript:void(0);\" class=\"remarkClass\" style=\"display:none\"");
                        sb.append(" cellid=\"").append(newFieldKey).append("\" id=\"remark_").append(newFieldKey).append(ResManager.loadKDString((String)"\">\u6dfb\u52a0\u4fee\u6539\u5907\u6ce8</a>", (String)"TemplateShowUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    }
                }
                sb.append("</div>");
            }
            if ("5".equals(celltype)) {
                sb.append("<div class=\"tcvat-base\" style=\"display:inline\" ").append(title);
                sb.append("style=\"width:100%;position: relative;\">");
                String baseId = null;
                String basetext = null;
                for (Map.Entry<Object, Object> item : itemMap.entrySet()) {
                    baseId = (String)item.getKey();
                    basetext = (String)item.getValue();
                }
                if (readOnly) {
                    sb.append("{{").append(newFieldKey).append("_text}}");
                } else {
                    sb.append(" <input class=\"tcvat-read-input-base\" type=\"text\" ");
                    sb.append(" cellid=\"").append(newFieldKey).append('\"');
                    sb.append(" value=\"").append("{{").append(newFieldKey).append("_text}}").append('\"');
                    sb.append(" />");
                    sb.append(" <i class=\"tcvat-icon-base\"");
                    sb.append(" cellid=\"").append(newFieldKey).append('\"');
                    sb.append(" baseEntityId=\"").append(baseId).append('\"');
                    sb.append(" displayProp=\"").append(basetext).append('\"');
                    sb.append(" ></i>");
                }
                sb.append("</div>");
            }
            if ("6".equals(celltype)) {
                sb.append("<div class=\"tcvat-href\"  style=\"display:inline\">").append(title);
                sb.append("<a href=\"javascript:void(0);\"");
                sb.append(" cellid=\"").append(newFieldKey).append("\" ");
                if (itemMap != null && itemMap.entrySet().iterator().hasNext()) {
                    Map.Entry<Object, Object> cellTypeEntry = itemMap.entrySet().iterator().next();
                    sb.append(" hreftype=\"").append((String)cellTypeEntry.getKey()).append("\" ");
                    sb.append(" hrefpara='").append((String)cellTypeEntry.getValue()).append("' ");
                }
                sb.append('>');
                sb.append("{{").append(newFieldKey).append("}}</a>");
                sb.append("</div>");
            }
            if (!SHOW_TYPE_EDIT.equals(showType)) {
                sb.append("<i class=\"tcvat-icon\"");
                sb.append("  id=\"icon_").append(newFieldKey).append('\"');
                sb.append("  cellid=\"").append(newFieldKey).append("\"></i>");
                sb.append("</div>");
            }
            text = text.contains("${" + fieldKey + "}") ? text.replace("${" + fieldKey + "}", sb.toString()) : text.replace(fieldKey, sb.toString());
            if (null == itemMap) continue;
            itemMap.clear();
        }
        text = "<div class=\"tcvat-cell\">" + text + "</div>";
        return text;
    }

    private static String getCellHtml(String sheetId, Cell cell, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, boolean locked, boolean needRemark) {
        String text = cell.getText();
        if (null != text && (text.contains("tcret_ccxws_zb_hb") || text.contains("tcret_ccxws_zb_hb#1#jmse") || text.contains("tcret_ccxws_zb_hb#1#taxtype"))) {
            LOGGER.info("find it===========###");
        }
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)text)) {
            return TemplateShowUtils.toNbsp(cell.getText());
        }
        ArrayList<String> fieldKeyList = new ArrayList<String>();
        if (text.contains("${")) {
            String[] str;
            for (String s : str = text.split("\\$\\{")) {
                String key;
                int index = s.indexOf(125);
                if (index <= 0 || !fieldMap.containsKey(key = s.substring(0, index))) continue;
                fieldKeyList.add(key);
            }
        } else if (fieldMap.containsKey(text)) {
            fieldKeyList.add(text);
        }
        if (fieldKeyList.isEmpty()) {
            return TemplateShowUtils.toNbsp(cell.getText());
        }
        boolean readOnly = !SHOW_TYPE_EDIT.equals(showType) || locked;
        Map<Object, Object> itemMap = new LinkedHashMap();
        for (String fieldKey : fieldKeyList) {
            StringBuilder sb = new StringBuilder();
            EntityField entityField = fieldMap.get(fieldKey);
            if (!SHOW_TYPE_EDIT.equals(showType)) {
                sb.append("<div class=\"tcvat-read-cell\" style=\"display:inline\" id=\"read_").append(entityField.getFieldId()).append("\">");
            }
            FormulaVo formulaVo = cellTypeMap.get(fieldKey);
            String celltype = "1";
            String title = "";
            if (formulaVo != null) {
                celltype = formulaVo.getCellType();
                try {
                    itemMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5355\u5143\u683c\u683c\u5f0f\u914d\u7f6e\u9519\u8bef[%2$s]", (String)"TemplateShowUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), formulaVo.getFormulaKey(), formulaVo.getFormulaName()), e);
                }
                if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)kd.bos.dataentity.utils.StringUtils.trimToEmpty((String)formulaVo.getContent()))) {
                    title = " title=\"{{" + entityField.getFieldId() + "_title}}\" ";
                }
            }
            if ("3".equals(celltype) || "4".equals(celltype)) {
                sb.append("<div class=\"tcvat-combo\" style=\"display:inline\" ").append(title);
                sb.append(" id=\"checkbox").append(entityField.getFieldId()).append("\">");
                for (Map.Entry<Object, Object> item : itemMap.entrySet()) {
                    sb.append("<input type=\"checkbox\" ");
                    sb.append(" cellid=\"").append(entityField.getFieldId()).append('\"');
                    sb.append(" value=\"").append((String)item.getKey()).append('\"');
                    sb.append(" radio=\"").append("4".equals(celltype)).append('\"');
                    sb.append(" {{ if ").append(entityField.getFieldId()).append("=='").append((String)item.getKey()).append("' }}");
                    sb.append(" checked");
                    sb.append(" {{ /if }}");
                    if (readOnly) {
                        sb.append(" disabled=\"true\"");
                    }
                    sb.append("/>");
                    sb.append("<span>").append((String)item.getValue()).append("</span>");
                }
                sb.append("</div>");
            } else if ("2".equals(celltype)) {
                sb.append("<div class=\"tcvat-select\" style=\"display:inline\" ").append(title);
                sb.append(" id=\"select").append(entityField.getFieldId()).append("\">");
                sb.append("<select style=\"width:100%;\" cellid=\"").append(entityField.getFieldId()).append('\"');
                if (readOnly) {
                    sb.append(" disabled=\"true\"");
                }
                sb.append('>');
                for (Map.Entry<Object, Object> item : itemMap.entrySet()) {
                    sb.append("<option value=\"").append((String)item.getKey()).append('\"');
                    sb.append(" {{ if ").append(entityField.getFieldId()).append("=='").append((String)item.getKey()).append("' }}");
                    sb.append(" selected='selected'");
                    sb.append(" {{ /if }}");
                    sb.append(" >");
                    sb.append((String)item.getValue());
                    sb.append("</option>");
                }
                sb.append("</select>");
                sb.append("</div>");
            } else if ("6".equals(celltype)) {
                sb.append("<div class=\"tcvat-href\"  style=\"display:inline\">").append(title);
                sb.append("<a href=\"javascript:void(0);\"");
                sb.append(" cellid=\"").append(entityField.getFieldId()).append("\" ");
                if (itemMap != null && itemMap.entrySet().iterator().hasNext()) {
                    Map.Entry<Object, Object> cellTypeEntry = itemMap.entrySet().iterator().next();
                    sb.append(" hreftype=\"").append((String)cellTypeEntry.getKey()).append("\" ");
                    sb.append(" hrefpara='").append((String)cellTypeEntry.getValue()).append("' ");
                }
                sb.append('>');
                sb.append("{{").append(entityField.getFieldId()).append("}}</a>");
                sb.append("</div>");
            } else if ("5".equals(celltype)) {
                sb.append("<div class=\"tcvat-base\" style=\"display:inline\" ").append(title);
                sb.append("style=\"width:100%;position: relative;\">");
                String baseId = null;
                String basetext = null;
                for (Map.Entry<Object, Object> item : itemMap.entrySet()) {
                    baseId = (String)item.getKey();
                    basetext = (String)item.getValue();
                }
                if (readOnly) {
                    sb.append("{{").append(entityField.getFieldId()).append("_text}}");
                } else {
                    sb.append(" <input class=\"tcvat-read-input-base\" type=\"text\" ");
                    sb.append(" cellid=\"").append(entityField.getFieldId()).append('\"');
                    sb.append(" value=\"").append("{{").append(entityField.getFieldId()).append("_text}}").append('\"');
                    sb.append(" />");
                    sb.append(" <i class=\"tcvat-icon-base\"");
                    sb.append(" cellid=\"").append(entityField.getFieldId()).append('\"');
                    sb.append(" baseEntityId=\"").append(baseId).append('\"');
                    sb.append(" displayProp=\"").append(basetext).append('\"');
                    sb.append(" ></i>");
                }
                sb.append("</div>");
            } else {
                sb.append("<div class=\"tcvat-bor\" style=\"display:inline\" ").append(title).append('>');
                if (readOnly) {
                    sb.append("{{").append(entityField.getFieldId()).append("}}");
                } else {
                    if (locked) {
                        sb.append("<div style=\"width:100%;");
                        sb.append(" cellid=\"").append(entityField.getFieldId()).append("\" ");
                        sb.append(" sheetid=\"").append(sheetId).append("\" ");
                        sb.append(" >{{").append(entityField.getFieldId()).append("}}</div> ");
                    } else {
                        sb.append("<input type=\"text\" style=\"width:100%;\" ");
                        if ("Decimal".equals(entityField.getFieldType())) {
                            sb.append(" oninput =\"value=value.replace(/[^\\d.-]/g,'')\"");
                        }
                        sb.append(" cellid=\"").append(entityField.getFieldId()).append("\" ");
                        sb.append(" sheetid=\"").append(sheetId).append("\" ");
                        sb.append(" value=\"{{").append(entityField.getFieldId()).append("}}\" /> ");
                    }
                    if (needRemark) {
                        sb.append("<a href=\"javascript:void(0);\" class=\"remarkClass\" style=\"display:none\"");
                        sb.append(" cellid=\"").append(entityField.getFieldId()).append("\" id=\"remark_").append(entityField.getFieldId()).append(ResManager.loadKDString((String)"\">\u6dfb\u52a0\u4fee\u6539\u5907\u6ce8</a>", (String)"TemplateShowUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    }
                }
                sb.append("</div>");
            }
            if (!SHOW_TYPE_EDIT.equals(showType)) {
                sb.append("<i class=\"tcvat-icon\"");
                sb.append("  id=\"icon_").append(entityField.getFieldId()).append('\"');
                sb.append("  cellid=\"").append(entityField.getFieldId()).append("\"></i>");
                sb.append("</div>");
            }
            text = text.contains("${" + fieldKey + "}") ? text.replace("${" + fieldKey + "}", sb.toString()) : text.replace(fieldKey, sb.toString());
            if (null == itemMap) continue;
            itemMap.clear();
        }
        text = "<div class=\"tcvat-cell\">" + text + "</div>";
        return text;
    }

    public static XSSFCellStyle getCellStyle(XSSFWorkbook wb, EntityField field, Style style) {
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        XSSFColor color = new XSSFColor(Color.BLACK, null);
        cellStyle.setBottomBorderColor(color);
        cellStyle.setLeftBorderColor(color);
        cellStyle.setTopBorderColor(color);
        cellStyle.setRightBorderColor(color);
        XSSFDataFormat fmt = wb.createDataFormat();
        cellStyle.setDataFormat(fmt.getFormat("TEXT"));
        if (field != null) {
            if ("Text".equals(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            } else if ("Date".equals(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            } else if ("Decimal".equals(field.getFieldType())) {
                if (field.getScale() < 1) {
                    cellStyle.setDataFormat(fmt.getFormat("0"));
                } else {
                    String formatSuffix = DECIMAL_SCALE_SUFFIX[field.getScale()];
                    cellStyle.setDataFormat(fmt.getFormat("0." + formatSuffix));
                }
            } else if ("Basedata".equals(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            }
        }
        if (style != null && "@".equals(style.getFormatter())) {
            cellStyle.setDataFormat(fmt.getFormat("TEXT"));
        }
        if (style != null) {
            if (style.gethAlign() != null) {
                switch (style.gethAlign()) {
                    case 0: {
                        cellStyle.setAlignment(HorizontalAlignment.LEFT);
                        break;
                    }
                    case 1: {
                        cellStyle.setAlignment(HorizontalAlignment.CENTER);
                        break;
                    }
                    case 2: {
                        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                        break;
                    }
                    default: {
                        TemplateShowUtils.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 1);
                    }
                }
            }
            if (style.getvAlign() != null) {
                cellStyle.setVerticalAlignment(VerticalAlignment.forInt((int)style.getvAlign()));
            }
        } else {
            TemplateShowUtils.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 1);
            TemplateShowUtils.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 2);
        }
        return cellStyle;
    }

    private static String toNbsp(String str) {
        int start;
        if (str == null) {
            return "&nbsp;";
        }
        if (!str.startsWith(" ")) {
            return str;
        }
        char[] value = str.toCharArray();
        int last = str.length() - 1;
        for (start = 0; start <= last && value[start] <= ' '; ++start) {
        }
        String strt = str.substring(0, start).replaceAll(" ", "&nbsp;");
        if (start == 0) {
            return str;
        }
        if (start >= last) {
            return "";
        }
        return strt + str.substring(start);
    }

    public static Map<String, String> parseCellType(String json) {
        LinkedHashMap<String, String> itemMap = new LinkedHashMap<String, String>();
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)json)) {
            Object jsonObject = JSONObject.parse((String)json);
            if (jsonObject instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)jsonObject;
                for (int i = 0; i < jSONArray.size(); ++i) {
                    JSONObject jon = (JSONObject)jSONArray.get(i);
                    itemMap.put(jon.getString("val"), jon.getString("text"));
                }
            } else if (jsonObject instanceof JSONObject) {
                JSONObject jon = (JSONObject)jsonObject;
                itemMap.put(jon.getString("val"), jon.getString("text"));
            }
        }
        return itemMap;
    }

    public static Map<String, String> parseCellTypeMap(String json) {
        LinkedHashMap<String, String> itemMap = new LinkedHashMap<String, String>();
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)json)) {
            Object jsonObject = JSONObject.parse((String)json);
            if (jsonObject instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)jsonObject;
                for (int i = 0; i < jSONArray.size(); ++i) {
                    JSONObject jon = (JSONObject)jSONArray.get(i);
                    itemMap.put("val", jon.getString("val"));
                    itemMap.put("text", jon.getString("text"));
                    String version = jon.getString("version");
                    itemMap.put("version", StringUtil.isBlank((CharSequence)version) ? "" : version);
                    String multiSelect = jon.getString("multiselect");
                    itemMap.put("multiselect", StringUtil.isBlank((CharSequence)multiSelect) ? "" : multiSelect);
                    String language = jon.getString("language");
                    itemMap.put("language", StringUtil.isBlank((CharSequence)language) ? "" : language);
                    String refprops = jon.getString("refprops");
                    itemMap.put("refprops", StringUtil.isBlank((CharSequence)refprops) ? "" : refprops);
                }
            } else if (jsonObject instanceof JSONObject) {
                JSONObject jon = (JSONObject)jsonObject;
                itemMap.put("val", jon.getString("val"));
                itemMap.put("text", jon.getString("text"));
                itemMap.put("version", jon.getString("version"));
                String multiSelect = jon.getString("multiselect");
                itemMap.put("multiselect", StringUtil.isBlank((CharSequence)multiSelect) ? "" : multiSelect);
                String language = jon.getString("language");
                itemMap.put("language", StringUtil.isBlank((CharSequence)language) ? "" : language);
                String refprops = jon.getString("refprops");
                itemMap.put("refprops", StringUtil.isBlank((CharSequence)refprops) ? "" : refprops);
            }
        }
        return itemMap;
    }

    public static List<String> parseBaseDataFieldList(String basetext) {
        ArrayList<String> selectFieldList = new ArrayList<String>();
        selectFieldList.add("id");
        if (basetext.contains("{")) {
            String[] str;
            for (String s : str = basetext.split("\\{")) {
                String selectField;
                int index = s.indexOf(125);
                if (index <= 0 || selectFieldList.contains(selectField = s.substring(0, index))) continue;
                selectFieldList.add(selectField);
            }
        }
        return selectFieldList;
    }

    public static Map<String, Object> convertMap(Map<String, String> valueMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank(valueMap)) {
            for (Map.Entry<String, String> entry : valueMap.entrySet()) {
                resultMap.put(entry.getKey(), entry.getValue());
            }
        }
        return resultMap;
    }

    public static String getBaseDataDisplayText(String value, String formulaName, Map<String, String> businessMap) {
        Map<String, String> formulaMap = TemplateShowUtils.parseCellTypeMap(formulaName);
        if (!formulaMap.isEmpty()) {
            String fieldName = formulaMap.get("text");
            String tableName = formulaMap.get("val");
            String language = TemplateShowUtils.getLanguage(businessMap, formulaMap);
            List<String> selectFieldList = TemplateShowUtils.parseBaseDataFieldList(fieldName);
            List idList = Stream.of(value.split("\u3001")).filter(StringUtils::isNotEmpty).map(v -> Long.parseLong(v)).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", idList);
            DynamicObjectCollection resultCollection = TemplateShowUtils.queryData(tableName, String.join((CharSequence)",", selectFieldList), new QFilter[]{qFilter}, language);
            return resultCollection.stream().map(result -> TemplateShowUtils.getDisplayText(fieldName, result)).filter(StringUtils::isNotEmpty).collect(Collectors.joining("\u3001"));
        }
        return null;
    }

    public static DynamicObjectCollection queryData(String tableName, String selectFields, QFilter[] qFilters, String language) {
        DynamicObjectCollection objectList = null;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)language)) {
            ORM orm = ORM.create();
            Lang lang = Lang.from((String)language);
            orm.hint().setLang(lang);
            objectList = orm.query(tableName, selectFields, qFilters);
        } else {
            objectList = QueryServiceHelper.query((String)tableName, (String)selectFields, (QFilter[])qFilters);
        }
        return objectList;
    }

    public static String getLanguage(Map<String, String> businessMap, Map<String, String> itemMap) {
        String language = null;
        if (businessMap != null) {
            language = businessMap.get("language");
        }
        if (StringUtil.isEmpty(language) && itemMap != null) {
            language = itemMap.get("language");
        }
        return language;
    }

    public static String getBaseDataDisplayText(String value, Map<String, String> dataBase) {
        return TemplateShowUtils.getBaseDataIdList(value).stream().filter(v -> StringUtil.isNotEmpty((CharSequence)((CharSequence)dataBase.get(v.toString())))).map(v -> (String)dataBase.get(v.toString())).collect(Collectors.joining("\u3001"));
    }

    public static String getBaseDataPropertyValue(String value, Map<String, DynamicObject> dataBase, String field, Map<String, EntityField> typeMap) {
        return TemplateShowUtils.getBaseDataIdList(value).stream().filter(v -> ObjectUtils.isNotEmpty(dataBase.get(v.toString()))).map(v -> TemplateUtils.dataFormatPreSave(((DynamicObject)dataBase.get(v.toString())).get(field), (EntityField)typeMap.get(field))).collect(Collectors.joining("\u3001"));
    }

    public static List<Long> getBaseDataIdList(String value) {
        return Stream.of(value.split("\u3001")).filter(StringUtils::isNotEmpty).map(v -> Long.parseLong(v)).collect(Collectors.toList());
    }

    public static String getDisplayText(String display, DynamicObject result) {
        if (result == null) {
            return "";
        }
        String displayEmpty = display;
        IDataEntityType objType = result.getDataEntityType();
        DataEntityPropertyCollection propertyCollection = objType.getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            display = display.replace("{" + property.getName() + "}", result.getString(property.getName()) == null ? "null" : result.getString(property.getName()));
            displayEmpty = displayEmpty.replace("{" + property.getName() + "}", "");
        }
        if (!display.equals(displayEmpty)) {
            return display;
        }
        return "";
    }

    private static void setCellDefaultAlignmentByFieldType(XSSFCellStyle cellStyle, Style style, EntityField fieldType, int alignmentType) {
        if (cellStyle != null) {
            if (fieldType != null) {
                if (1 == alignmentType) {
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                }
                if (2 == alignmentType) {
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                }
            } else {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            }
        }
        if (style != null) {
            if (fieldType != null) {
                if (1 == alignmentType) {
                    if ("Decimal".equals(fieldType.getFieldType())) {
                        style.sethAlign(2);
                    } else {
                        style.sethAlign(1);
                    }
                }
                if (2 == alignmentType) {
                    style.setvAlign(1);
                }
            } else {
                style.sethAlign(1);
                style.setvAlign(1);
            }
        }
    }

    public static String replaceJson(String type, String json, IPageCache pageCache, boolean keyToValue) {
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)json)) {
            Map<String, String> colsMap = TemplateShowUtils.getColsMap(type, json, pageCache);
            Set<Map.Entry<String, String>> entry = colsMap.entrySet();
            for (Map.Entry<String, String> ent : entry) {
                if (keyToValue) {
                    json = json.replace("${" + ent.getKey() + "}", "${" + ent.getValue() + "}");
                    continue;
                }
                json = json.replace("${" + ent.getValue() + "}", "${" + ent.getKey() + "}");
            }
            return json;
        }
        return "";
    }

    private static Map<String, String> getColsMap(String type, String templateJson, IPageCache pageCache) {
        Map<String, String> colsMap = TreeUtils.getCache(pageCache, type + "allField", Map.class);
        if (colsMap != null) {
            return colsMap;
        }
        if (type != null) {
            Map<String, String> listTab = SpreadUtils.getMetadataNumberMap(SpreadUtils.getSheets(templateJson, null));
            colsMap = TemplateUtils.getAllEntityFieldMap(listTab);
            TreeUtils.putCache(pageCache, type + "allField", colsMap);
            return colsMap;
        }
        return new HashMap<String, String>();
    }

    public static Map<String, FormulaVo> parseCellTypeFormula(String formulaString, Map<String, EntityField> fieldMap, String editFlag, Object sbbid) {
        HashMap<String, FormulaVo> formulaVoMap = new HashMap<String, FormulaVo>();
        return formulaVoMap;
    }

    public static List<FormulaVo> parseCellTypeFormulaList(Map<String, FormulaVo> formulaVoMap) {
        return formulaVoMap.entrySet().stream().map(v -> (FormulaVo)v.getValue()).collect(Collectors.toList());
    }
}

