/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.template;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.LocalMemoryCacheHelper;
import kd.taxc.bdtaxr.common.helper.QueryInHelper;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.CellFormatModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;

public class TemplateUtils {
    private static Log logger = LogFactory.getLog(TemplateUtils.class);
    public static final String EWBLXH = "ewblxh";
    public static final String SPLIT_STRING_SAVE = "#";
    public static final String SPLIT_STRING_SHOW = "_";
    public static final int TAXRATE_EXPANDED_TIMES = 100;
    public static final BigDecimal DEFAULT_VALUE = new BigDecimal("0.00");
    public static final BigDecimal COMPARE_STANDARD_VALUE = new BigDecimal("1.00");
    public static final Pattern FIELDNAME_Pattern = Pattern.compile("[\\[\\]()\uff08\uff09\"\u201c\u201d/]");
    public static final String DEFAULT_DECIMAL_FORMAT = "#####0.00";
    public static final String DECIMAL_INIT_FORMAT = "#####0";
    public static final String MICROMETER_DECIMAL_INIT_FORMAT = "###,##0";
    public static final String SUM = "sum";
    public static final String SEQ = "seq";
    private static final Set<String> BASE_FIELD_LAST = new HashSet<String>();
    private static final String BDTAXR_DECLARE_MAIN_EWBLXH = "tcvat_nsrxx#1#ewblxh";
    private static final String BDTAXR_DECLARE_MAIN_MODIFYTIME = "tcvat_nsrxx#1#modifytime";
    private static final String BDTAXR_DECLARE_MAIN_MODIFIER = "tcvat_nsrxx#1#modifier";
    private static final String BDTAXR_DECLARE_MAIN_BQYBTSE = "tcvat_nsrxx#1#bqybtse";
    private static final String TCVAT_SB_FJSF_BQYBSE = "tcvat_sb_fjsf#9#bqybse";

    public static Set<String> getBaseFieldLast() {
        return BASE_FIELD_LAST;
    }

    public static Map<String, String> queryEntityByTypeId(String typeId) {
        String key;
        LocalMemoryCache cache = LocalMemoryCacheHelper.getLocalCache("tctb");
        LinkedHashMap<String, String> typeMap = (LinkedHashMap<String, String>)cache.get(key = "tpo_template_type" + typeId);
        if (null == typeMap) {
            typeMap = new LinkedHashMap<String, String>();
            String fields = "entryentity.entityid as entityid,entryentity.entityname as entityname ";
            QFilter filter = new QFilter("id", "=", (Object)typeId);
            DynamicObjectCollection entityList = QueryServiceHelper.query((String)"tpo_template_type", (String)fields, (QFilter[])new QFilter[]{filter}, (String)"entryentity.seq");
            if (entityList != null && !entityList.isEmpty()) {
                for (DynamicObject dobj : entityList) {
                    if (!StringUtil.isNotEmpty((CharSequence)dobj.getString("entityid"))) continue;
                    typeMap.put(dobj.getString("entityid"), dobj.getString("entityname"));
                }
            }
        }
        cache.put(key, typeMap);
        return typeMap;
    }

    public static String getMainTableByTemplateId(Long templateId) {
        DynamicObject dobj;
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"bdtaxr_template_main");
        if (templateObject != null && (dobj = (DynamicObject)templateObject.get("type")) != null) {
            return dobj.getString("maintable");
        }
        return null;
    }

    public static Map<String, String> dataToMap(String entityId, String spitStr, QFilter[] filters) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        String allFieldToQuery = MetadataUtil.getAllFieldToQuery(entityId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)allFieldToQuery, (QFilter[])filters);
        if (collection == null || collection.isEmpty()) {
            return dataMap;
        }
        for (DynamicObject dObject : collection) {
            String ewbxh = dObject.getString(EWBLXH);
            for (EntityField field : entityInfo.getFieldList()) {
                if (!dObject.containsProperty(field.getFieldId())) continue;
                Object obj = dObject.get(field.getFieldId());
                String key = entityId + spitStr + ewbxh + spitStr + field.getFieldId();
                if (obj == null) continue;
                dataMap.put(key, TemplateUtils.dataFormatPreSave(obj, field));
            }
        }
        return dataMap;
    }

    public static Map<String, String> dataToMapForExport(String entityId, String spitStr, QFilter[] filters) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        String allFieldToQuery = MetadataUtil.getAllFieldToQuery(entityId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)allFieldToQuery, (QFilter[])filters);
        if (collection == null || collection.isEmpty()) {
            return dataMap;
        }
        String[] split = allFieldToQuery.split(",");
        Map<String, EntityField> map = entityInfo.getFieldList().stream().collect(Collectors.groupingBy(a -> a.getFieldId(), Collectors.reducing(new EntityField(), (m, n) -> n)));
        for (DynamicObject dObject : collection) {
            String ewbxh = dObject.getString(EWBLXH);
            for (String field : split) {
                Object obj = dObject.get(field);
                String key = entityId + spitStr + ewbxh + spitStr + field;
                if (obj == null) continue;
                dataMap.put(key, TemplateUtils.dataFormat(obj, map.get(field)));
            }
        }
        return dataMap;
    }

    public static Map<String, String> dataToMapForExportNew(String entityId, String spitStr, QFilter[] filters) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String allFieldToQuery = MetadataUtil.getAllFieldToQuery(entityId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)allFieldToQuery, (QFilter[])filters);
        if (collection == null || collection.isEmpty()) {
            return dataMap;
        }
        String[] split = allFieldToQuery.split(",");
        for (DynamicObject dObject : collection) {
            String ewbxh = dObject.getString(EWBLXH);
            for (String field : split) {
                Object obj = dObject.get(field);
                String key = entityId + spitStr + ewbxh + spitStr + field;
                if (obj == null) continue;
                dataMap.put(key, String.valueOf(obj));
            }
        }
        return dataMap;
    }

    public static List<Map<String, String>> dataToMapSpecial(String entityId, String spitStr, QFilter[] filters) {
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        String allFields = "id,electronicfileno,leverno,address,taxername,nationtaxsn,localtaxsn,creditcode,registertype,accountway,codeandname,nationtaxorg,localtaxorg,isabroad,isvirtualnode,commitername,commiterphone,grouproll,superorgname,ispointcompany,ispubliccompany,stockno,org";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)allFields, (QFilter[])filters);
        if (collection == null || collection.isEmpty()) {
            return dataList;
        }
        int index = 1;
        entityId = "tcvvt_clique_mcinfo";
        for (DynamicObject dObject : collection) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (String fieldId : allFields.split(",")) {
                Object obj = dObject.get(fieldId);
                String key = entityId + spitStr + index + spitStr + fieldId;
                if (obj == null) continue;
                dataMap.put(key, obj.toString());
            }
            dataList.add(dataMap);
        }
        return dataList;
    }

    public static void deleteData(String templateTypeId, String mainPk) {
        DynamicObject dispatchorder = BusinessDataServiceHelper.loadSingleFromCache((Object)templateTypeId, (String)"tpo_template_type");
        DynamicObjectCollection entityList = dispatchorder.getDynamicObjectCollection("entryentity");
        String mainTable = dispatchorder.getString("maintable");
        if (entityList != null && !entityList.isEmpty()) {
            QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)mainPk);
            for (DynamicObject dobj : entityList) {
                String entityId = dobj.getString("entityid");
                if (mainTable.equals(entityId)) {
                    DeleteServiceHelper.delete((String)mainTable, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(mainPk))});
                    continue;
                }
                DeleteServiceHelper.delete((String)entityId, (QFilter[])new QFilter[]{sbbIdFilter});
            }
        }
    }

    public static void deleteReport(Boolean deleteMainTable, Long orgId, String templateTypeId, Date startDate, Date endDate, String taxLimit) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)endDate);
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        if ("fcscztdsys".equals(templateTypeId)) {
            templateFilter.and(new QFilter("tcrettype", "=", (Object)"fcscztdsys"));
        }
        if (taxLimit != null) {
            templateFilter.and(new QFilter("taxlimit", "=", (Object)taxLimit));
        }
        TemplateUtils.deleteReportByFilter(deleteMainTable, templateTypeId, orgFilter.and(skssqqFilter).and(skssqzFilter).and(templateFilter));
    }

    private static void deleteReportByFilter(Boolean deleteMainTable, String templateTypeId, QFilter filter) {
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)mainTable, (String)"id", (QFilter[])new QFilter[]{filter});
        if (collection == null || collection.isEmpty()) {
            return;
        }
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject dObject : collection) {
            String mainId = dObject.getString("id");
            QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)mainId);
            QFilter sbbIdFilter1 = new QFilter("sbbid", "=", (Object)Long.parseLong(mainId));
            if (entityList == null || entityList.isEmpty()) continue;
            for (DynamicObject dobj : entityList) {
                DynamicObject nsrxx2;
                String entityId = dobj.getString("entityid");
                if (mainTable.equals(entityId)) {
                    if (deleteMainTable.booleanValue()) {
                        DeleteServiceHelper.delete((String)mainTable, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(mainId))});
                        continue;
                    }
                    try {
                        nsrxx2 = BusinessDataServiceHelper.loadSingleFromCache((Object)mainId, (String)mainTable);
                        nsrxx2.set("bqybtse", (Object)0);
                        OperationServiceHelper.executeOperate((String)"save", (String)mainTable, (DynamicObject[])new DynamicObject[]{nsrxx2}, (OperateOption)OperateOption.create());
                    }
                    catch (Exception nsrxx2) {}
                    continue;
                }
                if ("tcvat_prepay_declare_bill".equals(entityId) && !deleteMainTable.booleanValue()) {
                    nsrxx2 = BusinessDataServiceHelper.loadSingleFromCache((String)entityId, (String)"id,bqybtse", (QFilter[])new QFilter[]{sbbIdFilter});
                    nsrxx2.set("bqybtse", (Object)0);
                    OperationServiceHelper.executeOperate((String)"save", (String)entityId, (DynamicObject[])new DynamicObject[]{nsrxx2}, (OperateOption)OperateOption.create());
                    continue;
                }
                QFilter qFilter = DeclareConstant.LONG_SBBID_ENTITIES.contains(entityId) ? sbbIdFilter1 : sbbIdFilter;
                DeleteServiceHelper.delete((String)entityId, (QFilter[])new QFilter[]{qFilter});
            }
        }
    }

    public static void deleteReport(Boolean deleteBill, String serialno, Long orgId, String templateTypeId, Date startDate, Date endDate) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)endDate);
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        templateFilter.and(new QFilter("serialno", "=", (Object)serialno));
        TemplateUtils.deleteReportByFilter(deleteBill, templateTypeId, orgFilter.and(skssqqFilter).and(skssqzFilter).and(templateFilter));
        TemplateUtils.deleteDraftCellEditRecord(serialno);
    }

    public static void deleteDraftCellEditRecord(String serialno) {
        QFilter qFilter = new QFilter("draftnumber", "=", (Object)serialno);
        DeleteServiceHelper.delete((String)"tcvat_draft_edit", (QFilter[])new QFilter[]{qFilter});
    }

    public static void deleteReport(Long orgId, String templateTypeId, Date startDate, Date endDate, String taxLimit) {
        DynamicObjectCollection collection;
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)endDate);
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        if ("fcscztdsys".equals(templateTypeId)) {
            templateFilter.and(new QFilter("tcrettype", "=", (Object)"fcscztdsys"));
        }
        if (taxLimit != null) {
            templateFilter.and(new QFilter("taxlimit", "=", (Object)taxLimit));
        }
        if ((collection = QueryServiceHelper.query((String)mainTable, (String)"id", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, templateFilter})) == null || collection.isEmpty()) {
            return;
        }
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject dObject : collection) {
            String mainId = dObject.getString("id");
            QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)mainId);
            QFilter sbbIdFilter1 = new QFilter("sbbid", "=", (Object)Long.parseLong(mainId));
            if (entityList == null || entityList.isEmpty()) continue;
            logger.info("\u67e5\u8be2\u7684entityList\u7ed3\u679c\u4e3a:{}", (Object)SerializationUtils.toJsonString((Object)entityList));
            for (DynamicObject dobj : entityList) {
                String entityId = dobj.getString("entityid");
                if (mainTable.equals(entityId)) {
                    logger.info("entityId\u7b49\u4e8emainTable\u7684\u60c5\u51b5:{}", (Object)entityId);
                    DeleteServiceHelper.delete((String)mainTable, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(mainId))});
                    continue;
                }
                QFilter qFilter = DeclareConstant.LONG_SBBID_ENTITIES.contains(entityId) ? sbbIdFilter1 : sbbIdFilter;
                int delete = DeleteServiceHelper.delete((String)entityId, (QFilter[])new QFilter[]{qFilter});
                logger.info("TemplateUtils\u4e2d\u6267\u884c\u7ed3\u679c\u4e3a\uff1a{},entityId={},qFilter={}", new Object[]{delete, entityId, SerializationUtils.toJsonString((Object)qFilter)});
            }
        }
    }

    public static void deleteReport(ImportDataVo vo) {
        DynamicObjectCollection collection;
        Long orgId = Long.parseLong(vo.getOrgId());
        String templateTypeId = vo.getTemplateTypeId();
        Date startDate = vo.getStartDate();
        Date endDate = vo.getEndDate();
        String taxLimit = vo.getTaxLimit();
        String taxauthority = vo.getTaxauthority();
        String businessno = vo.getBusinessno();
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getDayFirst(startDate));
        QFilter skssqzFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast(endDate));
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        if ("fcscztdsys".equals(templateTypeId)) {
            templateFilter.and(new QFilter("tcrettype", "=", (Object)"fcscztdsys"));
        }
        if (TemplateUtils.isSzys(templateTypeId)) {
            templateFilter.and(new QFilter("taxauthority", "=", (Object)Long.parseLong(taxauthority)));
            templateFilter.and(new QFilter("businessno", "=", (Object)businessno));
        }
        if ("ccxws".equals(templateTypeId)) {
            templateFilter.and(new QFilter("taxauthority", "=", (Object)Long.parseLong(taxauthority)));
        }
        if ("drawback".equals(templateTypeId)) {
            Map<String, String> resultMap = vo.getResultMap();
            String batchNo = resultMap.get("tcetr_declare_main#1#batchno");
            templateFilter.and(new QFilter("batchno", "=", (Object)batchNo));
        }
        if (taxLimit != null) {
            templateFilter.and(new QFilter("taxlimit", "=", (Object)taxLimit));
        }
        if ("latqs".equals(templateTypeId)) {
            templateFilter.and(new QFilter("taxsourceid.number", "=", (Object)vo.getResultMap().get("tcret_tdzzs_base_tax#1#pronumber")));
            collection = QueryServiceHelper.query((String)mainTable, (String)"id", (QFilter[])new QFilter[]{orgFilter, templateFilter});
        } else {
            collection = QueryServiceHelper.query((String)mainTable, (String)"id", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, templateFilter});
        }
        if (collection == null || collection.isEmpty()) {
            return;
        }
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject dObject : collection) {
            String mainId = dObject.getString("id");
            QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)mainId);
            if (entityList != null && !entityList.isEmpty()) {
                for (DynamicObject dobj : entityList) {
                    String entityId = dobj.getString("entityid");
                    if (mainTable.equals(entityId)) {
                        DeleteServiceHelper.delete((String)mainTable, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(mainId))});
                        continue;
                    }
                    if (DeclareConstant.LONG_SBBID_ENTITIES.contains(entityId)) {
                        DeleteServiceHelper.delete((String)entityId, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)Long.parseLong(mainId))});
                        continue;
                    }
                    DeleteServiceHelper.delete((String)entityId, (QFilter[])new QFilter[]{sbbIdFilter});
                }
            }
            SourceOperateHelper.deleteSourceEntity(templateTypeId, Long.parseLong(mainId));
            DeleteServiceHelper.delete((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)String.valueOf(mainId))});
        }
    }

    private static boolean isSzys(String typeId) {
        return Arrays.asList((Object[])TemplateTypeConstant.getTypeMap().get("tcwat")).contains(typeId);
    }

    public static Map<String, String> getAllFieldToShow(Map<String, String> listTab) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (listTab != null) {
            Iterator<String> iterator = listTab.keySet().iterator();
            while (iterator.hasNext()) {
                map.putAll(TemplateUtils.getFieldMap(iterator.next(), SPLIT_STRING_SAVE, SPLIT_STRING_SHOW));
            }
        }
        return map;
    }

    public static Map<String, String> getAllDataToShow(Map<String, String> dataMap, Map<String, EntityField> typeMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (dataMap != null) {
            dataMap.entrySet().stream().forEach(v -> {
                if (((String)v.getKey()).contains(SPLIT_STRING_SAVE)) {
                    String key = ((String)v.getKey()).replaceAll(SPLIT_STRING_SAVE, SPLIT_STRING_SHOW);
                    String ketTemp = ((String)v.getKey()).split(SPLIT_STRING_SAVE)[0] + "_1_" + ((String)v.getKey()).split(SPLIT_STRING_SAVE)[2];
                    map.put(key, TemplateUtils.dataFormat(v.getValue(), (EntityField)typeMap.get(ketTemp)));
                } else {
                    map.put((String)v.getKey(), (String)v.getValue());
                }
            });
        }
        return map;
    }

    public static Map<String, String> getAllMapping(Map<String, String> dataMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (dataMap != null) {
            dataMap.entrySet().stream().forEach(v -> {
                if (((String)v.getKey()).contains(SPLIT_STRING_SAVE)) {
                    String key = ((String)v.getKey()).replaceAll(SPLIT_STRING_SAVE, SPLIT_STRING_SHOW);
                    map.put(key, (String)v.getKey());
                }
            });
        }
        return map;
    }

    public static Map<String, String> getAllFieldToSave(Map<String, String> listTab) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<String> iterator = listTab.keySet().iterator();
        while (iterator.hasNext()) {
            map.putAll(TemplateUtils.getFieldMap(iterator.next(), SPLIT_STRING_SHOW, SPLIT_STRING_SAVE));
        }
        return map;
    }

    public static Map<String, EntityField> getAllEntityByType(String type, String keySplit) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        Map<String, String> entityMap = TemplateUtils.queryEntityByTypeId(type);
        for (Map.Entry<String, String> entity : entityMap.entrySet()) {
            map.putAll(TemplateUtils.getEntityFieldMap(entity.getKey(), keySplit, null));
        }
        return map;
    }

    public static Map<String, EntityField> getAllEntity(Map<String, String> entityMap) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        for (Map.Entry<String, String> entity : entityMap.entrySet()) {
            map.putAll(TemplateUtils.getEntityFieldMap(entity.getKey(), SPLIT_STRING_SAVE, null));
        }
        return map;
    }

    public static Map<String, EntityField> getAllEntityShow(Map<String, String> listTab) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        Iterator<String> iterator = listTab.keySet().iterator();
        while (iterator.hasNext()) {
            map.putAll(TemplateUtils.getEntityFieldMap(iterator.next(), SPLIT_STRING_SAVE, SPLIT_STRING_SHOW));
        }
        return map;
    }

    public static Map<String, EntityField> getAllFieldTypeToShow(Map<String, String> listTab) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>();
        for (Map.Entry<String, String> entry : listTab.entrySet()) {
            EntityInfo entityInfo = MetadataUtil.getEntityById(entry.getKey());
            List<ValueMapItem> ewblxhItems = null;
            for (EntityField entityField : entityInfo.getFieldList()) {
                if (!EWBLXH.equals(entityField.getFieldId())) continue;
                ewblxhItems = entityField.getComboItems();
                break;
            }
            if (ewblxhItems == null) continue;
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String key = entityInfo.getEntityId() + SPLIT_STRING_SHOW + item.getValue() + SPLIT_STRING_SHOW + entityField.getFieldId();
                    String key1 = entityInfo.getEntityId() + SPLIT_STRING_SAVE + item.getValue() + SPLIT_STRING_SAVE + entityField.getFieldId();
                    map.put(key, entityField);
                    map.put(key1, entityField);
                }
            }
        }
        return map;
    }

    public static String dataFormat(Object dataObj, EntityField fieldType) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("Decimal".equals(fieldType.getFieldType())) {
                try {
                    if (dataObj == null || StringUtil.isEmpty((CharSequence)dataObj.toString())) {
                        dataObj = BigDecimal.ZERO.toString();
                    }
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    DecimalFormat decimalFormat = new DecimalFormat(TemplateUtils.getDecimalFormatByMetadataScale(fieldType, MICROMETER_DECIMAL_INIT_FORMAT, DEFAULT_DECIMAL_FORMAT));
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "DateTime".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd HH:mm:ss");
            }
            if (dataObj instanceof Date && "Date".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd");
            }
            if (dataObj instanceof String && "Date".equals(fieldType.getFieldType())) {
                if ("tcetr_declare_main#month".equals(fieldType.getFieldName())) {
                    String dateStr = (String)dataObj;
                    return dateStr.length() > 6 ? DateUtils.format(DateUtils.stringToDate((String)dataObj), DateUtils.YYYYMM) : dateStr;
                }
                if (dataObj.toString().length() > 0) {
                    return DateUtils.format(DateUtils.stringToDateInAnyFormat((String)dataObj), "yyyy-MM-dd");
                }
            } else {
                if ("Integer".equals(fieldType.getFieldType())) {
                    return TemplateUtils.formatInteger(dataObj, MICROMETER_DECIMAL_INIT_FORMAT);
                }
                if (dataObj instanceof String && "Date".equalsIgnoreCase(fieldType.getFieldType())) {
                    String value = (String)dataObj;
                    if (StringUtil.isBlank((CharSequence)value)) {
                        return value;
                    }
                    String formatter = "yyyy-MM-dd";
                    if (fieldType.getFormat() != null && StringUtil.isNotBlank((CharSequence)((SimpleDateFormat)fieldType.getFormat()).toPattern())) {
                        formatter = ((SimpleDateFormat)fieldType.getFormat()).toPattern();
                    }
                    try {
                        value = DateUtils.format(DateUtils.stringToDate(value, formatter), formatter);
                    }
                    catch (Exception e) {
                        logger.error("\u65f6\u95f4\u683c\u5f0f\u5316\u9519\u8bef\uff1a" + e);
                    }
                    return value;
                }
            }
        }
        return dataObj.toString();
    }

    public static String dataFormatPreSave(Object dataObj, EntityField fieldType) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("Decimal".equalsIgnoreCase(fieldType.getFieldType()) || "Amount".equals(fieldType.getFieldType())) {
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    DecimalFormat decimalFormat = new DecimalFormat(TemplateUtils.getDecimalFormatByMetadataScale(fieldType, DECIMAL_INIT_FORMAT, DEFAULT_DECIMAL_FORMAT));
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "DateTime".equalsIgnoreCase(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd HH:mm:ss");
            }
            if (dataObj instanceof Date && "Date".equalsIgnoreCase(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd");
            }
            if ("Integer".equalsIgnoreCase(fieldType.getFieldType())) {
                return TemplateUtils.formatInteger(dataObj, DECIMAL_INIT_FORMAT);
            }
        }
        return dataObj.toString();
    }

    public static void main(String[] args) {
        EntityField entityField = new EntityField();
        entityField.setScale(2);
        entityField.setFieldType("Decimal");
        String value = "123254352342.345";
        String str = TemplateUtils.dataFormatPreSave(value, entityField);
        System.out.println(str);
        System.out.println(TemplateUtils.dataFormat(value, entityField));
        BigDecimal bignum1 = new BigDecimal(value);
        String str2 = String.valueOf(bignum1.setScale(2, 4));
        System.out.println(str2);
        System.out.println(new DecimalFormat("0.00").format(new BigDecimal(value)));
        double pi = 12.345;
        String ss = "12.345";
        BigDecimal bdss = new BigDecimal(ss);
        DecimalFormat df = new DecimalFormat(DEFAULT_DECIMAL_FORMAT);
        df.setRoundingMode(RoundingMode.HALF_UP);
        System.out.println(df.format(pi));
        System.out.println(df.format(bdss));
    }

    public static String dataFormat(Object dataObj, EntityField fieldType, int expandedTimes) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("Decimal".equals(fieldType.getFieldType())) {
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    if (bd.compareTo(COMPARE_STANDARD_VALUE) <= 0) {
                        bd = bd.multiply(new BigDecimal(expandedTimes));
                    }
                    DecimalFormat decimalFormat = new DecimalFormat(TemplateUtils.getDecimalFormatByMetadataScale(fieldType, DECIMAL_INIT_FORMAT, DEFAULT_DECIMAL_FORMAT));
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "DateTime".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd HH:mm:ss");
            }
            if (dataObj instanceof Date && "Date".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd");
            }
            if ("Integer".equals(fieldType.getFieldType())) {
                return TemplateUtils.formatInteger(dataObj, DECIMAL_INIT_FORMAT);
            }
        }
        return dataObj.toString();
    }

    private static String formatInteger(Object dataObj, String initFormat) {
        try {
            String val = dataObj.toString();
            BigDecimal bd = new BigDecimal(val);
            StringBuilder format = new StringBuilder(initFormat);
            if (val.contains(".")) {
                String decimalPlace = val.substring(val.lastIndexOf(46) + 1);
                int scale = decimalPlace.length();
                for (int i = 0; i < scale; ++i) {
                    if (i == 0) {
                        format.append('.');
                    }
                    format.append('0');
                }
            }
            DecimalFormat decimalFormat = new DecimalFormat(format.toString());
            decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
            return decimalFormat.format(bd);
        }
        catch (Exception e) {
            return dataObj.toString();
        }
    }

    public static String getDecimalFormatByMetadataScale(EntityField fieldType, String initFormat, String defaultDecimalFormat) {
        if (null != fieldType) {
            StringBuilder format = new StringBuilder(initFormat);
            int scale = fieldType.getScale();
            for (int i = 0; i < scale; ++i) {
                if (i == 0) {
                    format.append('.');
                }
                format.append('0');
            }
            return format.toString();
        }
        return defaultDecimalFormat;
    }

    public static String getDecimalFormatByMetadataScale(CellFormatModel fieldType, String initFormat, String defaultDecimalFormat) {
        if (null != fieldType) {
            StringBuilder format = new StringBuilder(initFormat);
            int scale = fieldType.getScale();
            for (int i = 0; i < scale; ++i) {
                if (i == 0) {
                    format.append('.');
                }
                format.append('0');
            }
            return format.toString();
        }
        return defaultDecimalFormat;
    }

    private static Map<String, String> getFieldMap(String entityId, String keySplit, String valSplit) {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        List<ValueMapItem> ewblxhItems = null;
        for (EntityField entityField : entityInfo.getFieldList()) {
            if (!EWBLXH.equals(entityField.getFieldId())) continue;
            ewblxhItems = entityField.getComboItems();
            break;
        }
        if (ewblxhItems != null) {
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String key = entityInfo.getEntityId() + keySplit + item.getValue() + keySplit + entityField.getFieldId();
                    String value = entityInfo.getEntityId() + valSplit + item.getValue() + valSplit + entityField.getFieldId();
                    map.put(key, value);
                }
            }
        }
        return map;
    }

    public static List<String> getEntityFieldList(String entityId) {
        String allFieldStringNoCollection = MetadataUtil.getAllFieldStringNoCollection(entityId);
        List<String> collect = Arrays.stream(allFieldStringNoCollection.split(",")).collect(Collectors.toList());
        return collect;
    }

    public static Map<String, EntityField> getEntityFieldMap(String entityId, String keySplit, String valSplit) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        List<ValueMapItem> ewblxhItems = null;
        for (EntityField entityField : entityInfo.getFieldList()) {
            if (!EWBLXH.equals(entityField.getFieldId())) continue;
            ewblxhItems = entityField.getComboItems();
            break;
        }
        if (ewblxhItems != null) {
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String key = entityInfo.getEntityId() + keySplit + item.getValue() + keySplit + entityField.getFieldId();
                    String value = entityInfo.getEntityId() + valSplit + item.getValue() + valSplit + entityField.getFieldId();
                    EntityField field = new EntityField();
                    field.setEntityId(entityField.getEntityId());
                    field.setEntityName(entityField.getEntityName());
                    if (valSplit == null) {
                        field.setFieldId(entityField.getFieldId());
                    } else {
                        field.setFieldId(value);
                    }
                    field.setFieldType(entityField.getFieldType());
                    field.setFieldName(entityField.getFieldName());
                    field.setMaxLength(entityField.getMaxLength());
                    field.setPrecision(entityField.getPrecision());
                    field.setScale(entityField.getScale());
                    field.setComboItems(entityField.getComboItems());
                    field.setBaseEntityId(entityField.getBaseEntityId());
                    field.setDisplayProp(entityField.getDisplayProp());
                    field.setEwblxh(item.getValue());
                    field.setFormat(entityField.getFormat());
                    if (item.getName() != null) {
                        field.setEwblName(item.getName().getLocaleValue());
                    }
                    map.put(key, field);
                }
            }
        }
        return map;
    }

    public static Map<String, EntityField> getEntityFieldMapForAllImportCheck(String entityId, String keySplit, String valSplit) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        List<ValueMapItem> ewblxhItems = null;
        for (EntityField entityField : entityInfo.getFieldList()) {
            if (!EWBLXH.equals(entityField.getFieldId())) continue;
            ewblxhItems = entityField.getComboItems();
            break;
        }
        if (ewblxhItems != null) {
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String reportId = entityInfo.getEntityId() + keySplit + item.getValue() + keySplit + entityField.getFieldId();
                    String key = "${" + reportId + "}";
                    String value = entityInfo.getEntityId() + valSplit + item.getValue() + valSplit + entityField.getFieldId();
                    EntityField field = new EntityField();
                    field.setEntityId(entityField.getEntityId());
                    field.setEntityName(entityField.getEntityName());
                    if (valSplit == null) {
                        field.setFieldId(entityField.getFieldId());
                    } else {
                        field.setFieldId(value);
                    }
                    field.setFieldType(entityField.getFieldType());
                    field.setFieldName(entityField.getFieldName());
                    field.setMustInput(entityField.isMustInput());
                    field.setMaxLength(entityField.getMaxLength());
                    field.setPrecision(entityField.getPrecision());
                    field.setScale(entityField.getScale());
                    field.setComboItems(entityField.getComboItems());
                    field.setBaseEntityId(entityField.getBaseEntityId());
                    field.setDisplayProp(entityField.getDisplayProp());
                    field.setEwblxh(item.getValue());
                    field.setFormat(entityField.getFormat());
                    field.setReportId(reportId);
                    if (item.getName() != null) {
                        field.setEwblName(item.getName().getLocaleValue());
                    }
                    map.put(key, field);
                }
            }
        }
        return map;
    }

    public static void updateApllyDeclareserialno(String declareserialno) {
        QFilter declareserialnoFilter = new QFilter("declarenumber", "=", (Object)declareserialno);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tcvat_prepay_application", (String)"declarenumber", (QFilter[])new QFilter[]{declareserialnoFilter});
        if (null != dynamicObject) {
            dynamicObject.set("declarenumber", null);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
    }

    public static Map<String, String> getAllEntityFieldMap(Map<String, String> listTab) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<String> iterator = listTab.keySet().iterator();
        while (iterator.hasNext()) {
            map.putAll(TemplateUtils.getEntityFieldMap(iterator.next()));
        }
        return map;
    }

    public static Map<String, String> getEntityFieldMap(String entityId) {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        List<ValueMapItem> ewblxhItems = null;
        for (EntityField entityField : entityInfo.getFieldList()) {
            if (!EWBLXH.equals(entityField.getFieldId())) continue;
            ewblxhItems = entityField.getComboItems();
            break;
        }
        if (ewblxhItems != null) {
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String key = entityInfo.getEntityId() + SPLIT_STRING_SAVE + item.getValue() + SPLIT_STRING_SAVE + entityField.getFieldId();
                    String value = entityInfo.getEntityName() + SPLIT_STRING_SAVE + TemplateUtils.getFieldName(item.getName().getLocaleValue()) + SPLIT_STRING_SAVE + TemplateUtils.getFieldName(entityField.getFieldName());
                    map.put(key, value);
                }
            }
        }
        return map;
    }

    public static String getFieldName(String fieldName) {
        if (fieldName == null) {
            return fieldName;
        }
        Matcher matcher = FIELDNAME_Pattern.matcher(fieldName);
        return matcher.replaceAll("").trim();
    }

    public static void handleTaxRateOnFormShowByTypeAndField(String type, Map<String, String> dataMap) {
        Map<String, EntityField> allEntityByType = TemplateUtils.getAllEntityByType(type, SPLIT_STRING_SHOW);
        if (TemplateUtils.checkTemplateType(type)) {
            for (Map.Entry<String, String> entry : dataMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!TemplateUtils.checkRateColumnByCellKey(key)) continue;
                dataMap.put(key, TemplateUtils.dataFormat(value, allEntityByType.get(key), 100));
            }
        }
    }

    public static void handleSpecialFieldValuePreSave(String templateType, Map<String, String> newMap) {
        if (newMap.containsKey(BDTAXR_DECLARE_MAIN_EWBLXH)) {
            newMap.put(BDTAXR_DECLARE_MAIN_MODIFYTIME, DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
            newMap.put(BDTAXR_DECLARE_MAIN_MODIFIER, RequestContext.get().getUserId());
        }
        if (StringUtils.equals((CharSequence)"fjsf", (CharSequence)templateType)) {
            newMap.put(BDTAXR_DECLARE_MAIN_BQYBTSE, newMap.get(TCVAT_SB_FJSF_BQYBSE));
        }
        if (TemplateUtils.checkTemplateType(templateType)) {
            Map<String, EntityField> allEntityByType = TemplateUtils.getAllEntityByType(templateType, SPLIT_STRING_SAVE);
            for (Map.Entry<String, String> entry : newMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!TemplateUtils.checkRateColumnByCellKey(key)) continue;
                newMap.put(key, StringUtils.isNotBlank((CharSequence)value) ? (new BigDecimal(value).compareTo(COMPARE_STANDARD_VALUE) <= 0 ? value : BigDecimalUtil.divideObject(value, 100, null == allEntityByType.get(key) ? 4 : allEntityByType.get(key).getScale()).toString()) : DEFAULT_VALUE.toString());
            }
        }
    }

    private static boolean checkTemplateType(String type) {
        return StringUtils.equals((CharSequence)"qysdsnb", (CharSequence)type) || StringUtils.equals((CharSequence)"qysdsjb", (CharSequence)type) || StringUtils.equals((CharSequence)"yhs", (CharSequence)type) || StringUtils.equals((CharSequence)"fcscztdsys", (CharSequence)type);
    }

    private static boolean checkRateColumnByCellKey(String key) {
        return key.contains("tccit_qysds_a105050_3_") || key.contains("tccit_qysds_a105050#3#") || key.contains("tccit_qysds_a100000") && key.contains("sl1") || key.contains("tccit_qysds_a105060") && key.contains("ssgdkce") || key.contains("tccit_qysds_zb") && key.contains("sl") || key.contains("tcsd_zb") && key.contains("applicablerate") || (key.contains("tcret_housetax_price") || key.contains("tcret_housetax_hire")) && key.contains("taxrate") || key.contains("tcret_housetax_price") && key.contains("taxationratio") || (key.contains("tcret_housetax_p_info") || key.contains("tcret_housetax_h_info")) && key.contains("taxrate") || key.contains("tcret_housetax_p_info") && key.contains("taxationratio");
    }

    public static String formatMicrometer(String text) {
        DecimalFormat df = null;
        df = text.indexOf(46) > 0 ? (text.length() - text.indexOf(46) - 1 == 0 ? new DecimalFormat("###,##0.") : (text.length() - text.indexOf(46) - 1 == 1 ? new DecimalFormat("###,##0.0") : new DecimalFormat("###,##0.00"))) : new DecimalFormat(MICROMETER_DECIMAL_INIT_FORMAT);
        double number = 0.0;
        try {
            number = Double.parseDouble(text);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

    public static DynamicObject getDynamicTemplateObject(Long baseTemplateId, String orgId, String startDate, String endDate) {
        QFilter qFilter4;
        QFilter qFilter3;
        QFilter qFilter2;
        QFilter qFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_template_float", (String)"id,content,content_tag,html_tag", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("skssqq", "=", (Object)DateUtils.addMonth(DateUtils.stringToDate(startDate), 0)), qFilter3 = new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endDate), 0))), qFilter4 = new QFilter("basetemplateid", "=", (Object)baseTemplateId)});
        if (collection != null && !collection.isEmpty()) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public static DynamicObjectCollection getTemplateFloatSetting(Long baseTemplateId) {
        QFilter qFilter = new QFilter("basetemplateid", "=", (Object)baseTemplateId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_template_floatset", (String)"id,basetemplateid,type,tableentity,direct,maxrow,startrowindex,endrowindex,createrfield,createdatefield,modifierfield,modifydatefield,enable", (QFilter[])new QFilter[]{qFilter});
        return collection;
    }

    public static DynamicObject getTemplateFloatSettingByPrimaryKey(Object primaryKey) {
        QFilter qFilter = new QFilter("id", "=", primaryKey);
        DynamicObject collection = QueryServiceHelper.queryOne((String)"tpo_template_floatset", (String)"id,basetemplateid,type,tableentity,direct,maxrow,startrowindex,endrowindex,createrfield,createdatefield,modifierfield,modifydatefield,enable", (QFilter[])new QFilter[]{qFilter});
        return collection;
    }

    public static String getTemplateContentById(Long templateId) {
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"bdtaxr_template_main");
        return templateObject != null ? templateObject.getString("content_tag") : "";
    }

    public static DynamicObject getTemplateDynamicObjectById(Long templateId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"bdtaxr_template_main");
    }

    public static String getTemplateDataById(Long templateId) {
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"bdtaxr_template_main");
        return templateObject != null ? templateObject.getString("data_tag") : "";
    }

    public static DynamicObject getTemplateObjectById(String templateType, String templateId) {
        QFilter qFilter1 = new QFilter("type", "=", (Object)templateType);
        QFilter qFilter2 = new QFilter("id", "=", (Object)Long.valueOf(templateId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_template_main", (String)"id,number,content,content_tag,html_tag", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (collection != null && !collection.isEmpty()) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public static DynamicObject getTemplateObjectById(String templateId) {
        QFilter qFilter2 = new QFilter("id", "=", (Object)Long.valueOf(templateId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_template_main", (String)"id,number,content,content_tag,html_tag,type.number as typenumber,startdate,enddate", (QFilter[])new QFilter[]{qFilter2});
        if (collection != null && !collection.isEmpty()) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public static DynamicObject getTemplateObject(String orgid, String countryType, String taxtype, Date startDate, Date endDate) {
        QFilter qFilter5;
        QFilter qFilter4;
        QFilter qFilter3;
        QFilter qFilter2;
        QFilter qFilter1 = new QFilter("country", "=", (Object)Long.parseLong(countryType));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_template", (String)"id,number,content,content_tag,html_tag,formula_tag", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("startdate", "<=", (Object)startDate), qFilter3 = QFilter.isNull((String)"enddate").or(new QFilter("enddate", ">=", (Object)endDate)), qFilter4 = new QFilter("taxtype", "=", (Object)Long.parseLong(taxtype)), qFilter5 = new QFilter("org", "=", (Object)Long.parseLong(orgid))});
        if (collection != null && !collection.isEmpty()) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public static DynamicObject getTemplateObject(String templateType, Date startDate, Date endDate) {
        QFilter qFilter1 = new QFilter("type", "=", (Object)templateType);
        QFilter qFilter2 = new QFilter("startdate", "<=", (Object)startDate);
        QFilter qFilter3 = QFilter.isNull((String)"enddate").or(new QFilter("enddate", ">=", (Object)endDate));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_template_main", (String)"id,number,content,content_tag,html_tag", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        if (collection != null && !collection.isEmpty()) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public static DynamicObject getTemplateObjectByConfig(String templateType, String orgid, Date startDate, Date endDate) {
        return TemplateUtils.getTemplateObjectByConfig(templateType, orgid, startDate, endDate, "bdtaxr_template_main", null);
    }

    public static DynamicObject getTemplateObjectByConfig(DeclareRequestModel requestModel) {
        return TemplateUtils.getTemplateObjectByConfig(requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), DateUtils.stringToDate(requestModel.getSkssqq(), "yyyy-MM-dd"), DateUtils.stringToDate(requestModel.getSkssqz(), "yyyy-MM-dd"), "bdtaxr_template_main", null, requestModel.getBusinessMap());
    }

    public static DynamicObject getTemplateObjectByConfig(String templateType, String orgid, Date startDate, Date endDate, String templateEntityId, QFilter filter) {
        return TemplateUtils.getTemplateObjectByConfig(templateType, orgid, startDate, endDate, templateEntityId, filter, null);
    }

    public static Object getTemplateIdByType(String templateType) {
        QFilter typeFilter = new QFilter("type", "=", (Object)templateType);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)LocalDateTime.now()).and(new QFilter("enddate", ">=", (Object)LocalDateTime.now()).or(QFilter.isNull((String)"enddate")));
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_template_main", (String)"id", (QFilter[])new QFilter[]{typeFilter, dateFilter});
        return obj == null ? Integer.valueOf(0) : obj.get("id");
    }

    public static DynamicObjectCollection getAllTemplate() {
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)LocalDateTime.now()).and(new QFilter("enddate", ">=", (Object)LocalDateTime.now()).or(QFilter.isNull((String)"enddate")));
        return QueryServiceHelper.query((String)"bdtaxr_template_main", (String)"", (QFilter[])new QFilter[]{dateFilter});
    }

    public static Object getOldTemplateIdByType(String templateType) {
        QFilter typeFilter = new QFilter("type", "=", (Object)templateType);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)LocalDateTime.now()).and(new QFilter("enddate", ">=", (Object)LocalDateTime.now()).or(QFilter.isNull((String)"enddate")));
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tctb_template", (String)"id", (QFilter[])new QFilter[]{typeFilter, dateFilter});
        return obj == null ? Integer.valueOf(0) : obj.get("id");
    }

    public static DynamicObject getTemplateObjectByConfig(String templateType, String orgid, Date startDate, Date endDate, String templateEntityId, QFilter filter, Map<String, String> businessMap) {
        QFilter qFilter1 = null;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (templateType != null) {
            qFilter1 = new QFilter("type", "=", (Object)templateType);
            filterList.add(qFilter1);
        }
        if (startDate != null) {
            filterList.add(new QFilter("startdate", "<=", (Object)startDate));
        }
        if (endDate != null) {
            filterList.add(QFilter.isNull((String)"enddate").or(new QFilter("enddate", ">=", (Object)endDate)));
        }
        if (filter != null) {
            filterList.add(filter);
        }
        QFilter[] filters = filterList.toArray(new QFilter[0]);
        String selectFields = templateEntityId.equals("tpo_template") ? "id,number,content,content_tag,conditionjson,general" : "id,number,content,content_tag,html_tag,conditionjson,general";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)templateEntityId, (String)selectFields, (QFilter[])filters, (String)"createtime desc");
        DynamicObject templateObj = TemplateUtils.getTemplateObj(dynamicObjectCollection, orgid, businessMap);
        if ("ccxws".equals(templateType) && templateObj == null) {
            QFilter[] qFilterArray;
            QFilter qFilter4 = new QFilter("startdate", "<=", (Object)endDate).and(QFilter.isNull((String)"enddate").or(new QFilter("enddate", ">=", (Object)startDate)));
            if (filter == null) {
                QFilter[] qFilterArray2 = new QFilter[2];
                qFilterArray2[0] = qFilter1;
                qFilterArray = qFilterArray2;
                qFilterArray2[1] = qFilter4;
            } else {
                QFilter[] qFilterArray3 = new QFilter[3];
                qFilterArray3[0] = qFilter1;
                qFilterArray3[1] = qFilter4;
                qFilterArray = qFilterArray3;
                qFilterArray3[2] = filter;
            }
            QFilter[] filters1 = qFilterArray;
            DynamicObjectCollection dynamicObjectCollection2 = QueryServiceHelper.query((String)templateEntityId, (String)selectFields, (QFilter[])filters1, (String)"createtime desc");
            templateObj = TemplateUtils.getTemplateObj(dynamicObjectCollection2, orgid, businessMap);
        }
        return templateObj;
    }

    public static DynamicObject getZeroDeclareTemplate(String templateType, String orgId, Date startDate, Date endDate) {
        QFilter qFilter1 = new QFilter("type", "=", (Object)templateType);
        QFilter qFilter2 = new QFilter("startdate", "<=", (Object)startDate);
        QFilter qFilter3 = QFilter.isNull((String)"enddate").or(new QFilter("enddate", ">=", (Object)endDate));
        QFilter[] filters = new QFilter[]{qFilter1, qFilter2, qFilter3};
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bdtaxr_template_main", (String)"id,number,content,content_tag,conditionjson,general", (QFilter[])filters, (String)"createtime desc");
        return TemplateUtils.getZeroTemplate(dynamicObjectCollection, orgId);
    }

    private static DynamicObject getZeroTemplate(DynamicObjectCollection dynamicObjectCollection, String orgid) {
        DynamicObject template = null;
        List configList = dynamicObjectCollection.stream().filter(a -> !a.getBoolean("general") && StringUtil.isNotEmpty((CharSequence)a.getString("conditionjson"))).filter(e -> e.getString("conditionjson").contains("zerodeclare")).collect(Collectors.toList());
        if (configList.size() <= 0) {
            return null;
        }
        Optional<DynamicObject> oneFiter = configList.stream().filter(object -> {
            String conditionjson = object.getString("conditionjson");
            QFilter qFilter4 = FilterBuilderUtils.buildFilter(conditionjson, "tctb_tax_main_form");
            QFilter[] recombine = qFilter4.recombine();
            return recombine.length == 1;
        }).findFirst();
        if (oneFiter.isPresent()) {
            template = oneFiter.get();
        }
        List moreFilter = configList.stream().filter(object -> {
            String conditionjson = object.getString("conditionjson");
            QFilter qFilter4 = FilterBuilderUtils.buildFilter(conditionjson, "tctb_tax_main_form");
            QFilter[] recombine = qFilter4.recombine();
            return recombine.length > 1;
        }).collect(Collectors.toList());
        if (StringUtil.isNotEmpty((CharSequence)orgid) && moreFilter.size() > 0) {
            QFilter orgQfilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgid));
            Optional<DynamicObject> optional = moreFilter.stream().filter(dynamicObject -> {
                String conditionjson = dynamicObject.getString("conditionjson");
                return !CollectionUtils.isEmpty(TemplateUtils.isTaxMainMatched(orgQfilter, conditionjson));
            }).findFirst();
            if (optional.isPresent()) {
                template = optional.get();
            }
        }
        return template;
    }

    private static String getAppidByTemplateType(String templateType) {
        if (templateType.contains("qysds")) {
            return "tccit";
        }
        if (templateType.contains("zzs")) {
            return "tcvat";
        }
        if (templateType.contains("ccxws")) {
            return "tcret";
        }
        if (templateType.contains("FR00")) {
            return "tcvvt";
        }
        return templateType;
    }

    private static DynamicObject getTemplateObj(DynamicObjectCollection dynamicObjectCollection, String orgid, Map<String, String> businessMap) {
        if (dynamicObjectCollection.size() == 1) {
            return (DynamicObject)dynamicObjectCollection.get(0);
        }
        if (dynamicObjectCollection.size() > 1) {
            List configList = dynamicObjectCollection.stream().filter(a -> !a.getBoolean("general") && StringUtil.isNotEmpty((CharSequence)a.getString("conditionjson"))).collect(Collectors.toList());
            List configEmptyList = dynamicObjectCollection.stream().filter(a -> !a.getBoolean("general") && StringUtil.isEmpty((CharSequence)a.getString("conditionjson"))).collect(Collectors.toList());
            Optional<DynamicObject> generalOption = dynamicObjectCollection.stream().filter(a -> a.getBoolean("general")).findFirst();
            DynamicObject template = null;
            if (StringUtil.isNotEmpty((CharSequence)orgid) && !CollectionUtils.isEmpty(configList)) {
                QFilter orgQfilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgid));
                Optional<DynamicObject> optional = configList.stream().filter(dynamicObject -> TemplateUtils.configFilter(businessMap, orgQfilter, dynamicObject)).findFirst();
                if (optional.isPresent()) {
                    template = optional.get();
                }
            }
            if (template == null) {
                if (!CollectionUtils.isEmpty(configEmptyList)) {
                    template = (DynamicObject)configEmptyList.get(0);
                } else if (generalOption.isPresent()) {
                    template = generalOption.get();
                }
            }
            return template;
        }
        return null;
    }

    private static boolean configFilter(Map<String, String> businessMap, QFilter orgQfilter, DynamicObject dynamicObject) {
        String conditionjson = dynamicObject.getString("conditionjson");
        if (conditionjson.contains("zerodeclare")) {
            return false;
        }
        if (!TemplateUtils.isLatProjectAddressMatched(conditionjson, businessMap)) {
            return false;
        }
        return !CollectionUtils.isEmpty(TemplateUtils.isTaxMainMatched(orgQfilter, conditionjson));
    }

    private static List<DynamicObject> isTaxMainMatched(QFilter orgQfilter, String conditionjson) {
        QFilter qFilter4 = FilterBuilderUtils.buildFilter(conditionjson, "tctb_tax_main_form");
        QFilter taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
        TemplateUtils.dealAddress(qFilter4);
        return QueryInHelper.queryBySplitFilter("tctb_tax_main", "id", Collections.singletonList(qFilter4), Lists.newArrayList((Object[])new QFilter[]{orgQfilter, taxationsys}));
    }

    private static boolean isLatProjectAddressMatched(String conditionJson, Map<String, String> businessMap) {
        if (CollectionUtils.isEmpty(businessMap) || !businessMap.containsKey("latprojectid")) {
            return true;
        }
        QFilter configFilter = FilterBuilderUtils.buildFilter(conditionJson, "tctb_tax_main_form");
        TemplateUtils.dealLatAddressFilter(configFilter);
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(businessMap.get("latprojectid")));
        return QueryServiceHelper.exists((String)"tdm_tdzzs_clearing_unit", (QFilter[])new QFilter[]{idFilter, configFilter});
    }

    private static QFilter dealLatAddressFilter(QFilter conditionFilters) {
        String property = conditionFilters.getProperty();
        Object value = conditionFilters.getValue();
        String cp = conditionFilters.getCP();
        if (!property.equals("location") && !property.equals("location.fullname")) {
            conditionFilters.maskCurrent();
        }
        if ("location.fullname".equals(property)) {
            conditionFilters.__setProperty("location");
            List<String> subIds = TemplateUtils.getSubIds(value);
            if (EmptyCheckUtils.isNotEmpty(subIds)) {
                conditionFilters.__setValue(subIds);
                if (cp.equals("=")) {
                    conditionFilters.__setCP("in");
                } else if (cp.equals("!=") || cp.equals("<>")) {
                    conditionFilters.__setCP("not in");
                }
            }
        }
        List nests = conditionFilters.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            TemplateUtils.dealLatAddressFilter(nest.getFilter());
        }
        return conditionFilters;
    }

    public static QFilter dealAddress(QFilter conditionFilters) {
        String property = conditionFilters.getProperty();
        Object value = conditionFilters.getValue();
        String cp = conditionFilters.getCP();
        if (property.contains("zerodeclare") || property.contains("location") || property.contains("location.fullname")) {
            conditionFilters.maskCurrent();
        }
        if ("registeraddress.fullname".equals(property) || "actualaddress.fullname".equals(property)) {
            if (cp.equalsIgnoreCase("not like") || cp.equalsIgnoreCase("like")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\uff0c\u4e0d\u652f\u6301\u914d\u7f6enot_like/like\u8fc7\u6ee4\u6761\u4ef6", (String)"TemplateUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), property));
            }
            if ("registeraddress.fullname".equals(property)) {
                conditionFilters.__setProperty("registeraddress");
            } else if ("actualaddress.fullname".equals(property)) {
                conditionFilters.__setProperty("actualaddress");
            }
            List<String> subIds = TemplateUtils.getSubIds(value);
            if (EmptyCheckUtils.isNotEmpty(subIds)) {
                conditionFilters.__setValue(subIds);
                if (cp.equals("=")) {
                    conditionFilters.__setCP("in");
                } else if (cp.equals("!=") || cp.equals("<>")) {
                    conditionFilters.__setCP("not in");
                }
            }
        }
        List nests = conditionFilters.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            TemplateUtils.dealAddress(nest.getFilter());
        }
        return conditionFilters;
    }

    private static List<String> getSubIds(Object value) {
        List names = null;
        if (value instanceof String) {
            names = Collections.singletonList((String)value);
        } else if (value instanceof List) {
            names = (List)value;
        }
        if (names != null) {
            List<DynamicObject> admindivisions = QueryInHelper.batchQuery("bd_admindivision", "id,fullname", "fullname", names);
            List<String> parentIds = admindivisions.stream().map(a -> a.getString("id")).collect(Collectors.toList());
            ArrayList<String> collectIds = new ArrayList<String>(parentIds.size());
            collectIds.addAll(parentIds);
            TemplateUtils.getSubLeverIds(parentIds, collectIds);
            return collectIds;
        }
        return null;
    }

    private static void getSubLeverIds(List<String> parentIds, List<String> collectIds) {
        List<Object> parentId = parentIds.stream().map(Long::valueOf).collect(Collectors.toList());
        List<DynamicObject> admindivisions = QueryInHelper.batchQuery("bd_admindivision", "id", "parent.id", parentId);
        List<String> listTemp = admindivisions.stream().map(a -> a.getString("id")).collect(Collectors.toList());
        listTemp.removeIf(a -> collectIds.contains(a));
        if (listTemp.size() > 0) {
            collectIds.addAll(listTemp);
            TemplateUtils.getSubLeverIds(listTemp, collectIds);
        }
    }

    public static Boolean queryReportExists(String orgId, String templateTypeId, Date startDate, Date endDate, String taxLimit) {
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter skssqqFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getDayFirst(startDate));
        QFilter skssqzFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast(endDate));
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        if ("fcscztdsys".equals(templateTypeId)) {
            templateFilter.and(new QFilter("tcrettype", "=", (Object)"fcscztdsys"));
        }
        if (taxLimit != null) {
            templateFilter.and(new QFilter("taxlimit", "=", (Object)taxLimit));
        }
        return QueryServiceHelper.exists((String)mainTable, (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, templateFilter});
    }

    public static DynamicObject queryReportExistsId(String orgId, String templateTypeId, Date startDate, Date endDate, String taxLimit) {
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)endDate);
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        if ("fcscztdsys".equals(templateTypeId)) {
            templateFilter.and(new QFilter("tcrettype", "=", (Object)"fcscztdsys"));
        }
        if (taxLimit != null) {
            templateFilter.and(new QFilter("taxlimit", "=", (Object)taxLimit));
        }
        return QueryServiceHelper.queryOne((String)mainTable, (String)"id,datatype", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, templateFilter});
    }

    public static DynamicObject queryReportExists(String orgId, String templateTypeId, Date startDate, Date endDate, String taxauthority, String businessno) {
        QFilter szybhFilter;
        QFilter taxauthorityFilter;
        QFilter templateFilter;
        QFilter skssqzFilter;
        QFilter skssqqFilter;
        QFilter orgFilter;
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        DynamicObject szyObj = QueryServiceHelper.queryOne((String)mainTable, (String)"id,datatype", (QFilter[])new QFilter[]{orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId)), skssqqFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getDayFirst(startDate)), skssqzFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast(endDate)), templateFilter = new QFilter("type", "=", (Object)templateTypeId), taxauthorityFilter = new QFilter("taxauthority", "=", (Object)Long.parseLong(taxauthority)), szybhFilter = new QFilter("businessno", "=", (Object)businessno)});
        if (szyObj != null && "1".equals(szyObj.getString("datatype"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u7a0e\u52a1\u673a\u5173\u3001\u7a0e\u52a1\u7ec4\u7ec7\u3001\u6240\u5c5e\u7a0e\u671f\u3001\u6c34\u8d44\u6e90\u7a0e\u7f16\u53f7\u4e14\u7531\u7cfb\u7edf\u751f\u6210\u7684\u7533\u62a5\u6570\u636e\uff01", (String)"TemplateUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        return szyObj;
    }

    public static DynamicObject queryReportExists(String orgId, String templateTypeId, Date declaredate) {
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth(declaredate);
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth(declaredate);
        QFilter skssqqFilter = new QFilter("declaredate", ">=", (Object)firstDateOfMonth);
        QFilter skssqzFilter = new QFilter("declaredate", "<=", (Object)lastDateOfMonth);
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        DynamicObject qtsfObj = QueryServiceHelper.queryOne((String)mainTable, (String)"id,datatype", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, templateFilter});
        return qtsfObj;
    }

    static {
        BASE_FIELD_LAST.add("id");
        BASE_FIELD_LAST.add(EWBLXH);
        BASE_FIELD_LAST.add("ewblname");
        BASE_FIELD_LAST.add("sbbid");
    }
}

