/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.template.dynamic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.annotation.GlobalDynamicRowPluginFlag;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicCustomFormulaPlugin;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.ObjectUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.formula.FormulaUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class DynamicRowService {
    private static Log logger = LogFactory.getLog(DynamicRowService.class);
    private static final String DYNROWSET_ENTITY_NAME = "bdtaxr_template_dynrow";
    private static String DYNROWSET_ENTITY_NAME_ALL_FIELDS = "id,dynrow_no,rule_name,start_row,enable,rule_id,modifier,creator,template_id,modifytime,createtime,seq_no,group_no,type,pluginpath,disablefrontop,modeltype,filter,dynheader";
    private static final String FORMULA_ENTITY_NAME = "bdtaxr_formula_edit";
    private static final String KEY_FORMAT = "%s#%s#%s";
    private static final String START_ROW = "start_row";
    private static final String DYNROW_NO = "dynrow_no";
    private static final String RULE_ID = "rule_id";

    public static Map<String, FormulaVo> copyFormula(Map<String, FormulaVo> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>();
        if (formulas == null || CollectionUtils.isEmpty(dynList)) {
            return result;
        }
        formulas.values().forEach(v -> {
            String formula = v.getFormula();
            String formulaKey = v.getFormulaKey();
            Map<String, FormulaVo> map = DynamicRowService.copyFormula(DynamicRowService.matchDyn(dynList, formulaKey), v, dynList);
            logger.info("\u52a8\u6001\u884c\u590d\u5236\u516c\u5f0f\uff0c\u539f\u516c\u5f0f\u4e3a\uff1a" + formula + "\uff0c\u590d\u5236\u540e\u7684\u516c\u5f0f\u4e3a\uff1a" + map.toString());
            result.putAll(map);
        });
        return result;
    }

    private static Map<String, FormulaVo> copyFormula(DynamicRowModel rowModel, FormulaVo srcFormulaVo, List<DynamicRowModel> dynList) {
        List<Map<String, String>> rowList = rowModel.getRowList();
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>(CollectionUtils.isEmpty(rowList) ? 0 : rowList.size());
        String formula = srcFormulaVo.getFormula();
        String formulaKey = srcFormulaVo.getFormulaKey();
        if (StringUtil.isBlank((CharSequence)formula) || StringUtil.isBlank((CharSequence)formulaKey)) {
            return result;
        }
        if (!CollectionUtils.isEmpty(rowList)) {
            long startRow = rowModel.getStartRow();
            for (int i = 0; i < rowList.size(); ++i) {
                String newKey = DynamicRowService.getNewKey(formulaKey, (long)i + startRow);
                String formulaTemp = DynamicRowService.handleCopyFormula(formula, formulaKey, rowModel, (long)i + startRow, dynList);
                result.put(newKey, DynamicRowService.bulidFormulaVo(newKey, formulaTemp, srcFormulaVo));
            }
        }
        return result;
    }

    public static String handleCopyFormula(String formula, String formulaKey, DynamicRowModel rowModel, long rowIndex, List<DynamicRowModel> dynList) {
        List<String> list = ParseUtils.parseformula(formula);
        String formulaTemp = formula;
        String tableName = rowModel.getDynRowNo().split("#")[0];
        for (String formulaStr : list) {
            Map<String, String> map = ParseUtils.parseFormulaZKH(formulaStr);
            String key = ParseUtils.getValue(map);
            String type = ParseUtils.getType(map);
            if ("Q".equals(type) && DynamicRowService.matchDyn(dynList, key) != null) {
                formulaTemp = formulaTemp.replaceAll("Q\\[" + key + "\\]", "Q\\[" + DynamicRowService.getNewKey(key, rowIndex) + "\\]");
            }
            if (!"P".equals(type) || !key.contains("#")) continue;
            String[] ary = key.split("#");
            String newKey = DynamicRowService.getJoinKey("#", ary[0], rowIndex, ary[ary.length - 1]);
            formulaTemp = formulaTemp.replaceAll("P\\[" + key + "\\]", "P\\[" + tableName + "_" + newKey + "\\]");
        }
        return formulaTemp;
    }

    public static Map<String, FormulaVo> seqFormula(Map<String, FormulaVo> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>();
        if (formulas == null || CollectionUtils.isEmpty(dynList)) {
            return result;
        }
        long seqNo = 1L;
        String groupNo = "";
        String seq = "";
        for (DynamicRowModel rowModel : dynList) {
            FormulaVo formulaVo = DynamicRowService.findSeqFormulaVo(rowModel.getDynRowNo(), formulas);
            if (null == formulaVo) continue;
            String formula = formulaVo.getFormula();
            String formulaKey = formulaVo.getFormulaKey();
            if (StringUtil.isBlank((CharSequence)groupNo) || !groupNo.equals(rowModel.getGroupNo())) {
                seqNo = 1L;
            }
            groupNo = rowModel.getGroupNo();
            List<Map<String, String>> rowList = rowModel.getRowList();
            if (CollectionUtils.isEmpty(rowList)) continue;
            long startRow = rowModel.getStartRow();
            if (formula.substring(0, 4).equalsIgnoreCase("seq(") && formula.substring(formula.length() - 1).equalsIgnoreCase(")")) {
                seq = formula.replace("seq(", "");
                seq = seq.replace(")", "");
            }
            seqNo = DynamicRowService.getDefaultSeqNo(seq);
            for (int i = 0; i < rowList.size(); ++i) {
                String newKey = DynamicRowService.getNewKey(formulaKey, (long)i + startRow);
                if (seq.equals("00000001")) {
                    String zeroPrefix = "00000000".substring(0, 8 - String.valueOf(seqNo).length());
                    formula = "{C[" + zeroPrefix + seqNo + "]}";
                } else {
                    formula = "{C[" + (seq.contains(".") ? seq.split("\\.")[0] + "." : "") + seqNo + "]}";
                }
                result.put(newKey, DynamicRowService.bulidFormulaVo(newKey, formula, formulaVo.getFormulaType()));
                ++seqNo;
            }
        }
        return result;
    }

    private static long getDefaultSeqNo(String seq) {
        long seqNo = 1L;
        if (StringUtil.isBlank((CharSequence)seq)) {
            return seqNo;
        }
        if (seq.contains(".")) {
            String[] seqs = seq.split("\\.");
            try {
                return Long.parseLong(seqs[seqs.length - 1]);
            }
            catch (Exception e) {
                logger.error("\u5e8f\u53f7\u516c\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + e.getMessage());
            }
        }
        if (seq.equals("00000001")) {
            return seqNo;
        }
        try {
            return Long.parseLong(seq);
        }
        catch (Exception e) {
            logger.error("\u5e8f\u53f7\u516c\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + e.getMessage());
            return seqNo;
        }
    }

    private static FormulaVo findSeqFormulaVo(String dynRowNo, Map<String, FormulaVo> formulas) {
        for (Map.Entry<String, FormulaVo> entry : formulas.entrySet()) {
            FormulaVo formulaVo = entry.getValue();
            if (!formulaVo.getFormulaKey().startsWith(dynRowNo) || !formulaVo.getFormula().contains("seq")) continue;
            return formulaVo;
        }
        return null;
    }

    @Deprecated
    private static FormulaVo bulidFormulaVo(String newKey, String formulaTemp, String formulaType) {
        FormulaVo formulaVo = new FormulaVo();
        formulaVo.setFormulaKey(newKey);
        formulaVo.setFormulaType(StringUtil.isBlank((CharSequence)formulaType) ? "1" : formulaType);
        formulaVo.setFormula(formulaTemp);
        formulaVo.setFormulaName(formulaTemp);
        return formulaVo;
    }

    private static FormulaVo bulidFormulaVo(String newKey, String formulaTemp, FormulaVo formula) {
        FormulaVo formulaVo = new FormulaVo();
        formulaVo.setFormulaKey(newKey);
        formulaVo.setFormulaType(StringUtil.isBlank((CharSequence)formula.getFormulaType()) ? "1" : formula.getFormulaType());
        formulaVo.setFormula(formulaTemp);
        formulaVo.setFormulaName(formulaTemp);
        formulaVo.setContent(formula.getContent());
        formulaVo.setTitle(formula.getTitle());
        return formulaVo;
    }

    public static Map<String, FormulaVo> sumFormula(Map<String, FormulaVo> formulas, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>();
        if (formulas == null) {
            return result;
        }
        formulas.values().forEach(v -> {
            String key = v.getFormulaKey();
            String sumFormula = StringUtil.formatStringNoBlank(v.getFormula());
            List<String> sumFormulas = FormulaUtils.getSumFormula(sumFormula);
            for (String f : sumFormulas) {
                List<String> sumMatchKey = FormulaUtils.getMatchKeyList(f);
                List<String> list = DynamicRowService.getSumFormulaList(dynList, sumMatchKey, key, f);
                if (CollectionUtils.isEmpty(list)) continue;
                StringBuilder formula = new StringBuilder();
                for (int i = 0; i < list.size(); ++i) {
                    if (i == list.size() - 1) {
                        formula.append("{Q[").append(list.get(i)).append("]}");
                        continue;
                    }
                    formula.append("{Q[").append(list.get(i)).append("]}, ");
                }
                sumFormula = sumFormula.replace(f, " sum(" + formula + ")");
            }
            v.setFormula(sumFormula);
            v.setParsed(false);
            result.put(key, (FormulaVo)v);
        });
        return result;
    }

    public static Map<String, FormulaVo> getCustomFormulas(Map<String, FormulaVo> formulas, DeclareRequestModel requestModel, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> result = new HashMap<String, FormulaVo>();
        if (formulas == null) {
            return result;
        }
        formulas.values().forEach(v -> {
            String formula = v.getFormula();
            String pluginName = formula.replace("[DynRowCustomFormula]", "").replace("{", "").replace("}", "");
            logger.info("\u516c\u5f0f\u5904\u7406\u540e\u7684\u81ea\u5b9a\u4e49\u63d2\u4ef6\u4e3a\uff1a{}", (Object)pluginName);
            String resultFlag = "0";
            if (StringUtil.isNotEmpty((CharSequence)pluginName)) {
                try {
                    Class<?> aClass = Class.forName(pluginName);
                    if (AbstractDynamicCustomFormulaPlugin.class.isAssignableFrom(aClass)) {
                        AbstractDynamicCustomFormulaPlugin plugin = (AbstractDynamicCustomFormulaPlugin)aClass.newInstance();
                        logger.info("\u81ea\u5b9a\u4e49\u516c\u5f0f\u7684\u81ea\u5b9a\u4e49\u63d2\u4ef6\u5bf9\u8c61\u4e3a\uff1a{}", (Object)plugin);
                        Map<String, FormulaVo> value = plugin.queryByDeclareRequestModel(requestModel, dynList);
                        logger.info("\u81ea\u5b9a\u4e49\u516c\u5f0f\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", value);
                        if (!CollectionUtils.isEmpty(value)) {
                            result.putAll(value);
                            resultFlag = "1";
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("\u516c\u5f0f\uff1a{}\u83b7\u53d6\u52a8\u6001\u884c\u81ea\u5b9a\u4e49\u516c\u5f0f\u5f02\u5e38\uff1a{}", (Object)formula, (Object)e);
                    resultFlag = "2";
                }
            }
            if ("2".equals(v.getFormulaType()) && "0".equals(resultFlag)) {
                v.setFormula("1");
            }
        });
        return result;
    }

    public static String getNewKey(String srcKey, long rowIndex) {
        String[] ary = srcKey.split("#");
        String newKey = DynamicRowService.getJoinKey("#", ary[0], rowIndex, ary[ary.length - 1]);
        return newKey;
    }

    public static String getJoinKey(String joinStr, Object ... split) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            if (i == split.length - 1) {
                stringBuilder.append(split[i]);
                continue;
            }
            stringBuilder.append(split[i]);
            stringBuilder.append(joinStr);
        }
        return stringBuilder.toString();
    }

    public static Map<String, Object> getDynRowData(List<DynamicRowModel> list) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(list)) {
            return dataMap;
        }
        for (DynamicRowModel rowModel : list) {
            List<Map<String, String>> rowList = rowModel.getRowList();
            if (CollectionUtils.isEmpty(rowList)) continue;
            long startRow = rowModel.getStartRow();
            String tableName = rowModel.getDynRowNo().split("#")[0];
            for (int i = 0; i < rowList.size(); ++i) {
                Map<String, String> map = rowList.get(i);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String key = entry.getKey();
                    if (!key.contains("#")) continue;
                    String[] ary = key.split("#");
                    dataMap.put(DynamicRowService.getJoinKey("#", tableName + "_" + ary[0], (long)i + startRow, ary[ary.length - 1]), entry.getValue());
                }
            }
        }
        return dataMap;
    }

    public static List<String> getSumFormulaList(List<DynamicRowModel> list, List<String> sumFormulaList, String formulaKey, String formula) {
        ArrayList<String> dataResult = new ArrayList<String>();
        if (CollectionUtils.isEmpty(list)) {
            return dataResult;
        }
        for (String sumFormula : sumFormulaList) {
            DynamicRowModel rowModel = DynamicRowService.matchDyn(list, sumFormula);
            if (rowModel != null) {
                List<Map<String, String>> rowList = rowModel.getRowList();
                if (CollectionUtils.isEmpty(rowList)) continue;
                String dynRowNo = rowModel.getDynRowNo();
                String tableName = dynRowNo.split("#")[0];
                long startRow = rowModel.getStartRow();
                String[] ary = sumFormula.split("#");
                DynamicRowService.buildFormulaList(tableName, startRow, rowList, dataResult, ary[ary.length - 1]);
                continue;
            }
            logger.error("\u52a8\u6001\u884csum\u516c\u5f0f\uff0c\u914d\u7f6e\u6709\u8bef:formulaKey=" + formulaKey + ",formula=" + formula);
        }
        return dataResult;
    }

    public static DynamicRowModel matchDyn(List<DynamicRowModel> list, String key) {
        for (DynamicRowModel rowModel : list) {
            String dynRowNo = rowModel.getDynRowNo();
            int startRow = rowModel.getStartRow().intValue();
            String[] keys = key.split("#");
            if (!keys[0].equals(dynRowNo.split("#")[0])) continue;
            if (keys.length < 3) {
                return rowModel;
            }
            int rowIndex = 0;
            try {
                rowIndex = Integer.parseInt(keys[1]);
            }
            catch (NumberFormatException e) {
                logger.error("key\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff01");
            }
            if (rowIndex < startRow) continue;
            return rowModel;
        }
        return null;
    }

    public static boolean isDelKey(List<DynamicRowModel> list, String key) {
        for (DynamicRowModel rowModel : list) {
            String dynRowNo = rowModel.getDynRowNo();
            List<Map<String, String>> rowList = rowModel.getRowList();
            if (!key.startsWith(dynRowNo) || !CollectionUtils.isEmpty(rowList) && rowList.size() != 0) continue;
            return true;
        }
        return false;
    }

    private static List<String> buildFormulaList(String tableName, long startRow, List<Map<String, String>> rowList, List<String> list, String fieldId) {
        if (!CollectionUtils.isEmpty(rowList)) {
            for (int i = 0; i < rowList.size(); ++i) {
                String colKey = DynamicRowService.getJoinKey("#", tableName, (long)i + startRow, fieldId);
                list.add(colKey);
            }
        }
        return list;
    }

    public static List<DynamicRowModel> getDynamicRowList(Long templateId, Map<String, Object> param) {
        List<DynamicRowModel> dynamicRowModelList = DynamicRowService.getDynRowSetList(templateId);
        BussinessParamsVo bussinessParamsVo = new BussinessParamsVo();
        if (param != null) {
            bussinessParamsVo.setOrgId(String.valueOf(param.get("orgId")));
            bussinessParamsVo.setStartDate(param.get("skssqq") == null ? null : DateUtils.stringToDate(param.get("skssqq").toString(), "yyyy-MM-dd"));
            bussinessParamsVo.setEndDate(param.get("skssqz") == null ? null : DateUtils.stringToDate(param.get("skssqz").toString(), "yyyy-MM-dd"));
            bussinessParamsVo.setExtendParams(param);
        }
        ArrayList<String> pluginList = new ArrayList<String>(dynamicRowModelList.size());
        for (DynamicRowModel rowModel : dynamicRowModelList) {
            ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
            String type = rowModel.getType();
            List<Map<String, Object>> dynData = null;
            if (Objects.equals(type, "rule_fetch")) {
                Long ruleId = rowModel.getRuleId();
                dynData = DynamicRowService.getRuleDataByTmpId(ruleId, param);
            } else if (Objects.equals(type, "plugin_fetch")) {
                String pluginpath = rowModel.getPluginpath();
                Map<String, Object> extendParams = bussinessParamsVo.getExtendParams();
                if (extendParams != null) {
                    extendParams.put("dynRowNo", rowModel.getDynRowNo());
                    extendParams.put("templateId", rowModel.getTemplateId());
                }
                logger.info("\u52a8\u6001\u884c\uff1a{}\u63d2\u4ef6pluginpath\uff1a{}", (Object)rowModel.getDynRowNo(), (Object)pluginpath);
                if (StringUtil.isNotEmpty((CharSequence)pluginpath)) {
                    Class<?> aClassTemp = null;
                    try {
                        AbstractDynamicListBasePlugin plugin;
                        Class<?> aClass;
                        aClassTemp = aClass = Class.forName(pluginpath);
                        if (AbstractDynamicListBasePlugin.class.isAssignableFrom(aClass) && (plugin = (AbstractDynamicListBasePlugin)aClass.newInstance()).check(bussinessParamsVo)) {
                            long t1 = System.currentTimeMillis();
                            if (aClass.getAnnotation(GlobalDynamicRowPluginFlag.class) != null) {
                                if (pluginList.contains(pluginpath)) continue;
                                Method m = aClass.getMethod("globalDynrowQuery", BussinessParamsVo.class);
                                Object o = aClass.newInstance();
                                List dynamicRowModelListquery = (List)m.invoke(o, bussinessParamsVo);
                                for (DynamicRowModel d : dynamicRowModelList) {
                                    DynamicRowModel dyn = dynamicRowModelListquery.stream().filter(e -> e.getDynRowNo().equals(d.getDynRowNo())).findFirst().orElse(null);
                                    if (dyn == null) continue;
                                    d.setRowList(dyn.getRowList());
                                }
                                pluginList.add(pluginpath);
                                continue;
                            }
                            dynData = plugin.query(bussinessParamsVo);
                            long t2 = System.currentTimeMillis();
                            logger.info("\u63d2\u4ef6\uff1a{}\uff08{}\uff09\u6267\u884c\u8017\u65f6\uff1a{}", new Object[]{pluginpath, bussinessParamsVo.toString(), t2 - t1});
                        }
                    }
                    catch (Exception e2) {
                        if (null != aClassTemp && aClassTemp.getAnnotation(GlobalDynamicRowPluginFlag.class) != null) {
                            pluginList.add(pluginpath);
                        }
                        logger.error("\u83b7\u53d6\u52a8\u6001\u884c\u6570\u636e\u5217\u8868\u5f02\u5e38\uff1a", (Throwable)e2);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(dynData)) {
                for (Map<String, Object> map : dynData) {
                    HashMap temp = new HashMap();
                    map.entrySet().stream().forEach(v -> temp.put(v.getKey(), v.getValue() == null ? "" : ObjectUtils.getStringByType(v.getValue())));
                    dataList.add(temp);
                }
                logger.info("\u63d2\u4ef6\u6216\u89c4\u5219\uff1a{}\uff0c\u52a8\u6001\u884c\u6570\u636e\uff1a{}", (Object)(EmptyCheckUtils.isNotEmpty(rowModel.getPluginpath()) ? rowModel.getPluginpath() : rowModel.getRuleName()), dynData);
            }
            rowModel.setRowList(dataList);
        }
        return dynamicRowModelList;
    }

    public static List<DynamicRowModel> getInitedDynData(Map<String, DynamicObjectCollection> data, Long templateId) {
        List<DynamicRowModel> dynDoc = DynamicRowService.getDynRowSetList(templateId);
        for (DynamicRowModel dynObj : dynDoc) {
            String dynRowNo = dynObj.getDynRowNo();
            Long startRow = dynObj.getStartRow();
            String entityKey = dynRowNo.split("#")[0];
            DynamicObjectCollection doc = data.get(entityKey);
            if (doc == null) continue;
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            for (DynamicObject d : doc) {
                int ewblxh;
                String ewblxhStr = d.getString("ewblxh");
                if (!FormulaUtils.isNumeric(ewblxhStr) || (long)(ewblxh = Integer.parseInt(ewblxhStr)) < startRow) continue;
                HashMap<String, String> map = new HashMap<String, String>(16);
                for (String fieldId : TemplateUtils.getEntityFieldList(entityKey)) {
                    map.put(DynamicRowService.getJoinKey("#", entityKey, ewblxh, fieldId), d.getString(fieldId));
                }
                list.add(map);
            }
            dynObj.setRowList(list);
        }
        return dynDoc;
    }

    public static Map<String, String> getInitData(List<DynamicRowModel> list) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (DynamicRowModel dynObj : list) {
            List<Map<String, String>> rowList = dynObj.getRowList();
            if (rowList == null) continue;
            for (Map<String, String> map : rowList) {
                data.putAll(map);
            }
        }
        return data;
    }

    public static List<DynamicRowModel> getDynRowSetList(Long templateId) {
        ArrayList<DynamicRowModel> result = new ArrayList<DynamicRowModel>();
        QFilter qFilter = new QFilter("template_id", "=", (Object)templateId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)DYNROWSET_ENTITY_NAME, (String)DYNROWSET_ENTITY_NAME_ALL_FIELDS, (QFilter[])new QFilter[]{qFilter}, (String)"group_no,seq_no");
        if (null == doc) {
            return result;
        }
        for (DynamicObject dynamicObject : doc) {
            DynamicRowModel dynamicRowModel = new DynamicRowModel();
            dynamicRowModel.setTemplateId(dynamicObject.getLong("template_id"));
            dynamicRowModel.setDynRowNo(dynamicObject.getString(DYNROW_NO));
            dynamicRowModel.setStartRow(dynamicObject.getLong(START_ROW));
            dynamicRowModel.setRuleId(dynamicObject.getLong(RULE_ID));
            dynamicRowModel.setRuleName(dynamicObject.getString("rule_name"));
            dynamicRowModel.setSeqNo(dynamicObject.getLong("seq_no"));
            dynamicRowModel.setGroupNo(dynamicObject.getString("group_no"));
            String type = dynamicObject.getString("type");
            dynamicRowModel.setType(type);
            String pluginPath = dynamicObject.getString("pluginpath");
            dynamicRowModel.setPluginpath(pluginPath);
            dynamicRowModel.setDisablefrontop(dynamicObject.getBoolean("disablefrontop"));
            dynamicRowModel.setFilter(dynamicObject.getBoolean("filter"));
            dynamicRowModel.setDynheader(dynamicObject.getInt("dynheader"));
            result.add(dynamicRowModel);
        }
        return result;
    }

    public static List<String> getDynRowNoList(Long templateId) {
        List<DynamicRowModel> doc = DynamicRowService.getDynRowSetList(templateId);
        ArrayList<String> list = new ArrayList<String>(doc.size());
        for (int i = 0; i < doc.size(); ++i) {
            DynamicRowModel dynObj = doc.get(i);
            String dynRowNo = dynObj.getDynRowNo();
            list.add(dynRowNo);
        }
        return list;
    }

    private static List<Map<String, Object>> getRuleDataByTmpId(Long ruleId, Map<String, Object> param) {
        ArrayList<Map<String, Object>> rowList = new ArrayList();
        BussinessParamsVo bussinessParamsVo = new BussinessParamsVo();
        bussinessParamsVo.setOrgId(String.valueOf(param.get("orgId")));
        bussinessParamsVo.setExtendParams(param);
        logger.info("\u5f00\u59cbcalculateService.batchRuleCalService\uff0cbussinessParamsVo={}\uff0cruleId={}", (Object)JsonUtil.toJson(bussinessParamsVo), (Object)ruleId);
        rowList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleCalculateService", (String)"batchRuleCalService", (Object[])new Object[]{JsonUtil.toJson(bussinessParamsVo), ruleId});
        logger.info("\u7ed3\u675fcalculateService.batchRuleCalService,result={}", (Object)JsonUtil.toJson(rowList));
        return rowList;
    }

    private static Map<String, String> getDynRowKeyMapping(Long templateId, String dynRowNo, boolean srcFlag) {
        DynamicObject[] dynamicObjects;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (StringUtil.isBlank((CharSequence)dynRowNo) || templateId == null) {
            return resultMap;
        }
        for (DynamicObject dynObj : dynamicObjects = QueryFormulaService.getFormulaList(templateId)) {
            String key = dynObj.getString("formulakey");
            String formula = dynObj.getString("formula");
            if (!key.startsWith(dynRowNo)) continue;
            String value = "";
            if (srcFlag) {
                value = key.substring(key.lastIndexOf(35) + 1);
            } else if (formula.contains("{P[")) {
                String matchKey = FormulaUtils.getMatchKey(formula);
                if (matchKey.contains("#")) {
                    String[] ary = matchKey.split("#");
                    value = ary[0] + '#' + ary[ary.length - 1];
                } else {
                    value = matchKey;
                }
            }
            resultMap.put(key, value);
        }
        return resultMap;
    }
}

