/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.rule.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class RuleAccessUtil {
    public static final String KEY_ENTITY = "entity";
    public static final String KEY_SUBENTITY = "subEntity";
    public static final String KEY_ORG = "orgstate";
    public static final String KEY_DATE = "datastate";
    public static final String KEY_YEAR = "yearstate";
    public static final String KEY_MONTH = "monthstate";

    public static Map<String, String> getTableFields(Long tableid) {
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)tableid, (String)"tctb_custom_datasource");
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_ENTITY, object.getString("entityname"));
        result.put(KEY_SUBENTITY, object.getString("subname"));
        for (DynamicObject dynamicObject : object.getDynamicObjectCollection("entryentity")) {
            String fieldname = dynamicObject.getString("fieldname");
            String fieldsubname = dynamicObject.getString("fieldsubname");
            String entityname = object.getString("entityname");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityname);
            IDataEntityProperty dataEntityProperty = mainEntityType.findProperty(fieldsubname);
            if (!StringUtil.equalsIgnoreCase((CharSequence)entityname, (CharSequence)fieldsubname) && ObjectUtils.isNotEmpty((Object)dataEntityProperty)) {
                fieldname = fieldsubname + "." + fieldname;
            }
            if (dynamicObject.getBoolean(KEY_ORG)) {
                result.put(KEY_ORG, fieldname);
                continue;
            }
            if (dynamicObject.getBoolean(KEY_DATE)) {
                result.put(KEY_DATE, fieldname);
                continue;
            }
            if (dynamicObject.getBoolean(KEY_YEAR)) {
                result.put(KEY_YEAR, fieldname);
                continue;
            }
            if (!dynamicObject.getBoolean(KEY_MONTH)) continue;
            result.put(KEY_MONTH, fieldname);
        }
        return result;
    }
}

