/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class RuleFilterConditionService {
    private static final String EQUEAL = "67";
    private static final String NOT_EQUEAL = "83";
    private static final String IN = "17";
    private static final String NOT_IN = "34";
    private static final String START_WITH = "60";
    private static final String END_WITH = "211";
    private static final String CONTAIN = "59";
    private static final String NOT_CONTAIN = "58";
    private static final String PERCENT = "%";
    private static final Set<String> compareTypes_need_merge = new HashSet<String>(){
        {
            this.add(RuleFilterConditionService.EQUEAL);
            this.add(RuleFilterConditionService.NOT_EQUEAL);
            this.add(RuleFilterConditionService.CONTAIN);
            this.add(RuleFilterConditionService.NOT_CONTAIN);
            this.add(RuleFilterConditionService.START_WITH);
            this.add(RuleFilterConditionService.END_WITH);
        }
    };
    private static final Set<String> compareTypes_stay_same = new HashSet<String>(){
        {
            this.add(RuleFilterConditionService.IN);
            this.add(RuleFilterConditionService.NOT_IN);
        }
    };

    public static String queryAssgrp(String conditionjson) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionjson, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        List filterRow = filterCondition.getFilterRow();
        filterRow.forEach(e -> {
            if (null != e.getFieldName() && e.getFieldName().equals("assgrp")) {
                RuleFilterConditionService.packageFilter(e, new ArrayList<String>(1));
            }
        });
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser1 = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap1 = ser1.serializeToMap((Object)filterCondition, null);
        return SerializationUtils.toJsonString((Object)filterConditionMap1);
    }

    private static void packageFilter(SimpleFilterRow filterRow, List<String> errors) {
        ArrayList<FilterValue> cache = new ArrayList<FilterValue>(10);
        String compareType = filterRow.getCompareType();
        Set<String> oldCaptionSet = RuleFilterConditionService.validAsstact(filterRow, errors);
        if (oldCaptionSet.size() == 0) {
            oldCaptionSet.add("-1");
        }
        for (String id : oldCaptionSet) {
            FilterValue filterValue = new FilterValue();
            filterValue.setValue((Object)id);
            cache.add(filterValue);
        }
        filterRow.setValue(cache);
        RuleFilterConditionService.getQcp(filterRow, compareType);
    }

    public static Set<String> validAsstact(SimpleFilterRow filterRow, List<String> errors) {
        HashSet<String> oldCaptionSet = new HashSet<String>();
        String compareType = filterRow.getCompareType();
        if (!compareTypes_need_merge.contains(compareType) && !compareTypes_stay_same.contains(compareType)) {
            return oldCaptionSet;
        }
        List content = filterRow.getValue();
        ArrayList cache = new ArrayList();
        StringBuilder values = new StringBuilder();
        HashMap<String, Set<String>> asstactMap = new HashMap<String, Set<String>>(16);
        for (FilterValue filter : content) {
            String inputValue = (String)filter.getValue();
            String[] subAssgrp = inputValue.split(";");
            for (int index = 0; index < subAssgrp.length; ++index) {
                values.append(subAssgrp[index]).append(";");
                if (subAssgrp[index].contains(":")) {
                    String[] assgrpAndDetail = subAssgrp[index].split(":");
                    if (assgrpAndDetail.length == 2) {
                        String assgrpName = assgrpAndDetail[0];
                        String detailName = assgrpAndDetail[1];
                        HashSet<String> detailNameSet = (HashSet<String>)asstactMap.get(assgrpName);
                        if (detailNameSet == null) {
                            detailNameSet = new HashSet<String>(16);
                            detailNameSet.add(detailName);
                            asstactMap.put(assgrpName, detailNameSet);
                            continue;
                        }
                        detailNameSet.add(detailName);
                        asstactMap.put(assgrpName, detailNameSet);
                        continue;
                    }
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a\uff0c\u6b63\u786e\u683c\u5f0f\u5982:\u7269\u6599:\u6253\u5370\u673a.", (String)"RuleFilterConditionService_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return oldCaptionSet;
                }
                filterRow.setValue(cache);
                errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a\uff0c\u6b63\u786e\u683c\u5f0f\u5982:\u7269\u6599:\u6253\u5370\u673a.", (String)"RuleFilterConditionService_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return oldCaptionSet;
            }
        }
        RuleFilterConditionService.queryAsstact(filterRow, errors, asstactMap, oldCaptionSet);
        return oldCaptionSet;
    }

    private static QFilter getFilterByDisplayproperty(String displayproperty, String value) {
        String disprop;
        QFilter qFilter = new QFilter("fullname", "=", (Object)value);
        if (StringUtil.isEmpty((CharSequence)displayproperty)) {
            return qFilter;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)displayproperty, Map.class);
        if (null == map || null == map.get("disp") || null == ((Map)map.get("disp")).get("dispprop")) {
            return qFilter;
        }
        switch (disprop = (String)((Map)map.get("disp")).get("dispprop")) {
            case "1": {
                qFilter = new QFilter("longnumber", "=", (Object)value);
                break;
            }
            case "2": {
                qFilter = new QFilter("fullname", "=", (Object)value);
                break;
            }
            case "3": {
                String[] subs = value.split(",");
                if (subs.length != 2) break;
                qFilter = new QFilter("longnumber", "=", (Object)subs[0]);
            }
        }
        return qFilter;
    }

    private static void queryAsstact(SimpleFilterRow filterRow, List<String> errors, Map<String, Set<String>> asstactMap, Set<String> oldCaptionSet) {
        ArrayList cache = new ArrayList();
        DynamicObjectCollection assgrpList = QueryServiceHelper.query((String)"bd_asstacttype", (String)"name,flexfield,valuesource,disprops,valuetype", (QFilter[])new QFilter[]{new QFilter("name", "in", asstactMap.keySet())});
        if (assgrpList != null) {
            for (DynamicObject assgrp : assgrpList) {
                if (null == assgrp) {
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u5de6\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"RuleFilterConditionService_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return;
                }
                Set<String> detailNameSet = asstactMap.get(assgrp.getString("name"));
                DynamicObjectCollection detail = null;
                String valusSource = assgrp.getString("valuetype").equals("2") ? "bos_assistantdata_detail" : assgrp.getString("valuesource");
                HashSet<Long> idSet = new HashSet<Long>(16);
                for (String detailName : detailNameSet) {
                    if (StringUtil.isEmpty((CharSequence)valusSource)) continue;
                    QFilter qFilter = RuleFilterConditionService.getFilterByDisplayproperty(assgrp.getString("disprops"), detailName);
                    try {
                        detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                        if (null == detail || detail.size() == 0) {
                            if (qFilter.getProperty().equals("fullname")) {
                                qFilter = new QFilter("name", "=", (Object)detailName);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            } else if (qFilter.getProperty().equals("longnumber")) {
                                String[] subs = detailName.split(",");
                                if (subs.length == 2) {
                                    qFilter = new QFilter("number", "=", (Object)subs[0]);
                                    detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                                } else {
                                    qFilter = new QFilter("number", "=", (Object)detailName);
                                    detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (qFilter.getProperty().equals("fullname")) {
                            qFilter = new QFilter("name", "=", (Object)detailName);
                            detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                        }
                        if (qFilter.getProperty().equals("longnumber")) {
                            String[] subs = detailName.split(",");
                            if (subs.length == 2) {
                                qFilter = new QFilter("number", "=", (Object)subs[0]);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            } else {
                                qFilter = new QFilter("number", "=", (Object)detailName);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            }
                        }
                        filterRow.setValue(cache);
                        errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u5de6\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"RuleFilterConditionService_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    if (null == detail || detail.size() == 0) {
                        filterRow.setValue(cache);
                        errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u53f3\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"RuleFilterConditionService_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    Set idList = detail.stream().map(d -> d.get("id")).collect(Collectors.toSet());
                    idSet.addAll(idList);
                }
                RuleFilterConditionService.upDateCacheByAssgrpIds(idSet, assgrp, filterRow.getCompareType(), filterRow, detailNameSet, oldCaptionSet);
            }
        }
    }

    public static void upDateCacheByAssgrpIds(Set<Long> idSet, DynamicObject assgrp, String compareType, SimpleFilterRow filterRow, Set<String> detailNameSet, Set<String> oldCaptionSet) {
        DynamicObjectCollection assgrpAssists;
        String Qcp = RuleFilterConditionService.getQcp(filterRow, compareType);
        switch (assgrp.getString("valuetype")) {
            case "1": 
            case "2": {
                QFilter qFilter = new QFilter("asstype", "=", (Object)assgrp.getString("flexfield"));
                QFilter valFilter1 = new QFilter("assval", "in", idSet);
                assgrpAssists = QueryServiceHelper.query((String)"gl_assist_bd", (String)"hg as id", (QFilter[])new QFilter[]{qFilter, valFilter1});
                break;
            }
            case "3": {
                QFilter nameFilter = new QFilter("asstype", Qcp, (Object)assgrp.getString("flexfield"));
                QFilter valFilter = null;
                for (String detailName : detailNameSet) {
                    if (null == valFilter) {
                        valFilter = new QFilter("assval", Qcp, (Object)detailName);
                        continue;
                    }
                    valFilter.or(new QFilter("assval", Qcp, (Object)detailName));
                }
                String propertyName = "hg as id";
                assgrpAssists = QueryServiceHelper.query((String)"gl_assist_txt", (String)propertyName, (QFilter[])new QFilter[]{nameFilter, valFilter});
                break;
            }
            default: {
                return;
            }
        }
        if (null != assgrpAssists && assgrpAssists.size() != 0) {
            HashSet<String> currentIds = new HashSet<String>();
            for (DynamicObject dynamicObject : assgrpAssists) {
                currentIds.add(String.valueOf(dynamicObject.getLong("id")));
            }
            oldCaptionSet.addAll(currentIds);
        }
    }

    private static String getQcp(SimpleFilterRow filterRow, String compareType) {
        switch (compareType) {
            case "17": {
                return "=";
            }
            case "34": {
                return "=";
            }
            case "67": {
                return "=";
            }
            case "83": {
                return "=";
            }
            case "58": {
                filterRow.setCompareType(NOT_IN);
                return "not like";
            }
            case "59": {
                filterRow.setCompareType(IN);
                return "like";
            }
            case "60": {
                filterRow.setCompareType(IN);
                return "like";
            }
            case "211": {
                filterRow.setCompareType(IN);
                return "like";
            }
        }
        return null;
    }
}

