/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.DeclarePageType;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.IStatusService;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public abstract class AbstractDeclarePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(AbstractDeclarePlugin.class);
    private static final String COMMA = ResManager.loadKDString((String)"\uff0c", (String)"AbstractDeclarePlugin_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    protected static String BAR_KEY = "toolbarap";
    protected static String TOOL_BAR_DECLARE = "toolbarapdeclare";
    protected static final String CONTENT_TAB = "tabcontent";
    protected static final String ORGID_KEY = "orgid";
    protected static final String NEXT_KEY = "next";
    protected static final String FORWARD_KEY = "forward";
    protected static final String EDIT_KEY = "edit";
    protected static final String SAVE_KEY = "save";
    protected static final String CANCEL_KEY = "cancel";
    protected static final String SUBMIT_KEY = "submit";
    protected static final String UNSUBMIT_KEY = "unsubmit";
    protected static final String AUDIT_KEY = "audit";
    protected static final String UNAUDIT_KEY = "unaudit";
    protected static final String FASTSETTING_KEY = "fastsetting";
    protected static final String RECALC_KEY = "recalc";
    protected static final String ORG_SEL = "org";
    protected static final String START_DATE = "startdate";
    protected static final String END_DATE = "enddate";
    protected static final String FOCUS_PAGE = "focuspage";
    protected static final String BILL_STATUS = "cache_billstatus";
    protected static final String SBBID = "cache_sbbid";
    protected static final String STATUS = "status";
    protected static final String READ_ONLY = "readonly";
    protected static final String TOOLBAR_FLEX = "toolbarapflex";
    protected static final String CALLBACKID_MOD = "modifyOrDelete";
    private static Map<String, String> appidCategoryMap = new HashMap<String, String>();
    private Map<String, DeclarePageType> declarePageMap = new HashMap<String, DeclarePageType>();
    private IStatusService statusService;

    public Map<String, DeclarePageType> getDeclarePageMap() {
        return this.declarePageMap;
    }

    public void setDeclarePageMap(Map<String, DeclarePageType> declarePageMap) {
        this.declarePageMap = declarePageMap;
    }

    protected IStatusService getStatusService() {
        return this.statusService;
    }

    protected void setStatusService(IStatusService statusService) {
        this.statusService = statusService;
    }

    public void registerListener(EventObject e) {
        for (int step = 1; step <= this.declarePageMap.size(); ++step) {
            this.addClickListeners(new String[]{"step" + step});
        }
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_DECLARE});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SUBMIT_KEY, SAVE_KEY, CANCEL_KEY});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get(ORGID_KEY) != null && customParams.get("skssqq") != null && customParams.get("skssqz") != null) {
            this.loadFromHyperLinkClick(customParams);
        } else {
            this.loadFromDeclareMenu();
        }
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        String appId = this.getView().getFormShowParameter().getAppId();
        String orgid = (String)customParams.get(ORGID_KEY);
        TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid(appId);
        Boolean checkResult = OrgCheckUtil.check(this.getView(), orgid, appId, licenseTaxEnum != null ? licenseTaxEnum.getCategoryCode() : null);
        if (!checkResult.booleanValue()) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.getPageCache().put(ORGID_KEY, orgid);
            String skssqqstr = (String)customParams.get("skssqq");
            Date skssqq = DateUtils.stringToDate(skssqqstr);
            this.getModel().setValue(START_DATE, (Object)skssqq);
            this.getPageCache().put("skssqq", skssqqstr);
            String skssqzstr = (String)customParams.get("skssqz");
            Date skssqz = DateUtils.stringToDate(skssqzstr);
            this.getModel().setValue(END_DATE, (Object)skssqz);
            this.getPageCache().put("skssqz", skssqzstr);
            this.openDeclarePage(orgid, skssqqstr, skssqzstr);
        }
    }

    private void loadFromDeclareMenu() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        Long orgid = OrgCheckUtil.setDefaultOrg(this.getView(), (Long)RequestContext.get().getOrgId(), col);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (orgid != null) {
            TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid(appId);
            Boolean checkResult = OrgCheckUtil.check(this.getView(), String.valueOf(orgid), appId, licenseTaxEnum != null ? licenseTaxEnum.getCategoryCode() : null);
            if (checkResult.booleanValue()) {
                this.initStartAndEndDate();
                return;
            }
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.getPageCache().put(ORGID_KEY, String.valueOf(orgid));
            this.initStartAndEndDate();
            if (!this.doCustomInAfterCreateNewData(String.valueOf(orgid), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"))) {
                return;
            }
            this.openDeclarePage(String.valueOf(orgid), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
        } else {
            DeclareStepsUtils.resetSteps(this.getDeclarePageMap().size(), "0", "0", this.getView());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"AbstractDeclarePlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    protected boolean doCustomInAfterCreateNewData(String orgId, String skssqq, String skssqz) {
        return true;
    }

    protected void openDeclarePage(String orgid, String skssqq, String skssqz) {
        Map<String, Object> map = this.chooseDeclareFormByDataType(orgid, this.getTemplateType(), skssqq, skssqz);
        if (((Boolean)map.get("flag")).booleanValue()) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)((String)map.get("billstatus")))) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclarePlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclarePlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7a0e", (String)"AbstractDeclarePlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                String taxLimitTips = DateUtils.getTaxLimitTips(DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz));
                String orgname = this.getModel().getValue(ORG_SEL) == null ? "" : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("name");
                String msg = ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u5b58\u5728\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c", (String)"AbstractDeclarePlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\n\u91cd\u65b0\u8ba1\u7a0e\uff1a\u6e05\u7a7a\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u5e76\u4f7f\u7528\u81ea\u52a8\u8ba1\u7a0e", (String)"AbstractDeclarePlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKID_MOD, (IFormPlugin)this), btnNameMaps);
            } else {
                this.showInnerTbPage(String.valueOf(this.getDeclarePageMap().size()), orgid, true);
            }
        } else {
            this.showInnerTbPage("1", orgid);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        switch (e.getProperty().getName()) {
            case "org": {
                DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
                if (null == newOrg) {
                    this.getView().getModel().setValue(ORG_SEL, (Object)this.getPageCache().get(ORGID_KEY));
                    return;
                }
                String neworgid = newOrg.getString("id");
                String appid = this.getView().getFormShowParameter().getAppId();
                if (OrgCheckUtil.check(this.getView(), neworgid, appid, appidCategoryMap.get(appid))) {
                    this.getView().getModel().setValue(ORG_SEL, (Object)this.getPageCache().get(ORGID_KEY));
                    return;
                }
                this.getPageCache().put(ORGID_KEY, neworgid);
                this.initStartAndEndDate();
                break;
            }
            case "startdate": {
                if (null == this.getModel().getValue(ORG_SEL)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclarePlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return;
                }
                Date startDate = (Date)changeData[0].getNewValue();
                this.getPageCache().put("skssqq", DateUtils.format(startDate));
                if (this.isValidDates(startDate, DateUtils.stringToDate(this.getPageCache().get("skssqz")))) break;
                return;
            }
            case "enddate": {
                if (null == this.getModel().getValue(ORG_SEL)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclarePlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return;
                }
                Date endDate = (Date)changeData[0].getNewValue();
                this.getPageCache().put("skssqz", DateUtils.format(endDate));
                if (this.isValidDates(DateUtils.stringToDate(this.getPageCache().get("skssqq")), endDate)) break;
                return;
            }
        }
        this.openDeclarePage(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
    }

    protected boolean isValidDates(Date startDate, Date endDate) {
        String[] taxLimits;
        boolean isvalid = false;
        for (String taxLimit : taxLimits = this.getTaxLimits()) {
            boolean temp = DateUtils.validDateRange(taxLimit, startDate, endDate);
            isvalid |= temp;
        }
        if (!isvalid) {
            String errMsg = this.buildErrorMsg(taxLimits);
            this.getView().showTipNotification(errMsg);
            return false;
        }
        return true;
    }

    private String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a%s\u3002", (String)"AbstractDeclarePlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        ArrayList<String> nameList = new ArrayList<String>(4);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "next": 
            case "forward": {
                this.lastOrNextStep(key);
                break;
            }
            case "save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"AbstractDeclarePlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 1000);
                this.save();
                break;
            }
            case "cancel": {
                LocaleString cancelMsg = new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"AbstractDeclarePlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                this.getView().showLoading(cancelMsg, 3000);
                this.enableSubmitBtn();
                FormulaService.cancel(this.getPageCache());
                this.operationSbb("read");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "edit": {
                this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY});
                this.operationSbb(EDIT_KEY);
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.submit(key);
                break;
            }
            case "recalc": {
                this.recale();
            }
        }
    }

    public void enableSubmitBtn() {
        String focusPage = this.getPageCache().get(FOCUS_PAGE);
        if (focusPage.equals(String.valueOf(this.declarePageMap.size()))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY});
        }
    }

    public void recale() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclarePlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclarePlugin_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5c06\u5bfc\u81f4\u539f\u6709\u6570\u636e\uff08\u5305\u62ec\u624b\u5de5\u8c03\u6574\u7684\u6570\u636e\uff09\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u64cd\u4f5c\uff1f", (String)"AbstractDeclarePlugin_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void submit(String key) {
        String sbbid = this.getPageCache().get(SBBID);
        DynamicObject declare = this.queryNsrxx(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
        if (declare != null) {
            sbbid = declare.getString("id");
            this.getPageCache().put(SBBID, sbbid);
        }
        if (!StringUtils.isEmpty((CharSequence)sbbid)) {
            ArrayList<Object> pklist = new ArrayList<Object>();
            pklist.add(sbbid);
            boolean flag = DeclareUtils.submit(this.getView(), pklist, SUBMIT_KEY, "tcvat_nsrxx", false);
            if (flag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SUBMIT_KEY, SAVE_KEY, RECALC_KEY, CANCEL_KEY});
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c", (String)"AbstractDeclarePlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    public void save() {
        Object type;
        String endDate;
        String startDate;
        String orgId;
        DynamicObject declareMain;
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        IFormPlugin taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("TaxDeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if ((declareMain = this.getDeclareMain(orgId = this.getPageCache().get(ORGID_KEY), startDate = this.getPageCache().get("skssqq"), endDate = this.getPageCache().get("skssqz"), type = childView.getFormShowParameter().getCustomParams().get("templatetype"))) != null && !"A".equals(declareMain.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u5df2\u7ecf\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838,\u4e0d\u5141\u8bb8\u4fee\u6539\u4fdd\u5b58\uff01", (String)"AbstractDeclarePlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class);
                saveClick.invoke((Object)taxDeclarePlugin, childPageCache);
            }
            catch (Exception e) {
                LOGGER.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"AbstractDeclarePlugin_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof KDBizException) {
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    this.getView().showErrorNotification(msg + COMMA + targetException.getMessage());
                } else {
                    this.getView().showErrorNotification(msg);
                }
                return;
            }
            this.operationSbb("read");
        }
        this.enableSubmitBtn();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
        String orgname = org.getString("name");
        AppLogInfo appLogInfo = new AppLogInfo();
        String appId = this.getView().getFormShowParameter().getAppId();
        String appname = appidCategoryMap.get(appId);
        if ("qysds".equals(appname)) {
            appLogInfo.setBizAppID("/Z0U6BXKR4Y+");
            appLogInfo.setBizObjID("tccit_newmainpage");
        } else if ("zzs".equals(appname)) {
            appLogInfo.setBizAppID("/RFP+MBMR+I6");
            appLogInfo.setBizObjID("tcvat_declare_home");
        } else if ("yhs".equals(appname)) {
            appLogInfo.setBizAppID("0O65K4HJ9WA2");
            appLogInfo.setBizObjID("tcsd_draft_page");
        } else {
            appLogInfo.setBizAppID("0WN4LZ29HLGY");
            appLogInfo.setBizObjID("tcct_draft_edit");
        }
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        appLogInfo.setOpName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AbstractDeclarePlugin_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        appLogInfo.setOpDescription(String.format(ResManager.loadKDString((String)"\u5c5e\u671f%1$s\u81f3%2$s\uff0c\u7ec4\u7ec7%3$s\u7684\u7533\u62a5\u8868\u4fdd\u5b58\u6210\u529f", (String)"AbstractDeclarePlugin_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), startDate, endDate, orgname));
        service.addLog(appLogInfo);
    }

    public DynamicObject getDeclareMain(String orgid, String startDate, String endDate, Object type) {
        QFilter q1 = new QFilter(ORG_SEL, "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate(startDate));
        QFilter q3 = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate(endDate));
        QFilter q4 = new QFilter("type", "=", type);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_declare_main", (String)"id,billstatus", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        return object;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String startdate = this.getPageCache().get("skssqq");
        String enddate = this.getPageCache().get("skssqz");
        String status = this.getStatusService().getStatus(orgId, startdate, enddate);
        if (key.startsWith("step")) {
            String focuspage;
            String step = key.replace("step", "");
            if (step.equals(focuspage = this.getPageCache().get(FOCUS_PAGE))) {
                return;
            }
            if (Integer.parseInt(status) >= Integer.parseInt(step)) {
                this.showInnerTbPage(step, orgId);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        switch (callBackId = e.getCallBackId()) {
            case "isDeclared": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    PageShowCommon.showBillList(ShowType.NewTabPage, "tcvat_declare_list", this.getView(), null);
                    this.getView().close();
                    break;
                }
                if (e.getResult() != MessageBoxResult.Cancel) break;
                this.getView().close();
                break;
            }
            case "recalc": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String orgId = this.getPageCache().get(ORGID_KEY);
                String startdate = this.getPageCache().get("skssqq");
                String enddate = this.getPageCache().get("skssqz");
                if (orgId == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclarePlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return;
                }
                this.getStatusService().delete(orgId, startdate, enddate);
                TemplateUtils.deleteReport((Boolean)false, Long.parseLong(orgId), this.getTemplateType(), DateUtils.stringToDate(startdate), DateUtils.stringToDate(enddate), null);
                this.showInnerTbPage("1", orgId);
                break;
            }
            case "modifyOrDelete": {
                String orgId = this.getPageCache().get(ORGID_KEY);
                if (e.getResult() == MessageBoxResult.Yes) {
                    String skssqq = this.getPageCache().get("skssqq");
                    String skssqz = this.getPageCache().get("skssqz");
                    TemplateUtils.deleteReport(Long.parseLong(orgId), this.getTemplateType(), DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz), null);
                    this.showInnerTbPage("1", orgId);
                    break;
                }
                if (e.getResult() == MessageBoxResult.No) {
                    if ("head".equals(this.getPageCache().get("orgType"))) {
                        this.showInnerTbPage(String.valueOf(this.getDeclarePageMap().size() - 1), orgId, true);
                        break;
                    }
                    this.showInnerTbPage(String.valueOf(this.getDeclarePageMap().size()), orgId, true);
                    break;
                }
                this.getView().close();
            }
        }
    }

    public void lightenForStatus(String focuspage, String status) {
        DeclareStepsUtils.resetSteps(this.declarePageMap.size(), focuspage, status, this.getView());
        this.setButtonVisible(focuspage);
        this.getPageCache().put(FOCUS_PAGE, focuspage);
    }

    protected void setButtonVisible(String focuspage) {
        if ("1".equals(focuspage)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FORWARD_KEY, EDIT_KEY, SUBMIT_KEY, SAVE_KEY, CANCEL_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{NEXT_KEY});
            this.setSubmitAuditButton();
        } else if (focuspage.equals(String.valueOf(this.declarePageMap.size()))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD_KEY});
            if ("A".equals(this.getPageCache().get(BILL_STATUS)) || StringUtils.isBlank((CharSequence)this.getPageCache().get(BILL_STATUS))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, EDIT_KEY});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, EDIT_KEY});
            }
            this.setSubmitAuditButton();
            this.getView().setVisible(Boolean.FALSE, new String[]{NEXT_KEY, SAVE_KEY, CANCEL_KEY, FASTSETTING_KEY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD_KEY, NEXT_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SUBMIT_KEY, SAVE_KEY, CANCEL_KEY});
            this.setSubmitAuditButton();
        }
    }

    private void setSubmitAuditButton() {
        if ("A".equals(this.getPageCache().get(BILL_STATUS))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FASTSETTING_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{SUBMIT_KEY});
            this.getView().setEnable(Boolean.FALSE, new String[]{UNSUBMIT_KEY});
        } else if ("B".equals(this.getPageCache().get(BILL_STATUS))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, AUDIT_KEY, FASTSETTING_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{UNSUBMIT_KEY, AUDIT_KEY});
            this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY, UNAUDIT_KEY});
        } else if ("C".equals(this.getPageCache().get(BILL_STATUS))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, AUDIT_KEY, FASTSETTING_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{UNAUDIT_KEY});
            this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY});
        }
    }

    protected boolean showInnerTbPage(String focuspage, String orgId) {
        return this.showInnerTbPage(focuspage, orgId, false);
    }

    protected boolean showInnerTbPage(String focuspage, String orgId, boolean editImportData) {
        int i;
        this.beforeShowInnerTbPage(focuspage, orgId);
        String startdate = this.getPageCache().get("skssqq");
        String enddate = this.getPageCache().get("skssqz");
        String status = this.getStatusService().getStatus(orgId, startdate, enddate);
        this.getPageCache().put(STATUS, status);
        if (Integer.parseInt(focuspage) < 3 && Integer.parseInt(focuspage) - Integer.parseInt(status) > 2 && !editImportData) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u6b65\u9aa4\u672a\u8fdb\u884c\u5b8c\u6bd5\u6216\u5931\u8d25\uff0c\u4e0d\u80fd\u8fdb\u884c\u4e0b\u4e00\u6b65\u64cd\u4f5c!", (String)"AbstractDeclarePlugin_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return false;
        }
        this.setButtonStyle(focuspage);
        Map<String, Object> customParams = this.createCustomParams(orgId, startdate, enddate, status, focuspage);
        customParams.put(ORGID_KEY, orgId);
        customParams.put(STATUS, status);
        String rootPageId = this.getView().getPageId();
        customParams.put("rootPageId", rootPageId);
        customParams.put("skssqq", startdate);
        customParams.put("skssqz", enddate);
        customParams.put("statusclass", this.getStatusService().getClass().getName());
        customParams.put("totalsteps", this.getDeclarePageMap().size());
        customParams.put(FOCUS_PAGE, focuspage);
        customParams.put("planid", this.getPageCache().get("planid"));
        boolean readonly = false;
        boolean isDeclare = this.isDeclared(rootPageId, orgId, startdate, enddate);
        if (isDeclare) {
            readonly = true;
        }
        this.getView().setVisible(Boolean.valueOf(!readonly), new String[]{RECALC_KEY});
        customParams.put(READ_ONLY, readonly);
        if (editImportData) {
            customParams.put("refresh", "false");
            for (i = 1; i <= this.declarePageMap.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"step" + i});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{FORWARD_KEY, NEXT_KEY, RECALC_KEY});
        } else {
            for (i = 1; i <= this.declarePageMap.size(); ++i) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"step" + i});
                this.getView().setEnable(Boolean.TRUE, new String[]{FORWARD_KEY, NEXT_KEY, RECALC_KEY});
            }
        }
        FormShowParameter param = this.createShowParameter(focuspage, orgId, startdate, enddate, readonly);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        this.lightenForStatus(focuspage, this.getStatusService().getStatus(orgId, startdate, enddate));
        if ("othertype".equals(this.getPageCache().get("taxPayerType"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FORWARD_KEY, NEXT_KEY, RECALC_KEY});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{FORWARD_KEY, NEXT_KEY, RECALC_KEY});
        }
        this.getView().showForm(param);
        return true;
    }

    public void setButtonStyle(String focuspage) {
        HashMap style = new HashMap(1);
        HashMap map = new HashMap(1);
        HashMap<String, String> margin = new HashMap<String, String>();
        DeclarePageType declarePageType = this.declarePageMap.get(focuspage);
        if ("1".equals(focuspage) && DeclarePageType.TCCT_PAGE1 == declarePageType) {
            margin.put("r", "110px");
        } else if ("1".equals(focuspage) && DeclarePageType.TCVAT_PREPAY_PAGE1 != declarePageType) {
            margin.put("r", "0px");
        } else if (String.valueOf(this.getDeclarePageMap().size()).equals(focuspage)) {
            margin.put("r", "70px");
        } else if (DeclarePageType.TCCIT_Y_PAGE2 == declarePageType || DeclarePageType.TCCIT_Y_PAGE3 == declarePageType || DeclarePageType.TCCIT_Y_PAGE4 == declarePageType || DeclarePageType.TCVAT_PREPAY_PAGE1 == declarePageType) {
            margin.put("r", "70px");
        } else if (DeclarePageType.TCCIT_S_PAGE2 == declarePageType) {
            margin.put("r", "0px");
        } else {
            margin.put("r", "110px");
        }
        style.put("m", margin);
        map.put("s", style);
        this.getView().updateControlMetadata(TOOLBAR_FLEX, map);
    }

    protected FormShowParameter createShowParameter(String focuspage, String orgId, String startdate, String enddate, boolean readonly) {
        DeclarePageType declarePageType = this.declarePageMap.get(focuspage);
        String entity = declarePageType.getEntity();
        if (declarePageType.getShowType().equals("Form")) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId(entity);
            return param;
        }
        if (declarePageType.getShowType().equals("Bill")) {
            BillShowParameter billParam = new BillShowParameter();
            billParam.setFormId(entity);
            billParam.setStatus(readonly ? OperationStatus.VIEW : OperationStatus.EDIT);
            DynamicObject object = this.getStatusService().queryOne(orgId, startdate, enddate);
            if (object != null) {
                billParam.setPkId(object.get("id"));
            }
            return billParam;
        }
        if (declarePageType.getShowType().equals("BillList")) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("bos_list");
            listShowParameter.setFormId(entity);
            return listShowParameter;
        }
        return null;
    }

    protected boolean isDeclared(String rootPageId, String orgId, String startdate, String enddate) {
        DynamicObject declare = this.queryNsrxx(orgId, startdate, enddate);
        IFormView rootView = this.getView().getView(rootPageId);
        IPageCache rootCache = (IPageCache)rootView.getService(IPageCache.class);
        rootCache.put(BILL_STATUS, "A");
        if (declare != null) {
            String status = declare.getString("declarestatus");
            String billstatus = declare.getString("billstatus");
            String id = declare.getString("id");
            rootCache.put(BILL_STATUS, billstatus);
            rootCache.put(SBBID, id);
            if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
                DynamicObject org = (DynamicObject)rootView.getModel().getValue(ORG_SEL);
                String orgName = null != org ? org.getString("name") : "";
                String statusName = this.getStatusLocaleName(status, billstatus);
                String taxlimitStr = DateUtils.getTaxLimitTips(DateUtils.stringToDate(startdate), DateUtils.stringToDate(enddate));
                if (!taxlimitStr.equals("")) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2%3$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"AbstractDeclarePlugin_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, taxlimitStr, statusName);
                    rootView.showTipNotification(msg, Integer.valueOf(5000));
                    this.getView().sendFormAction(rootView);
                }
                return true;
            }
        }
        return false;
    }

    public String getStatusLocaleName(String status, String billstatus) {
        String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279", (String)"AbstractDeclarePlugin_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        if ("C".equals(billstatus)) {
            statusName = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"AbstractDeclarePlugin_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        }
        if ("declared".equals(status)) {
            statusName = ResManager.loadKDString((String)"\u7533\u62a5", (String)"AbstractDeclarePlugin_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        }
        return statusName;
    }

    protected DynamicObject queryNsrxx(String orgId, String startdate, String enddate) {
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate)) {
            return null;
        }
        return YbnsrService.queryYbnsr(orgId, this.getTemplateType(), startdate, enddate, Collections.emptyMap());
    }

    public void operationSbb(String operationType) {
        String oldPageId = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(oldPageId);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        String sheetId = childPageCache.get("sheetid");
        String sheetname = childPageCache.get("sheetname");
        Map customParams = childView.getFormShowParameter().getCustomParams();
        FormShowParameter param = new FormShowParameter();
        customParams.put("operation", operationType);
        customParams.put("sheetid", sheetId);
        customParams.put("refresh", "false");
        if (StringUtils.isNotBlank((CharSequence)sheetname)) {
            customParams.put("sheetname", sheetname);
        }
        param.setFormId(this.getDeclarePageEntity());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        customParams.put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        if (EDIT_KEY.equals(operationType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{SAVE_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{CANCEL_KEY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{EDIT_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{SAVE_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL_KEY});
        }
    }

    private void lastOrNextStep(String step) {
        String newFocusPage;
        String orgId;
        String focusPage = this.getPageCache().get(FOCUS_PAGE);
        String string = orgId = null != this.getPageCache().get("taxorg") ? this.getPageCache().get("taxorg") : this.getPageCache().get(ORGID_KEY);
        if (focusPage == null || orgId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclarePlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        if (LicenseCheckServiceHelper.check(orgId, this.getView(), this.getView().getFormShowParameter().getAppId())) {
            return;
        }
        String startdate = this.getPageCache().get("skssqq");
        String enddate = this.getPageCache().get("skssqz");
        String status = this.getStatusService().getStatus(orgId, startdate, enddate);
        this.getPageCache().put(STATUS, status);
        if (NEXT_KEY.equals(step)) {
            if (focusPage.equals("1") && !this.verifyRegistertime(orgId, enddate)) {
                return;
            }
            if (!this.checkBeforeNextStep(orgId, startdate, enddate, status, focusPage)) {
                return;
            }
            newFocusPage = String.valueOf(Integer.parseInt(focusPage) + 1);
        } else {
            newFocusPage = String.valueOf(Integer.parseInt(focusPage) - 1);
        }
        if (this.showInnerTbPage(newFocusPage, orgId)) {
            this.getPageCache().put(FOCUS_PAGE, newFocusPage);
        }
    }

    protected static void showDeclareEditingForm(String type, String pageName, IFormView view, Map<String, Object> customParams) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(pageName);
        if (customParams == null) {
            param.setCustomParams(new HashMap());
        } else {
            param.setCustomParams(customParams);
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCaption(TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredEditingCn());
        view.showForm(param);
    }

    protected Map<String, Object> chooseDeclareFormByDataType(String orgid, String type, String startDate, String endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject dyo = YbnsrService.queryYbnsr(orgid, type, startDate, endDate, null);
        Boolean flag = Boolean.FALSE;
        String declareStatus = "";
        if (null != dyo && StringUtils.equals((CharSequence)"2", (CharSequence)dyo.getString("datatype"))) {
            declareStatus = dyo.getString("declarestatus");
            map.put("billstatus", dyo.getString("billstatus"));
            flag = Boolean.TRUE;
        }
        map.put("declarestatus", declareStatus);
        map.put("flag", flag);
        return map;
    }

    protected void initStartAndEndDate() {
        Date skssqz;
        Date skssqq;
        String taxLimit;
        switch (taxLimit = this.getTaxLimits()[0]) {
            case "year": {
                skssqq = DateUtils.getFirstDateOfYear(DateUtils.addYear(new Date(), -1));
                skssqz = DateUtils.getLastDateOfYear(skssqq);
                break;
            }
            case "halfyear": {
                skssqq = DateUtils.getFirstDateOfHalfYear(DateUtils.addMonth(new Date(), -6));
                skssqz = DateUtils.getLastDateOfHalfYear(skssqq);
                break;
            }
            case "season": {
                skssqq = DateUtils.getFirstDateOfSeason(DateUtils.addMonth(new Date(), -3));
                skssqz = DateUtils.getLastDateOfSeason(skssqq);
                break;
            }
            default: {
                skssqq = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(new Date(), -1));
                skssqz = DateUtils.getLastDateOfMonth(skssqq);
            }
        }
        this.getModel().setValue(START_DATE, (Object)skssqq);
        this.getPageCache().put("skssqq", DateUtils.format(skssqq));
        this.getModel().setValue(END_DATE, (Object)skssqz);
        this.getPageCache().put("skssqz", DateUtils.format(skssqz));
    }

    protected String[] getTaxLimits() {
        return new String[]{"month"};
    }

    public abstract String getTemplateType();

    public abstract String getDeclarePageEntity();

    public abstract Map<String, Object> createCustomParams(String var1, String var2, String var3, String var4, String var5);

    public abstract boolean checkBeforeNextStep(String var1, String var2, String var3, String var4, String var5);

    protected void beforeShowInnerTbPage(String focuspage, String orgId) {
    }

    public boolean verifyRegistertime(String orgId, String enddate) {
        boolean isSuss = true;
        if (StringUtil.isNotBlank((CharSequence)orgId)) {
            DynamicObject dynamicObject = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
            if (dynamicObject == null) {
                return true;
            }
            Date fregistertime = dynamicObject.getDate("registertime");
            if (Objects.nonNull(fregistertime) && fregistertime.after(DateUtils.stringToDate(enddate))) {
                isSuss = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u786e\u8ba4\u7533\u62a5\u7684\u6240\u5c5e\u7a0e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u3002", (String)"AbstractDeclarePlugin_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            return isSuss;
        }
        return true;
    }

    static {
        appidCategoryMap.put("tcvat", "zzs");
        appidCategoryMap.put("tccit", "qysds");
        appidCategoryMap.put("tcsd", "yhs");
        appidCategoryMap.put("tcct", "xfs");
    }
}

