/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public abstract class AbstractDeclareReportPlugin
extends AbstractFormPlugin {
    private static final String COMMA = ResManager.loadKDString((String)"\uff0c", (String)"AbstractDeclareReportPlugin_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    private static Log logger = LogFactory.getLog(AbstractDeclareReportPlugin.class);
    protected static final String ORGID_KEY = "orgid";
    protected static final String CONTENT_TAB = "tabcontent";
    protected static String BAR_KEY = "toolbarap";
    protected static String TOOL_BAR_DECLARE = "toolbarapdeclare";
    protected static final String SBBID = "cache_sbbid";
    protected static final String EDIT_KEY = "edit";
    protected static final String SAVE_KEY = "save";
    protected static final String CANCEL_KEY = "cancel";
    protected static final String SUBMIT_KEY = "submit";
    protected static final String RECALC_KEY = "recalc";
    protected static final String VIEW_DRAFT_KEY = "viewdraft";
    protected static final String ONE_KEY_GENERATE = "onekeygenerate";
    protected static final String LINK_TO_DRAFT_LIST = "linktodraftlist";
    protected static final String ORG_SEL = "org";
    public static final String TCTB_DECLARE = "bdtaxr_declare_old";
    protected static final String DECLARE_PAGE_ENTITY = "bdtaxr_declare_old";
    protected static final String BILL_STATUS = "cache_billstatus";
    protected static final String READ_ONLY = "readonly";
    protected static final String CALLBACKID_MOD = "modifyOrDelete";
    protected static final String CALLBACKID_MODIFY = "callback_modify";
    private static final String TEMPLATE_TYPE = "templatetype";
    private static final String TAXPAYER_TYPE_KEY = "taxPayerType";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_DECLARE});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SUBMIT_KEY, SAVE_KEY, CANCEL_KEY});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get(ORGID_KEY) != null && customParams.get("skssqq") != null && customParams.get("skssqz") != null) {
            this.loadFromHyperLinkClick(customParams);
        } else {
            this.loadFromDeclareMenu();
        }
    }

    private void loadFromDeclareMenu() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String appId = this.getView().getFormShowParameter().getAppId();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        Long orgid = OrgCheckUtil.setDefaultOrg(this.getView(), (Long)RequestContext.get().getOrgId(), col);
        if (orgid == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"AbstractDeclareReportPlugin_36", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ORGID_KEY, String.valueOf(orgid));
        this.initPeriod(this.getModel(), this.getPageCache(), String.valueOf(orgid), customParams);
        this.beforeOpenInnerPage(String.valueOf(orgid), customParams);
        this.init();
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        String orgid = (String)customParams.get(ORGID_KEY);
        String appid = this.getView().getFormShowParameter().getAppId();
        TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid(appid);
        String categoryType = Optional.ofNullable(licenseTaxEnum).isPresent() ? licenseTaxEnum.getCategoryCode() : null;
        Boolean checkResult = OrgCheckUtil.check(this.getView(), orgid, appid, categoryType);
        if (!checkResult.booleanValue()) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.getPageCache().put(ORGID_KEY, orgid);
            String skssqqstr = (String)customParams.get("skssqq");
            Date skssqq = DateUtils.stringToDate(skssqqstr);
            this.getModel().setValue("skssqq", (Object)skssqq);
            this.getPageCache().put("skssqq", skssqqstr);
            String skssqzstr = (String)customParams.get("skssqz");
            Date skssqz = DateUtils.stringToDate(skssqzstr);
            this.getModel().setValue("skssqz", (Object)skssqz);
            this.getPageCache().put("skssqz", skssqzstr);
            customParams.get("refresh");
            String startDate = this.getPageCache().get("skssqq");
            String endDate = this.getPageCache().get("skssqz");
            this.getPageCache().put(TAXPAYER_TYPE_KEY, (String)customParams.get(TEMPLATE_TYPE));
            this.openDeclarePage(orgid, skssqqstr, skssqzstr, "true".equals(String.valueOf(customParams.get("refresh"))));
            this.init();
        }
    }

    private void beforeOpenInnerPage(String orgid, Map<String, Object> customParams) {
        String appid = this.getView().getFormShowParameter().getAppId();
        this.getPageCache().put(ORGID_KEY, orgid);
        TaxAppEnum taxAppEnum = TaxAppEnum.getEnumInstanceByAppid(appid);
        Boolean checkResult = OrgCheckUtil.check(this.getView(), orgid, appid, taxAppEnum != null ? taxAppEnum.getCategoryCode() : null);
        if (!checkResult.booleanValue()) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.openDeclarePage(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appid = this.getView().getFormShowParameter().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        if (e.getProperty().getName().equals(ORG_SEL)) {
            Object object = changeData[0].getNewValue();
            if (StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue()) {
                TaxAppEnum taxAppEnum = TaxAppEnum.getEnumInstanceByAppid("tcvat");
                Boolean checkResult = OrgCheckUtil.check(this.getView(), ((DynamicObject)changeData[0].getOldValue()).get("id").toString(), "tcvat", taxAppEnum != null ? taxAppEnum.getCategoryCode() : null);
                if (checkResult.booleanValue()) {
                    return;
                }
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
            String orgid = org.getString("id");
            TaxAppEnum taxAppEnum = TaxAppEnum.getEnumInstanceByAppid(appid);
            Boolean checkResult = OrgCheckUtil.check(this.getView(), orgid, appid, taxAppEnum != null ? taxAppEnum.getCategoryCode() : null);
            if (checkResult.booleanValue()) {
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
            } else {
                this.getPageCache().put(ORGID_KEY, orgid);
                this.initStartAndEndDate(true);
                this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"));
            }
        }
        if (e.getProperty().getName().equals("skssqq")) {
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPlugin_37", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            if (StringUtil.isNotEmpty((CharSequence)this.getPageCache().get("code_change_start"))) {
                this.getPageCache().remove("code_change_start");
                return;
            }
            this.getView().showLoading(null, 1000);
            this.loadData((Date)changeData[0].getNewValue(), (Date)this.getModel().getValue("skssqz"));
        }
        if (e.getProperty().getName().equals("skssqz")) {
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPlugin_37", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            if (StringUtil.isNotEmpty((CharSequence)this.getPageCache().get("code_change_end"))) {
                this.getPageCache().remove("code_change_end");
                return;
            }
            this.getView().showLoading(null, 1000);
            this.loadData((Date)this.getModel().getValue("skssqq"), (Date)changeData[0].getNewValue());
        }
        this.init();
    }

    public void loadData(Date startDate, Date endDate) {
        Boolean flag = this.isValidDates(startDate, endDate);
        if (flag.booleanValue()) {
            this.getPageCache().put("skssqq", DateUtils.format(startDate));
            this.getPageCache().put("skssqz", DateUtils.format(endDate));
            this.openDeclarePage(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), false);
        }
    }

    protected Boolean isValidDates(Date startDate, Date endDate) {
        String[] taxLimits;
        boolean isvalid = Boolean.FALSE;
        for (String taxLimit : taxLimits = this.getTaxLimits()) {
            boolean temp = DateUtils.validDateRange(taxLimit, startDate, endDate);
            isvalid |= temp;
        }
        if (!isvalid) {
            String errMsg = this.buildErrorMsg(taxLimits);
            this.getView().showTipNotification(errMsg);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4e3a%s", (String)"AbstractDeclareReportPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        ArrayList<String> nameList = new ArrayList<String>(4);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map<String, String> dataMap = CacheUtils.getInstance().getDataResult(this.getPageCache());
        this.clientCallBackMethod(dataMap, e.getName());
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        String orgid = this.getPageCache().get(ORGID_KEY);
        if (StringUtil.isBlank((CharSequence)orgid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPlugin_37", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        switch (key = evt.getItemKey()) {
            case "save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"AbstractDeclareReportPlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                this.save();
                break;
            }
            case "cancel": {
                LocaleString cancelMsg = new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"AbstractDeclareReportPlugin_38", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                this.getView().showLoading(cancelMsg, 3000);
                this.enableSubmitBtn();
                FormulaService.cancel(this.getPageCache());
                this.operationSbb("read");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        String orgid = this.getPageCache().get(ORGID_KEY);
        if (StringUtil.isBlank((CharSequence)orgid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPlugin_37", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "edit": {
                this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY});
                this.operationSbb(EDIT_KEY);
                break;
            }
            case "submit": {
                this.submit();
                break;
            }
            case "recalc": {
                this.recalc();
                break;
            }
            case "viewdraft": {
                this.viewDraft();
                break;
            }
            case "onekeygenerate": {
                this.onekeygenerate();
                break;
            }
        }
    }

    protected void viewDraft() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        QFilter orgFilter = new QFilter(ORG_SEL, "=", (Object)Long.valueOf(orgid));
        QFilter startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate(startDate));
        QFilter endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate(endDate));
        String templateType = this.getTemplateType();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(templateType);
        QFilter templateFilter = new QFilter(TEMPLATE_TYPE, "=", (Object)templateEnum.getDraftType());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"id,type", (QFilter[])new QFilter[]{orgFilter, templateFilter, startFilter, endFilter});
        if (dynamicObject == null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(VIEW_DRAFT_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportPlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportPlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
            String orgName = org != null ? org.getString("name") : "";
            String msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5c1a\u672a\u7f16\u5236\u8ba1\u7a0e\u5e95\u7a3f\uff0c\u662f\u5426\u524d\u5f80\u7f16\u5236\uff1f", (String)"AbstractDeclareReportPlugin_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put(ORGID_KEY, orgid);
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", endDate);
            customParams.put("type", dynamicObject.getString("type"));
            customParams.put(TEMPLATE_TYPE, templateEnum.getDraftType());
            PageShowCommon.showForm(ShowType.MainNewTabPage, templateEnum.getDraftPage(), this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void operationSbb(String operationType) {
        String oldPageId = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(oldPageId);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        String sheetId = childPageCache.get("sheetid");
        String sheetname = childPageCache.get("sheetname");
        Map customParams = childView.getFormShowParameter().getCustomParams();
        FormShowParameter param = new FormShowParameter();
        customParams.put("operation", operationType);
        customParams.put("sheetid", sheetId);
        customParams.put("refresh", "false");
        if (StringUtils.isNotBlank((CharSequence)sheetname)) {
            customParams.put("sheetname", sheetname);
        }
        param.setFormId("bdtaxr_declare_old");
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        customParams.put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        if (EDIT_KEY.equals(operationType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{SAVE_KEY, CANCEL_KEY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{EDIT_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{SAVE_KEY, CANCEL_KEY});
        }
    }

    public void save() {
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        String sbbid = childPageCache.get("sbbid");
        if (null != sbbid) {
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"A").and("id", "=", (Object)Long.valueOf(sbbid));
            String templatetype = childPageCache.get(TEMPLATE_TYPE);
            if (templatetype.startsWith("zzs") && !QueryServiceHelper.exists((String)"tcvat_zzs_declare_list", (QFilter[])new QFilter[]{qFilter})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\uff0c\u7533\u62a5\u8868\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"AbstractDeclareReportPlugin_39", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
        }
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("TaxDeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class);
                saveClick.invoke(taxDeclarePlugin, childPageCache);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"AbstractDeclareReportPlugin_40", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof KDBizException) {
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    this.getView().showErrorNotification(msg + COMMA + targetException.getMessage());
                } else {
                    this.getView().showErrorNotification(msg);
                }
                return;
            }
            this.operationSbb("read");
        }
        this.enableSubmitBtn();
    }

    public void enableSubmitBtn() {
        this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY});
    }

    public void submit() {
        String sbbid = null;
        DynamicObject declare = this.queryNsrxx(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
        if (declare != null) {
            sbbid = declare.getString("id");
        }
        if (!StringUtils.isEmpty(sbbid)) {
            ArrayList<Object> pklist = new ArrayList<Object>();
            pklist.add(sbbid);
            boolean flag = DeclareUtils.submit(this.getView(), pklist, SUBMIT_KEY, "tcvat_nsrxx", false);
            if (flag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SUBMIT_KEY, SAVE_KEY, RECALC_KEY, CANCEL_KEY});
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"AbstractDeclareReportPlugin_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    protected DynamicObject queryNsrxx(String orgId, String startdate, String enddate) {
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate)) {
            return null;
        }
        return YbnsrService.queryYbnsr(orgId, this.getTemplateType(), startdate, enddate, Collections.emptyMap());
    }

    private void recalc() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportPlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportPlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5c06\u5bfc\u81f4\u539f\u6709\u7eb3\u7a0e\u7533\u62a5\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportPlugin_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void onekeygenerate() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        if (LicenseCheckServiceHelper.check(orgid, this.getView(), "tcdrs")) {
            return;
        }
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(this.getTemplateType());
        String draftType = templateEnum.getDraftType();
        DynamicObject draft = StatusUtils.queryOne(draftType, orgid, skssqq, skssqz, "nssb");
        if (draft != null) {
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(orgid), (String)"bos_org");
            String msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5728\u3010%2$s\u3011\u81f3\u3010%3$s\u3011\u5df2\u5b58\u5728\u5e95\u7a3f\u6570\u636e\uff0c\u91cd\u65b0\u751f\u6210\u5c06\u5bfc\u81f4\u539f\u6709\u7684\u5e95\u7a3f\u548c\u7533\u62a5\u8868\u6570\u636e\u88ab\u6e05\u9664\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportPlugin_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgObj.getString("name"), skssqq, skssqz);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ONE_KEY_GENERATE, (IFormPlugin)this);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks, null, SerializationUtils.toJsonString((Object)draft));
        } else {
            this.executeEngineHandler(orgid, skssqq, skssqz, this.getTemplateType());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        String templateType = this.getTemplateType();
        switch (callBackId) {
            case "recalc": {
                if (!this.isValidDates((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz")).booleanValue()) {
                    return;
                }
                if (e.getResult() == MessageBoxResult.Yes) {
                    if (orgId == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPlugin_37", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    this.openDeclarePage(orgId, skssqq, skssqz, true);
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{EDIT_KEY});
                this.getView().setVisible(Boolean.FALSE, new String[]{SAVE_KEY, CANCEL_KEY});
                break;
            }
            case "viewdraft": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put(ORGID_KEY, orgId);
                customParams.put("skssqq", skssqq);
                customParams.put("skssqz", skssqz);
                TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(templateType);
                customParams.put(TEMPLATE_TYPE, templateEnum.getDraftType());
                PageShowCommon.showForm(ShowType.MainNewTabPage, templateEnum.getDraftPage(), this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "callback_modify": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    this.showInnerPage(orgId, skssqq, skssqz, false);
                    break;
                }
                this.getView().close();
                break;
            }
            case "modifyOrDelete": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    TemplateUtilsOld.deleteReport(Long.parseLong(orgId), templateType, DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz), null);
                    TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(templateType);
                    StatusUtils.delete(templateEnum.getDraftType(), orgId, skssqq, skssqz, "nssb");
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    customParams.put(ORGID_KEY, orgId);
                    customParams.put("skssqq", skssqq);
                    customParams.put("skssqz", skssqz);
                    PageShowCommon.showForm(ShowType.MainNewTabPage, templateEnum.getDraftPage(), this.getView(), customParams, (IFormPlugin)this);
                    this.getView().close();
                    break;
                }
                if (e.getResult() == MessageBoxResult.No) {
                    this.showInnerPage(orgId, skssqq, skssqz, false);
                    break;
                }
                this.getView().close();
                break;
            }
            case "onekeygenerate": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String customVaule = e.getCustomVaule();
                JSONObject object = JSONObject.parseObject((String)customVaule);
                if (!"A".equals(object.getString("billstatus"))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5df2\u63d0\u4ea4\u5ba1\u6838\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u662f\u5426\u9700\u8981\u524d\u5f80\u5e95\u7a3f\u67e5\u8be2\u754c\u9762\u4fee\u6539\uff1f", (String)"AbstractDeclareReportPlugin_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), object.getString("billno"));
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(LINK_TO_DRAFT_LIST, (IFormPlugin)this);
                    this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, object.getString("billno"));
                    break;
                }
                this.executeEngineHandler(orgId, skssqq, skssqz, templateType);
                break;
            }
            case "linktodraftlist": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String draftQueryPage = TemplateEnum.getEnumByDeclareType(this.getTemplateType()).getDraftQueryPage();
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put(ORGID_KEY, Long.parseLong(orgId));
                customParams.put("startdate", DateUtils.stringToDate(skssqq));
                customParams.put("enddate", DateUtils.stringToDate(skssqz));
                PageShowCommon.showBillList(ShowType.MainNewTabPage, draftQueryPage, this.getView(), customParams);
                break;
            }
            case "handle_onekey_generate_exception": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String declareType = this.getTemplateType();
                String draftPage = TemplateEnum.getEnumByDeclareType(declareType).getDraftPage();
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put(ORGID_KEY, orgId);
                customParams.put("skssqq", skssqq);
                customParams.put("skssqz", skssqz);
                PageShowCommon.showForm(ShowType.MainNewTabPage, draftPage, this.getView(), customParams, (IFormPlugin)this);
            }
        }
    }

    private void executeEngineHandler(String orgId, String skssqq, String skssqz, String templateType) {
        EngineHandler handler = EngineHandlerFactory.createHandler(templateType);
        EngineModel engineModel = this.buildEngineModel(orgId, skssqq, skssqz, templateType, this.getPageCache());
        try {
            handler.validate(engineModel);
            handler.execute(engineModel);
        }
        catch (KDBizException exception) {
            handler.handleException(exception, this.getView(), (IFormPlugin)this);
            return;
        }
        this.openDeclarePage(orgId, skssqq, skssqz, true);
    }

    private String getBillStatus(String rootPageId, String orgId, String startdate, String enddate) {
        DynamicObject declare = this.queryNsrxx(orgId, startdate, enddate);
        IFormView rootView = this.getView().getView(rootPageId);
        IPageCache rootCache = (IPageCache)rootView.getService(IPageCache.class);
        rootCache.put(BILL_STATUS, "A");
        this.getPageCache().remove("templateid");
        if (declare != null) {
            if (StringUtil.isNotEmpty((CharSequence)declare.getString("templateid"))) {
                this.getPageCache().put("templateid", declare.getString("templateid"));
            }
            String status = declare.getString("declarestatus");
            String billstatus = declare.getString("billstatus");
            String id = declare.getString("id");
            rootCache.put(BILL_STATUS, billstatus);
            rootCache.put(SBBID, id);
            if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
                DynamicObject org = (DynamicObject)rootView.getModel().getValue(ORG_SEL);
                String orgName = null != org ? org.getString("name") : "";
                String statusName = this.getStatusLocaleName(status, billstatus);
                String taxlimitStr = DateUtils.getTaxLimitTips(DateUtils.stringToDate(startdate), DateUtils.stringToDate(enddate));
                if (!taxlimitStr.equals("")) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2%3$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"AbstractDeclareReportPlugin_41", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, taxlimitStr, statusName);
                    rootView.showTipNotification(msg, Integer.valueOf(5000));
                    this.getView().sendFormAction(rootView);
                }
                return billstatus;
            }
        }
        return "A";
    }

    private String getStatusLocaleName(String status, String billstatus) {
        String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279", (String)"AbstractDeclareReportPlugin_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        if ("C".equals(billstatus)) {
            statusName = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"AbstractDeclareReportPlugin_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        }
        if ("declared".equals(status)) {
            statusName = ResManager.loadKDString((String)"\u7533\u62a5", (String)"AbstractDeclareReportPlugin_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        }
        return statusName;
    }

    protected String[] getTaxLimits() {
        return new String[]{"month"};
    }

    protected void initStartAndEndDate(boolean orgChange) {
        Date skssqz;
        Date skssqq;
        String taxLimit;
        switch (taxLimit = this.getTaxLimits()[0]) {
            case "year": {
                skssqq = DateUtils.getFirstDateOfYear(DateUtils.addYear(new Date(), -1));
                skssqz = DateUtils.getLastDateOfYear(skssqq);
                break;
            }
            case "halfyear": {
                skssqq = DateUtils.getFirstDateOfHalfYear(DateUtils.addMonth(new Date(), -6));
                skssqz = DateUtils.getLastDateOfHalfYear(skssqq);
                break;
            }
            case "season": {
                skssqq = DateUtils.getFirstDateOfSeason(DateUtils.addMonth(new Date(), -3));
                skssqz = DateUtils.getLastDateOfSeason(skssqq);
                break;
            }
            default: {
                skssqq = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(new Date(), -1));
                skssqz = DateUtils.getLastDateOfMonth(skssqq);
            }
        }
        if (orgChange && !StringUtil.equals((CharSequence)DateUtils.format(skssqq), (CharSequence)DateUtils.format((Date)this.getModel().getValue("skssqq")))) {
            this.getPageCache().put("code_change_start", "true");
        }
        this.getModel().setValue("skssqq", (Object)skssqq);
        this.getPageCache().put("skssqq", DateUtils.format(skssqq));
        if (orgChange && !StringUtil.equals((CharSequence)DateUtils.format(skssqz), (CharSequence)DateUtils.format((Date)this.getModel().getValue("skssqz")))) {
            this.getPageCache().put("code_change_end", "true");
        }
        this.getModel().setValue("skssqz", (Object)skssqz);
        this.getPageCache().put("skssqz", DateUtils.format(skssqz));
    }

    private void openDeclarePage(String orgid, String skssqq, String skssqz, boolean refresh) {
        String templateType = this.getTemplateType();
        Map<String, Object> map = this.chooseDeclareFormByDataType(orgid, templateType, skssqq, skssqz);
        if (((Boolean)map.get("flag")).booleanValue()) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)((String)map.get("billstatus")))) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                String taxLimitTips = DateUtils.getTaxLimitTips(DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz));
                String orgname = this.getModel().getValue(ORG_SEL) == null ? "" : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("name");
                String msg = ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u5b58\u5728\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c", (String)"AbstractDeclareReportPlugin_28", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                if ("yhs".equals(templateType)) {
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclareReportPlugin_29", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclareReportPlugin_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e", (String)"AbstractDeclareReportPlugin_31", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener(CALLBACKID_MODIFY, (IFormPlugin)this), btnNameMaps);
                } else {
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclareReportPlugin_29", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclareReportPlugin_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7a0e", (String)"AbstractDeclareReportPlugin_32", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\n\u91cd\u65b0\u8ba1\u7a0e\uff1a\u6e05\u7a7a\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u5e76\u4f7f\u7528\u81ea\u52a8\u8ba1\u7a0e", (String)"AbstractDeclareReportPlugin_33", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKID_MOD, (IFormPlugin)this), btnNameMaps);
                }
            } else {
                this.showInnerPage(orgid, skssqq, skssqz, refresh);
            }
        } else {
            this.showInnerPage(orgid, skssqq, skssqz, refresh);
        }
    }

    private Map<String, Object> chooseDeclareFormByDataType(String orgid, String type, String startDate, String endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject dyo = YbnsrService.queryYbnsr(orgid, type, startDate, endDate, null);
        Boolean flag = Boolean.FALSE;
        String declareStatus = "";
        if (null != dyo && StringUtils.equals((CharSequence)"2", (CharSequence)dyo.getString("datatype"))) {
            declareStatus = dyo.getString("declarestatus");
            map.put("billstatus", dyo.getString("billstatus"));
            flag = Boolean.TRUE;
        }
        map.put("declarestatus", declareStatus);
        map.put("flag", flag);
        return map;
    }

    private void showInnerPage(String orgid, String startDate, String endDate, boolean refresh) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("rootPageId", this.getView().getPageId());
        customParams.put("refresh", refresh ? "true" : "false");
        customParams.put(ORGID_KEY, orgid);
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", endDate);
        String taxLimit = DateUtils.getTaxLimit(DateUtils.stringToDate(startDate), DateUtils.stringToDate(endDate));
        customParams.put("taxlimit", taxLimit);
        customParams.put(TEMPLATE_TYPE, this.getTemplateType());
        customParams.put("ParentCache", "true");
        if ("zzsybnsr_ybfz".equals(customParams.get(TEMPLATE_TYPE))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u6c47\u603b\u7ec4\u7ec7\u65e0\u987b\u7533\u62a5", (String)"AbstractDeclareReportPlugin_34", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), null);
            return;
        }
        if ("zzsybnsr_fzjg".equals(customParams.get(TEMPLATE_TYPE)) || "zzsybnsr_zjg".equals(customParams.get(TEMPLATE_TYPE))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6c47\u603b\u822a\u7a7a\u6682\u4e0d\u652f\u6301\u7eb3\u7a0e\u7533\u62a5", (String)"AbstractDeclareReportPlugin_35", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), null);
            return;
        }
        if (("zzsybnsr_yz_zjg".equals(customParams.get(TEMPLATE_TYPE)) || "zzsybnsr_yz_fzjg".equals(customParams.get(TEMPLATE_TYPE))) && !this.isYzZjgDraftExist()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u603b\u673a\u6784\u7eb3\u7a0e\u603b\u89c8\u8868\u3002", (String)"AbstractDeclareReportPlugin_42", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        String billStatus = this.getBillStatus(this.getView().getPageId(), orgid, startDate, endDate);
        this.setBtnStatus(billStatus);
        customParams.put(READ_ONLY, !"A".equals(billStatus));
        customParams.put("templateid", this.getPageCache().get("templateid"));
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bdtaxr_declare_old");
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        this.getView().updateView(CONTENT_TAB);
    }

    private boolean isYzZjgDraftExist() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        String startDateStr = this.getPageCache().get("skssqq");
        String endDateStr = this.getPageCache().get("skssqz");
        Date startDate = DateUtils.stringToDate(startDateStr);
        Date endDate = DateUtils.stringToDate(endDateStr);
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter("tcvat", "zerodeclare", Long.parseLong(orgid));
        if (zerodeclare) {
            return true;
        }
        DynamicObject declarePlanObject = OrgUtils.getOrgDeclarePlan(Long.parseLong(orgid), startDate, endDate);
        if (declarePlanObject == null) {
            return false;
        }
        DynamicObjectCollection orgrow = declarePlanObject.getDynamicObjectCollection("orgrow");
        Optional<DynamicObject> mainObj = orgrow.stream().filter(o -> "2".equals(o.getString("declaration"))).findFirst();
        if (!mainObj.isPresent()) {
            return false;
        }
        orgid = mainObj.get().getDynamicObject(ORGID_KEY).getString("id");
        QFilter orgFilter = new QFilter(ORG_SEL, "=", (Object)Long.valueOf(orgid));
        QFilter startFilter = new QFilter("startdate", "=", (Object)startDate);
        QFilter endFilter = new QFilter("enddate", "=", (Object)endDate);
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType("zzsybnsr_yz_zjg");
        QFilter templateFilter = new QFilter(TEMPLATE_TYPE, "=", (Object)templateEnum.getDraftType());
        return QueryServiceHelper.exists((String)"tctb_draft_main", (QFilter[])new QFilter[]{orgFilter, templateFilter, startFilter, endFilter});
    }

    private void setBtnStatus(String billStatus) {
        if ("A".equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{EDIT_KEY, VIEW_DRAFT_KEY, SUBMIT_KEY, RECALC_KEY, ONE_KEY_GENERATE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE_KEY, CANCEL_KEY});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{EDIT_KEY, SAVE_KEY, CANCEL_KEY, RECALC_KEY, SUBMIT_KEY, ONE_KEY_GENERATE});
        }
    }

    protected EngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String templateType, IPageCache pageCache) {
        return new EngineModel(orgId, skssqq, skssqz, templateType, pageCache);
    }

    public abstract void init();

    public abstract String getTaxType();

    public abstract String getTemplateType();

    public abstract void clientCallBackMethod(Map<String, String> var1, String var2);

    public abstract void initPeriod(IDataModel var1, IPageCache var2, String var3, Map<String, Object> var4);
}

