/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.helper.AttachmentHelper;
import kd.taxc.bdtaxr.common.helper.tctrc.RiskCalculateHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public abstract class AbstractTaxDeclarePluginNew
extends AbstractFormPlugin
implements UploadListener {
    private static Log LOGGER = LogFactory.getLog(AbstractTaxDeclarePluginNew.class);
    private static final String ATTACHMENT_VISIABLE = "attachment_visiable";

    public void registerListener(EventObject e) {
        if (this.getAttachmentFieldName() != null) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(this.getAttachmentFieldName());
            attachmentPanel.addUploadListener((UploadListener)this);
        }
    }

    public void showAttachment(String sbbid, String operation, String templateType) {
        this.showAttachment("tcvat_nsrxx", sbbid, operation, templateType);
    }

    public void showAttachment(String entityId, String sbbid, String operation, String templateType) {
        try {
            this.doShowAttachment(entityId, sbbid, operation, templateType);
            if (this.getAttachmentFieldName() != null) {
                this.getView().updateView(this.getAttachmentFieldName());
            }
            if (this.getAttachmentPanelName() != null) {
                this.getView().updateView(this.getAttachmentPanelName());
            }
        }
        catch (Exception e) {
            if (this.getAttachmentPanelName() != null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{this.getAttachmentPanelName()});
            }
            LOGGER.error(String.format("show attachments error,sbbid:%s, operation:%s,templateType:%s", sbbid, operation, templateType), (Throwable)e);
        }
    }

    private void collapseAttachment() {
        AttachmentPanel control;
        if (this.getAttachmentFieldName() != null && (control = (AttachmentPanel)this.getControl(this.getAttachmentFieldName())) != null) {
            control.setCollapse(true);
        }
        if (this.getAttachmentPanelName() != null && (control = (Container)this.getControl(this.getAttachmentPanelName())) != null) {
            control.setCollapse(true);
        }
    }

    public void afterBindData(EventObject e) {
        this.collapseAttachment();
    }

    private void doShowAttachment(String entityId, String sbbid, String operation, String templateType) {
        if (AttachmentHelper.isDeclareAttachmentType(templateType) && this.getAttachmentFieldName() != null) {
            DynamicObject nsrxx;
            DynamicObjectCollection attachmentFields;
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getAttachmentPanelName()});
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(this.getAttachmentFieldName());
            ArrayList attachments = new ArrayList();
            String appId = this.getView().getFormShowParameter().getAppId();
            String formId = this.getView().getFormShowParameter().getFormId();
            String attachmentFieldName = this.getAttachmentFieldName();
            HashMap<String, LocaleString> uidToUserNameMap = new HashMap<String, LocaleString>();
            if (QueryServiceHelper.exists((String)entityId, (Object)Long.parseLong(sbbid)) && null != (attachmentFields = (DynamicObjectCollection)(nsrxx = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sbbid), (String)entityId)).get("attachment")) && attachmentFields.size() > 0) {
                Set fbasedataidIds = attachmentFields.stream().map(a -> a.get("fbasedataid_id")).collect(Collectors.toSet());
                DynamicObjectCollection bd_attachments = QueryServiceHelper.query((String)"bd_attachment", (String)"number,name,status,creator,modifier,enable,createtime,modifytime,uid,previewurl,type,tempfile,pageid,description,url,size,sort,filesource,id", (QFilter[])new QFilter("id", "in", fbasedataidIds).toArray());
                for (DynamicObject attachment : bd_attachments) {
                    Set uidSet = attachmentPanel.getAttachmentData().stream().filter(o -> o.containsKey("uid")).map(o -> o.get("uid")).collect(Collectors.toSet());
                    if (uidSet.contains(attachment.get("uid"))) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("type", attachment.getString("type"));
                    String url = attachment.getString("url");
                    try (InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);){
                        String tempUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attachment.getString("name"), (InputStream)new BufferedInputStream(inputStream), 3600);
                        map.put("url", tempUrl);
                        map.put("uid", attachment.getString("uid"));
                        map.put("name", attachment.getString("name"));
                        map.put("size", attachment.get("size"));
                        map.put("fattachmentpanel", "attachmentpanel");
                        map.put("entityNum", this.getView().getEntityId());
                        map.put("lastModified", attachment.getDate("modifytime"));
                        Date createtime = attachment.getDate("createtime");
                        if (createtime != null) {
                            map.put("createdate", createtime.getTime());
                            map.put("uploadTime", createtime.getTime());
                        }
                        Object creator = attachment.get("creator");
                        Map userInfoByID = UserServiceHelper.getUserInfoByID((long)((Long)creator));
                        String name = userInfoByID.getOrDefault("name", "");
                        map.put("creator", new LocaleString(name));
                        uidToUserNameMap.put(attachment.getString("uid"), new LocaleString(name));
                        map.put("status", "success");
                        map.put("client", "web");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    attachments.add(map);
                }
            }
            if (EmptyCheckUtils.isNotEmpty(attachments)) {
                attachmentPanel.upload(attachments);
                String visible = this.getAttachmentPermission();
                attachments.forEach(a -> {
                    a.put("creator", uidToUserNameMap.getOrDefault(a.get("uid"), new LocaleString("")));
                    a.put("visible", visible);
                });
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.invokeControlMethod(attachmentFieldName, "addAttachment", new Object[]{attachments});
            }
            String visiableUpload = AttachmentHelper.queryPermission("2NJ5SR4NUEJ=", RequestContext.get().getCurrUserId(), appId, formId);
            this.getView().setEnable(Boolean.valueOf(Objects.equals(operation, "edit") && Objects.equals("1", visiableUpload)), new String[]{attachmentFieldName});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getAttachmentPanelName()});
        }
    }

    public void saveAttachment(String sbbid, String templateType) {
        this.saveAttachment("tcvat_nsrxx", sbbid, templateType, "bdtaxr");
    }

    public void saveAttachment(String entityId, String sbbid, String templateType, String appid) {
        if (AttachmentHelper.isDeclareAttachmentType(templateType) && this.getAttachmentFieldName() != null) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(this.getAttachmentFieldName());
            List attachmentData = attachmentPanel.getAttachmentData();
            if (QueryServiceHelper.exists((String)entityId, (Object)Long.parseLong(sbbid))) {
                DynamicObject sbbObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sbbid), (String)entityId);
                DynamicObjectCollection attachmentFields = sbbObject.getDynamicObjectCollection("attachment");
                try (TXHandle h = TX.requiresNew();){
                    try {
                        AttachmentHelper.updateAttachmentField(attachmentData, attachmentFields, appid, entityId, Long.parseLong(sbbid));
                    }
                    catch (Exception e) {
                        h.markRollback();
                        LOGGER.error("save attachments error", (Throwable)e);
                        throw e;
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sbbObject});
            }
        }
    }

    private String getAttachmentPermission() {
        String attachmentVisiable = this.getPageCache().get(ATTACHMENT_VISIABLE);
        String appId = "bdtaxr";
        String formId = this.getView().getFormShowParameter().getFormId();
        if (StringUtil.isNotEmpty((CharSequence)attachmentVisiable)) {
            return attachmentVisiable;
        }
        Long userId = RequestContext.get().getCurrUserId();
        String visiablePreview = AttachmentHelper.queryPermission("2NJ5VA7D2ONF", userId, appId, formId);
        String visiableDownload = AttachmentHelper.queryPermission("2NJ5XVVCMBCL", userId, appId, formId);
        String visiableRename = AttachmentHelper.queryPermission("2NJ5W8AA040D", userId, appId, formId);
        String visiableDelete = AttachmentHelper.queryPermission("2NJ5YJOIS+MJ", userId, appId, formId);
        attachmentVisiable = visiablePreview + visiableDownload + visiableRename + visiableDelete;
        this.getPageCache().put(ATTACHMENT_VISIABLE, attachmentVisiable);
        return attachmentVisiable;
    }

    public abstract String getAttachmentFieldName();

    public abstract String getAttachmentPanelName();

    public void afterUpload(UploadEvent evt) {
        this.updateUrls(evt.getUrls());
    }

    private void updateUrls(Object[] urls) {
        if (EmptyCheckUtils.isNotEmpty(urls)) {
            String visible = this.getAttachmentPermission();
            for (Object url : urls) {
                Map map = (Map)url;
                map.put("visible", visible);
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.updateUrls(evt.getUrls());
    }

    protected void sendRiskCalRealTimeTask(DeclareRequestModel requestModel, Map<String, String> updateMap, Map<String, String> resultMap) {
        Map<String, Object> params = this.buildTaskParams(requestModel, resultMap);
        RiskCalculateHelper.calculateRiskAsync(params);
    }

    private Map<String, Object> buildTaskParams(DeclareRequestModel requestModel, Map<String, String> resultMap) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgid", requestModel.getOrgId());
        params.put("skssqq", requestModel.getSkssqq());
        params.put("skssqz", requestModel.getSkssqz());
        params.put("taxationsys", requestModel.getTaxationsys());
        params.put("modelid", requestModel.getModelId());
        params.put("templateid", requestModel.getTemplateId());
        params.put("templatenumber", requestModel.getTemplateNumber());
        params.put("templatetype", requestModel.getTemplateType());
        Map<String, Object> extendParams = requestModel.getExtendParams();
        if (EmptyCheckUtils.isNotEmpty(extendParams)) {
            params.put("taxcategory", extendParams.getOrDefault("taxtype", "0"));
            params.put("taxareagroup", extendParams.getOrDefault("taxareagroup", "0"));
            params.put("draftpurpose", extendParams.getOrDefault("draftpurpose", ""));
        }
        return params;
    }
}

