/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public interface IStatusService {
    public static final String STATUS_VAL0 = "0";
    public static final String STATUS_VAL1 = "1";
    public static final String STATUS_VAL2 = "2";
    public static final String STATUS_VAL3 = "3";
    public static final String STATUS_VAL4 = "4";
    public static final String STATUS_VAL5 = "5";
    public static final String STATUS_VAL6 = "6";
    public static final String STATUS_VAL7 = "7";
    public static final String STATUS_VAL8 = "8";

    public String getStatusEntity();

    default public void updateStatus(String orgid, String startdate, String enddate, String status) {
        List<QFilter> list = this.buildQFilters(orgid, startdate, enddate);
        DynamicObject temp = QueryServiceHelper.queryOne((String)this.getStatusEntity(), (String)"id", (QFilter[])list.toArray(new QFilter[0]));
        if (temp != null) {
            String id = temp.getString("id");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getStatusEntity());
            object.set("status", (Object)status);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    default public void updateStatus(String orgid, String startdate, String enddate, String status, String projectid, String serialno) {
        List<QFilter> list = this.buildQFilters(orgid, startdate, enddate, projectid, serialno);
        DynamicObject temp = QueryServiceHelper.queryOne((String)this.getStatusEntity(), (String)"id", (QFilter[])list.toArray(new QFilter[0]));
        if (temp != null) {
            String id = temp.getString("id");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getStatusEntity());
            object.set("status", (Object)status);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    default public String getStatus(String orgid, String startdate, String enddate) {
        List<QFilter> list = this.buildQFilters(orgid, startdate, enddate);
        DynamicObject object = QueryServiceHelper.queryOne((String)this.getStatusEntity(), (String)"id,status", (QFilter[])list.toArray(new QFilter[0]));
        String status = STATUS_VAL0;
        if (object != null) {
            status = object.getString("status");
        }
        return status;
    }

    default public void delete(String orgid, String startdate, String enddate) {
        List<QFilter> list = this.buildQFilters(orgid, startdate, enddate);
        DeleteServiceHelper.delete((String)this.getStatusEntity(), (QFilter[])list.toArray(new QFilter[0]));
    }

    default public DynamicObject queryOne(String orgid, String startdate, String enddate) {
        List<QFilter> list = this.buildQFilters(orgid, startdate, enddate);
        return QueryServiceHelper.queryOne((String)this.getStatusEntity(), (String)"id,status", (QFilter[])list.toArray(new QFilter[0]));
    }

    default public List<QFilter> buildQFilters(String orgid, String startdate, String enddate) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("startdate", "=", (Object)DateUtils.stringToDate(startdate)));
        list.add(new QFilter("enddate", "=", (Object)DateUtils.stringToDate(enddate)));
        list.add(new QFilter("orgid", "=", (Object)Long.parseLong(StringUtil.isNotBlank((CharSequence)orgid) ? orgid : STATUS_VAL0)));
        return list;
    }

    default public List<QFilter> buildQFilters(String orgid, String startdate, String enddate, String projectid, String serialno) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("startdate", "=", (Object)DateUtils.stringToDate(startdate)));
        list.add(new QFilter("enddate", "=", (Object)DateUtils.stringToDate(enddate)));
        list.add(new QFilter("orgid", "=", (Object)Long.parseLong(StringUtil.isNotBlank((CharSequence)orgid) ? orgid : STATUS_VAL0)));
        list.add(new QFilter("projectid", "=", (Object)Long.parseLong(StringUtil.isNotBlank((CharSequence)projectid) ? orgid : STATUS_VAL0)));
        list.add(new QFilter("declareserialno", "=", (Object)Long.parseLong(StringUtil.isNotBlank((CharSequence)serialno) ? orgid : STATUS_VAL0)));
        return list;
    }
}

