/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQSender;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class TsdStatusUtils {
    public static final String TPO_DECLARE_MAIN_TSD = "tpo_declare_main_tsd";
    public static final String STATUS_VAL0 = "0";
    public static final String STATUS_VAL1 = "1";
    public static final String STATUS_VAL2 = "2";
    public static final String STATUS_VAL3 = "3";
    public static final String STATUS_VAL4 = "4";
    public static final String STATUS_VAL5 = "5";
    public static final String STATUS_VAL6 = "6";
    public static final String STATUS_VAL7 = "7";

    public static DynamicObject createStatus(String templatetype, String orgid, String startdate, String enddate, String status, String draftpurpose, String accountorg) {
        List<QFilter> list = TsdStatusUtils.buildQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
        DynamicObject temp = QueryServiceHelper.queryOne((String)TPO_DECLARE_MAIN_TSD, (String)"id", (QFilter[])list.toArray(new QFilter[0]));
        if (temp == null) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)TPO_DECLARE_MAIN_TSD);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
            Date start = DateUtils.stringToDate(startdate);
            Date end = DateUtils.stringToDate(enddate);
            dynamicObject.set("skssqq", (Object)start);
            dynamicObject.set("skssqz", (Object)end);
            dynamicObject.set("deadline", (Object)DeclareUtils.convertDate2DeadLine(start, end));
            dynamicObject.set("org", (Object)Long.valueOf(orgid));
            String billno = UUID.randomUUID();
            dynamicObject.set("billno", (Object)billno.substring(0, 30));
            dynamicObject.set("status", (Object)status);
            dynamicObject.set("billstatus", (Object)"A");
            dynamicObject.set("templatetype", (Object)templatetype);
            dynamicObject.set("taxsystem", (Object)AccrualConstant.TAXSYSTEM_CHINA);
            dynamicObject.set("taxareagroup", (Object)AccrualConstant.TAXAREAGROUP_CHINA);
            if (templatetype.contains("zzs")) {
                dynamicObject.set("taxtype", (Object)BaseTaxCategory.ZZS);
            } else if (templatetype.contains("qysds")) {
                dynamicObject.set("taxtype", (Object)BaseTaxCategory.QYSDS);
            }
            dynamicObject.set("draftpurpose", (Object)(StringUtils.isEmpty((CharSequence)draftpurpose) ? "nssb" : draftpurpose));
            dynamicObject.set("accountorg", (Object)(StringUtils.isEmpty((CharSequence)accountorg) || "null".equals(accountorg) ? 0L : Long.parseLong(accountorg)));
            dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)TPO_DECLARE_MAIN_TSD, (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                AccrualMQSender.sendMQ(BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)TPO_DECLARE_MAIN_TSD));
            }
            return dynamicObject;
        }
        return null;
    }

    public static void updateStatus(String templatetype, String orgid, String startdate, String enddate, String status, String draftpurpose) {
        List<QFilter> list = TsdStatusUtils.buildQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
        DynamicObject temp = QueryServiceHelper.queryOne((String)TPO_DECLARE_MAIN_TSD, (String)"id", (QFilter[])list.toArray(new QFilter[0]));
        if (temp != null) {
            String id = temp.getString("id");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)TPO_DECLARE_MAIN_TSD);
            object.set("status", (Object)status);
            DeclareServiceHelper.setAccrualPlanId(orgid, startdate, enddate, draftpurpose, object);
            OperationServiceHelper.executeOperate((String)"save", (String)TPO_DECLARE_MAIN_TSD, (DynamicObject[])new DynamicObject[]{object}, (OperateOption)OperateOption.create());
        }
    }

    public static String getStatus(String templatetype, String orgid, String startdate, String enddate, String draftpurpose) {
        List<QFilter> list = TsdStatusUtils.buildQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
        DynamicObject object = QueryServiceHelper.queryOne((String)TPO_DECLARE_MAIN_TSD, (String)"id,status", (QFilter[])list.toArray(new QFilter[0]));
        String status = STATUS_VAL1;
        if (object != null) {
            status = object.getString("status");
        }
        return status;
    }

    public static DynamicObject queryOne(String templatetype, String orgid, String startdate, String enddate, String draftpurpose) {
        List<QFilter> list = TsdStatusUtils.buildQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
        return QueryServiceHelper.queryOne((String)TPO_DECLARE_MAIN_TSD, (String)"id,billno,status,org,taxsystem,generatebusinessdoc,type,billstatus,businessdocno as jtnumber,accrualplan", (QFilter[])list.toArray(new QFilter[0]));
    }

    public static DynamicObject loadSingle(Object pk) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)TPO_DECLARE_MAIN_TSD);
    }

    public static void delete(String templatetype, String orgid, String startdate, String enddate, String draftpurpose) {
        List<QFilter> list = TsdStatusUtils.buildQFilters(templatetype, orgid, startdate, enddate, draftpurpose);
        DeleteServiceHelper.delete((String)TPO_DECLARE_MAIN_TSD, (QFilter[])list.toArray(new QFilter[0]));
    }

    private static List<QFilter> buildQFilters(String templatetype, String orgid, String startdate, String enddate, String draftpurpose) {
        String draftpurposePros = StringUtils.isEmpty((CharSequence)draftpurpose) ? "nssb" : draftpurpose;
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("templatetype", "=", (Object)templatetype));
        list.add(new QFilter("skssqq", "=", (Object)DateUtils.stringToDate(startdate)));
        list.add(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate(enddate)));
        list.add(new QFilter("org", "=", (Object)Long.parseLong(StringUtil.isNotBlank((CharSequence)orgid) ? orgid : STATUS_VAL0)));
        list.add(new QFilter("draftpurpose", "=", (Object)draftpurposePros));
        return list;
    }
}

