/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.address;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.taxdeclare.address.AddressUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class RegisterAddressUtil {
    private static Map<String, Integer> methodMap = new HashMap<String, Integer>();
    private static Map<Integer, String> monthMap;
    private static Map<Long, String> taxCatetoryMap;
    private static final String ENTITY_CALENDAR = "tpo_tax_calendar";
    public static final List<Long> PLAN_SINGLE_CITY_LIST;
    private static final String METHODS_MONTH = "2";
    private static final String METHODS_SEAON = "1";
    private static final String METHODS_YEAR = "3";

    public static final Date findZZSMonthApplyEndDate(Object orgid) {
        return RegisterAddressUtil.findOrgApplyTypeTaxTypeEndDate(orgid, METHODS_MONTH, METHODS_SEAON);
    }

    public static final List<Map<String, Object>> findOrgApplyTypeTaxTypeEndDate(Object orgid, String taxType, Date date) {
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"RegisterAddressService", (String)"findOrgApplyTypeTaxTypeEndDate", (Object[])new Object[]{orgid, taxType, date});
    }

    public static final Date findOrgApplyTypeTaxTypeWithQueryDateEndDate(Object orgid, String applyType, String taxType, Date date) {
        return (Date)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"RegisterAddressService", (String)"findOrgApplyTypeTaxTypeWithQueryDateEndDate", (Object[])new Object[]{orgid, applyType, taxType, date});
    }

    public static Date findOrgApplyTypeTaxTypeEndDate(Object orgid, String applyType, String taxType) {
        return (Date)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"RegisterAddressService", (String)"findOrgApplyTypeTaxTypeExpDate", (Object[])new Object[]{orgid, applyType, taxType});
    }

    public static Date getTaxCalenderDate(Object orgid, String applyType, String taxType, Date date, Long admindivision) {
        return (Date)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"RegisterAddressService", (String)"getTaxCalenderDate", (Object[])new Object[]{orgid, applyType, taxType, date, admindivision});
    }

    private static boolean isPlanSingleCity(Long cityid) {
        return PLAN_SINGLE_CITY_LIST.contains(cityid);
    }

    public static List<Map<String, Object>> getTaxCalenderDate(Object orgid, String taxType, Date date) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        DynamicObject taxmain = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id,taxorg.istaxpayer as isentity,orgid.name, registeraddress", (QFilter[])new QFilter[]{orgFilter});
        if (taxmain == null) {
            return null;
        }
        Long admindivision = taxmain.getLong("registeraddress");
        DynamicObject registerAddress = AddressUtils.getAdmindivision(admindivision);
        if (EmptyCheckUtils.isEmpty(registerAddress)) {
            return null;
        }
        long level = registerAddress.getLong("basedatafield.level");
        long provinceid = 0L;
        Long cityid = 0L;
        if (level == 1L) {
            provinceid = registerAddress.getLong("id");
        } else if (level == 2L) {
            cityid = registerAddress.getLong("id");
            provinceid = registerAddress.getLong("parent");
        } else if (level == 3L) {
            cityid = registerAddress.getLong("parent");
            DynamicObject city = AddressUtils.getAdmindivision(cityid);
            if (null == city) {
                return null;
            }
            provinceid = city.getLong("parent");
        } else if (level > 3L) {
            long streetid = registerAddress.getLong("parent");
            DynamicObject area = AddressUtils.getAdmindivision(streetid);
            if (null == area) {
                return null;
            }
            cityid = area.getLong("parent");
            DynamicObject city = AddressUtils.getAdmindivision(cityid);
            if (null == city) {
                return null;
            }
            provinceid = city.getLong("parent");
        }
        boolean isPlanSingleCity = AddressUtils.isPlanSingleCity(cityid);
        int month = DateUtils.getMonthOfDate(date);
        int year = DateUtils.getYearOfDate(date);
        QFilter provinceFilter = new QFilter("entryentity.provinces", "=", (Object)provinceid);
        QFilter cityFilter = new QFilter("entryentity.city", "=", (Object)cityid);
        QFilter taxFilter = new QFilter("entryentity.taxtype", "=", (Object)taxType);
        QFilter yearFilter = new QFilter("year", "=", (Object)String.valueOf(year));
        String monthEndDateStr = monthMap.get(month);
        if (EmptyCheckUtils.isEmpty(monthEndDateStr)) {
            throw new KDBizException("month is error month = " + month);
        }
        DynamicObjectCollection calendars = isPlanSingleCity ? RegisterAddressUtil.queryCalender(provinceFilter, cityFilter, taxFilter, null, yearFilter, month) : RegisterAddressUtil.queryCalender(provinceFilter, null, taxFilter, null, yearFilter, month);
        if (EmptyCheckUtils.isEmpty(calendars)) {
            calendars = RegisterAddressUtil.queryCalendarByName(provinceid, cityid, taxFilter, null, yearFilter, month);
        }
        if (EmptyCheckUtils.isEmpty(calendars)) {
            return null;
        }
        ArrayList<Map<String, Object>> calendarDates = RegisterAddressUtil.getCalendarDate(orgid, year, calendars);
        if (calendarDates != null) {
            calendarDates.sort(Comparator.comparing(a -> methodMap.getOrDefault(a.get("methods"), 0)));
        }
        return calendarDates;
    }

    public static String getCalenderTaxType(Long baseCategoryId) {
        return taxCatetoryMap.get(baseCategoryId);
    }

    private static DynamicObjectCollection queryCalender(QFilter provinceFilter, QFilter cityFilter, QFilter taxtypeFilter, QFilter methodsFilter, QFilter yearFilter, int month) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (EmptyCheckUtils.isNotEmpty(provinceFilter)) {
            qFilterList.add(provinceFilter);
        }
        if (EmptyCheckUtils.isNotEmpty(cityFilter)) {
            qFilterList.add(cityFilter);
        }
        if (EmptyCheckUtils.isNotEmpty(taxtypeFilter)) {
            qFilterList.add(taxtypeFilter);
        }
        if (EmptyCheckUtils.isNotEmpty(methodsFilter)) {
            qFilterList.add(methodsFilter);
        }
        if (EmptyCheckUtils.isNotEmpty(yearFilter)) {
            qFilterList.add(yearFilter);
        }
        return QueryServiceHelper.query((String)ENTITY_CALENDAR, (String)("entryentity.methods as methods, entryentity.provinces as provinces, entryentity.city as city,entryentity.taxtype as taxtype, entryentity." + monthMap.get(month) + " as date"), (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
    }

    private static DynamicObjectCollection queryCalendarByName(Long provinceid, Long cityid, QFilter taxtypeFilter, QFilter methodsFilter, QFilter yearFilter, int month) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObject province = AddressUtils.getAdmindivision(provinceid);
        DynamicObject city = AddressUtils.getAdmindivision(cityid);
        QFilter provinceNameFilter = null;
        QFilter cityNameFilter = null;
        if (EmptyCheckUtils.isNotEmpty(province)) {
            provinceNameFilter = new QFilter("entryentity.provinces.name", "like", (Object)(province.getString("name") + "%"));
        }
        if (EmptyCheckUtils.isNotEmpty(city)) {
            cityNameFilter = new QFilter("entryentity.city.name", "like", (Object)("%" + city.getString("name") + "%"));
        }
        if (EmptyCheckUtils.isNotEmpty(provinceNameFilter)) {
            collection = EmptyCheckUtils.isNotEmpty(cityNameFilter) ? RegisterAddressUtil.queryCalender(provinceNameFilter, cityNameFilter, taxtypeFilter, methodsFilter, yearFilter, month) : RegisterAddressUtil.queryCalender(provinceNameFilter, null, taxtypeFilter, methodsFilter, yearFilter, month);
        }
        return collection;
    }

    private static ArrayList<Map<String, Object>> getCalendarDate(Object orgid, int year, DynamicObjectCollection calendars) {
        if (EmptyCheckUtils.isEmpty(calendars)) {
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (DynamicObject calendar : calendars) {
            String endDateStr = calendar.getString("date");
            if ("\u2014\u2014".equalsIgnoreCase(endDateStr)) continue;
            HashMap<String, Object> resItem = new HashMap<String, Object>(8);
            StringBuilder datestr = new StringBuilder();
            datestr.append(year).append(ResManager.loadKDString((String)"\u5e74", (String)"RegisterAddressUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).append(endDateStr);
            endDateStr = datestr.toString();
            Date taxDate = DateUtils.stringToDateInAnyFormat(endDateStr);
            resItem.put("taxdate", taxDate);
            resItem.put("orgid", orgid);
            resItem.put("taxtype", calendar.getString("taxtype"));
            resItem.put("provinces", calendar.getLong("provinces"));
            resItem.put("city", calendar.getLong("city"));
            resItem.put("methods", calendar.getString("methods"));
            result.add(resItem);
        }
        return result;
    }

    static {
        methodMap.put(METHODS_MONTH, 1);
        methodMap.put(METHODS_SEAON, 2);
        methodMap.put("6", 3);
        methodMap.put(METHODS_YEAR, 4);
        methodMap.put("4", 5);
        methodMap.put("5", 6);
        methodMap.put("7", 7);
        methodMap.put("8", 8);
        monthMap = new HashMap<Integer, String>();
        monthMap.put(1, "january");
        monthMap.put(2, "february");
        monthMap.put(3, "march");
        monthMap.put(4, "april");
        monthMap.put(5, "may");
        monthMap.put(6, "june");
        monthMap.put(7, "july");
        monthMap.put(8, "august");
        monthMap.put(9, "september");
        monthMap.put(10, "october");
        monthMap.put(11, "november");
        monthMap.put(12, "december");
        taxCatetoryMap = new HashMap<Long, String>();
        taxCatetoryMap.put(BaseTaxCategory.ZZS, METHODS_SEAON);
        taxCatetoryMap.put(BaseTaxCategory.QYSDS, METHODS_MONTH);
        taxCatetoryMap.put(BaseTaxCategory.YHS, METHODS_YEAR);
        taxCatetoryMap.put(BaseTaxCategory.FCS, "4");
        taxCatetoryMap.put(BaseTaxCategory.ZZS, "5");
        taxCatetoryMap.put(BaseTaxCategory.CZTDSYS, "6");
        taxCatetoryMap.put(BaseTaxCategory.HBS, "7");
        taxCatetoryMap.put(BaseTaxCategory.XFS, "8");
        PLAN_SINGLE_CITY_LIST = Lists.newArrayList((Object[])new Long[]{3135L, 407L, 2676L, 194L, 2530L, 3547L, 2232L, 142L, 124L});
    }
}

