/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.constant;

public enum TaxTypeEnum {
    TCVAT("tcvat", new String[]{"zzsybnsr", "zzsxgmnsr", "fjsf", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg"}),
    TCCITYJ("tccit_yj", new String[]{"qysdsjb", "qysds_hdzs_jb"}),
    TCCITHJ("tccit_hj", new String[]{"qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_nb"}),
    TCSD("tcsd", new String[]{"yhs"}),
    TCRET("tcret", new String[]{"ccxws"}),
    TCRET_LAT("tcret_lat", new String[]{"latyj", "latqs", "latwp"}),
    TCCT("tcct", new String[]{"xfs", "xfsjypf", "fjsf"}),
    TOTF("totf", new String[]{"fjsf", "tcept", "tcrt", "yys", "tcvvt", "tvpt"}),
    TCVVT_("tcvvt", new String[]{"qhjtbs", "zdsybsqyxxb"}),
    TAM("tam", new String[]{"qysdsjb", "qysds_hdzs_jb", "qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_nb", "zzsybnsr", "zzsxgmnsr", "fjsf", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsyjskb", "ccxws", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg", "qtsf_tysbb", "qtsf_fsstysbb", "whsyjsf", "FR0001", "FR0002", "FR0003", "FR0004", "FR0011", "szys_a", "szys_b"}),
    TSATE("tsate", new String[]{"zzsybnsr", "zzsybnsr_zjg", "zzsybnsr_fzjg", "zzsxgmnsr", "fjsf", "zzsybnsr_ybhz", "qysdsjb", "qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_jb", "qysds_hdzs_nb", "ccxws", "yhs", "fcscztdsys"});

    private String appId;
    private String[] templates;

    private TaxTypeEnum(String appId, String[] templates) {
        this.appId = appId;
        this.templates = templates;
    }

    public String getAppId() {
        return this.appId;
    }

    private void setAppId(String appId) {
        this.appId = appId;
    }

    public String[] getTemplates() {
        return this.templates;
    }

    private void setTemplates(String[] templates) {
        this.templates = templates;
    }

    public static TaxTypeEnum valueOfAppId(String appId) {
        for (TaxTypeEnum taxTypeEnum : TaxTypeEnum.values()) {
            if (!taxTypeEnum.getAppId().equals(appId)) continue;
            return taxTypeEnum;
        }
        return null;
    }
}

