/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.draft;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.dto.BaseRowModel;
import kd.taxc.bdtaxr.common.dto.DraftPluginDto;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.helper.AttachmentHelper;
import kd.taxc.bdtaxr.common.helper.DistributeCacheHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQSender;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.taxdeclare.DeclarePageType;
import kd.taxc.bdtaxr.common.taxdeclare.draft.CalcTaskClick;
import kd.taxc.bdtaxr.common.taxdeclare.draft.DraftConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.DraftStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.file.ExportExcelUtils;
import kd.taxc.bdtaxr.common.util.file.FileUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public abstract class AbstractDraftPlugin
extends AbstractLicenseCheckFormPlugin
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(AbstractDraftPlugin.class);
    private static final String DRAFT_ID = "draftId";
    protected static String BAR_KEY = "toolbarap";
    protected static String TOOL_BAR_DECLARE = "toolbarapdeclare";
    public static final String FLEXPANELAP22 = "flexpanelap22";
    protected static final String CONTENT_TAB = "tabcontent";
    protected static final String ORGID_KEY = "orgid";
    protected static final String OLD_ORGID_KEY = "oldorgid";
    protected static final String NEXT_KEY = "next";
    protected static final String FORWARD_KEY = "forward";
    protected static final String EDIT_KEY = "edit";
    protected static final String SAVE_KEY = "save";
    protected static final String CANCEL_KEY = "cancel";
    protected static final String EXPORTER_KEY = "exportsheet";
    protected static final String SUBMIT_KEY = "submit";
    protected static final String UNSUBMIT_KEY = "unsubmit";
    protected static final String AUDIT_KEY = "audit";
    protected static final String UNAUDIT_KEY = "unaudit";
    protected static final String FASTSETTING_KEY = "fastsetting";
    protected static final String RECALC_KEY = "recalc";
    protected static final String FETCH_KEY = "refetch";
    protected static final String CREATESBB_KEY = "createsbb";
    protected static final String NEWJTD_KEY = "newjtd";
    protected static final String VIEWFLOWCHART_KEY = "viewflowchart";
    protected static final String REFRESH_KEY = "refresh";
    protected static final String ORG_SEL = "org";
    protected static final String SKSSQQ = "skssqq";
    protected static final String SKSSQZ = "skssqz";
    protected static final String FOCUS_PAGE = "focuspage";
    protected static final String BILL_STATUS = "cache_billstatus";
    protected static final String STATUS = "status";
    protected static final String READ_ONLY = "readonly";
    protected static final String TOOLBAR_FLEX = "toolbarapflex";
    protected static final String RULE_CODE_FIELD = "draftnumber";
    protected static final String DRAFT_NUMBER_SEPARATOR = "_";
    private static boolean READONLY = false;
    protected static final String DECLARE_STATUS = "cache_declarestatus";
    private static Map<String, String> appidCategoryMap = new HashMap<String, String>();
    private static final String ATTACHMENT_VISIABLE = "attachment_visiable";
    public static final String DRAFT_ENTITY = "tctb_draft_main";
    public static final String DRAFT_SJJT_ENTITY = "tpo_declare_main_tsd";
    private Map<String, DeclarePageType> declarePageMap = new HashMap<String, DeclarePageType>();

    protected Map<String, DeclarePageType> getDeclarePageMap() {
        return this.declarePageMap;
    }

    public void setDeclarePageMap(Map<String, DeclarePageType> declarePageMap) {
        this.declarePageMap = declarePageMap;
    }

    public void registerListener(EventObject e) {
        for (int step = 1; step <= this.declarePageMap.size(); ++step) {
            this.addClickListeners(new String[]{"step" + step});
        }
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_DECLARE});
        if (this.hasAttachment()) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(this.getAttachmentFieldName());
            attachmentPanel.addUploadListener((UploadListener)this);
        }
    }

    public String getAttachmentFieldName() {
        return null;
    }

    public String getAttachmentPanelName() {
        return null;
    }

    public boolean hasAttachment() {
        return this.getAttachmentPanelName() != null;
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SUBMIT_KEY, SAVE_KEY, CANCEL_KEY, CREATESBB_KEY, AUDIT_KEY, VIEWFLOWCHART_KEY, REFRESH_KEY});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("draftpurpose", customParams.get("draftpurpose") != null ? customParams.get("draftpurpose").toString() : "nssb");
        if (customParams.get(ORGID_KEY) != null && customParams.get(SKSSQQ) != null && customParams.get(SKSSQZ) != null) {
            this.loadFromHyperLinkClick(customParams);
        } else {
            this.loadFromMenuClick(customParams);
        }
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        String orgid = (String)customParams.get(ORGID_KEY);
        READONLY = customParams.get("declarefinish") == null ? false : (Boolean)customParams.get("declarefinish");
        this.getView().setVisible(Boolean.valueOf(!READONLY), new String[]{FLEXPANELAP22, TOOLBAR_FLEX});
        this.getModel().setValue(ORG_SEL, (Object)orgid);
        this.getPageCache().put(ORGID_KEY, orgid);
        String skssqqstr = (String)customParams.get(SKSSQQ);
        Date skssqq = DateUtils.stringToDate(skssqqstr);
        this.getModel().setValue(SKSSQQ, (Object)skssqq);
        this.getPageCache().put(SKSSQQ, skssqqstr);
        String skssqzstr = (String)customParams.get(SKSSQZ);
        Date skssqz = DateUtils.stringToDate(skssqzstr);
        this.getModel().setValue(SKSSQZ, (Object)skssqz);
        this.getPageCache().put(SKSSQZ, skssqzstr);
        this.setRuleCode();
        this.loadData((Date)this.getModel().getValue(SKSSQQ), (Date)this.getModel().getValue(SKSSQZ));
    }

    private void loadFromMenuClick(Map<String, Object> customParams) {
        String appId = this.getView().getFormShowParameter().getAppId();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        String paramOrgid = (String)customParams.get(ORG_SEL);
        Long org = StringUtil.isNotBlank((CharSequence)paramOrgid) ? Long.parseLong(paramOrgid) : RequestContext.get().getOrgId();
        Long orgid = OrgCheckUtil.setDefaultOrg(this.getView(), org, col);
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        if (orgid != null) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.getPageCache().put(ORGID_KEY, String.valueOf(orgid));
            this.initStartAndEndDate(false);
            String orgname = this.getModel().getValue(ORG_SEL) == null ? "" : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("name");
            boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter(appId, "zerodeclare", orgid);
            if (zerodeclare) {
                if ("sjjt".equals(draftpurpose)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u8ba1\u63d0\u5e95\u7a3f\u3002", (String)"AbstractDraftPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgname));
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"AbstractDraftPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgname));
                }
                DraftStepsUtils.resetSteps(this.getDeclarePageMap().size(), "0", "0", this.getView());
                this.getView().setVisible(Boolean.FALSE, new String[]{FORWARD_KEY});
                this.getModel().setValue(ORG_SEL, null);
                this.getPageCache().put(ORGID_KEY, null);
                return;
            }
            boolean isTrue = OrgCheckUtil.withoutLicenseCheck(this.getView(), String.valueOf(orgid), appId, appidCategoryMap.get(appId));
            if (isTrue) {
                DraftStepsUtils.resetSteps(this.getDeclarePageMap().size(), "0", "0", this.getView());
                this.getModel().setValue(ORG_SEL, null);
                this.getPageCache().put(ORGID_KEY, null);
                return;
            }
            boolean hasLicense = false;
            if (StringUtil.isNotEmpty((CharSequence)appId) && !"tam".equals(appId)) {
                hasLicense = OrgCheckUtil.draftLicenseCheck(this.getView(), String.valueOf(orgid), appId, appidCategoryMap.get(appId));
            }
            if (hasLicense) {
                DraftStepsUtils.resetSteps(this.getDeclarePageMap().size(), "0", "0", this.getView());
                this.getModel().setValue(ORG_SEL, null);
                this.getPageCache().put(ORGID_KEY, null);
                return;
            }
            if (!this.doCustomInAfterCreateNewData(String.valueOf(orgid), this.getPageCache().get(SKSSQQ), this.getPageCache().get(SKSSQZ))) {
                return;
            }
            this.loadData((Date)this.getModel().getValue(SKSSQQ), (Date)this.getModel().getValue(SKSSQZ));
        } else {
            DraftStepsUtils.resetSteps(this.getDeclarePageMap().size(), "0", "0", this.getView());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"AbstractDraftPlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        String name = e.getProperty().getName();
        if (name.equals(ORG_SEL) || name.equals(SKSSQQ) || name.equals(SKSSQZ)) {
            switch (name) {
                case "org": {
                    DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
                    if (null == newOrg) {
                        this.getView().getModel().setValue(ORG_SEL, (Object)this.getPageCache().get(ORGID_KEY));
                        return;
                    }
                    String neworgid = newOrg.getString("id");
                    String appid = this.getView().getFormShowParameter().getAppId();
                    String draftpurpose = this.getView().getFormShowParameter().getCustomParams().getOrDefault("draftpurpose", "nssb");
                    boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter(appid, "zerodeclare", Long.parseLong(neworgid));
                    if (zerodeclare) {
                        if ("sjjt".equals(draftpurpose)) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u8ba1\u63d0\u5e95\u7a3f\u3002", (String)"AbstractDraftPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), newOrg.getString("name")));
                        } else {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"AbstractDraftPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), newOrg.getString("name")));
                        }
                        this.getView().getModel().setValue(ORG_SEL, (Object)this.getPageCache().get(ORGID_KEY));
                        return;
                    }
                    boolean notAuthorize = LicenseCheckServiceHelper.check(neworgid, this.getView(), this.getView().getFormShowParameter().getAppId());
                    if (notAuthorize) {
                        this.getModel().setValue(ORG_SEL, (Object)this.getPageCache().get(ORGID_KEY));
                        return;
                    }
                    this.getPageCache().put(ORGID_KEY, neworgid);
                    this.initStartAndEndDate(true);
                    break;
                }
                case "skssqq": {
                    if (null == this.getModel().getValue(ORG_SEL)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDraftPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    if (StringUtil.isNotEmpty((CharSequence)this.getPageCache().get("code_change_start"))) {
                        this.getPageCache().remove("code_change_start");
                        return;
                    }
                    Date startDate = (Date)changeData[0].getNewValue();
                    this.getPageCache().put(SKSSQQ, DateUtils.format(startDate));
                    if (this.isValidDateNoMsg(startDate, DateUtils.stringToDate(this.getPageCache().get(SKSSQZ)))) break;
                    return;
                }
                case "skssqz": {
                    if (null == this.getModel().getValue(ORG_SEL)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDraftPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return;
                    }
                    if (StringUtil.isNotEmpty((CharSequence)this.getPageCache().get("code_change_end"))) {
                        this.getPageCache().remove("code_change_end");
                        return;
                    }
                    Date endDate = (Date)changeData[0].getNewValue();
                    this.getPageCache().put(SKSSQZ, DateUtils.format(endDate));
                    if (this.isValidDateNoMsg(DateUtils.stringToDate(this.getPageCache().get(SKSSQQ)), endDate)) break;
                    return;
                }
            }
            this.loadData((Date)this.getModel().getValue(SKSSQQ), (Date)this.getModel().getValue(SKSSQZ));
        }
    }

    protected boolean isValidDates(Date startDate, Date endDate) {
        boolean isvalid = false;
        String[] taxLimits = this.getTaxLimits();
        if (taxLimits.length == 0) {
            return false;
        }
        for (String taxLimit : taxLimits) {
            boolean temp = DateUtils.validDateRange(taxLimit, startDate, endDate);
            isvalid |= temp;
        }
        if (!isvalid) {
            String errMsg = this.buildErrorMsg(taxLimits);
            this.getView().showTipNotification(errMsg);
            return false;
        }
        return true;
    }

    protected boolean isValidDateNoMsg(Date startDate, Date endDate) {
        boolean isvalid = false;
        String[] taxLimits = this.getTaxLimits();
        if (taxLimits.length == 0) {
            return false;
        }
        for (String taxLimit : taxLimits) {
            boolean temp = DateUtils.validDateRange(taxLimit, startDate, endDate);
            isvalid |= temp;
        }
        return isvalid;
    }

    private String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a%s\u3002", (String)"AbstractDraftPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        ArrayList<String> nameList = new ArrayList<String>(taxLimits.length);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        List<String> itemButton = Arrays.asList(NEXT_KEY, FORWARD_KEY, SAVE_KEY, CANCEL_KEY);
        if (itemButton.contains(itemKey = evt.getItemKey()) && !this.isValidDates((Date)this.getModel().getValue(SKSSQQ), (Date)this.getModel().getValue(SKSSQZ))) {
            return;
        }
        switch (itemKey) {
            case "next": 
            case "forward": {
                this.lastOrNextStep(itemKey);
                break;
            }
            case "save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"AbstractDraftPlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                this.save();
                break;
            }
            case "cancel": {
                LocaleString cancelMsg = new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"AbstractDraftPlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                this.getView().showLoading(cancelMsg, 3000);
                FormulaService.cancel(this.getPageCache());
                this.operationSbb("read");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String itemKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!this.isValidDates((Date)this.getModel().getValue(SKSSQQ), (Date)this.getModel().getValue(SKSSQZ))) {
            return;
        }
        switch (itemKey = afterDoOperationEventArgs.getOperateKey()) {
            case "edit": {
                this.operationSbb(EDIT_KEY);
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.submit(itemKey);
                break;
            }
            case "recalc": {
                this.recale();
                break;
            }
            case "refetch": {
                this.refetch();
                break;
            }
            case "createsbb": {
                this.createsbb();
                break;
            }
            case "newjtd": {
                this.newJtd();
                break;
            }
            case "exportsheet": {
                this.export();
                break;
            }
            case "viewflowchart": {
                this.viewFlowChart();
                break;
            }
            case "refresh": {
                this.refresh();
            }
        }
    }

    protected void refresh() {
        String orgId = this.getPageCache().get(ORGID_KEY) != null ? this.getPageCache().get(ORGID_KEY) : "0";
        boolean readonly = this.isSubmitOrAudit(this.getView().getPageId(), orgId, this.getPageCache().get(SKSSQQ), this.getPageCache().get(SKSSQZ), this.getDraftpurpose());
        this.setButtonVisible(this.getPageCache().get(FOCUS_PAGE));
        String billStatus = this.getPageCache().get(BILL_STATUS);
        if ("A".equals(billStatus)) {
            this.setChildViewStatus();
        }
    }

    protected void viewFlowChart() {
        String draftpurpose = this.getDraftpurpose();
        DynamicObject object = this.queryDraftBillObject(this.getTemplateType(), this.getPageCache().get(ORGID_KEY), this.getPageCache().get(SKSSQQ), this.getPageCache().get(SKSSQZ), draftpurpose);
        if (object != null) {
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            try {
                WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)object.get("id"), (OpenStyle)openStyle);
            }
            catch (Exception e) {
                LOGGER.error("\u67e5\u770b\u6d41\u7a0b\u56fe\u5f02\u5e38", (Object)ThrowableHelper.toString(e));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"TaxDeclareQueryListPlugin_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        }
    }

    public void export() {
        String draftnumber = (String)this.getModel().getValue(RULE_CODE_FIELD);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
        String orgName = org.getString("name");
        String skssqq = DateUtils.format((Date)this.getModel().getValue(SKSSQQ));
        String skssqz = DateUtils.format((Date)this.getModel().getValue(SKSSQZ));
        String sheetName = this.getPageCache().get("sheetName");
        List<? extends BaseRowModel> data = this.getExportData(orgName, skssqq, skssqz);
        if (CollectionUtils.isEmpty(data)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7b7e\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\uff01", (String)"AbstractDraftPlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        LOGGER.info("draftExport data: {}", (Object)JSONObject.toJSONString(data));
        File file = ExportExcelUtils.exportExcelWithSheet(null, null, data, data.get(0).getClass());
        LOGGER.info("draftExport data: {}", (Object)JSONObject.toJSONString((Object)file));
        if (file == null) {
            return;
        }
        LOGGER.info("draftExport exist: {}", (Object)file.exists());
        LOGGER.info("draftExport file: {}", (Object)file.getAbsolutePath());
        String fileName = draftnumber + orgName + skssqq + skssqz + sheetName;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)in, 5000);
            LOGGER.info("draftExport urls: {}", (Object)urls);
            String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
            String entityNum = this.getView().getFormShowParameter().getFormId();
            PermissionUtils.putTempFilePermissionCache(urls, serviceAppId, entityNum, "4730fc9f000004ae");
            this.getView().openUrl(urls);
        }
        catch (Exception e) {
            try {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
            }
            catch (Throwable throwable) {
                FileUtils.safeClose(in);
                throw throwable;
            }
        }
        FileUtils.safeClose(in);
    }

    protected List<? extends BaseRowModel> getExportData(String orgName, String skssqq, String skssqz) {
        IFormView childView = this.getView().getView(this.getPageCache().get("draftPageId"));
        if (childView == null) {
            return null;
        }
        IDataModel childModel = childView.getModel();
        String entryEntityName = this.getPageCache().get("entryEntityName");
        String pluginName = this.getView().getPageCache().get("draftDataDtoPluginName");
        LOGGER.info("draftExport params --- orgName: {}, skssqq: {}, skssqz: {}, entryEntityName: {}, pluginName: {}", new Object[]{orgName, skssqq, skssqz, entryEntityName, pluginName});
        if (StringUtil.isBlank((CharSequence)entryEntityName) || StringUtil.isBlank((CharSequence)pluginName)) {
            return null;
        }
        DynamicObjectCollection col = childModel.getEntryEntity(entryEntityName);
        List<? extends BaseRowModel> result = BeanUtils.dynamicToDto(pluginName, null, col, null);
        String pluginFeildExpandStr = this.getPageCache().get("pluginFeildExpandStr");
        if (StringUtil.isNotBlank((CharSequence)pluginFeildExpandStr)) {
            DynamicObjectCollection col1 = childModel.getEntryEntity(entryEntityName + pluginFeildExpandStr);
            result = BeanUtils.dynamicToDto(pluginName, result, col1, pluginFeildExpandStr);
        }
        result.forEach(el -> {
            BaseRowModel obj = el;
            obj = BeanUtils.setValueBySetMethodName(pluginName, "setOrgName", obj, orgName, String.class);
            obj = BeanUtils.setValueBySetMethodName(pluginName, "setSkssqq", obj, skssqq, String.class);
            obj = BeanUtils.setValueBySetMethodName(pluginName, "setSkssqz", obj, skssqz, String.class);
            el = (BaseRowModel)JSONObject.parseObject((String)JSONObject.toJSONString((Object)obj), el.getClass(), (Feature[])new Feature[0]);
        });
        return result;
    }

    protected void newJtd() {
    }

    private void createsbb() {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String skssqq = this.getPageCache().get(SKSSQQ);
        String skssqz = this.getPageCache().get(SKSSQZ);
        customParams.put(ORGID_KEY, orgId);
        customParams.put(SKSSQQ, skssqq);
        customParams.put(SKSSQZ, skssqz);
        customParams.put(REFRESH_KEY, "true");
        String declarePage = TemplateEnum.getEnumByDraftType(this.getTemplateType()).getDeclarePage();
        PageShowCommon.showForm(ShowType.MainNewTabPage, declarePage, this.getView(), customParams, (IFormPlugin)this);
    }

    private void submit(String itemKey) {
        String draftpurpose = this.getDraftpurpose();
        DynamicObject declare = this.queryDraftBillObject(this.getTemplateType(), this.getPageCache().get(ORGID_KEY), this.getPageCache().get(SKSSQQ), this.getPageCache().get(SKSSQZ), draftpurpose);
        if (declare != null) {
            String entity;
            switch (this.getTemplateType()) {
                case "draft_qysdsjb": {
                    if ("sjjt".equals(draftpurpose)) {
                        entity = "tccit_sjjt_list";
                        break;
                    }
                    entity = "tccit_seasonal_dg_bill";
                    break;
                }
                case "draft_qysdsnb": {
                    entity = "tccit_year_dg_bill";
                    break;
                }
                case "draft_zzsybnsr_sjjt": 
                case "draft_zzsybnsr_ybhz_sjjt": 
                case "draft_zzsybnsr_hz_zjg_sjjt": 
                case "draft_zzsybnsr_yz_zjg_sjjt": 
                case "draft_zzsxgmnsr_sjjt": {
                    entity = "tcvat_sjjt_draft_query";
                    break;
                }
                default: {
                    entity = "tcvat_query_ybnsr";
                }
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)itemKey, (String)entity, (Object[])new Object[]{declare.get("id")}, (OperateOption)OperateOption.create());
            boolean isSuccess = result.isSuccess();
            boolean isSubmitandaudit = false;
            String msg = "";
            if (SUBMIT_KEY.equals(itemKey)) {
                isSubmitandaudit = Optional.ofNullable(ParameterReader.getBillParameter((String)entity)).map(e -> e.getBoolean("submitandaudit")).orElse(false);
                if (isSuccess) {
                    msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"AbstractDraftPlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                    if (isSubmitandaudit && (isSuccess = (result = OperationServiceHelper.executeOperate((String)AUDIT_KEY, (String)entity, (Object[])new Object[]{declare.get("id")}, (OperateOption)OperateOption.create())).isSuccess())) {
                        msg = ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"AbstractDraftPlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                    }
                }
            } else if (isSuccess) {
                String string = itemKey.equals(AUDIT_KEY) ? ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"AbstractDraftPlugin_32", (String)"taxc-bdtaxr-common", (Object[])new Object[0]) : (msg = itemKey.equals(UNAUDIT_KEY) ? ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"AbstractDraftPlugin_33", (String)"taxc-bdtaxr-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"AbstractDraftPlugin_34", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (isSuccess) {
                this.getView().showSuccessNotification(msg);
                this.setBtnStatus(declare, itemKey, isSubmitandaudit);
                if ((UNSUBMIT_KEY.equals(itemKey) || UNAUDIT_KEY.equals(itemKey)) && this.getPageCache().get("declarepageid") != null) {
                    this.setChildViewStatus();
                }
            } else {
                this.getView().showOperationResult(result);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e95\u7a3f\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\uff01", (String)"AbstractDraftPlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    private void setBtnStatus(DynamicObject dynamicObject, String itemKey, boolean isSubmitandaudit) {
        if (dynamicObject != null) {
            String focuspage = this.getPageCache().get(FOCUS_PAGE);
            if (itemKey.equals(SUBMIT_KEY)) {
                if (isSubmitandaudit) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY, VIEWFLOWCHART_KEY});
                    this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SAVE_KEY, RECALC_KEY, FETCH_KEY, CANCEL_KEY, FASTSETTING_KEY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{UNAUDIT_KEY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY, VIEWFLOWCHART_KEY});
                    this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SAVE_KEY, RECALC_KEY, FETCH_KEY, CANCEL_KEY, FASTSETTING_KEY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{UNSUBMIT_KEY, AUDIT_KEY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY, UNAUDIT_KEY});
                }
            }
            if (itemKey.equals(UNSUBMIT_KEY) || itemKey.equals(UNAUDIT_KEY)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{VIEWFLOWCHART_KEY});
                this.getView().setEnable(Boolean.TRUE, new String[]{SUBMIT_KEY});
                this.getView().setEnable(Boolean.FALSE, new String[]{UNSUBMIT_KEY});
                if ("1".equals(focuspage)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{RECALC_KEY, FASTSETTING_KEY});
                    this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY, EDIT_KEY});
                } else if (String.valueOf(this.declarePageMap.size()).equals(focuspage)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, EDIT_KEY, RECALC_KEY});
                    this.getView().setVisible(Boolean.FALSE, new String[]{AUDIT_KEY, UNAUDIT_KEY});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{RECALC_KEY, FASTSETTING_KEY});
                    this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY, EDIT_KEY});
                }
            }
            if (itemKey.equals(AUDIT_KEY)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY, VIEWFLOWCHART_KEY});
                this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SAVE_KEY, RECALC_KEY, FETCH_KEY, CANCEL_KEY, FASTSETTING_KEY});
                this.getView().setEnable(Boolean.TRUE, new String[]{UNAUDIT_KEY});
                this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY});
            }
        }
    }

    private void setChildViewStatus() {
        IFormView childView = this.getView().getView(this.getPageCache().get("declarepageid"));
        if (childView != null) {
            childView.setStatus(OperationStatus.EDIT);
            childView.getFormShowParameter().setStatus(OperationStatus.EDIT);
            this.getView().sendFormAction(childView);
        }
    }

    public void save() {
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("TaxDeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class);
                saveClick.invoke(taxDeclarePlugin, childPageCache);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"AbstractDraftPlugin_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            this.operationSbb("read");
        }
        Object draftnumber = this.getModel().getValue(RULE_CODE_FIELD);
        String appId = this.getView().getFormShowParameter().getAppId();
        String appname = appidCategoryMap.get(appId);
        String operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AbstractDraftPlugin_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        String operateDescription = String.format(ResManager.loadKDString((String)"\u5e95\u7a3f\u7f16\u7801\u4e3a%s\u7684\u5e95\u7a3f\u4fdd\u5b58\u6210\u529f", (String)"AbstractDraftPlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), draftnumber);
        if ("zzs".equals(appname)) {
            OperatorDialogUtils.operateDialog("zzs", "tcvat_draft_page", operateName, operateDescription);
        }
        if ("yhs".equals(appname)) {
            OperatorDialogUtils.operateDialog("yhs", "tcsd_draft_page", operateName, operateDescription);
        }
        if ("tcct".equals(appname)) {
            OperatorDialogUtils.operateDialog("tcct", "tcct_draft_edit", operateName, operateDescription);
        }
    }

    private void refetch() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(FETCH_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDraftPlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDraftPlugin_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = this.getReFetchMsg();
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    protected void recale() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDraftPlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDraftPlugin_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = this.getMsg();
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    protected String getMsg() {
        return ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5c06\u5bfc\u81f4\u539f\u6709\u5e95\u7a3f\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDraftPlugin_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    protected String getReFetchMsg() {
        return ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u5c06\u5bfc\u81f4\u5e95\u7a3f\u5185\u975e\u624b\u5de5\u4fee\u6539\u5355\u5143\u683c\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDraftPlugin_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    public void click(EventObject evt) {
        String status;
        String key = ((Control)evt.getSource()).getKey();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String startdate = this.getPageCache().get(SKSSQQ);
        String enddate = this.getPageCache().get(SKSSQZ);
        String draftpurpose = this.getPageCache().get("draftpurpose");
        String string = status = null == orgId ? "0" : StatusUtils.getStatus(this.getTemplateType(), orgId, startdate, enddate, draftpurpose);
        if (key.startsWith("step")) {
            String focuspage;
            if (orgId != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(orgId)).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"AbstractDraftPlugin_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            String step = key.replace("step", "");
            if (step.equals(focuspage = this.getPageCache().get(FOCUS_PAGE))) {
                return;
            }
            if (Integer.parseInt(status) >= Integer.parseInt(step)) {
                if (!this.checkBeforeNextStep(orgId, startdate, enddate, status, step)) {
                    return;
                }
                if (this.showInnerTbPage(step, orgId) && "3".equals(step)) {
                    this.markEditStatus();
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String enddate;
        String startdate;
        String orgId;
        String callBackId = e.getCallBackId();
        if (RECALC_KEY.equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            orgId = this.getPageCache().get(ORGID_KEY);
            startdate = this.getPageCache().get(SKSSQQ);
            enddate = this.getPageCache().get(SKSSQZ);
            String draftpurpose = this.getPageCache().get("draftpurpose");
            if (orgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDraftPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            String templateType = this.getTemplateType();
            EngineHandler handler = EngineHandlerFactory.createHandler(TemplateEnum.getEnumByDraftType(templateType).getDeclareType());
            EngineModel engineModel = this.getEngineModel(orgId, startdate, enddate, draftpurpose);
            handler.getEngineList().forEach(engine -> engine.deleteData(engineModel));
            this.deleteAllDraftData(templateType, orgId, startdate, enddate);
            StatusUtils.updateStatus(templateType, orgId, startdate, enddate, "1", draftpurpose);
            this.showInnerTbPage("1", orgId);
            CacheUtils.getInstance().setDataResult(this.getPageCache(), null);
        }
        if (FETCH_KEY.equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            orgId = this.getPageCache().get(ORGID_KEY);
            startdate = this.getPageCache().get(SKSSQQ);
            enddate = this.getPageCache().get(SKSSQZ);
            String declaretype = this.getPageCache().get("declaretype");
            String focuspage = this.getPageCache().get(FOCUS_PAGE);
            if (orgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDraftPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            this.dispatch(orgId, startdate, enddate, declaretype, FETCH_KEY, Boolean.FALSE, focuspage);
        }
    }

    protected void dispatch(String orgId, String startdate, String enddate, String declaretype, String calcType, Boolean removeAdjustByHand, String focuspage) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("orgId", orgId);
        params.put("startdate", startdate);
        params.put("enddate", enddate);
        params.put("declaretype", declaretype);
        params.put("remove_adjust_by_hand", removeAdjustByHand);
        params.put("calcType", calcType);
        params.put(FOCUS_PAGE, focuspage);
        this.addCustomParams(params);
        this.dispatch(params);
    }

    protected void addCustomParams(Map<String, Object> params) {
    }

    protected void dispatch(Map<String, Object> customParams) {
        String appId = this.getView().getFormShowParameter().getAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(this.getJobName());
        jobInfo.setId(this.getJobId());
        jobInfo.setTaskClassname(this.getTaskClassName());
        jobInfo.setRunByUserId(RequestContext.getOrCreate().getCurrUserId());
        jobInfo.setParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(this.getCaption());
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName(this.getClickClassName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    protected String getCaption() {
        return ResManager.loadKDString((String)"\u89c4\u5219\u53d6\u6570\u8fdb\u5ea6", (String)"AbstractDraftPlugin_31", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtil.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtil.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                this.taskEndCallBack(taskInfo);
            }
        }
    }

    public void taskEndCallBack(TaskInfo taskInfo) {
    }

    protected String getJobName() {
        return "";
    }

    protected String getJobId() {
        return UUID.randomUUID().toString();
    }

    protected String getTaskClassName() {
        return "";
    }

    protected String getClickClassName() {
        return CalcTaskClick.class.getName();
    }

    protected EngineModel getEngineModel(String orgId, String startdate, String enddate, String draftpurpose) {
        EngineModel engineModel = new EngineModel(orgId, startdate, enddate);
        engineModel.addCustom("draftpurpose", draftpurpose);
        engineModel.addCustom("taxperiod", startdate.substring(0, 7));
        engineModel.addCustom("deadLine", this.getPageCache().get("deadLine"));
        engineModel.addCustom(SKSSQQ, startdate);
        engineModel.addCustom(SKSSQZ, enddate);
        engineModel.addCustom("taxPayerType", this.getPageCache().get("taxPayerType"));
        return engineModel;
    }

    protected void lightenForStatus(String focuspage, String status) {
        DraftStepsUtils.resetSteps(this.declarePageMap.size(), focuspage, status, this.getView());
        this.setButtonVisible(focuspage);
        this.getPageCache().put(FOCUS_PAGE, focuspage);
    }

    protected void setButtonVisible(String focuspage) {
        if ("1".equals(focuspage)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FORWARD_KEY, FETCH_KEY, EDIT_KEY, EXPORTER_KEY, SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY, CREATESBB_KEY, SAVE_KEY, CANCEL_KEY, NEWJTD_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{NEXT_KEY, REFRESH_KEY});
            this.setSubmitAuditButton(this.getPageCache().get(BILL_STATUS));
        } else if (focuspage.equals(String.valueOf(this.declarePageMap.size()))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD_KEY, CREATESBB_KEY, REFRESH_KEY});
            if ("A".equals(this.getPageCache().get(BILL_STATUS)) || StringUtils.isBlank((CharSequence)this.getPageCache().get(BILL_STATUS))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, EDIT_KEY});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, EDIT_KEY});
            }
            this.setSubmitAuditButton(this.getPageCache().get(BILL_STATUS));
            this.getView().setVisible(Boolean.FALSE, new String[]{EXPORTER_KEY, NEXT_KEY, SAVE_KEY, CANCEL_KEY, FASTSETTING_KEY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{EXPORTER_KEY, FORWARD_KEY, NEXT_KEY, REFRESH_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY, CREATESBB_KEY, SAVE_KEY, CANCEL_KEY, NEWJTD_KEY});
            this.setSubmitAuditButton(this.getPageCache().get(BILL_STATUS));
            if ("A".equals(this.getPageCache().get(BILL_STATUS)) || StringUtils.isBlank((CharSequence)this.getPageCache().get(BILL_STATUS))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FETCH_KEY});
            }
        }
    }

    protected void setSubmitAuditButton(String billstatus) {
        if ("A".equals(billstatus) || StringUtils.isBlank((CharSequence)billstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FASTSETTING_KEY, RECALC_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{AUDIT_KEY, UNAUDIT_KEY, VIEWFLOWCHART_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{SUBMIT_KEY});
            this.getView().setEnable(Boolean.FALSE, new String[]{UNSUBMIT_KEY});
        } else if ("B".equals(billstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY, VIEWFLOWCHART_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, FASTSETTING_KEY, RECALC_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{UNSUBMIT_KEY, AUDIT_KEY});
            this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY, UNAUDIT_KEY});
        } else if ("C".equals(billstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY, VIEWFLOWCHART_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, FASTSETTING_KEY, RECALC_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{UNAUDIT_KEY});
            this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY});
        }
    }

    protected boolean showInnerTbPage(String focuspage, String orgId) {
        FormShowParameter param;
        if (!this.beforeShowInnerTbPage(focuspage, orgId)) {
            return false;
        }
        if (!this.isValidDates((Date)this.getModel().getValue(SKSSQQ), (Date)this.getModel().getValue(SKSSQZ))) {
            return false;
        }
        String startdate = Optional.ofNullable((Date)this.getModel().getValue(SKSSQQ)).map(date -> DateUtils.format(date)).orElseGet(() -> "");
        String enddate = Optional.ofNullable((Date)this.getModel().getValue(SKSSQZ)).map(date -> DateUtils.format(date)).orElseGet(() -> "");
        String draftpurpose = this.getPageCache().get("draftpurpose");
        String draftId = this.getPageCache().get(DRAFT_ID);
        String tempateType = this.getTemplateType();
        if (StringUtil.isBlank((CharSequence)tempateType)) {
            return false;
        }
        if (tempateType.endsWith("zzsybnsr_zjg") || tempateType.endsWith("zzsybnsr_fzjg")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY, FETCH_KEY});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u822a\u7a7a\u8fd0\u8f93\u4f01\u4e1a\u6682\u4e0d\u652f\u6301\u6c47\u603b\u7533\u62a5", (String)"AbstractDraftPlugin_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), null);
            return false;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{RECALC_KEY, FETCH_KEY});
        String status = StatusUtils.getStatus(tempateType, orgId, startdate, enddate, draftpurpose);
        this.getPageCache().put(STATUS, status);
        if (Integer.parseInt(focuspage) < 6 && Integer.parseInt(focuspage) - Integer.parseInt(status) > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u6b65\u9aa4\u672a\u8fdb\u884c\u5b8c\u6bd5\u6216\u5931\u8d25\uff0c\u4e0d\u80fd\u8fdb\u884c\u4e0b\u4e00\u6b65\u64cd\u4f5c!", (String)"AbstractDraftPlugin_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return false;
        }
        if ("1".equals(focuspage) || "6".equals(focuspage)) {
            this.setRuleCode();
        }
        this.setButtonStyle(focuspage);
        Map<String, Object> customParams = this.createCustomParams(orgId, startdate, enddate, status, focuspage);
        customParams.put(ORGID_KEY, orgId);
        customParams.put(STATUS, status);
        String rootPageId = this.getView().getPageId();
        customParams.put("rootPageId", rootPageId);
        customParams.put(SKSSQQ, startdate);
        customParams.put(SKSSQZ, enddate);
        customParams.put("totalsteps", this.getDeclarePageMap().size());
        customParams.put(FOCUS_PAGE, focuspage);
        customParams.put("draftpurpose", draftpurpose);
        customParams.put(DRAFT_ID, draftId);
        String draftTable = DraftService.getDraftTable(draftpurpose);
        customParams.put("draftTable", draftTable);
        boolean readonly = this.isSubmitOrAudit(rootPageId, orgId, startdate, enddate, draftpurpose);
        DynamicObject draftObject = StatusUtils.queryOne(tempateType, orgId, startdate, enddate, draftpurpose);
        if (draftObject != null) {
            String draftid = draftObject.getString("id");
            this.getPageCache().put(DRAFT_ID, draftid);
        }
        this.showAttachment(draftObject, readonly);
        this.getView().setVisible(Boolean.valueOf(!readonly), new String[]{RECALC_KEY, FETCH_KEY});
        customParams.put("billstatus", this.getPageCache().get(BILL_STATUS));
        customParams.put(READ_ONLY, readonly);
        Object scene = this.getView().getFormShowParameter().getCustomParam("scene");
        customParams.put("scene", scene);
        if ("workflowview".equals(scene)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TOOLBAR_FLEX});
        }
        if (null != (param = this.createShowParameter(focuspage, orgId, startdate, enddate, readonly))) {
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.InContainer);
            param.getOpenStyle().setTargetKey(CONTENT_TAB);
            String pageid = param.getPageId();
            this.getPageCache().put("declarepageid", pageid);
            this.lightenForStatus(focuspage, status);
            String appId = this.getView().getFormShowParameter().getAppId();
            boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter(appId, "zerodeclare", Long.parseLong(orgId));
            if (zerodeclare) {
                String orgname = OrgUtils.getOrgNameById(orgId);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"AbstractDraftPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgname));
            }
            this.getView().setEnable(Boolean.valueOf(!zerodeclare), new String[]{CONTENT_TAB});
            this.getView().showForm(param);
        }
        return true;
    }

    public void setButtonStyle(String focuspage) {
        HashMap style = new HashMap(1);
        HashMap map = new HashMap(1);
        HashMap<String, String> margin = new HashMap<String, String>();
        DeclarePageType declarePageType = this.declarePageMap.get(focuspage);
        String pageTypeStyle = declarePageType.getStyle();
        if (StringUtil.isBlank((CharSequence)pageTypeStyle)) {
            pageTypeStyle = "0px";
        }
        margin.put("r", pageTypeStyle);
        style.put("m", margin);
        map.put("s", style);
        this.getView().updateControlMetadata(TOOLBAR_FLEX, map);
    }

    private boolean verifyRegisterTime(String orgId, String enddate) {
        boolean isSuss = true;
        if (StringUtil.isNotBlank((CharSequence)orgId)) {
            DynamicObject dynamicObject = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
            if (dynamicObject == null) {
                return true;
            }
            Date fregistertime = dynamicObject.getDate("registertime");
            if (Objects.nonNull(fregistertime) && fregistertime.after(DateUtils.stringToDate(enddate))) {
                isSuss = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u786e\u8ba4\u7533\u62a5\u7684\u6240\u5c5e\u7a0e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u3002", (String)"AbstractDraftPlugin_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            return isSuss;
        }
        return true;
    }

    private FormShowParameter createShowParameter(String focuspage, String orgId, String startdate, String enddate, boolean readonly) {
        DeclarePageType declarePageType = this.declarePageMap.get(focuspage);
        String entity = declarePageType.getEntity();
        if (declarePageType.getShowType().equals("Form")) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId(entity);
            param.setStatus(readonly ? OperationStatus.VIEW : OperationStatus.EDIT);
            return param;
        }
        if (declarePageType.getShowType().equals("Bill")) {
            BillShowParameter billParam = new BillShowParameter();
            billParam.setFormId(entity);
            billParam.setStatus(readonly ? OperationStatus.VIEW : OperationStatus.EDIT);
            DynamicObject object = this.queryDynamicObject(focuspage, this.getTemplateType(), orgId, startdate, enddate);
            if (object != null) {
                billParam.setPkId(object.get("id"));
            }
            return billParam;
        }
        return null;
    }

    private boolean isSubmitOrAudit(String rootPageId, String orgId, String startdate, String enddate, String draftpurpose) {
        DynamicObject object;
        String billstatus = "A";
        String message = ResManager.loadKDString((String)"\u7533\u62a5\u8868", (String)"AbstractDraftPlugin_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        String templateid = this.getTemplateType();
        if (!"sjjt".equals(draftpurpose)) {
            DynamicObject declareReportStatus = StatusUtils.queryDeclareReport(templateid, orgId, startdate, enddate);
            if (declareReportStatus != null) {
                billstatus = declareReportStatus.getString("billstatus");
                this.getPageCache().put(DECLARE_STATUS, billstatus);
            } else {
                this.getPageCache().put(DECLARE_STATUS, "A");
            }
        }
        if ("A".equals(billstatus) && (object = StatusUtils.queryOne(this.getTemplateType(), orgId, startdate, enddate, draftpurpose)) != null) {
            billstatus = object.getString("billstatus");
            message = ResManager.loadKDString((String)"\u5e95\u7a3f", (String)"AbstractDraftPlugin_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        }
        return this.getBillStatus(rootPageId, billstatus, startdate, enddate, message);
    }

    private boolean getBillStatus(String rootPageId, String billstatus, String startdate, String enddate, String message) {
        IFormView rootView = this.getView().getView(rootPageId);
        IPageCache rootCache = (IPageCache)rootView.getService(IPageCache.class);
        rootCache.put(BILL_STATUS, billstatus);
        if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
            String taxlimitStr;
            DynamicObject org = (DynamicObject)rootView.getModel().getValue(ORG_SEL);
            String orgName = null != org ? org.getString("name") : "";
            String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"AbstractDraftPlugin_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            if ("C".equals(billstatus)) {
                statusName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"AbstractDraftPlugin_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            if (!(taxlimitStr = DateUtils.getTaxLimitTips(DateUtils.stringToDate(startdate), DateUtils.stringToDate(enddate))).equals("")) {
                if (!READONLY && !"workflowview".equals(this.getView().getFormShowParameter().getCustomParam("scene"))) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f%3$s\u5df2%4$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"AbstractDraftPlugin_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, taxlimitStr, message, statusName);
                    rootView.showTipNotification(msg, Integer.valueOf(5000));
                }
                this.getView().sendFormAction(rootView);
            }
            return true;
        }
        return false;
    }

    public void operationSbb(String operationType) {
        String oldPageId = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(oldPageId);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        String sheetId = childPageCache.get("sheetid");
        String sheetname = childPageCache.get("sheetname");
        Map customParams = childView.getFormShowParameter().getCustomParams();
        FormShowParameter param = new FormShowParameter();
        customParams.put("operation", operationType);
        customParams.put("sheetid", sheetId);
        customParams.put(REFRESH_KEY, "false");
        if (StringUtils.isNotBlank((CharSequence)sheetname)) {
            customParams.put("sheetname", sheetname);
        }
        param.setFormId(this.getDeclarePageEntity());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        customParams.put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        if (EDIT_KEY.equals(operationType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{SAVE_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{CANCEL_KEY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{EDIT_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{SAVE_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL_KEY});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void lastOrNextStep(String itemKey) {
        String focusPage = this.getPageCache().get(FOCUS_PAGE);
        String orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG_SEL)).map(o -> o.getString("id")).orElseGet(() -> "0");
        String startdate = Optional.ofNullable((Date)this.getModel().getValue(SKSSQQ)).map(date -> DateUtils.format(date)).orElseGet(() -> "");
        String enddate = Optional.ofNullable((Date)this.getModel().getValue(SKSSQZ)).map(date -> DateUtils.format(date)).orElseGet(() -> "");
        String draftpurpose = this.getDraftpurpose();
        String accountorg = Optional.ofNullable(this.getPageCache().get("accountorg")).orElseGet(() -> "0");
        String status = StatusUtils.getStatus(this.getTemplateType(), orgId, startdate, enddate, draftpurpose);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean bl = READONLY = customParams.get("declarefinish") == null ? false : (Boolean)customParams.get("declarefinish");
        if (READONLY && NEXT_KEY.equals(itemKey) && Integer.parseInt(focusPage) + 1 > Integer.parseInt(status)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u672a\u68c0\u6d4b\u5230\u6709\u5b58\u50a8\u7684\u5e95\u7a3f\u6570\u636e\u3002", (String)"AbstractDraftPlugin_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        if (focusPage == null || "0".equals(orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDraftPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(orgId)).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"AbstractDraftPlugin_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(STATUS, status);
        if (NEXT_KEY.equals(itemKey)) {
            String newFocusPage = String.valueOf(Integer.parseInt(focusPage) + 1);
            if (focusPage.equals("1") && !this.verifyRegisterTime(orgId, enddate)) {
                return;
            }
            if (!this.checkBeforeNextStep(orgId, startdate, enddate, status, newFocusPage)) {
                return;
            }
            if ("312".equals(this.getPageCache().get("declaretype"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672c\u5e74\u5ea6\u6682\u4e0d\u9700\u8981\u51fa\u5177\u7533\u8bf7\u8868", (String)"AbstractDraftPlugin_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            String appid = this.getView().getFormShowParameter().getAppId();
            String key = String.format("tax_%s_%s_%s", appid, orgId, startdate, enddate);
            if (!StringUtil.isBlank((CharSequence)DistributeCacheHelper.get(key))) return;
            DistributeCacheHelper.put(key, "draft", 300);
            LOGGER.info("========================createDraftCache=======,cacheKey=" + key);
            try {
                if (newFocusPage.equals("2") && "1".equals(status) || newFocusPage.equals("7") && "6".equals(status)) {
                    String policypageid = this.getPageCache().get("declarepageid");
                    DynamicObject dataEntity = this.getView().getView(policypageid).getModel().getDataEntity(true);
                    OperationResult result = OperationServiceHelper.executeOperate((String)SAVE_KEY, (String)dataEntity.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
                    if (result.isSuccess()) {
                        StatusUtils.createStatus(this.getTemplateType(), orgId, startdate, enddate, "2", draftpurpose, accountorg);
                        DraftStepsUtils.resetSteps(this.getDeclarePageMap().size(), this.getPageCache().get(FOCUS_PAGE), "2", this.getView());
                        this.saveDraftNumber(orgId, startdate, enddate, draftpurpose, accountorg);
                    } else {
                        this.getView().showOperationResult(result);
                        return;
                    }
                }
                DraftPluginDto draftPluginDto = new DraftPluginDto(orgId, startdate, enddate, status, newFocusPage);
                if (Integer.parseInt(newFocusPage) > Integer.parseInt(status)) {
                    long time1 = System.currentTimeMillis();
                    this.runEngineBeforeNextStep(draftPluginDto);
                    long time2 = System.currentTimeMillis();
                    StatusUtils.updateStatus(this.getTemplateType(), orgId, startdate, enddate, newFocusPage, draftpurpose);
                    long time3 = System.currentTimeMillis();
                    DraftStepsUtils.resetSteps(this.getDeclarePageMap().size(), newFocusPage, status, this.getView());
                    long time4 = System.currentTimeMillis();
                    LOGGER.info("\u5e74\u62a5\u7b2c\u4e00\u6b65\u5230\u7b2c\u4e8c\u6b65\u6267\u884c\u8017\u65f6 ========= runEngineBeforeNextStep\uff1a{}\uff0cupdateStatus\uff1a{}\uff0cresetSteps\uff1a{}\uff0ctotal\uff1a{}", new Object[]{time2 - time1, time3 - time2, time4 - time3, time4 - time1});
                }
                if ("1".equals(draftPluginDto.getAsyn()) || !this.showInnerTbPage(newFocusPage, orgId)) return;
                this.getPageCache().put(FOCUS_PAGE, newFocusPage);
                if (!"3".equals(newFocusPage)) return;
                this.markEditStatus();
                return;
            }
            finally {
                DistributeCacheHelper.remove(key);
                LOGGER.info("========================DeleteDraftCache=======,cacheKey=" + key);
            }
        } else {
            String newFocusPage = String.valueOf(Integer.parseInt(focusPage) - 1);
            if (!this.showInnerTbPage(newFocusPage, orgId)) return;
            this.getPageCache().put(FOCUS_PAGE, newFocusPage);
        }
    }

    protected void markEditStatus() {
    }

    protected void saveDraftNumber(String orgId, String startdate, String enddate, String draftpurpose, String accountorg) {
        DynamicObject dynamicObject;
        String dgType = this.getDgType();
        DynamicObject billObject = this.queryDraftBillObject(this.getTemplateType(), orgId, startdate, enddate, draftpurpose);
        if (billObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.getDraftBillName(draftpurpose));
            dynamicObject.set("billstatus", (Object)"A");
            if ("sjjt".equals(draftpurpose)) {
                dynamicObject.set(SKSSQQ, (Object)DateUtils.stringToDate(startdate));
                dynamicObject.set(SKSSQZ, (Object)DateUtils.stringToDate(enddate));
            } else {
                dynamicObject.set("startdate", (Object)DateUtils.stringToDate(startdate));
                dynamicObject.set("enddate", (Object)DateUtils.stringToDate(enddate));
            }
            dynamicObject.set(ORG_SEL, (Object)Long.valueOf(orgId));
            dynamicObject.set("templatetype", (Object)this.getTemplateType());
            dynamicObject.set("billno", this.getModel().getValue(RULE_CODE_FIELD));
            dynamicObject.set("draftpurpose", (Object)draftpurpose);
            dynamicObject.set("accountorg", (Object)Long.valueOf(accountorg));
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billObject.getLong("id"), (String)this.getDraftBillName(draftpurpose));
        }
        dynamicObject.set("type", (Object)(billObject != null && StringUtil.isNotBlank((CharSequence)billObject.getString("type")) ? billObject.getString("type") : dgType));
        dynamicObject.set("billno", this.getModel().getValue(RULE_CODE_FIELD));
        OperationResult result = OperationServiceHelper.executeOperate((String)SAVE_KEY, (String)this.getDraftBillName(draftpurpose), (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            this.getView().showOperationResult(result);
        }
        if ("sjjt".equals(draftpurpose)) {
            AccrualMQSender.sendMQ(dynamicObject);
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        String operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AbstractDraftPlugin_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u5e95\u7a3f,\u4fdd\u5b58\u6210\u529f", (String)"AbstractDraftPlugin_28", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), this.getModel().getValue(RULE_CODE_FIELD));
        OperatorDialogUtils.operateDialog(TaxNameUtil.getTaxName(appId), "tcvat_draft_page", operateName, operateDescription);
    }

    protected abstract void runEngineBeforeNextStep(DraftPluginDto var1);

    public void clientCallBack(ClientCallBackEvent e) {
        if ("savedraftstatus".equals(e.getName())) {
            String policypageid = this.getPageCache().get("declarepageid");
            String draftpurpose = this.getDraftpurpose();
            String accountorg = this.getPageCache().get("accountorg");
            DynamicObject dataEntity = this.getView().getView(policypageid).getModel().getDataEntity(true);
            OperationResult result = OperationServiceHelper.executeOperate((String)SAVE_KEY, (String)dataEntity.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
            this.getView().showOperationResult(result);
            if (result.isSuccess()) {
                StatusUtils.createStatus(this.getTemplateType(), this.getPageCache().get(ORGID_KEY), this.getPageCache().get(SKSSQQ), this.getPageCache().get(SKSSQZ), "1", draftpurpose, accountorg);
                DraftStepsUtils.resetSteps(this.getDeclarePageMap().size(), this.getPageCache().get(FOCUS_PAGE), "1", this.getView());
            }
        }
    }

    protected void initStartAndEndDate(boolean orgChange) {
        Date skssqz;
        Date skssqq;
        String taxLimit;
        String[] taxLimits = this.getTaxLimits();
        if (taxLimits.length == 0) {
            return;
        }
        switch (taxLimit = this.getTaxLimits()[0]) {
            case "year": {
                skssqq = DateUtils.getFirstDateOfYear(DateUtils.addYear(new Date(), -1));
                skssqz = DateUtils.getLastDateOfYear(skssqq);
                break;
            }
            case "halfyear": {
                skssqq = DateUtils.getFirstDateOfHalfYear(DateUtils.addMonth(new Date(), -6));
                skssqz = DateUtils.getLastDateOfHalfYear(skssqq);
                break;
            }
            case "season": {
                skssqq = DateUtils.getFirstDateOfSeason(DateUtils.addMonth(new Date(), -3));
                skssqz = DateUtils.getLastDateOfSeason(skssqq);
                break;
            }
            default: {
                skssqq = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(new Date(), -1));
                skssqz = DateUtils.getLastDateOfMonth(skssqq);
            }
        }
        if (orgChange && !StringUtil.equals((CharSequence)DateUtils.format(skssqq), (CharSequence)DateUtils.format((Date)this.getModel().getValue(SKSSQQ)))) {
            this.getPageCache().put("code_change_start", "true");
        }
        this.getModel().setValue(SKSSQQ, (Object)skssqq);
        this.getPageCache().put(SKSSQQ, DateUtils.format(skssqq));
        if (orgChange && !StringUtil.equals((CharSequence)DateUtils.format(skssqz), (CharSequence)DateUtils.format((Date)this.getModel().getValue(SKSSQZ)))) {
            this.getPageCache().put("code_change_end", "true");
        }
        this.getModel().setValue(SKSSQZ, (Object)skssqz);
        this.getPageCache().put(SKSSQZ, DateUtils.format(skssqz));
    }

    protected void loadData(Date startDate, Date endDate) {
        this.showInnerTbPage("1", this.getPageCache().get(ORGID_KEY));
    }

    protected String[] getTaxLimits() {
        return new String[]{"month"};
    }

    protected boolean beforeShowInnerTbPage(String focuspage, String orgId) {
        return true;
    }

    protected boolean doCustomInAfterCreateNewData(String orgId, String skssqq, String skssqz) {
        return true;
    }

    public abstract String getTemplateType();

    private String getDeclarePageEntity() {
        return this.declarePageMap.get(String.valueOf(this.declarePageMap.size())).getEntity();
    }

    public abstract Map<String, Object> createCustomParams(String var1, String var2, String var3, String var4, String var5);

    public abstract boolean checkBeforeNextStep(String var1, String var2, String var3, String var4, String var5);

    protected abstract DynamicObject queryDynamicObject(String var1, String var2, String var3, String var4, String var5);

    protected abstract void deleteAllDraftData(String var1, String var2, String var3, String var4);

    protected void setRuleCode() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean resetDraftNumber = (Boolean)customParams.get("refreshDraftNumber");
        String templateType = this.getTemplateType();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String startdate = this.getPageCache().get(SKSSQQ);
        String enddate = this.getPageCache().get(SKSSQZ);
        String draftpurpose = this.getDraftpurpose();
        DynamicObject draftBill = this.queryDraftBillObject(templateType, orgId, startdate, enddate, draftpurpose);
        if (!Boolean.TRUE.equals(resetDraftNumber) && EmptyCheckUtils.isNotEmpty(draftBill) && StringUtil.isNotEmpty((CharSequence)draftBill.getString("billno"))) {
            this.getModel().setValue(RULE_CODE_FIELD, draftBill.get("billno"));
        } else {
            String replaceStart = startdate.replace("-", "");
            String replaceEnd = enddate.replace("-", "");
            String cacheKey = orgId + DRAFT_NUMBER_SEPARATOR + replaceStart + DRAFT_NUMBER_SEPARATOR + replaceEnd + DRAFT_NUMBER_SEPARATOR + templateType;
            String s = this.getPageCache().get(cacheKey);
            if (StringUtil.isEmpty((CharSequence)s)) {
                String draftBillName = this.getDraftBillName();
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)draftBillName);
                String draftNumberPrefix = this.getNumberPrefix();
                if (StringUtil.isEmpty((CharSequence)draftNumberPrefix)) {
                    String format = String.format(ResManager.loadKDString((String)"%s\u6a21\u677f\u7684\u5e95\u7a3f\u7f16\u5236\u524d\u7f00\u672a\u914d\u7f6e", (String)"AbstractDraftPlugin_29", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), templateType);
                    this.getView().showErrorNotification(format);
                    return;
                }
                String readNumber = DeclareServiceHelper.generateSBBNo(draftBillName, dynamicObject, orgId);
                readNumber = this.getDraftNumber(draftpurpose, readNumber, draftNumberPrefix);
                this.getPageCache().put(cacheKey, readNumber);
                this.getModel().setValue(RULE_CODE_FIELD, (Object)readNumber);
            } else {
                this.getModel().setValue(RULE_CODE_FIELD, (Object)s);
            }
        }
    }

    private String getDraftpurpose() {
        return this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
    }

    protected String getDraftNumber(String draftpurpose, String readNumber, String draftNumberPrefix) {
        return readNumber.replaceAll("X", "sjjt".equals(draftpurpose) ? "EITACCURE" : draftNumberPrefix);
    }

    protected String getNumberPrefix() {
        return DraftConstant.getDraftNumberPrefix(this.getTemplateType());
    }

    protected DynamicObject queryDraftBillObject(String templateType, String orgId, String startdate, String enddate, String draftpurpose) {
        return StatusUtils.queryOne(templateType, orgId, startdate, enddate, draftpurpose);
    }

    protected String getDraftBillName(String draftpurpose) {
        if ("sjjt".equals(draftpurpose)) {
            return DRAFT_SJJT_ENTITY;
        }
        return DRAFT_ENTITY;
    }

    protected String getDraftBillName() {
        return DRAFT_ENTITY;
    }

    protected String getDgType() {
        String type = this.getNumberPrefix().split("-")[1];
        return type;
    }

    public void showAttachment(DynamicObject draftObject, boolean readonly) {
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        if (this.hasAttachment() && AttachmentHelper.isDraftAttachmentType(appId)) {
            String attachmentFieldName = this.getAttachmentFieldName();
            String formId = this.getView().getFormShowParameter().getFormId();
            String orgId = this.getPageCache().get(ORGID_KEY);
            if (StringUtil.isEmpty((CharSequence)orgId) || StringUtil.eqNull(orgId)) {
                return;
            }
            String visiableUpload = AttachmentHelper.queryPermissionByOrg("2NJ5SR4NUEJ=", RequestContext.get().getCurrUserId(), Long.parseLong(orgId), appId, formId);
            this.getView().setEnable(Boolean.valueOf(!Objects.equals(readonly, Boolean.TRUE) && Objects.equals("1", visiableUpload)), new String[]{attachmentFieldName});
            if (draftObject == null) {
                this.clearAttachment();
                this.getPageCache().remove(DRAFT_ID);
            } else {
                DynamicObject nsrxx;
                DynamicObjectCollection attachmentFields;
                String draftid = draftObject.getString("id");
                String lastDraftid = this.getPageCache().get(DRAFT_ID);
                if (Objects.equals(lastDraftid, draftid)) {
                    return;
                }
                this.getPageCache().put(DRAFT_ID, draftid);
                this.clearAttachment();
                ArrayList attachments = new ArrayList();
                HashMap<String, LocaleString> uidToUserNameMap = new HashMap<String, LocaleString>();
                String draftEntity = this.getDraftEntity();
                if (QueryServiceHelper.exists((String)draftEntity, (Object)Long.parseLong(draftid)) && null != (attachmentFields = (DynamicObjectCollection)(nsrxx = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(draftid), (String)draftEntity)).get("attachment")) && attachmentFields.size() > 0) {
                    Set fbasedataidIds = attachmentFields.stream().map(a -> a.get("fbasedataid_id")).collect(Collectors.toSet());
                    DynamicObjectCollection bd_attachments = QueryServiceHelper.query((String)"bd_attachment", (String)"number,name,status,creator,modifier,enable,createtime,modifytime,uid,previewurl,type,tempfile,pageid,description,url,size,sort,filesource,id", (QFilter[])new QFilter("id", "in", fbasedataidIds).toArray());
                    for (DynamicObject attachment : bd_attachments) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("type", attachment.getString("type"));
                        String url = attachment.getString("url");
                        try (InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);){
                            String tempUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attachment.getString("name"), (InputStream)new BufferedInputStream(inputStream), 3600);
                            map.put("url", tempUrl);
                            map.put("uid", attachment.getString("uid"));
                            map.put("name", attachment.getString("name"));
                            map.put("size", attachment.get("size"));
                            map.put("fattachmentpanel", "attachmentpanel");
                            map.put("entityNum", this.getView().getEntityId());
                            map.put("lastModified", attachment.getDate("modifytime"));
                            Date createtime = attachment.getDate("createtime");
                            if (createtime != null) {
                                map.put("createdate", createtime.getTime());
                                map.put("uploadTime", createtime.getTime());
                            }
                            Object creator = attachment.get("creator");
                            Map userInfoByID = UserServiceHelper.getUserInfoByID((long)((Long)creator));
                            String name = userInfoByID.getOrDefault("name", "");
                            map.put("creator", new LocaleString(name));
                            uidToUserNameMap.put(attachment.getString("uid"), new LocaleString(name));
                            map.put(STATUS, "success");
                            map.put("client", "web");
                        }
                        catch (Exception e) {
                            LOGGER.error("saveAsFullUrl errors:" + e.getMessage());
                        }
                        attachments.add(map);
                    }
                }
                if (EmptyCheckUtils.isNotEmpty(attachments)) {
                    AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(this.getAttachmentFieldName());
                    this.getPageCache().put("codeOpAtt", "1");
                    try {
                        attachmentPanel.upload(attachments);
                    }
                    catch (Exception e) {
                        LOGGER.error("upload attachments errors:" + e.getMessage());
                    }
                    this.getPageCache().remove("codeOpAtt");
                    String visible = this.getAttachmentPermission();
                    attachments.forEach(a -> {
                        a.put("creator", uidToUserNameMap.getOrDefault(a.get("uid"), new LocaleString("")));
                        a.put("visible", visible);
                    });
                    IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    clientViewProxy.invokeControlMethod(attachmentFieldName, "addAttachment", new Object[]{attachments});
                    Container panel = (Container)this.getControl(this.getAttachmentPanelName());
                    panel.setCollapse(true);
                }
            }
            this.getView().updateView(this.getAttachmentFieldName());
        }
    }

    protected String getDraftEntity() {
        return "sjjt".equals(this.getDraftpurpose()) ? DRAFT_SJJT_ENTITY : DRAFT_ENTITY;
    }

    private void clearAttachment() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(this.getAttachmentFieldName());
        this.getPageCache().put("codeOpAtt", "1");
        attachmentPanel.getAttachmentData().forEach(a -> attachmentPanel.remove(a));
        this.getPageCache().remove("codeOpAtt");
    }

    public void saveAttachment(String draftId) {
        String appId;
        if (this.hasAttachment() && AttachmentHelper.isDraftAttachmentType(appId = this.getView().getFormShowParameter().getServiceAppId())) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(this.getAttachmentFieldName());
            List attachmentData = attachmentPanel.getAttachmentData();
            String draftEntity = this.getDraftEntity();
            if (QueryServiceHelper.exists((String)draftEntity, (Object)Long.parseLong(draftId))) {
                DynamicObject nsrxx = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(draftId), (String)draftEntity);
                DynamicObjectCollection attachmentFields = nsrxx.getDynamicObjectCollection("attachment");
                try (TXHandle h = TX.requiresNew();){
                    try {
                        AttachmentHelper.updateAttachmentField(attachmentData, attachmentFields, "tctb", draftEntity, Long.parseLong(draftId));
                    }
                    catch (Exception e) {
                        h.markRollback();
                        LOGGER.error("save attachments error", (Throwable)e);
                        throw e;
                    }
                }
                OperationResult result = SaveServiceHelper.saveOperate((String)SAVE_KEY, (String)draftEntity, (DynamicObject[])new DynamicObject[]{nsrxx}, (OperateOption)OperateOption.create());
                if (!result.isSuccess()) {
                    this.getView().showErrorNotification(result.getMessage());
                }
            }
        }
    }

    private String getAttachmentPermission() {
        String orgId = this.getPageCache().get(ORGID_KEY);
        if (StringUtil.isEmpty((CharSequence)orgId) || StringUtil.eqNull(orgId)) {
            return "0000";
        }
        String attachmentVisiable = this.getPageCache().get(ATTACHMENT_VISIABLE + orgId);
        long org = Long.parseLong(orgId);
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (StringUtil.isNotEmpty((CharSequence)attachmentVisiable)) {
            return attachmentVisiable;
        }
        Long userId = RequestContext.get().getCurrUserId();
        String visiablePreview = AttachmentHelper.queryPermissionByOrg("2NJ5VA7D2ONF", userId, org, appId, formId);
        String visiableDownload = AttachmentHelper.queryPermissionByOrg("2NJ5XVVCMBCL", userId, org, appId, formId);
        String visiableRename = AttachmentHelper.queryPermissionByOrg("2NJ5W8AA040D", userId, org, appId, formId);
        String visiableDelete = AttachmentHelper.queryPermissionByOrg("2NJ5YJOIS+MJ", userId, org, appId, formId);
        attachmentVisiable = visiablePreview + visiableDownload + visiableRename + visiableDelete;
        this.getPageCache().put(ATTACHMENT_VISIABLE + orgId, attachmentVisiable);
        return attachmentVisiable;
    }

    public void afterUpload(UploadEvent evt) {
        this.updateUrls(evt.getUrls());
    }

    private void updateUrls(Object[] urls) {
        String orgId = this.getPageCache().get(ORGID_KEY);
        if (StringUtil.isEmpty((CharSequence)orgId) || StringUtil.eqNull(orgId)) {
            return;
        }
        if (EmptyCheckUtils.isNotEmpty(urls) && !this.getPageCache().getAll().containsKey("codeOpAtt")) {
            String visible = this.getAttachmentPermission();
            for (Object url : urls) {
                Map map = (Map)url;
                map.put("visible", visible);
            }
            String draftid = this.getPageCache().get(DRAFT_ID);
            if (StringUtil.isNotEmpty((CharSequence)draftid)) {
                this.saveAttachment(draftid);
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.updateUrls(evt.getUrls());
    }

    static {
        appidCategoryMap.put("tcvat", "zzs");
        appidCategoryMap.put("tccit", "qysds");
        appidCategoryMap.put("tcsd", "yhs");
        appidCategoryMap.put("tcct", "xfs");
    }
}

