/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class EngineCalcFilterService {
    public static QFilter getOrgQfilterByRelation(Map<String, List<Long>> orgRelationMap, Long cOrg, String entityId, String entitykey, String orgFieldName) {
        List<Long> cOrgs = Collections.singletonList(cOrg);
        return EngineCalcFilterService.getOrgQfilterByList(orgRelationMap, cOrgs, entityId, entitykey, orgFieldName);
    }

    public static QFilter getOrgQfilterByList(Map<String, List<Long>> orgRelationMap, List<Long> cOrgs, String entityId, String entitykey, String orgFieldName) {
        List<Long> orgListByRelation = EngineCalcFilterService.getOrgListByRelation(orgRelationMap, cOrgs, entityId, entitykey, orgFieldName);
        if (!Objects.equals(entityId, entitykey)) {
            String string = orgFieldName = orgFieldName.startsWith(entitykey + ".") ? orgFieldName : entitykey + "." + orgFieldName;
        }
        if (EmptyCheckUtils.isEmpty(orgListByRelation)) {
            return new QFilter(orgFieldName, "in", cOrgs);
        }
        if (orgListByRelation.size() == 1) {
            return new QFilter(orgFieldName, "=", (Object)orgListByRelation.get(0));
        }
        return new QFilter(orgFieldName, "in", orgListByRelation);
    }

    public static List<Long> getOrgListByRelation(Map<String, List<Long>> orgRelationMap, List<Long> cOrgs, String entityId, String entitykey, String orgFieldName) {
        String orgFun = MetadataUtil.getOrgFun(entityId, entitykey, orgFieldName);
        if (orgFun != null && orgRelationMap != null) {
            HashSet<Long> fitOrgs = new HashSet<Long>(cOrgs.size() * 2);
            for (Long cOrg : cOrgs) {
                List<Long> orgRelation = orgRelationMap.get(TaxOrgTakeRelationServiceHelper.getRelationMapKey(cOrg, orgFun));
                if (!EmptyCheckUtils.isNotEmpty(orgRelation)) continue;
                fitOrgs.addAll(orgRelation);
            }
            if (!EmptyCheckUtils.isEmpty(fitOrgs)) {
                return fitOrgs.stream().collect(Collectors.toList());
            }
        }
        return cOrgs;
    }

    public static QFilter getMappingQfilter(Long taxId, Long dataSourceId, List<Long> taxorgs, Date start, Date end) {
        Boolean isMapping;
        Map<String, Object> dataSourceMapping = EngineCalcFilterService.getMappingResult(taxId, dataSourceId, taxorgs, start, end);
        if (dataSourceMapping != null && (isMapping = (Boolean)dataSourceMapping.getOrDefault("isMapping", Boolean.FALSE)).booleanValue()) {
            String fieldkey = (String)dataSourceMapping.get("fieldkey");
            Map mappingList = (Map)dataSourceMapping.get("mappingList");
            if (EmptyCheckUtils.isNotEmpty(mappingList)) {
                ArrayList objectList = new ArrayList(8);
                mappingList.values().forEach(a -> objectList.addAll(a));
                if (!objectList.isEmpty()) {
                    return new QFilter(fieldkey, "in", objectList);
                }
            }
        }
        return null;
    }

    public static QFilter getMappingQfilter(Map<String, Object> dataSourceMapping) {
        Boolean isMapping;
        if (dataSourceMapping != null && (isMapping = (Boolean)dataSourceMapping.getOrDefault("isMapping", Boolean.FALSE)).booleanValue()) {
            String fieldkey = (String)dataSourceMapping.get("fieldkey");
            Map mappingList = (Map)dataSourceMapping.get("mappingList");
            if (EmptyCheckUtils.isNotEmpty(mappingList)) {
                ArrayList objectList = new ArrayList(8);
                mappingList.values().forEach(a -> objectList.addAll(a));
                if (!objectList.isEmpty()) {
                    return new QFilter(fieldkey, "in", objectList);
                }
            }
        }
        return null;
    }

    public static Map<String, Object> getMappingResult(Long taxId, Long dataSourceId, List<Long> taxorgs, Date start, Date end) {
        Map<String, Object> dataSourceMapping = TaxOrgTakeRelationServiceHelper.getDataSourceMappingListByTaxorg(dataSourceId, taxorgs, start, end);
        if (dataSourceMapping != null) {
            Map mappingList;
            HashMap orgMapping = new HashMap();
            Boolean isMapping = (Boolean)dataSourceMapping.getOrDefault("isMapping", Boolean.FALSE);
            if (isMapping.booleanValue() && dataSourceMapping.containsKey("mappingList") && EmptyCheckUtils.isNotEmpty(mappingList = (Map)dataSourceMapping.get("mappingList"))) {
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)dataSourceId, (String)"tctb_custom_datasource");
                String key_field = (String)dataSourceMapping.get("fieldkey");
                boolean longPk = EngineCalcFilterService.isLongPk(object, key_field);
                String business = null;
                for (Map.Entry entry : mappingList.entrySet()) {
                    Long taxOrgid = (Long)entry.getKey();
                    List taxToBaseDatalist = (List)entry.getValue();
                    if (EmptyCheckUtils.isEmpty(business)) {
                        business = (String)((Map)taxToBaseDatalist.get(0)).get("business");
                    }
                    String taxids = String.valueOf(taxId);
                    List collect = taxToBaseDatalist.stream().filter(a -> {
                        String taxcategory = (String)a.get("taxcategory");
                        String[] split = taxcategory.split(",");
                        return Arrays.asList(split).contains(taxids);
                    }).map(a -> (String)a.get("businessid")).map(a -> longPk ? Long.valueOf(Long.parseLong(a)) : a).collect(Collectors.toList());
                    orgMapping.put(taxOrgid, collect);
                }
                dataSourceMapping.put("business", business);
            }
            dataSourceMapping.put("mappingList", orgMapping);
        }
        return dataSourceMapping;
    }

    public static void checkField(DynamicObject datasource, String key_field) {
        String entityname = datasource.getString("entityname");
        if (StringUtil.isEmpty((CharSequence)entityname)) {
            throw new KDBizException("The number of datasource is empty!");
        }
        if (key_field.contains(".")) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityname);
            if (mainEntityType != null) {
                Map allEntities = mainEntityType.getAllEntities();
                Optional<DynamicObject> first = datasource.getDynamicObjectCollection("entryentity").stream().filter(a -> key_field.equals(a.getString("fieldname")) && allEntities.containsKey(a.getString("fieldsubname"))).findFirst();
                if (!first.isPresent()) {
                    throw new KDBizException(String.format("'%s' field in the '%s' does not exist!", key_field, entityname));
                }
            }
        } else {
            Optional<DynamicObject> first = datasource.getDynamicObjectCollection("entryentity").stream().filter(a -> key_field.equals(a.getString("fieldname")) && entityname.equals(a.getString("fieldsubname"))).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException(String.format("'%s' field in the '%s' does not exist!", key_field, entityname));
            }
        }
    }

    public static boolean isLongPk(DynamicObject datasource, String key_field) {
        EngineCalcFilterService.checkField(datasource, key_field);
        String entityname = datasource.getString("entityname");
        IDataEntityProperty prop = MetadataUtil.findProp(entityname, key_field);
        if (prop instanceof BasedataProp) {
            IDataEntityProperty refIdProp = ((BasedataProp)prop).getRefIdProp();
            return refIdProp instanceof LongProp;
        }
        return false;
    }
}

