/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.enums;

import kd.taxc.bdtaxr.common.util.string.StringUtil;

public enum DraftTypeEnum {
    TCVAT("tcvat", "nssb", new String[]{"draft_zzsybnsr", "draft_zzsxgmnsr", "draft_zzsybnsr_ybhz", "draft_zzsybnsr_hz_zjg", "draft_zzsybnsr_yz_zjg"}),
    TCVAT_SJJT("tcvat", "sjjt", new String[]{"draft_zzsybnsr_sjjt", "draft_zzsybnsr_ybhz_sjjt", "draft_zzsybnsr_hz_zjg_sjjt", "draft_zzsybnsr_yz_zjg_sjjt", "draft_zzsxgmnsr_sjjt"}),
    TCCIT_QYSDSNB("tccit", "qysdsnb", new String[]{"draft_qysdsnb"}),
    TCCIT_QYSDSJB("tccit", "qysdsjb", new String[]{"draft_qysdsjb"}),
    TAM("tam", null, new String[]{"draft_zzsybnsr", "draft_zzsxgmnsr", "draft_zzsybnsr_ybhz", "draft_zzsybnsr_hz_zjg", "draft_zzsybnsr_yz_zjg", "draft_qysdsnb", "draft_qysdsjb"}),
    TCCT("tcct", null, new String[]{"draft_xfs", "draft_xfsjypf"}),
    TCSD("tcsd", null, new String[]{"draft_yhs"});

    private String appId;
    private String type;
    private String[] templates;

    private DraftTypeEnum(String appId, String type, String[] templates) {
        this.appId = appId;
        this.type = type;
        this.templates = templates;
    }

    public String getAppId() {
        return this.appId;
    }

    private void setAppId(String appId) {
        this.appId = appId;
    }

    public String getType() {
        return this.type;
    }

    private void setType(String type) {
        this.type = type;
    }

    public String[] getTemplates() {
        return this.templates;
    }

    private void setTemplates(String[] templates) {
        this.templates = templates;
    }

    public static DraftTypeEnum valueOfAppId(String appId, String type) {
        for (DraftTypeEnum taxTypeEnum : DraftTypeEnum.values()) {
            String enumType = taxTypeEnum.getType();
            if (!taxTypeEnum.getAppId().equalsIgnoreCase(appId) || !StringUtil.isBlank((CharSequence)enumType) && !enumType.equalsIgnoreCase(type)) continue;
            return taxTypeEnum;
        }
        return null;
    }
}

