/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.opplugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.enums.DraftMatchDeclareEnum;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessageData;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.IStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.StatusServiceFactory;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeclareQueryListOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(DeclareQueryListOp.class);
    private List<DynamicObject> successObj = Lists.newArrayList();
    private Map<String, List<DeclareMQMessageData>> successBeforeDeleteEntryData = new HashMap<String, List<DeclareMQMessageData>>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("versiontype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if ("delete".equals(operateKey)) {
                    ExtendedDataEntity[] dataEntities;
                    for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                        DynamicObject data = dataEntity.getDataEntity();
                        if (!data.containsProperty("versiontype")) {
                            return;
                        }
                        String versiontype = data.getString("versiontype");
                        if (!"gzsb".equals(versiontype)) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u66f4\u6b63\u7533\u62a5\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DeclareQueryListOp_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            for (DynamicObject entity : this.successObj) {
                this.callElementFresh(entity, operationKey, this.successBeforeDeleteEntryData.get(entity.getString("id")));
                this.revWriteDraft(entity);
            }
            Set<Object> sbbids = this.successObj.stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
            new DeclareService().deleteRiskItem(sbbids);
            this.deleteTamEntry(sbbids);
            try {
                sbbids.stream().forEach(s -> WorkflowServiceHelper.abandonByBusienssKey((String)s.toString()));
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
            DeclareMainServiceHelper.fireModel2DeclareMainChangeEvent((DynamicObject[])e.getDataEntities(), (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operationKey));
        }
    }

    private void deleteTamEntry(Set<Object> sbbIds) {
        try {
            if (EmptyCheckUtils.isNotEmpty(sbbIds)) {
                QFilter qFilter = new QFilter("id", "in", sbbIds);
                DeleteServiceHelper.delete((String)"tam_declare_entry", (QFilter[])qFilter.toArray());
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    protected void revWriteDraft(DynamicObject entity) {
        List<String> declareTypes = Arrays.asList("qysdsjb", "qysds_hdzs_jb", "qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_nb", "zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg", "zzsyjskb", "ccxws");
        if (declareTypes.contains(entity.getString("type"))) {
            Date skssqq = entity.getDate("skssqq");
            Date skssqz = entity.getDate("skssqz");
            String declareType = entity.getString("type");
            Long orgId = entity.getDynamicObject("org").getLong("id");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"tctb_draft_main", (String)"id,isdeclare,sbbno", (QFilter[])new QFilter[]{new QFilter("startdate", "=", (Object)skssqq), new QFilter("enddate", "=", (Object)skssqz), new QFilter("org", "=", (Object)orgId), new QFilter("draftpurpose", "=", (Object)"nssb"), new QFilter("templatetype", "=", (Object)DraftMatchDeclareEnum.getDraftByDeclare(declareType))});
            if (object != null) {
                object.set("isdeclare", (Object)"0");
                object.set("sbbno", null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
    }

    private void callElementFresh(DynamicObject entity, String operationKey, List<DeclareMQMessageData> queryBeforeDeleteData) {
        try {
            Date skssqq = entity.getDate("skssqq");
            Date skssqz = entity.getDate("skssqz");
            DeclareMQSender.sendMQBeforeDelete(entity, skssqq, skssqz, DeclareMQType.DECLARE.name(), operationKey, queryBeforeDeleteData);
        }
        catch (Exception e1) {
            logger.error("\u8c03\u7528\u5143\u7d20\u5237\u65b0\u63a5\u53e3\u5931\u8d25\uff1a" + e1);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            for (DynamicObject entity : dataEntities) {
                Object pkValue = entity.getPkValue();
                try {
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"tcvat_nsrxx");
                    String templatetype = declare.getString("type");
                    this.queryBeforeDelete(pkValue.toString(), templatetype);
                    Long orgId = declare.getDynamicObject("org").getLong("id");
                    Date skssqq = declare.getDate("skssqq");
                    Date skssqz = declare.getDate("skssqz");
                    IStatusService service = StatusServiceFactory.getService(templatetype);
                    if (service != null) {
                        service.delete(orgId.toString(), DateUtils.format(skssqq), DateUtils.format(skssqz));
                    }
                    DeclareServiceHelper.deleteBySbbId(declare.getLong("id"));
                    if ("zzsybnsr".equals(templatetype) || "zzsybnsr_ybhz".equals(templatetype) || "zzsybnsr_hz_zjg".equals(templatetype)) {
                        String id = String.valueOf(pkValue);
                        QFilter q1 = new QFilter("sssbbid", "=", (Object)id);
                        QFilter q2 = new QFilter("deductionperiod", "=", (Object)"0");
                        DynamicObject[] load = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"deductionperiod,sssbbid", (QFilter[])new QFilter[]{q1, q2});
                        Arrays.stream(load).forEach(e -> e.set("sssbbid", (Object)"0"));
                        SaveServiceHelper.update((DynamicObject[])load);
                    }
                    successObjs.add(entity);
                    this.successObj.add(declare);
                }
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                    String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u7533\u62a5\u6570\u636e\u5931\u8d25\u3002", (String)"DeclareQueryListOp_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entity.getString("billno"));
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_declare_error", "", msg, ErrorLevel.Error);
                    this.operationResult.addErrorInfo((OperateErrorInfo)info);
                    this.successBeforeDeleteEntryData.remove(pkValue.toString());
                }
            }
            args.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        }
    }

    private void queryBeforeDelete(String sbbid, String templatetype) {
        if ("ccxws".equals(templatetype)) {
            QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
            DynamicObjectCollection tcretCcxwsZbTds = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"taxtype,startdate as skssqq,enddate as skssqz", (QFilter[])new QFilter[]{sbbidFilter});
            Map<String, Long> taxtypeMap = Arrays.stream(DeclareTaxType.values()).filter(a -> a.getLocalTaxName() != null && a.getBaseTaxId() != null).collect(Collectors.toMap(k -> k.getLocalTaxName(), v -> v.getBaseTaxId(), (m, n) -> m));
            ArrayList<DeclareMQMessageData> arrayList = new ArrayList<DeclareMQMessageData>();
            for (DynamicObject tcvatNsrxx : tcretCcxwsZbTds) {
                Long taxcatetory;
                if (tcvatNsrxx.getString("taxtype") == null || (taxcatetory = taxtypeMap.get(tcvatNsrxx.getString("taxtype"))) == null) continue;
                tcvatNsrxx.set("taxtype", (Object)((Object)taxcatetory).toString());
                this.fillData(sbbid, arrayList, tcvatNsrxx);
            }
            this.successBeforeDeleteEntryData.put(sbbid, arrayList);
        } else if ("qtsf_tysbb".equals(templatetype) || "qtsf_fsstysbb".equals(templatetype)) {
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(sbbid));
            DynamicObjectCollection tcvat_nsrxx = QueryServiceHelper.query((String)"totf_tysb_declare_main", (String)"entryentity.startdate as skssqq,entryentity.enddate as skssqz,entryentity.zspm as taxtype", (QFilter[])new QFilter[]{qFilter});
            ArrayList<DeclareMQMessageData> arrayList = new ArrayList<DeclareMQMessageData>();
            for (DynamicObject tcvatNsrxx : tcvat_nsrxx) {
                Long taxcatetory = ZspmEnum.getTaxcatetoryByNameAndTemplateType(tcvatNsrxx.getString("taxtype"), templatetype);
                if (taxcatetory == null) continue;
                tcvatNsrxx.set("taxtype", (Object)((Object)taxcatetory).toString());
                this.fillData(sbbid, arrayList, tcvatNsrxx);
            }
            this.successBeforeDeleteEntryData.put(sbbid, arrayList);
        }
    }

    private void fillData(String sbbid, List<DeclareMQMessageData> arrayList, DynamicObject tcvatNsrxx) {
        DeclareMQMessageData declareMQMessageData = new DeclareMQMessageData();
        declareMQMessageData.setTaxType(tcvatNsrxx.getString("taxtype"));
        declareMQMessageData.setSbbid(sbbid);
        declareMQMessageData.setSkssqq(DateUtils.format(tcvatNsrxx.getDate("skssqq")));
        declareMQMessageData.setSkssqz(DateUtils.format(tcvatNsrxx.getDate("skssqz")));
        arrayList.add(declareMQMessageData);
    }
}

