/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.ruleconfig;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.db.DynamicObjectUtils;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.enums.RuleCodeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class RuleTemplateFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String KEY_CONDITIONJSON = "conditionjson";
    private static final String ENTRY_ENTITY_KEY = "entryentity";
    private static final Map<String, String> formToBillMap = new LinkedHashMap<String, String>();
    private static final Map<String, String[]> billEntitySuffix = new LinkedHashMap<String, String[]>();
    private static final String SIM_VATINVOICE = "1163062995127970816";
    private static final String SIM_VATINVOICE_TAX = "1163062995136359510";
    private static final String SIM_VATINVOICE_ZJZT = "1835580761286481920";
    private static final String SIM_VATINVOICE_ZJZT_TAX = "1835580806685626454";
    private static final String SIM_VATINVOICE_NUMBER = "sim_vatinvoice";
    private static final String SIM_VATINVOICE_VEHICLES = "sim_vatinvoice_vehicles";
    private static final String[] addBtn = new String[]{"bar_disable", "saverule", "advconbaritemap6", "advconbaritemap7", "advconbaritemap512", "advconbaritemap3"};

    public void initialize() {
        String[] entitys = this.getBillEntitys();
        if (entitys != null) {
            for (String entitySuffix : entitys) {
                BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield" + entitySuffix);
                amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                BasedataEdit tablefield = (BasedataEdit)this.getControl("table" + entitySuffix);
                tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            BasedataEdit tablefield = (BasedataEdit)this.getControl("table12");
            tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        } else {
            List items = ((Container)this.getControl("conentpanel")).getItems();
            List<EntryGrid> allEntryGrid = this.findAllEntryGrid(items);
            for (EntryGrid entryGrid : allEntryGrid) {
                BasedataEdit tablefield;
                String entryKey = entryGrid.getEntryKey();
                String entitySuffix = entryKey.replace(ENTRY_ENTITY_KEY, "");
                BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield" + entitySuffix);
                if (amountfield != null) {
                    amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                }
                if ((tablefield = (BasedataEdit)this.getControl("table" + entitySuffix)) == null) continue;
                tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
    }

    private List<EntryGrid> findAllEntryGrid(List<Control> items) {
        ArrayList<EntryGrid> result = new ArrayList<EntryGrid>(items.size());
        for (Control item : items) {
            if (item instanceof EntryGrid) {
                result.add((EntryGrid)item);
                continue;
            }
            if (!(item instanceof Container)) continue;
            List<EntryGrid> subEntryGrid = this.findAllEntryGrid(((Container)item).getItems());
            result.addAll(subEntryGrid);
        }
        return result;
    }

    private String[] getBillEntitys() {
        String currentPage = this.getModel().getDataEntityType().getName();
        String entityName = formToBillMap.get(currentPage);
        return billEntitySuffix.get(entityName);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("org", customParams.remove("createorg"));
        customParams.remove("orgid");
        this.getView().setVisible(Boolean.FALSE, new String[]{"saverule"});
    }

    public void afterCreateNewData(EventObject e) {
        Object ruletype;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        if (orgid != null) {
            this.getModel().setValue("org", orgid);
        }
        if (null == (ruletype = customParams.get("ruletype"))) {
            this.getModel().setValue("ruletype", (Object)"private");
        } else {
            this.getModel().setValue("ruletype", ruletype);
        }
        this.initBtnStatus(customParams);
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruledetail = customParams.getOrDefault("ruledetail", "");
        if (StringUtils.isNotBlank((CharSequence)ruledetail)) {
            Boolean iscopy;
            String formId = ((BillModel)e.getSource()).getDataEntityType().getName();
            DynamicObject obj = DynamicObjectUtils.serializeToDataEntity(ruledetail, formId);
            String operateSource = customParams.getOrDefault("operateSource", "");
            if ("tpo_rule".equals(operateSource) && (iscopy = customParams.getOrDefault("iscopy", Boolean.FALSE)).booleanValue()) {
                String number = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)obj, (String)obj.getString("org.id"));
                obj.set("number", (Object)number);
                obj.set("ruletype", (Object)"private");
            }
            e.setDataEntity(obj);
        }
        this.initBtnStatus(customParams);
    }

    private void initBtnStatus(Map<String, Object> customParams) {
        String operation = (String)customParams.get("operateType");
        String ruledetail = (String)customParams.getOrDefault("ruledetail", "");
        if ("addSysRule".equals(operation)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            if ("addSysRule".equals(operation)) {
                try {
                    this.getModel().setValue("ruletype", (Object)"private");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!"addSysRule".equals(operation) && StringUtils.isNotBlank((CharSequence)ruledetail)) {
            Boolean iscopy = (Boolean)customParams.getOrDefault("iscopy", Boolean.FALSE);
            if (iscopy.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            } else {
                this.getView().setVisible(Boolean.FALSE, addBtn);
            }
        }
        if (!"addSysRule".equals(operation) && StringUtils.isBlank((CharSequence)ruledetail)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"saverule"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            if (!key.startsWith("setting") && !key.startsWith("setadvancedconf")) {
                return;
            }
            String entitySuffix = "";
            if (key.startsWith("setting")) {
                entitySuffix = key.replace("setting", "");
                EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY_KEY + entitySuffix);
                int focusRow = entryentity.getEntryState().getFocusRow();
                DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + entitySuffix, focusRow);
                if (tabletype == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateFormPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String formId = this.getView().getFormShowParameter().getFormId();
                if ("tcvat_rule_apportion".equals(formId) && "setting".equals(key) && Objects.equals(tabletype.getLong("id"), 1366529236009019392L)) {
                    args.setCancel(true);
                }
            } else if (key.startsWith("setadvancedconf")) {
                entitySuffix = key.replace("setadvancedconf", "");
                EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY_KEY + entitySuffix);
                int focusRow = entryentity.getEntryState().getFocusRow();
                DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + entitySuffix, focusRow);
                if (tabletype == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateFormPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String datatype = (String)this.getModel().getValue("datatype" + entitySuffix, focusRow);
                if (datatype.equals(DataType.ZJQS.getCode()) && "tcvat_rule_apportion".equals(this.getView().getEntityId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u884c\u7684\u53d6\u6570\u65b9\u5f0f\u7b49\u4e8e\u201d\u76f4\u63a5\u53d6\u6570\u201c\uff0c\u65e0\u9700\u914d\u7f6e\u201d\u9ad8\u7ea7\u914d\u7f6e\u201c\u3002", (String)"RuleTemplateFormPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("saverule".equals(operateKey)) {
            DynamicObject ruleObject = this.getModel().getDataEntity(true);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            RuleTemplateService.saveRule(ruleObject, customParams);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TemplatePlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (!operateKey.startsWith("setting") && !operateKey.startsWith("setadvancedconf")) {
            return;
        }
        if (args.getOperationResult().isSuccess()) {
            String entitySuffix;
            if (operateKey.startsWith("setting")) {
                entitySuffix = operateKey.replace("setting", "");
                String formId = this.getView().getFormShowParameter().getFormId();
                if ("tcvat_rule_income".equals(formId) && "setting2".equals(operateKey)) {
                    return;
                }
                EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY_KEY + entitySuffix);
                int focusRow = entryentity.getEntryState().getFocusRow();
                DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + entitySuffix, focusRow);
                if (tabletype == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateFormPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return;
                }
                if ("tcvat_rule_apportion".equals(formId) && "setting".equals(operateKey) && Objects.equals(tabletype.getLong("id"), 1366529236009019392L)) {
                    return;
                }
                String ischild = tabletype.getString("ischild");
                String entityNumber = tabletype.getString("name");
                if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                    entityNumber = tabletype.getString("subname");
                }
                this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, ENTRY_ENTITY_KEY + entitySuffix, KEY_CONDITIONJSON + entitySuffix, "setting" + entitySuffix, entitySuffix);
            } else if (operateKey.startsWith("setadvancedconf")) {
                entitySuffix = operateKey.replace("setadvancedconf", "");
                EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY_KEY + entitySuffix);
                int focusRow = entryentity.getEntryState().getFocusRow();
                DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + entitySuffix, focusRow);
                if (tabletype == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateFormPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return;
                }
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield" + entitySuffix, focusRow);
                String datatype = (String)this.getModel().getValue("datatype" + entitySuffix, focusRow);
                AdvanceConfDto advanceConfDto = new AdvanceConfDto();
                advanceConfDto.setDatatype(datatype);
                advanceConfDto.setAdvanceconfKey(operateKey);
                this.setVatrate(advanceConfDto, entitySuffix, focusRow, datatype);
                this.setEntryEntityConf(advanceConfDto, entitySuffix, focusRow, datatype);
                advanceConfDto.setTableNumber(tabletype.getString("entityname"));
                if ("tcvat_rule_income".equals(this.getView().getEntityId())) {
                    Boolean DifferenceInvoice = (Boolean)this.getModel().getValue("differenceinvoice" + entitySuffix, focusRow);
                    advanceConfDto.setDifferenceInvoice(DifferenceInvoice);
                }
                if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson" + entitySuffix)) {
                    String exratejson = (String)this.getModel().getValue("exratejson" + entitySuffix, focusRow);
                    advanceConfDto.setConvertExrateJson(exratejson);
                }
                RuleTemplateService.operationConfigClick(advanceConfDto, args, entryentity, amountfield, (Long)tabletype.getLong("id"), this.getView(), focusRow, ENTRY_ENTITY_KEY, (IFormPlugin)this);
            }
        }
    }

    public void setVatrate(AdvanceConfDto advanceConfDto, String entitySuffix, int focusRow, String datatype) {
        BigDecimal vatrate = BigDecimal.ZERO;
        if ("tcvat_rule_income".equals(this.getView().getEntityId()) && StringUtil.isEmpty((CharSequence)entitySuffix)) {
            vatrate = new BigDecimal((String)this.getModel().getValue("entryentityconfjson", focusRow));
        } else if ("tcvat_rule_refund".equals(this.getView().getEntityId()) && !StringUtil.isEmpty((CharSequence)entitySuffix)) {
            vatrate = new BigDecimal((String)this.getModel().getValue("entryentityconfjson" + entitySuffix, focusRow));
        } else if (!"1".equals(entitySuffix) && !"12".equals(entitySuffix) && (datatype.equals(DataType.HSJHSSE.getCode()) || datatype.equals(DataType.BHSJHSSE.getCode()) || datatype.equals(DataType.JSFLQS.getCode()) || datatype.equals(DataType.CYSLDSQS.getCode()) || datatype.equals(DataType.BHSJHSHSJ.getCode()))) {
            vatrate = (BigDecimal)this.getModel().getValue("vatrate" + entitySuffix, focusRow);
        }
        advanceConfDto.setVatrate(vatrate);
    }

    public void setEntryEntityConf(AdvanceConfDto advanceConfDto, String entitySuffix, int focusRow, String datatype) {
        String entryentityconf = null;
        String entryentityconfjson = null;
        if ("tcvat_rule_refund".equals(this.getView().getEntityId()) && StringUtil.isEmpty((CharSequence)entitySuffix)) {
            entryentityconf = (String)this.getModel().getValue("entryentityconf", focusRow);
            entryentityconfjson = (String)this.getModel().getValue("entryentityconfjson", focusRow);
        }
        advanceConfDto.setAdvancedconf(entryentityconf);
        advanceConfDto.setAdvancedconfjson(entryentityconfjson);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        Map filterData;
        String entitySuffix;
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if (evt.getActionId().startsWith("setting")) {
            entitySuffix = key.replace("setting", "");
            filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + entitySuffix);
                this.getModel().setValue(KEY_FILTERCONDITION + entitySuffix, filterData.get("filterdescription"), currentRowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON + entitySuffix, filterData.get("filtervalue"), currentRowIndex);
            }
        }
        if (evt.getActionId().startsWith("setadvancedconf")) {
            entitySuffix = key.replace("setadvancedconf", "");
            filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + entitySuffix);
                Object datatype = this.getModel().getValue("datatype" + entitySuffix, currentRowIndex);
                if ("tcvat_rule_income".equals(this.getView().getEntityId())) {
                    this.getModel().setValue("differenceinvoice" + entitySuffix, filterData.get("differenceinvoice"), currentRowIndex);
                }
                if ("tcvat_rule_income".equals(this.getView().getEntityId()) && StringUtil.isEmpty((CharSequence)entitySuffix) && !DataType.ZJQS.getCode().equals(datatype)) {
                    this.getModel().setValue("entryentityconfjson", filterData.get("vatrate"), currentRowIndex);
                } else if ("tcvat_rule_refund".equals(this.getView().getEntityId())) {
                    if (StringUtils.isEmpty((CharSequence)entitySuffix)) {
                        this.getModel().setValue("entryentityconf" + entitySuffix, filterData.get("advancedconf"), currentRowIndex);
                        this.getModel().setValue("entryentityconfjson" + entitySuffix, filterData.get("advancedconfjson"), currentRowIndex);
                    }
                    if (!datatype.equals(DataType.ZJQS.getCode())) {
                        this.getModel().setValue("entryentityconfjson" + entitySuffix, filterData.get("vatrate"), currentRowIndex);
                    }
                } else if (!"1".equals(entitySuffix) && !"12".equals(entitySuffix) && (datatype.equals(DataType.HSJHSSE.getCode()) || datatype.equals(DataType.BHSJHSSE.getCode()) || datatype.equals(DataType.JSFLQS.getCode()) || datatype.equals(DataType.CYSLDSQS.getCode()) || datatype.equals(DataType.BHSJHSHSJ.getCode()))) {
                    this.getModel().setValue("vatrate" + entitySuffix, filterData.get("vatrate"), currentRowIndex);
                }
                if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson" + entitySuffix)) {
                    this.getModel().setValue("exratejson" + entitySuffix, filterData.get("convert_rate_json"), currentRowIndex);
                }
            }
        }
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId, String entitySuffix) {
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION + entitySuffix));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object ruleType = this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if (null != ruleType) {
            formshowParameter.setCustomParam("ruletype", ruleType);
        }
        if (org != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        String currentPage = this.getModel().getDataEntityType().getName();
        String entityName = formToBillMap.get(currentPage);
        if (RuleTypeEnum.INCOME.getEntry().equals(entityName) && (Objects.equals(entityNumber, SIM_VATINVOICE_NUMBER) || Objects.equals(entityNumber, SIM_VATINVOICE_VEHICLES)) && Lists.newArrayList((Object[])new String[]{"1", "11"}).contains(entitySuffix)) {
            formshowParameter.setCustomParam("NO_SPECIAL", (Object)"true");
            formshowParameter.setCustomParam("NO_TAXRATE", (Object)"true");
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        if (evt.getProperty().getName().startsWith("amountfield")) {
            key = evt.getProperty().getName();
            String suffix = key.replace("amountfield", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(evt.getProperty().getParent().getName());
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + suffix, rowIndex);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateFormPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter id = new QFilter("tableid", "=", tabletype.get("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(id);
            String currentPage = this.getModel().getDataEntityType().getName();
            String entityName = formToBillMap.get(currentPage);
            if (RuleTypeEnum.REDUCE.getEntry().equals(entityName) && "tdm_balance_new".equals(tabletype.get("name"))) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
            if (RuleTypeEnum.INCOME.getEntry().equals(entityName)) {
                DynamicObject taxation = (DynamicObject)this.getModel().getValue("taxation");
                if (null != taxation && taxation.getString("number").equals("MS") && "tdm_balance_new".equals(tabletype.get("name"))) {
                    QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                    formShowParameter.getListFilterParameter().setFilter(fieldFilter);
                }
                if (Lists.newArrayList((Object[])new String[]{"11", "3", "2"}).contains(suffix)) {
                    if (Objects.equals(tabletype.get("id"), Long.valueOf(SIM_VATINVOICE))) {
                        formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)Long.parseLong(SIM_VATINVOICE_TAX)));
                    }
                    if (Objects.equals(tabletype.get("id"), Long.valueOf(SIM_VATINVOICE_ZJZT))) {
                        formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)Long.parseLong(SIM_VATINVOICE_ZJZT_TAX)));
                    }
                }
            }
        }
        if (evt.getProperty().getName().startsWith("table")) {
            String formId;
            String ruleType;
            key = evt.getProperty().getName();
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            if (StringUtil.isNotBlank((CharSequence)(ruleType = RuleCodeEnum.getRuleType(formId = this.getView().getFormShowParameter().getFormId())))) {
                QFilter filter = new QFilter("basedataid.billno", "=", (Object)ruleType);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (eventName.equals("table12") && "tcvat_rule_income".equals(formId)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("invoiceentity");
            this.getModel().setValue("invoicefiltercondition", null, rowIndex);
            this.getModel().setValue("invoiceconditionjson", null, rowIndex);
            this.getModel().setValue("amountfield12", null, rowIndex);
            this.getModel().setValue("absolute12", (Object)Boolean.FALSE, rowIndex);
            return;
        }
        if (eventName.startsWith("table")) {
            String suffix = eventName.replace("table", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + suffix);
            this.getModel().setValue("amountfield" + suffix, null, rowIndex);
            this.getModel().setValue(KEY_FILTERCONDITION + suffix, null, rowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON + suffix, null, rowIndex);
            this.getModel().setValue("absolute" + suffix, (Object)Boolean.FALSE, rowIndex);
        } else if (eventName.startsWith("amountfield")) {
            String suffix = eventName.replace("amountfield", "");
            DynamicObject changeAmount = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + suffix);
            if (changeAmount == null) {
                return;
            }
            String amountValue = changeAmount.getString("fieldname");
            String table = changeAmount.getString("fieldsubname");
            BiPredicate<String, String> tdmBalance = RuleTemplateFormPlugin.predicate("tdm_balance_new", Lists.newArrayList((Object[])new String[]{"closinglocalcurrency", "openinglocalcurrency"}));
            BiPredicate<String, String> glBalance = RuleTemplateFormPlugin.predicate("gl_balance", Lists.newArrayList((Object[])new String[]{"beginlocal", "endlocal"}));
            if (tdmBalance.test(table, amountValue) || glBalance.test(table, amountValue)) {
                this.getModel().setValue("absolute" + suffix, (Object)Boolean.TRUE, rowIndex);
            } else {
                this.getModel().setValue("absolute" + suffix, (Object)Boolean.FALSE, rowIndex);
            }
        }
    }

    private static BiPredicate<String, String> predicate(String table, List<String> columns) {
        BiPredicate<String, String> predicate = (table1, amountValue1) -> table.equals(table1) && columns.contains(amountValue1);
        return predicate;
    }

    private static List<String> getBizName() {
        return Arrays.asList(ResManager.loadKDString((String)"\u8d22\u52a1\u4e91.\u51ed\u8bc1", (String)"RuleTemplateFormPlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d22\u52a1\u4e91.\u79d1\u76ee\u4f59\u989d\u8868", (String)"RuleTemplateFormPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51ed\u8bc1\u8868", (String)"RuleTemplateFormPlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u79d1\u76ee\u4f59\u989d\u8868", (String)"RuleTemplateFormPlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }

    static {
        formToBillMap.put("tcvat_rule_income", "tcvat_rule_income");
        formToBillMap.put("tcvat_rule_apportion", "tcvat_rule_apportion");
        formToBillMap.put("tcvat_rule_apportion_inh", "tcvat_rule_apportion_inh");
        formToBillMap.put("tcret_rule_fcczzj", "tcret_rule_fcczzj");
        billEntitySuffix.put("tcvat_rule_income", new String[]{"", "1", "2", "11", "3", "12"});
        billEntitySuffix.put("tcvat_rule_apportion", new String[]{"", "1", "11", "12"});
        billEntitySuffix.put("tcvat_rule_apportion_inh", new String[]{"", "1", "11", "12"});
        billEntitySuffix.put("tcret_rule_fcczzj", new String[]{""});
    }
}

