/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.template;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.form.IPageCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.domain.Style;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.BasePointInfo;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TemplateShowUtils {
    private static Log LOGGER = LogFactory.getLog(TemplateShowUtils.class);
    public static final String SHOW_TYPE_READ = "read";
    public static final String SHOW_TYPE_EDIT = "edit";
    private static final String BASE_PATH = System.getProperty("user.home") + File.separator + "template" + File.separator;
    public static final String BUILD_ORIGIN = "origin";
    public static final String BUILD_IMPORT = "IMPORT";
    private static final String BUILD_RESULT = "RESULT";
    public static final String PARA_PAGE_ID = "{PAGE_ID}";
    private static final String CELL_TYPE_TEXT = "1";
    public static final String CELL_TYPE_CHECKBOX = "3";
    public static final String CELL_TYPE_RADIO = "4";
    public static final String CELL_TYPE_SELECT = "2";
    public static final String CELL_TYPE_BASEDATA = "5";
    private static final String CELL_TYPE_HREF = "6";
    private static final Set<String> EXCLUDE_SHEET_SET = new HashSet<String>();

    public static InputStream getbuildExcel(String buildType, Long templateId) {
        String templateHtml = TemplateShowUtils.buildExcel(buildType, templateId);
        FileInputStream in = null;
        File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)templateHtml))));
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
        }
        return in;
    }

    public static String buildExcel(String buildType, Long templateId) {
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"tpo_template_old");
        String fileName = templateId.toString();
        if (templateObject != null) {
            Date updateTime = (Date)templateObject.get("updateTime");
            if (updateTime != null) {
                fileName = fileName + DateUtils.format(updateTime, "yyyyMMddHHmmssSS");
            }
            fileName = fileName + ".xlsx";
            File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)fileName))));
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                DynamicObject typeObject = (DynamicObject)templateObject.get("type");
                String type = typeObject.getString("id");
                Map<String, FormulaVo> formulaVoMap = FormulaService.queryCellConfig(typeObject.getString("number"), templateObject.getString("startdate"), null, templateId.toString());
                Map<String, String> listTab = TemplateUtilsOld.queryEntityByTypeId(type);
                Map<String, EntityField> fieldMap = TemplateUtilsOld.getAllEntityShow(listTab);
                String jsonString = templateObject.getString("content_tag");
                TemplateShowUtils.buildExcel(buildType, jsonString, null, fieldMap, file, formulaVoMap, new HashMap<String, String>());
            }
        }
        return fileName;
    }

    public static String downResultExcel(DynamicObject templateObject, List<String> hideSheets, Map<String, String> valMap) {
        templateObject = BusinessDataServiceHelper.loadSingle((Object)templateObject.getLong("id"), (String)"tpo_template_old");
        String fileName = UUID.randomUUID().toString() + ".xlsx";
        if (templateObject != null) {
            File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)fileName))));
            file.getParentFile().mkdirs();
            DynamicObject typeObject = (DynamicObject)templateObject.get("type");
            String type = typeObject.getString("id");
            Map<String, FormulaVo> formulaVoMap = FormulaService.queryCellConfig(typeObject.getString("number"), templateObject.getString("startdate"), null, null);
            Map<String, String> listTab = TemplateUtilsOld.queryEntityByTypeId(type);
            Map<String, EntityField> fieldMap = TemplateUtilsOld.getAllEntityShow(listTab);
            String jsonString = templateObject.getString("content_tag");
            TemplateShowUtils.buildExcel(BUILD_RESULT, jsonString, hideSheets, fieldMap, file, formulaVoMap, valMap);
        }
        return fileName;
    }

    @Deprecated
    public static InputStream getDownResultExcelFile(DynamicObject template, Map<String, String> valMap) {
        String templateHtml = TemplateShowUtils.downResultExcel(template, null, valMap);
        FileInputStream in = null;
        File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)templateHtml))));
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
        }
        return in;
    }

    public static InputStream getDownResultExcelFile(DynamicObject template, List<String> hideSheets, Map<String, String> valMap) {
        String templateHtml = TemplateShowUtils.downResultExcel(template, hideSheets, valMap);
        FileInputStream in = null;
        File file = new File(FilenameUtils.normalize((String)(BASE_PATH + FilenameUtils.getName((String)templateHtml))));
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
        }
        return in;
    }

    public static Map<String, String> queryData(Long orgId, String templateTypeId, Date startdate, Date enddate) {
        return TemplateShowUtils.queryData(orgId, templateTypeId, startdate, enddate, "_");
    }

    public static Map<String, String> queryData(Long orgId, String templateTypeId, Date startdate, Date enddate, String splitStr) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (templateTypeId == null) {
            return dataMap;
        }
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingle((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getDayFirst(startdate));
        QFilter skssqzFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast(enddate));
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        Map<String, String> mainMap = TemplateUtilsOld.dataToMap(mainTable, splitStr, new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, templateFilter});
        dataMap.putAll(mainMap);
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        String mainId = mainMap.get(mainTable + splitStr + CELL_TYPE_TEXT + splitStr + "id");
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)mainId);
        if (entityList != null && !entityList.isEmpty()) {
            for (DynamicObject dobj : entityList) {
                String entityId = dobj.getString("entityid");
                if (mainTable.equals(entityId)) continue;
                Map<String, String> dMap = TemplateUtilsOld.dataToMap(entityId, splitStr, new QFilter[]{sbbIdFilter});
                dataMap.putAll(dMap);
            }
        }
        return dataMap;
    }

    public static Map<String, String> queryData(String templateTypeId, String mainPk, String splitStr) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (templateTypeId == null) {
            return dataMap;
        }
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingle((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        QFilter orgFilter = new QFilter("id", "=", (Object)Long.parseLong(mainPk));
        Map<String, String> mainMap = TemplateUtilsOld.dataToMapForExport(mainTable, splitStr, new QFilter[]{orgFilter});
        dataMap.putAll(mainMap);
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)mainPk);
        QFilter sbbIdFilter1 = new QFilter("sbbid", "=", (Object)Long.parseLong(mainPk));
        if (entityList != null && !entityList.isEmpty()) {
            for (DynamicObject dobj : entityList) {
                String entityId = dobj.getString("entityid");
                if (mainTable.equals(entityId)) continue;
                QFilter qFilter = DeclareConstant.LONG_SBBID_ENTITIES.contains(entityId) ? sbbIdFilter1 : sbbIdFilter;
                Map<String, String> dMap = TemplateUtilsOld.dataToMapForExport(entityId, splitStr, new QFilter[]{qFilter});
                dataMap.putAll(dMap);
            }
        }
        return dataMap;
    }

    public static Map<String, EntityField> queryTemplateField(Long templateId) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"tpo_template_old");
        if (templateObject != null) {
            DynamicObject typeObject = (DynamicObject)templateObject.get("type");
            String type = typeObject.getString("id");
            HashMap<String, EntityField> fieldMap = new HashMap<String, EntityField>(16);
            Map<String, String> listTab = TemplateUtilsOld.queryEntityByTypeId(type);
            for (Map.Entry<String, String> entity : listTab.entrySet()) {
                fieldMap.putAll(TemplateUtilsOld.getEntityFieldMapForAllImportCheck(entity.getKey(), "#", null));
            }
            String jsonString = templateObject.getString("content_tag");
            return TemplateShowUtils.queryTemplateField(fieldMap, jsonString);
        }
        return map;
    }

    public static Map<String, EntityField> queryTemplateField(Long templateId, String entityTemplate) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)entityTemplate);
        if (templateObject != null) {
            HashMap<String, EntityField> fieldMap = new HashMap<String, EntityField>(16);
            String jsonString = templateObject.getString("content_tag");
            return TemplateShowUtils.queryTemplateField(fieldMap, jsonString);
        }
        return map;
    }

    public static Map<String, EntityField> queryTemplateField(Map<String, EntityField> fieldMap, String jsonString) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        LinkedHashMap<String, LinkedHashMap> jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString(jsonString);
        for (Map.Entry<String, LinkedHashMap> entry : jsonMap.entrySet()) {
            if (null == entry || TemplateShowUtils.isContainsExcludeSheet(entry) || SpreadUtils.isSheetInvisible(entry)) continue;
            String sheetName = (String)entry.getValue().get("name");
            Map<Integer, List<Cell>> dataMap = SpreadUtils.getDataCell(entry, SpreadUtils.parseStyles(JSONObject.parseObject((String)jsonString)));
            for (Map.Entry<Integer, List<Cell>> data : dataMap.entrySet()) {
                for (Cell cell : data.getValue()) {
                    EntityField entityField;
                    String text = cell.getText();
                    if (StringUtils.isNotEmpty((CharSequence)text) && !text.startsWith("${")) {
                        text = "${" + text + "}";
                    }
                    if (null != text && text.endsWith("}%")) {
                        text = text.substring(0, text.length() - 1);
                    }
                    if ((entityField = fieldMap.get(text)) == null) continue;
                    if (cell.getStyle() != null) {
                        entityField.setExcelFormatter(cell.getStyle().getFormatter());
                    }
                    map.put(sheetName + "#" + cell.getRow() + "#" + cell.getCol(), entityField);
                }
            }
        }
        return map;
    }

    private static boolean isContainsExcludeSheet(Map.Entry<String, LinkedHashMap> entry) {
        boolean check = false;
        if (null != entry) {
            check = EXCLUDE_SHEET_SET.contains(entry.getKey());
        }
        return check;
    }

    public static String buildSbbHtml(List<Sheet> listSheet, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, String pageId) {
        return TemplateShowUtils.buildSbbHtml(listSheet, fieldMap, cellTypeMap, showType, pageId, true, true, Collections.emptyList());
    }

    public static String buildSbbHtml(List<Sheet> listSheet, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, String pageId, boolean needWarn, boolean needRemark, List<BasePointInfo> floatBasePointList) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, BasePointInfo> pointInfoMap = new HashMap<String, BasePointInfo>(floatBasePointList.size());
        for (BasePointInfo pointInfo : floatBasePointList) {
            pointInfoMap.put(pointInfo.getTableEntity(), pointInfo);
        }
        sb.append("<div class=\"taxDeclaration\">");
        sb.append("<div class=\"declareTable\">");
        if (needWarn) {
            sb.append(TemplateShowUtils.buildRiskEarlyWarning(pageId));
        }
        String style = "margin-top: 20px;";
        if (listSheet.size() > 1) {
            sb.append("<div class=\"_3kovUH3b\">");
            sb.append("  <div style=\"border-bottom:1px solid rgba(227, 227, 227, 0.9)\" class=\"_14gRBkXY\">");
            sb.append("    <div class=\"_9IbcKm6A\">");
            sb.append("      <div style=\"display: flex\" class=\"_2jmOZxVo\">");
            for (int i = 0; listSheet.size() > 1 && i < listSheet.size(); ++i) {
                Sheet sheet = listSheet.get(i);
                sb.append("<div style=\"display: flex;height: 24px;align-items: center;cursor: pointer;\" class=\"_39ZryrqT tab-item-hover tab-item-content theme ").append(i == 0 ? "tab-active" : "").append("\" ");
                sb.append(" id=\"tab-item-content").append(pageId).append(sheet.getId()).append('\"');
                sb.append(" pageid=\"").append(pageId).append('\"');
                sb.append(" tabid=\"").append(sheet.getId()).append("\">");
                sb.append("<span style=\"padding:0 12px;white-space: nowrap\" class=\"_11249s7w\">").append(sheet.getName()).append("<span class=\"riskCircle\"></span></span>");
                sb.append("</div>");
            }
            sb.append("      </div>");
            sb.append("    </div>");
            sb.append("  </div>");
            sb.append("  <ul class=\"_2hLXwAlh\"/>");
            sb.append("</div>");
            style = "margin-top: 10px;";
        }
        sb.append("<div class=\"tcvat-content\" style=\"height: calc(100% - 20px);").append(style).append('\"').append(" pageid=\"").append(pageId).append("\">");
        boolean show = true;
        for (Sheet sheet : listSheet) {
            if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u51cf\u514d\u7a0e\u7533\u62a5\u660e\u7ec6\u8868", (String)"TemplateShowUtils_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), (CharSequence)sheet.getName())) {
                sb.append(TemplateShowUtils.getDynamicTableHtml(sheet, show, fieldMap, cellTypeMap, showType, pageId, needRemark, pointInfoMap));
            } else {
                sb.append(TemplateShowUtils.getTableHtml(sheet, show, fieldMap, cellTypeMap, showType, pageId, needRemark));
            }
            show = false;
        }
        sb.append("</div>");
        sb.append("</div>");
        sb.append("</div>");
        return sb.toString();
    }

    public static String buildExcel(String buildType, String jsonString, List<String> hideSheets, Map<String, EntityField> fieldMap, File file, Map<String, FormulaVo> formulaVoMap, Map<String, String> valMap) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFCellStyle cellStyle = wb.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            XSSFColor color = new XSSFColor(Color.BLACK, null);
            cellStyle.setBottomBorderColor(color);
            cellStyle.setLeftBorderColor(color);
            cellStyle.setTopBorderColor(color);
            cellStyle.setRightBorderColor(color);
            LinkedHashMap<String, LinkedHashMap> jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString(jsonString);
            Iterator<Map.Entry<String, LinkedHashMap>> iterator = jsonMap.entrySet().iterator();
            TreeMap<Integer, Object> sheetMap = new TreeMap<Integer, Object>();
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            while (iterator.hasNext()) {
                Map.Entry<String, LinkedHashMap> entry = iterator.next();
                if (null == entry || TemplateShowUtils.isContainsExcludeSheet(entry) || SpreadUtils.isSheetInvisible(entry, hideSheets)) continue;
                sheetMap.put(Integer.valueOf(((LinkedHashMap)entry.getValue()).getOrDefault("index", "0").toString()), entry);
            }
            for (Map.Entry entry : sheetMap.entrySet()) {
                Map.Entry entry2 = (Map.Entry)entry.getValue();
                String name = (String)((LinkedHashMap)entry2.getValue()).get("name");
                XSSFSheet sheet = wb.createSheet(name);
                sheet.setDefaultColumnWidth(20);
                Map<Integer, List<Cell>> dataMap = SpreadUtils.getDataCell(entry2, SpreadUtils.parseStyles(jsonObject));
                List<Integer> colWidthList = SpreadUtils.parseColumns(entry2, 30);
                int index = 0;
                for (Integer n : colWidthList) {
                    int w = n * 30;
                    if (w > 65280) {
                        sheet.setColumnWidth(index++, 65280);
                        continue;
                    }
                    sheet.setColumnWidth(index++, w);
                }
                for (Map.Entry entry3 : dataMap.entrySet()) {
                    XSSFRow row = sheet.createRow(((Integer)entry3.getKey()).intValue());
                    for (Cell cell : (List)entry3.getValue()) {
                        Map<String, String> stringStringMap;
                        XSSFCell hSSFCell = row.createCell(cell.getCol());
                        String text = cell.getText();
                        if (StringUtils.isNotEmpty((CharSequence)text) && text.endsWith("%")) {
                            text = text.substring(0, text.length() - 1);
                        }
                        EntityField field = StringUtils.isNotEmpty((CharSequence)text) && text.startsWith("${") && text.endsWith("}") ? fieldMap.get(text.replace("${", "").replace("}", "")) : fieldMap.get(text);
                        hSSFCell.setCellStyle((CellStyle)TemplateShowUtils.getCellStyle(wb, field, cell.getStyle()));
                        if (field == null) {
                            hSSFCell.setCellValue(text);
                            continue;
                        }
                        if (BUILD_ORIGIN.equals(buildType)) {
                            hSSFCell.setCellValue(field.getEntityName() + "#" + field.getEwblName() + "#" + field.getFieldName());
                            continue;
                        }
                        String fieldId = field.getFieldId();
                        String[] s = field.getFieldId().split("_");
                        FormulaVo formulaVo = formulaVoMap.get(field.getEntityId() + "#" + field.getEwblxh() + "#" + s[s.length - 1]);
                        if (formulaVo != null && (CELL_TYPE_SELECT.equals(formulaVo.getCellType()) || CELL_TYPE_CHECKBOX.equals(formulaVo.getCellType()) || CELL_TYPE_RADIO.equals(formulaVo.getCellType()))) {
                            stringStringMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                            if (stringStringMap.size() > 40) {
                                TemplateShowUtils.setDropDownBox(wb, sheet.getSheetName(), stringStringMap.values().toArray(new String[0]), cell.getRow(), cell.getRow(), cell.getCol(), cell.getCol());
                            } else {
                                CellRangeAddressList regions = new CellRangeAddressList(cell.getRow(), cell.getRow(), cell.getCol(), cell.getCol());
                                DataValidationHelper helper = sheet.getDataValidationHelper();
                                DataValidationConstraint constraint = helper.createExplicitListConstraint(stringStringMap.values().toArray(new String[0]));
                                DataValidation validation = helper.createValidation(constraint, regions);
                                sheet.addValidationData(validation);
                            }
                        }
                        text = valMap.getOrDefault(fieldId, "");
                        if ("Combo".equals(field.getFieldType())) {
                            String v = "[" + valMap.getOrDefault(fieldId, "").replaceAll(",", "],[") + "]";
                            ArrayList<String> itemList = new ArrayList<String>();
                            for (ValueMapItem item : field.getComboItems()) {
                                if (!v.contains("[" + item.getValue() + "]")) continue;
                                itemList.add(item.getName().getLocaleValue());
                            }
                            text = String.join((CharSequence)",", itemList);
                        } else if (null != formulaVo && CELL_TYPE_BASEDATA.equals(formulaVo.getCellType()) && "Basedata".equals(field.getFieldType())) {
                            Map<String, String> itemMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                            if (itemMap != null) {
                                Map.Entry<String, String> cellTypeEntry = itemMap.entrySet().iterator().next();
                                String key = cellTypeEntry.getKey();
                                List<String> selectFieldList = TemplateShowUtils.parseBaseDataFieldList(cellTypeEntry.getValue());
                                DynamicObject object = QueryServiceHelper.queryOne((String)key, (String)String.join((CharSequence)",", selectFieldList), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(StringUtils.isNumeric((CharSequence)text) ? Long.parseLong(text) : 0L))});
                                text = TemplateShowUtils.getDisplayText(cellTypeEntry.getValue(), object);
                            }
                        } else if (formulaVo != null && CELL_TYPE_RADIO.equals(formulaVo.getCellType())) {
                            stringStringMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                            text = stringStringMap.get(text);
                        }
                        hSSFCell.setCellValue(text);
                    }
                }
                List<Cell> spanList = SpreadUtils.getSpanCell(entry2);
                for (Cell cell : spanList) {
                    CellRangeAddress region = new CellRangeAddress(cell.getRow(), cell.getRow() + cell.getRowCount() - 1, cell.getCol(), cell.getCol() + cell.getColCount() - 1);
                    sheet.addMergedRegion(region);
                }
            }
            try {
                FileOutputStream fout = new FileOutputStream(file);
                wb.write((OutputStream)fout);
                fout.close();
            }
            catch (Exception e) {
                LOGGER.error("\u751f\u6210\u6a21\u677f\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
        return file.getAbsolutePath();
    }

    public static void setDropDownBox(XSSFWorkbook wb, String typeName, String[] values, Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol) {
        int sheetTotal = wb.getNumberOfSheets();
        if (values != null && values.length != 0) {
            String hiddenSheetName = "hiddenSheet";
            XSSFSheet hiddenSheet = wb.getSheet(hiddenSheetName);
            if (hiddenSheet == null) {
                hiddenSheet = wb.createSheet(hiddenSheetName);
                for (int i = 0; i < values.length; ++i) {
                    XSSFRow row = hiddenSheet.createRow(i);
                    XSSFCell cell = row.createCell(0);
                    cell.setCellValue(values[i]);
                }
                wb.setSheetHidden(sheetTotal, true);
            }
            String strFormula = hiddenSheetName + "!$A$1:$A$65535";
            XSSFDataValidationConstraint constraint = new XSSFDataValidationConstraint(3, strFormula);
            CellRangeAddressList regions = new CellRangeAddressList(firstRow.intValue(), lastRow.intValue(), firstCol.intValue(), lastCol.intValue());
            XSSFDataValidationHelper help = new XSSFDataValidationHelper(hiddenSheet);
            DataValidation validation = help.createValidation((DataValidationConstraint)constraint, regions);
            XSSFSheet sheet1 = wb.getSheet(typeName);
            sheet1.addValidationData(validation);
        }
    }

    private static String buildRiskEarlyWarning(String pageId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"warn_open_").append(pageId).append("\" class=\"{{haslicense==1 ? riskwarningSize==0 && tctrcwarningsize==0 ?  \"taxRiskWarningImgNo\":\"taxRiskWarningImg\":riskwarningSize==0 ?  \"taxRiskWarningImgNo\":\"taxRiskWarningImg\"}}\" style=\"height:26px;width:26px;top:10px;\"></div>");
        sb.append("<div class=\"riskWarning\" style=\"display:none;\" id=\"taxDeclarationWarn_").append(pageId).append("\">");
        sb.append("<div style=\"background:white;position: relative;box-shadow : rgba(0, 0, 0, 0.3) 0px 1px 1px 0px;\" class=\"riskTitle\">").append("<div class=\"titleContent\" style=\" padding-left: 20px; \">").append("<div id=\"riskwarningtitle_").append(pageId).append("\" style=\" {{riskwarningSize==0?\"color:#26B175\":\"color:#FD6C6A\"}};cursor:pointer;width:170px;height:38px;float: left \" >").append(ResManager.loadKDString((String)"\u7533\u62a5\u4e8b\u9879\uff08{{riskwarningSize}}\uff09", (String)"TemplateShowUtils_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).append("</div>").append("</span>").append("</div>").append("</div>");
        sb.append("<ul id=\"riskwarningul_").append(pageId).append("\"  class=\"riskContent {{riskwarningSize==0?\"contentno\":\"\"}} \" style=\"height:270px;\" >").append("<div class=\"contentimg\"></div>").append(ResManager.loadKDString((String)"<div class=\"{{riskwarningSize==0?\"contentnotext\":\"contenthave\"}}\">\u4f18\u79c0\uff01\u6682\u65e0\u7533\u62a5\u8868\u6821\u9a8c\u98ce\u9669\uff5e</div>", (String)"TemplateShowUtils_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).append("{{each riskwarning as risk}}").append("<li id=\"riskItem").append(pageId).append("{{$index}}\">").append("<div class=\"contentTitle\" riskjump={{risk.jump}}>{{risk.title}}</div>").append("<div class=\"content\">{{risk.content}}</div><span class=\"items\">{{risk.items}}</span>").append("</li>").append("{{/each}}").append("</ul>");
        sb.append("<div style=\"{{haslicense==1?\"display:\":\"display:none\"}};box-shadow : rgba(0, 0, 0, 0.3) 0px 1px 1px 0px;background:white;position: relative;\" class=\"riskTitle\">").append("<div class=\"titleContent\" style=\" padding-left: 20px; \">").append("<div  id=\"riskwarningtctrctitle_").append(pageId).append("\" style=\" {{tctrcwarningsize==0?\"color:#26B175\":\"color:#FD6C6A\"}};cursor:pointer; width:170px;height:38px;float: left \" >").append(ResManager.loadKDString((String)"\u98ce\u63a7\u4e8b\u9879\uff08{{tctrcwarningsize}}\uff09", (String)"TemplateShowUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).append("</div>").append("<div id =\"riskwarningrecal").append(pageId).append(ResManager.loadKDString((String)"\"+ style=\"color:#5e80eb;cursor:pointer; width: 70px; height: 38px; text-align:center ; float: left; margin-left:135px;\"></div>", (String)"TemplateShowUtils_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).append("</span>").append("</div>").append("</div>");
        sb.append("<ul id=\"tctrcriskul_").append(pageId).append("\" class=\"riskContent {{tctrcwarningsize==0?\"contentno\":\"\"}} \" style=\"{{haslicense==1?\"display:\":\"display:none\"}};height:270px;\" >").append("<div class=\"contentimg\"></div>").append(ResManager.loadKDString((String)"<div class=\"{{tctrcwarningsize==0?\"contentnotext\":\"contenthave\"}}\">\u4f18\u79c0\uff01\u6682\u65e0\u98ce\u9669\u7ba1\u63a7\u9884\u8b66\uff5e</div>", (String)"TemplateShowUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).append("{{each tctrcwarning as tctrcrisk}}").append("<li id=\"tctrcriskItem").append(pageId).append("{{$index}}\">").append("<div class=\"contentTitle\" >{{tctrcrisk.tctrcriskname}}").append(ResManager.loadKDString((String)" <a tctrcresultid={{tctrcrisk.id}} style=\" text-decoration: underline;color:#0E5FD8;margin-left: 8px;cursor: pointer; \" >\u67e5\u770b\u8be6\u60c5</a> ", (String)"TemplateShowUtils_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).append("</div>").append("<div class=\"content\">{{tctrcrisk.tctrcriskdesc}}</div>").append("</li>").append("{{/each}}").append("</ul>");
        sb.append("</div>");
        return sb.toString();
    }

    private static String getTableHtml(Sheet sheet, boolean show, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, String pageId, boolean needRemark) {
        StringBuilder sb = new StringBuilder();
        List<List<Cell>> rowList = sheet.getRowList();
        if (!rowList.isEmpty()) {
            int maxWidth = 1500;
            int sumWidth = sheet.getColWidthList().stream().filter(a -> a > 0).mapToInt(Integer::intValue).sum();
            int count = (int)sheet.getColWidthList().stream().filter(a -> a > 0).count();
            int defaultWidth = -1;
            int colNum = sheet.getColNum();
            if (colNum > count) {
                defaultWidth = (maxWidth - sumWidth) / (colNum - count);
            } else {
                maxWidth = sumWidth;
            }
            sb.append("<table id=\"sbb_tab").append(pageId).append(sheet.getId()).append("\" ");
            sb.append(" pageid=\"").append(pageId).append('\"');
            sb.append(" style=\"table-layout:fixed;width=").append(maxWidth).append("px;");
            if (!show) {
                sb.append("display:none;");
            }
            sb.append("\">");
            sb.append("<thead><tr style=\"visibility: hidden;\" mce_style=\"display:none\">");
            for (int i = 0; i < colNum; ++i) {
                Integer width = defaultWidth;
                if (sheet.getColWidthList().size() >= i + 1) {
                    width = sheet.getColWidthList().get(i);
                }
                sb.append("<th");
                if (width > 0) {
                    sb.append("  style=\"width: ").append(width).append("px;\"");
                }
                sb.append('>');
                sb.append("<div style=\"width:").append(width).append("px;height:1px;\">&nbsp;</div>");
                sb.append("</th>");
            }
            sb.append("</tr></thead>");
            for (List<Cell> cellList : rowList) {
                if (cellList.size() == 1 && cellList.get(0).getColCount() == colNum) {
                    Cell cell1 = cellList.get(0);
                    sb.append("<tr style=\"height:40px;");
                    sb.append("\">");
                    TemplateShowUtils.createTd(sb, sheet, cell1, fieldMap, cellTypeMap, showType, needRemark);
                    sb.append("</tr>");
                    int placeHolderRow = cell1.getRowCount() - 1;
                    for (int i = 0; i < placeHolderRow; ++i) {
                        sb.append("<tr style=\"height:40px;\"></tr>");
                    }
                    continue;
                }
                sb.append("<tr style=\"height:40px;");
                sb.append("\">");
                for (Cell cell : cellList) {
                    TemplateShowUtils.createTd(sb, sheet, cell, fieldMap, cellTypeMap, showType, needRemark);
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
        }
        return sb.toString();
    }

    public static void createTd(StringBuilder sb, Sheet sheet, Cell cell, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, boolean needRemark) {
        EntityField entityField = fieldMap.get(StringUtil.getMatchContent(cell.getText()));
        sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
        Style style = cell.getStyle();
        boolean locked = false;
        if (style != null) {
            if (style.gethAlign() != null) {
                if (0 == style.gethAlign()) {
                    sb.append(" align=\"left\"");
                }
                if (1 == style.gethAlign()) {
                    sb.append(" align=\"center\"");
                }
                if (2 == style.gethAlign()) {
                    sb.append(" align=\"right\"");
                }
            }
            if (style.getLocked() != null && style.getLocked().booleanValue()) {
                locked = true;
            }
        }
        if (entityField != null) {
            sb.append(" id=\"td_").append(entityField.getFieldId()).append('\"');
            sb.append(" sheetid=\"").append(sheet.getId()).append('\"');
        }
        sb.append('>');
        sb.append(TemplateShowUtils.getCellHtml(sheet.getId(), cell, fieldMap, cellTypeMap, showType, locked, needRemark));
        sb.append("</td>");
    }

    private static String getDynamicTableHtml(Sheet sheet, boolean show, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, String pageId, boolean needRemark, Map<String, BasePointInfo> pointInfoMap) {
        StringBuilder sb = new StringBuilder();
        List<List<Cell>> rowList = sheet.getRowList();
        if (!rowList.isEmpty()) {
            int maxWidth = 1500;
            int sumWidth = sheet.getColWidthList().stream().filter(a -> a > 0).mapToInt(Integer::intValue).sum();
            int count = (int)sheet.getColWidthList().stream().filter(a -> a > 0).count();
            int defaultWidth = -1;
            if (sheet.getColNum() > count) {
                defaultWidth = (maxWidth - sumWidth) / (sheet.getColNum() - count);
            } else {
                maxWidth = sumWidth;
            }
            sb.append("<table id=\"sbb_tab").append(pageId).append(sheet.getId()).append("\" ");
            sb.append(" pageid=\"").append(pageId).append('\"');
            sb.append(" style=\"table-layout:fixed;width=").append(maxWidth).append("px;");
            if (!show) {
                sb.append("display:none;");
            }
            sb.append("\">");
            sb.append("<thead><tr style=\"visibility: hidden;\" mce_style=\"display:none\">");
            for (int i = 0; i < sheet.getColNum(); ++i) {
                Integer width = defaultWidth;
                if (sheet.getColWidthList().size() >= i + 1) {
                    width = sheet.getColWidthList().get(i);
                }
                sb.append("<th");
                if (width > 0) {
                    sb.append("  style=\"width: ").append(width).append("px;\"");
                }
                sb.append('>');
                sb.append("<div style=\"width:").append(width).append("px;height:1px;\">&nbsp;</div>");
                sb.append("</th>");
            }
            sb.append("</tr></thead>");
            for (List<Cell> cellList : rowList) {
                sb.append("<tr style=\"height:40px;\"operation=\"dynamic");
                sb.append("\">");
                boolean addFlag = false;
                boolean addAndDeleteFlag = false;
                for (Cell cell : cellList) {
                    EntityField entityField = fieldMap.get(StringUtil.getMatchContent(cell.getText()));
                    if (null == entityField) {
                        sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
                    } else {
                        String fieldId = cell.getText().replace("${", "").replace("}", "");
                        String[] split = fieldId.split("#");
                        String rowIndex = split[1];
                        if (pointInfoMap.containsKey(split[0])) {
                            if (CELL_TYPE_TEXT.equals(rowIndex)) {
                                sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
                            } else if (CELL_TYPE_SELECT.equals(rowIndex)) {
                                if (!addFlag) {
                                    sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"').append("\"operate=\"add\"");
                                } else {
                                    sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
                                }
                                addFlag = true;
                            } else {
                                if (!addAndDeleteFlag) {
                                    sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"').append("\"operate=\"addanddelete\"");
                                } else {
                                    sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
                                }
                                addAndDeleteFlag = true;
                            }
                        } else {
                            sb.append("<td colspan=\"").append(cell.getColCount()).append("\" rowspan=\"").append(cell.getRowCount()).append('\"');
                        }
                    }
                    Style style = cell.getStyle();
                    boolean locked = false;
                    if (style != null) {
                        if (style.gethAlign() != null) {
                            if (0 == style.gethAlign()) {
                                sb.append(" align=\"left\"");
                            }
                            if (1 == style.gethAlign()) {
                                sb.append(" align=\"center\"");
                            }
                            if (2 == style.gethAlign()) {
                                sb.append(" align=\"right\"");
                            }
                        }
                        if (style.getLocked() != null && style.getLocked().booleanValue()) {
                            locked = true;
                        }
                    }
                    if (entityField != null) {
                        sb.append(" id=\"td_").append(entityField.getFieldId()).append('\"');
                        sb.append(" sheetid=\"").append(sheet.getId()).append('\"');
                    }
                    sb.append('>');
                    sb.append(TemplateShowUtils.getCellHtml(sheet.getId(), cell, fieldMap, cellTypeMap, showType, locked, needRemark));
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
        }
        return sb.toString();
    }

    private static String getCellHtml(String sheetId, Cell cell, Map<String, EntityField> fieldMap, Map<String, FormulaVo> cellTypeMap, String showType, boolean locked, boolean needRemark) {
        String text = cell.getText();
        if (StringUtils.isEmpty((CharSequence)text)) {
            return TemplateShowUtils.toNbsp(cell.getText());
        }
        ArrayList<String> fieldKeyList = new ArrayList<String>();
        if (text.contains("${")) {
            String[] str;
            for (String s : str = text.split("\\$\\{")) {
                String key;
                int index = s.indexOf(125);
                if (index <= 0 || !fieldMap.containsKey(key = s.substring(0, index))) continue;
                fieldKeyList.add(key);
            }
        } else if (fieldMap.containsKey(text)) {
            fieldKeyList.add(text);
        }
        if (fieldKeyList.isEmpty()) {
            return TemplateShowUtils.toNbsp(cell.getText());
        }
        boolean readOnly = !SHOW_TYPE_EDIT.equals(showType) || locked;
        Map<Object, Object> itemMap = new LinkedHashMap();
        for (String fieldKey : fieldKeyList) {
            StringBuilder sb = new StringBuilder();
            EntityField entityField = fieldMap.get(fieldKey);
            if (!SHOW_TYPE_EDIT.equals(showType)) {
                sb.append("<div class=\"tcvat-read-cell\" style=\"display:inline\" id=\"read_").append(entityField.getFieldId()).append("\">");
            }
            FormulaVo formulaVo = cellTypeMap.get(fieldKey);
            String celltype = CELL_TYPE_TEXT;
            String title = " title=\"{{" + entityField.getFieldId() + "}}\" ";
            if (formulaVo != null) {
                celltype = formulaVo.getCellType();
                try {
                    itemMap = TemplateShowUtils.parseCellType(formulaVo.getFormulaName());
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5355\u5143\u683c\u683c\u5f0f\u914d\u7f6e\u9519\u8bef[%2$s]", (String)"TemplateShowUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), formulaVo.getFormulaKey(), formulaVo.getFormulaName()), e);
                }
            }
            if (CELL_TYPE_CHECKBOX.equals(celltype) || CELL_TYPE_RADIO.equals(celltype)) {
                sb.append("<div class=\"tcvat-combo\" style=\"display:inline\" ").append(title);
                sb.append(" id=\"checkbox").append(entityField.getFieldId()).append("\">");
                for (Map.Entry<Object, Object> item : itemMap.entrySet()) {
                    if (StringUtil.isBlank((CharSequence)((CharSequence)item.getKey()))) continue;
                    sb.append("<input type=\"checkbox\" ");
                    sb.append(" cellid=\"").append(entityField.getFieldId()).append('\"');
                    sb.append(" value=\"").append((String)item.getKey()).append('\"');
                    sb.append(" radio=\"").append(CELL_TYPE_RADIO.equals(celltype)).append('\"');
                    sb.append(" {{ if ").append(entityField.getFieldId()).append((String)item.getKey()).append(" !=null  }}");
                    sb.append(" checked");
                    sb.append(" {{ /if }}");
                    if (readOnly) {
                        sb.append(" disabled=\"true\"");
                    }
                    sb.append("/>");
                    sb.append("<span>").append((String)item.getValue()).append("</span>");
                }
                sb.append("</div>");
            } else if (CELL_TYPE_SELECT.equals(celltype)) {
                sb.append("<div class=\"tcvat-select\" style=\"display:inline\" ").append(title);
                sb.append(" id=\"select").append(entityField.getFieldId()).append("\">");
                sb.append("<select style=\"width:100%;\" cellid=\"").append(entityField.getFieldId()).append('\"');
                if (readOnly) {
                    sb.append(" disabled=\"true\"");
                }
                sb.append('>');
                for (Map.Entry<Object, Object> item : itemMap.entrySet()) {
                    sb.append("<option value=\"").append((String)item.getKey()).append('\"');
                    sb.append(" {{ if ").append(entityField.getFieldId()).append("=='").append((String)item.getKey()).append("' }}");
                    sb.append(" selected='selected'");
                    sb.append(" {{ /if }}");
                    sb.append(" >");
                    sb.append((String)item.getValue());
                    sb.append("</option>");
                }
                sb.append("</select>");
                sb.append("</div>");
            } else if (CELL_TYPE_HREF.equals(celltype)) {
                sb.append("<div class=\"tcvat-href\"  style=\"display:inline\" ").append(title).append(">");
                sb.append("<a href=\"javascript:void(0);\"");
                sb.append(" cellid=\"").append(entityField.getFieldId()).append("\" ");
                if (itemMap != null && itemMap.entrySet().iterator().hasNext()) {
                    Map.Entry<Object, Object> cellTypeEntry = itemMap.entrySet().iterator().next();
                    sb.append(" hreftype=\"").append((String)cellTypeEntry.getKey()).append("\" ");
                    sb.append(" hrefpara='").append((String)cellTypeEntry.getValue()).append("' ");
                }
                sb.append('>');
                sb.append("{{").append(entityField.getFieldId()).append("}}</a>");
                sb.append("</div>");
            } else if (CELL_TYPE_BASEDATA.equals(celltype)) {
                sb.append("<div class=\"tcvat-base\" style=\"display:inline\" ").append(title);
                sb.append("style=\"width:100%;position: relative;\">");
                String baseId = null;
                String basetext = null;
                for (Map.Entry<Object, Object> item : itemMap.entrySet()) {
                    baseId = (String)item.getKey();
                    basetext = (String)item.getValue();
                }
                if (readOnly) {
                    sb.append("{{").append(entityField.getFieldId()).append("_text}}");
                } else {
                    sb.append(" <input class=\"tcvat-read-input-base\" type=\"text\" ");
                    sb.append(" cellid=\"").append(entityField.getFieldId()).append('\"');
                    sb.append(" value=\"").append("{{").append(entityField.getFieldId()).append("_text}}").append('\"');
                    sb.append(" />");
                    sb.append(" <i class=\"tcvat-icon-base\"");
                    sb.append(" cellid=\"").append(entityField.getFieldId()).append('\"');
                    sb.append(" baseEntityId=\"").append(baseId).append('\"');
                    sb.append(" displayProp=\"").append(basetext).append('\"');
                    sb.append(" ></i>");
                }
                sb.append("</div>");
            } else {
                sb.append("<div class=\"tcvat-bor\" style=\"display:inline\" ").append(title).append('>');
                if (readOnly) {
                    sb.append("{{").append(entityField.getFieldId()).append("}}");
                } else {
                    if (locked) {
                        sb.append("<div style=\"width:100%;");
                        sb.append(" cellid=\"").append(entityField.getFieldId()).append("\" ");
                        sb.append(" sheetid=\"").append(sheetId).append("\" ");
                        sb.append(" >{{").append(entityField.getFieldId()).append("}}</div> ");
                    } else {
                        sb.append("<input type=\"text\" style=\"width:100%;\" ");
                        if ("Decimal".equals(entityField.getFieldType())) {
                            sb.append(" oninput =\"value=value.replace(/[^\\d.-]/g,'')\"");
                        }
                        sb.append(" cellid=\"").append(entityField.getFieldId()).append("\" ");
                        sb.append(" sheetid=\"").append(sheetId).append("\" ");
                        sb.append(" value=\"{{").append(entityField.getFieldId()).append("}}\" /> ");
                    }
                    if (needRemark) {
                        sb.append("<a href=\"javascript:void(0);\" class=\"remarkClass\" style=\"display:none\"");
                        sb.append(" cellid=\"").append(entityField.getFieldId()).append("\" id=\"remark_").append(entityField.getFieldId()).append(ResManager.loadKDString((String)"\">\u6dfb\u52a0\u4fee\u6539\u5907\u6ce8</a>", (String)"TemplateShowUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    }
                }
                sb.append("</div>");
            }
            if (!SHOW_TYPE_EDIT.equals(showType)) {
                sb.append("<i class=\"tcvat-icon\"");
                sb.append("  id=\"icon_").append(entityField.getFieldId()).append('\"');
                sb.append("  cellid=\"").append(entityField.getFieldId()).append("\"></i>");
                sb.append("</div>");
            }
            text = text.contains("${" + fieldKey + "}") ? text.replace("${" + fieldKey + "}", sb.toString()) : text.replace(fieldKey, sb.toString());
            if (null == itemMap) continue;
            itemMap.clear();
        }
        text = "<div class=\"tcvat-cell\">" + text + "</div>";
        return text;
    }

    private static XSSFCellStyle getCellStyle(XSSFWorkbook wb, EntityField field, Style style) {
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        XSSFColor color = new XSSFColor(Color.BLACK, null);
        cellStyle.setBottomBorderColor(color);
        cellStyle.setLeftBorderColor(color);
        cellStyle.setTopBorderColor(color);
        cellStyle.setRightBorderColor(color);
        XSSFDataFormat fmt = wb.createDataFormat();
        cellStyle.setDataFormat(fmt.getFormat("TEXT"));
        if (field != null) {
            if ("Text".equals(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            } else if ("Date".equals(field.getFieldType())) {
                cellStyle.setDataFormat(fmt.getFormat("TEXT"));
            } else if ("Decimal".equals(field.getFieldType())) {
                if (field.getScale() < 1) {
                    cellStyle.setDataFormat(fmt.getFormat("0"));
                } else {
                    cellStyle.setDataFormat(fmt.getFormat("0.00"));
                }
            }
        }
        if (style != null && "@".equals(style.getFormatter())) {
            cellStyle.setDataFormat(fmt.getFormat("TEXT"));
        }
        if (style != null) {
            if (style.gethAlign() != null) {
                switch (style.gethAlign()) {
                    case 0: {
                        cellStyle.setAlignment(HorizontalAlignment.LEFT);
                        break;
                    }
                    case 1: {
                        cellStyle.setAlignment(HorizontalAlignment.CENTER);
                        break;
                    }
                    case 2: {
                        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                        break;
                    }
                    default: {
                        TemplateShowUtils.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 1);
                    }
                }
            }
            if (style.getvAlign() != null) {
                cellStyle.setVerticalAlignment(VerticalAlignment.forInt((int)style.getvAlign()));
            }
        } else {
            TemplateShowUtils.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 1);
            TemplateShowUtils.setCellDefaultAlignmentByFieldType(cellStyle, null, field, 2);
        }
        return cellStyle;
    }

    private static String toNbsp(String str) {
        if (str == null) {
            return "&nbsp;";
        }
        if (str.contains(ResManager.loadKDString((String)"18\uff08\u598217&lt;11\uff0c\u5219\u4e3a17\uff0c\u5426\u5219\u4e3a11\uff09", (String)"TemplateShowUtils_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]))) {
            return str;
        }
        return StringEscapeUtils.escapeHtml((String)str);
    }

    public static Map<String, String> parseCellType(String json) {
        LinkedHashMap<String, String> itemMap = new LinkedHashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            Object jsonObject = JSONObject.parse((String)json);
            if (jsonObject instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)jsonObject;
                for (int i = 0; i < jSONArray.size(); ++i) {
                    JSONObject jon = (JSONObject)jSONArray.get(i);
                    itemMap.put(jon.getString("val"), jon.getString("text"));
                }
            } else if (jsonObject instanceof JSONObject) {
                JSONObject jon = (JSONObject)jsonObject;
                itemMap.put(jon.getString("val"), jon.getString("text"));
            }
        }
        return itemMap;
    }

    public static List<String> parseBaseDataFieldList(String basetext) {
        ArrayList<String> selectFieldList = new ArrayList<String>();
        selectFieldList.add("id");
        if (basetext.contains("{")) {
            String[] str;
            for (String s : str = basetext.split("\\{")) {
                String selectField;
                int index = s.indexOf(125);
                if (index <= 0 || selectFieldList.contains(selectField = s.substring(0, index))) continue;
                selectFieldList.add(selectField);
            }
        }
        return selectFieldList;
    }

    public static Map<String, Object> convertMap(Map<String, String> valueMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(valueMap)) {
            for (Map.Entry<String, String> entry : valueMap.entrySet()) {
                resultMap.put(entry.getKey(), entry.getValue());
            }
        }
        return resultMap;
    }

    public static String getBaseDataDisplayText(String value, String formulaName, Map<String, String> businessMap) {
        Map<String, String> formulaMap = TemplateShowUtils.parseCellTypeMap(formulaName);
        if (!formulaMap.isEmpty()) {
            String fieldName = formulaMap.get("text");
            String tableName = formulaMap.get("val");
            String language = TemplateShowUtils.getLanguage(businessMap, formulaMap);
            List<String> selectFieldList = TemplateShowUtils.parseBaseDataFieldList(fieldName);
            List idList = Stream.of(value.split("\u3001")).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).map(v -> Long.parseLong(v)).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", idList);
            DynamicObjectCollection resultCollection = TemplateShowUtils.queryData(tableName, String.join((CharSequence)",", selectFieldList), new QFilter[]{qFilter}, language);
            return resultCollection.stream().map(result -> TemplateShowUtils.getDisplayText(fieldName, result)).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).collect(Collectors.joining("\u3001"));
        }
        return null;
    }

    public static DynamicObjectCollection queryData(String tableName, String selectFields, QFilter[] qFilters, String language) {
        DynamicObjectCollection objectList = null;
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            ORM orm = ORM.create();
            Lang lang = Lang.from((String)language);
            orm.hint().setLang(lang);
            objectList = orm.query(tableName, selectFields, qFilters);
        } else {
            objectList = QueryServiceHelper.query((String)tableName, (String)selectFields, (QFilter[])qFilters);
        }
        return objectList;
    }

    public static Map<String, String> parseCellTypeMap(String json) {
        LinkedHashMap<String, String> itemMap = new LinkedHashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            Object jsonObject = JSONObject.parse((String)json);
            if (jsonObject instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)jsonObject;
                for (int i = 0; i < jSONArray.size(); ++i) {
                    JSONObject jon = (JSONObject)jSONArray.get(i);
                    itemMap.put("val", jon.getString("val"));
                    itemMap.put("text", jon.getString("text"));
                    String version = jon.getString("version");
                    itemMap.put("version", StringUtil.isBlank((CharSequence)version) ? "" : version);
                    String multiSelect = jon.getString("multiselect");
                    itemMap.put("multiselect", StringUtil.isBlank((CharSequence)multiSelect) ? "" : multiSelect);
                    String language = jon.getString("language");
                    itemMap.put("language", StringUtil.isBlank((CharSequence)language) ? "" : language);
                }
            } else if (jsonObject instanceof JSONObject) {
                JSONObject jon = (JSONObject)jsonObject;
                itemMap.put("val", jon.getString("val"));
                itemMap.put("text", jon.getString("text"));
                itemMap.put("version", jon.getString("version"));
                String multiSelect = jon.getString("multiselect");
                itemMap.put("multiselect", StringUtil.isBlank((CharSequence)multiSelect) ? "" : multiSelect);
                String language = jon.getString("language");
                itemMap.put("language", StringUtil.isBlank((CharSequence)language) ? "" : language);
            }
        }
        return itemMap;
    }

    public static String getLanguage(Map<String, String> businessMap, Map<String, String> itemMap) {
        String language = null;
        if (businessMap != null) {
            language = businessMap.get("language");
        }
        if (StringUtil.isEmpty(language) && itemMap != null) {
            language = itemMap.get("language");
        }
        return language;
    }

    public static List<Long> getBaseDataIdList(String value) {
        return Stream.of(value.split("\u3001")).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).map(v -> Long.parseLong(v)).collect(Collectors.toList());
    }

    public static String getDisplayText(String display, DynamicObject result) {
        if (result == null) {
            return "";
        }
        String displayEmpty = display;
        IDataEntityType objType = result.getDataEntityType();
        DataEntityPropertyCollection propertyCollection = objType.getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            if (null == property || StringUtil.isBlank((CharSequence)result.getString(property.getName()))) continue;
            display = display.replace("{" + property.getName() + "}", result.getString(property.getName()));
            displayEmpty = displayEmpty.replace("{" + property.getName() + "}", "");
        }
        if (StringUtil.isNotBlank((CharSequence)display) && !display.equals(displayEmpty)) {
            return display;
        }
        return "";
    }

    private static void setCellDefaultAlignmentByFieldType(XSSFCellStyle cellStyle, Style style, EntityField fieldType, int alignmentType) {
        if (cellStyle != null) {
            if (fieldType != null) {
                if (1 == alignmentType) {
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                }
                if (2 == alignmentType) {
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                }
            } else {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            }
        }
        if (style != null) {
            if (fieldType != null) {
                if (1 == alignmentType) {
                    if ("Decimal".equals(fieldType.getFieldType())) {
                        style.sethAlign(2);
                    } else {
                        style.sethAlign(1);
                    }
                }
                if (2 == alignmentType) {
                    style.setvAlign(1);
                }
            } else {
                style.sethAlign(1);
                style.setvAlign(1);
            }
        }
    }

    public static String replaceJson(String type, String json, IPageCache pageCache, boolean keyToValue) {
        if (!StringUtils.isEmpty((CharSequence)json)) {
            Map<String, String> colsMap = TemplateShowUtils.getColsMap(type, json, pageCache);
            Set<Map.Entry<String, String>> entry = colsMap.entrySet();
            for (Map.Entry<String, String> ent : entry) {
                if (keyToValue) {
                    json = json.replace("${" + ent.getKey() + "}", "${" + ent.getValue() + "}");
                    continue;
                }
                json = json.replace("${" + ent.getValue() + "}", "${" + ent.getKey() + "}");
            }
            return json;
        }
        return "";
    }

    private static Map<String, String> getColsMap(String type, String templateJson, IPageCache pageCache) {
        Map<String, String> colsMap = TreeUtils.getCache(pageCache, type + "allField", Map.class);
        if (colsMap != null) {
            return colsMap;
        }
        if (type != null) {
            Map<String, String> listTab = SpreadUtils.getMetadataNumberMap(SpreadUtils.getSheets(templateJson, null));
            colsMap = TemplateUtilsOld.getAllEntityFieldMap(listTab);
            TreeUtils.putCache(pageCache, type + "allField", colsMap);
            return colsMap;
        }
        return new HashMap<String, String>();
    }

    static {
        EXCLUDE_SHEET_SET.add(ResManager.loadKDString((String)"\u540d\u518c\u4fe1\u606f\u8868", (String)"TemplateShowUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }
}

