/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxdeclare.template;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.LocalMemoryCacheHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TemplateUtilsOld {
    public static final String EWBLXH = "ewblxh";
    public static final String SPLIT_STRING_SAVE = "#";
    public static final String SPLIT_STRING_SHOW = "_";
    public static final int TAXRATE_EXPANDED_TIMES = 100;
    public static final BigDecimal DEFAULT_VALUE = new BigDecimal("0.00");
    public static final BigDecimal COMPARE_STANDARD_VALUE = new BigDecimal("1.00");
    public static final Pattern FIELDNAME_Pattern = Pattern.compile("[\\[\\]()\uff08\uff09\"\u201c\u201d/]");
    public static final String DEFAULT_DECIMAL_FORMAT = "#####0.00";
    public static final String DECIMAL_INIT_FORMAT = "#####0";
    public static final String MICROMETER_DECIMAL_INIT_FORMAT = "###,##0";
    public static final int GET_TEMPLATE_MODEL_START = 1;
    public static final int GET_TEMPLATE_MODEL_END = 0;
    private static final Set<String> BASE_FIELD_LAST = new HashSet<String>();
    private static final String TCVAT_NSRXX_EWBLXH = "tcvat_nsrxx#1#ewblxh";
    private static final String TCVAT_NSRXX_MODIFYTIME = "tcvat_nsrxx#1#modifytime";
    private static final String TCVAT_NSRXX_MODIFIER = "tcvat_nsrxx#1#modifier";
    private static final String TCVAT_NSRXX_BQYBTSE = "tcvat_nsrxx#1#bqybtse";
    private static final String TCVAT_SB_FJSF_BQYBSE = "tcvat_sb_fjsf#9#bqybse";

    public static Set<String> getBaseFieldLast() {
        return BASE_FIELD_LAST;
    }

    public static Map<String, String> queryEntityByTypeId(String typeId) {
        String key;
        LocalMemoryCache cache = LocalMemoryCacheHelper.getLocalCache("tctb");
        LinkedHashMap<String, String> typeMap = (LinkedHashMap<String, String>)cache.get(key = "tpo_template_type" + typeId);
        if (null == typeMap) {
            typeMap = new LinkedHashMap<String, String>();
            String fields = "entryentity.entityid as entityid,entryentity.entityname as entityname ";
            QFilter filter = new QFilter("id", "=", (Object)typeId);
            DynamicObjectCollection entityList = QueryServiceHelper.query((String)"tpo_template_type", (String)fields, (QFilter[])new QFilter[]{filter}, (String)"entryentity.seq");
            if (entityList != null && !entityList.isEmpty()) {
                for (DynamicObject dobj : entityList) {
                    if (!StringUtil.isNotEmpty((CharSequence)dobj.getString("entityid"))) continue;
                    typeMap.put(dobj.getString("entityid"), dobj.getString("entityname"));
                }
            }
        }
        cache.put(key, typeMap);
        return typeMap;
    }

    public static String getMainTableByTemplateId(Long templateId) {
        DynamicObject dobj;
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"tpo_template_old");
        if (templateObject != null && (dobj = (DynamicObject)templateObject.get("type")) != null) {
            return dobj.getString("maintable");
        }
        return null;
    }

    public static String getMainTable(String type) {
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingle((Object)type, (String)"tpo_template_type");
        if (templateObject != null) {
            return templateObject.getString("maintable");
        }
        return null;
    }

    public static Map<String, String> dataToMap(String entityId, String spitStr, QFilter[] filters) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        String allFieldToQuery = MetadataUtil.getAllFieldToQuery(entityId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)allFieldToQuery, (QFilter[])filters);
        if (collection == null || collection.isEmpty()) {
            return dataMap;
        }
        for (DynamicObject dObject : collection) {
            String ewbxh = dObject.getString(EWBLXH);
            for (EntityField field : entityInfo.getFieldList()) {
                if (!dObject.containsProperty(field.getFieldId())) continue;
                Object obj = dObject.get(field.getFieldId());
                String key = entityId + spitStr + ewbxh + spitStr + field.getFieldId();
                if (obj == null) continue;
                dataMap.put(key, TemplateUtilsOld.dataFormatPreSave(obj, field));
            }
        }
        return dataMap;
    }

    public static Map<String, String> dataToMapForExport(String entityId, String spitStr, QFilter[] filters) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        String allFieldToQuery = MetadataUtil.getAllFieldToQuery(entityId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)allFieldToQuery, (QFilter[])filters);
        if (collection == null || collection.isEmpty()) {
            return dataMap;
        }
        String[] split = allFieldToQuery.split(",");
        Map<String, EntityField> map = entityInfo.getFieldList().stream().collect(Collectors.groupingBy(a -> a.getFieldId(), Collectors.reducing(new EntityField(), (m, n) -> n)));
        for (DynamicObject dObject : collection) {
            String ewbxh = dObject.getString(EWBLXH);
            for (String field : split) {
                Object obj = dObject.get(field);
                String key = entityId + spitStr + ewbxh + spitStr + field;
                if (obj == null) continue;
                dataMap.put(key, TemplateUtilsOld.dataFormat(obj, map.get(field)));
            }
        }
        return dataMap;
    }

    public static List<Map<String, String>> dataToMapSpecial(String entityId, String spitStr, QFilter[] filters) {
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        String allFields = "id,electronicfileno,leverno,address,taxername,nationtaxsn,localtaxsn,creditcode,registertype,accountway,codeandname,nationtaxorg,localtaxorg,isabroad,isvirtualnode,commitername,commiterphone,grouproll,superorgname,ispointcompany,ispubliccompany,stockno,org";
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)allFields, (QFilter[])filters);
        if (collection == null || collection.isEmpty()) {
            return dataList;
        }
        int index = 1;
        entityId = "tcvvt_clique_mcinfo";
        for (DynamicObject dObject : collection) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (String fieldId : allFields.split(",")) {
                Object obj = dObject.get(fieldId);
                String key = entityId + spitStr + index + spitStr + fieldId;
                if (obj == null) continue;
                dataMap.put(key, obj.toString());
            }
            dataList.add(dataMap);
        }
        return dataList;
    }

    public static void deleteData(String templateTypeId, String mainPk) {
        DynamicObject dispatchorder = BusinessDataServiceHelper.loadSingle((Object)templateTypeId, (String)"tpo_template_type");
        DynamicObjectCollection entityList = dispatchorder.getDynamicObjectCollection("entryentity");
        String mainTable = dispatchorder.getString("maintable");
        if (entityList != null && !entityList.isEmpty()) {
            QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)mainPk);
            for (DynamicObject dobj : entityList) {
                String entityId = dobj.getString("entityid");
                if (mainTable.equals(entityId)) {
                    DeleteServiceHelper.delete((String)mainTable, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(mainPk))});
                    continue;
                }
                DeleteServiceHelper.delete((String)entityId, (QFilter[])new QFilter[]{sbbIdFilter});
            }
        }
    }

    public static Boolean queryReportExists(String orgId, String templateTypeId, Date startDate, Date endDate, String taxLimit) {
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingle((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter skssqqFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getDayFirst(startDate));
        QFilter skssqzFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast(endDate));
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        if ("fcscztdsys".equals(templateTypeId)) {
            templateFilter.and(new QFilter("tcrettype", "=", (Object)"fcscztdsys"));
        }
        if (taxLimit != null) {
            templateFilter.and(new QFilter("taxlimit", "=", (Object)taxLimit));
        }
        return QueryServiceHelper.exists((String)mainTable, (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, templateFilter});
    }

    public static void deleteReport(Long orgId, String templateTypeId, Date startDate, Date endDate, String taxLimit) {
        TemplateUtilsOld.deleteReport((Boolean)true, orgId, templateTypeId, startDate, endDate, taxLimit);
    }

    public static void deleteReport(Boolean deleteMainTable, Long orgId, String templateTypeId, Date startDate, Date endDate, String taxLimit) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)endDate);
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        if ("fcscztdsys".equals(templateTypeId)) {
            templateFilter.and(new QFilter("tcrettype", "=", (Object)"fcscztdsys"));
        }
        if (taxLimit != null) {
            templateFilter.and(new QFilter("taxlimit", "=", (Object)taxLimit));
        }
        TemplateUtilsOld.deleteReportByFilter(deleteMainTable, templateTypeId, orgFilter.and(skssqqFilter).and(skssqzFilter).and(templateFilter));
    }

    public static void deleteReport(Boolean deleteMainTable, Long[] sbbids, String templateTypeId) {
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        templateFilter.and(new QFilter("id", "in", (Object)sbbids));
        TemplateUtilsOld.deleteReportByFilter(deleteMainTable, templateTypeId, templateFilter);
    }

    public static void deleteReport(Boolean deleteBill, String serialno, Long orgId, String templateTypeId, Date startDate, Date endDate) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)endDate);
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        templateFilter.and(new QFilter("serialno", "=", (Object)serialno));
        TemplateUtilsOld.deleteReportByFilter(deleteBill, templateTypeId, orgFilter.and(skssqqFilter).and(skssqzFilter).and(templateFilter));
    }

    public static void deleteReport(Boolean deleteMainTable, Long orgId, String templateTypeId, Date startDate, Date endDate, Long taxauthorityId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)endDate);
        QFilter templateFilter = new QFilter("type", "=", (Object)templateTypeId);
        templateFilter.and(new QFilter("taxauthority", "=", (Object)taxauthorityId));
        TemplateUtilsOld.deleteReportByFilter(deleteMainTable, templateTypeId, orgFilter.and(skssqqFilter).and(skssqzFilter).and(templateFilter));
    }

    private static void deleteReportByFilter(Boolean deleteMainTable, String templateTypeId, QFilter filter) {
        boolean exists = QueryServiceHelper.exists((String)"tpo_template_type", (Object)templateTypeId);
        if (!exists) {
            return;
        }
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingle((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)mainTable, (String)"id", (QFilter[])new QFilter[]{filter});
        if (collection == null || collection.isEmpty()) {
            return;
        }
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject dObject : collection) {
            String mainId = dObject.getString("id");
            QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)mainId);
            QFilter sbbIdFilter1 = new QFilter("sbbid", "=", (Object)Long.parseLong(mainId));
            if (entityList == null || entityList.isEmpty()) continue;
            for (DynamicObject dobj : entityList) {
                DynamicObject nsrxx2;
                String entityId = dobj.getString("entityid");
                if (mainTable.equals(entityId)) {
                    if (deleteMainTable.booleanValue()) {
                        DeleteServiceHelper.delete((String)mainTable, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(mainId))});
                        continue;
                    }
                    try {
                        nsrxx2 = BusinessDataServiceHelper.loadSingle((Object)mainId, (String)mainTable);
                        nsrxx2.set("bqybtse", (Object)0);
                        OperationServiceHelper.executeOperate((String)"save", (String)mainTable, (DynamicObject[])new DynamicObject[]{nsrxx2}, (OperateOption)OperateOption.create());
                    }
                    catch (Exception nsrxx2) {}
                    continue;
                }
                if ("tcvat_prepay_declare_bill".equals(entityId) && !deleteMainTable.booleanValue()) {
                    nsrxx2 = BusinessDataServiceHelper.loadSingle((String)entityId, (String)"id,bqybtse", (QFilter[])new QFilter[]{sbbIdFilter});
                    nsrxx2.set("bqybtse", (Object)0);
                    OperationServiceHelper.executeOperate((String)"save", (String)entityId, (DynamicObject[])new DynamicObject[]{nsrxx2}, (OperateOption)OperateOption.create());
                    continue;
                }
                QFilter qFilter = DeclareConstant.LONG_SBBID_ENTITIES.contains(entityId) ? sbbIdFilter1 : sbbIdFilter;
                DeleteServiceHelper.delete((String)entityId, (QFilter[])new QFilter[]{qFilter});
            }
        }
    }

    public static DynamicObject getTemplateObjectById(String templateId) {
        QFilter qFilter2 = new QFilter("id", "=", (Object)Long.valueOf(templateId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_template_old", (String)"id,number,content,content_tag,html_tag,type.number as typenumber", (QFilter[])new QFilter[]{qFilter2});
        if (collection != null && !collection.isEmpty()) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public static DynamicObject getTemplateObjectByConfig(String templateType, String orgid, Date startDate, Date endDate) {
        QFilter qFilter1 = new QFilter("type", "=", (Object)templateType);
        QFilter qFilter2 = new QFilter("startdate", "<=", (Object)startDate);
        QFilter qFilter3 = QFilter.isNull((String)"enddate").or(new QFilter("enddate", ">=", (Object)endDate));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tpo_template_old", (String)"id,number,content,content_tag,html_tag,conditionjson,general", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, (String)"createtime desc");
        if (dynamicObjectCollection.size() == 1) {
            return (DynamicObject)dynamicObjectCollection.get(0);
        }
        if (dynamicObjectCollection.size() > 1) {
            List configList = dynamicObjectCollection.stream().filter(a -> !a.getBoolean("general") && StringUtil.isNotEmpty((CharSequence)a.getString("conditionjson"))).collect(Collectors.toList());
            List configEmptyList = dynamicObjectCollection.stream().filter(a -> !a.getBoolean("general") && StringUtil.isEmpty((CharSequence)a.getString("conditionjson"))).collect(Collectors.toList());
            Optional<DynamicObject> generalOption = dynamicObjectCollection.stream().filter(a -> a.getBoolean("general")).findFirst();
            DynamicObject template = null;
            if (StringUtil.isNotEmpty((CharSequence)orgid) && configList.size() > 0) {
                QFilter orgQfilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgid));
                QFilter taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
                Optional<DynamicObject> optional = configList.stream().filter(dynamicObject -> {
                    String conditionjson = dynamicObject.getString("conditionjson");
                    QFilter qFilter4 = FilterBuilderUtils.buildFilter(conditionjson, "tctb_tax_main_form");
                    TemplateUtilsOld.dealAddress(qFilter4);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"tctb_tax_main", (String)"id", (QFilter[])new QFilter[]{qFilter4, orgQfilter, taxationsys});
                    return query.size() > 0;
                }).findFirst();
                if (optional.isPresent()) {
                    template = optional.get();
                }
            }
            if (template == null) {
                if (configEmptyList.size() > 0) {
                    template = (DynamicObject)configEmptyList.get(0);
                } else if (generalOption.isPresent()) {
                    template = generalOption.get();
                }
            }
            return template;
        }
        return null;
    }

    public static QFilter dealAddress(QFilter conditionFilters) {
        String property = conditionFilters.getProperty();
        Object value = conditionFilters.getValue();
        String cp = conditionFilters.getCP();
        if ("registeraddress.fullname".equals(property) || "actualaddress.fullname".equals(property)) {
            if ("registeraddress.fullname".equals(property)) {
                conditionFilters.__setProperty("registeraddress");
            } else if ("actualaddress.fullname".equals(property)) {
                conditionFilters.__setProperty("actualaddress");
            }
            List<String> subIds = TemplateUtilsOld.getSubIds(value);
            if (EmptyCheckUtils.isNotEmpty(subIds)) {
                conditionFilters.__setValue(subIds);
                if (cp.equals("=")) {
                    conditionFilters.__setCP("in");
                } else if (cp.equals("!=") || cp.equals("<>")) {
                    conditionFilters.__setCP("not in");
                }
            }
        }
        List nests = conditionFilters.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            TemplateUtilsOld.dealAddress(nest.getFilter());
        }
        return conditionFilters;
    }

    private static List<String> getSubIds(Object value) {
        List names = null;
        if (value instanceof String) {
            names = Collections.singletonList((String)value);
        } else if (value instanceof List) {
            names = (List)value;
        }
        if (names != null) {
            DynamicObjectCollection admindivisions = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,fullname", (QFilter[])new QFilter("fullname", "in", (Object)names).toArray());
            List<String> parentIds = admindivisions.stream().map(a -> a.getString("id")).collect(Collectors.toList());
            ArrayList<String> collectIds = new ArrayList<String>(parentIds.size());
            collectIds.addAll(parentIds);
            TemplateUtilsOld.getSubLeverIds(parentIds, collectIds);
            return collectIds;
        }
        return null;
    }

    private static void getSubLeverIds(List<String> parentIds, List<String> collectIds) {
        DynamicObjectCollection admindivisions = QueryServiceHelper.query((String)"bd_admindivision", (String)"id", (QFilter[])new QFilter("parent.id", "in", parentIds.stream().map(Long::valueOf).collect(Collectors.toList())).toArray());
        List<String> listTemp = admindivisions.stream().map(a -> a.getString("id")).collect(Collectors.toList());
        listTemp.removeIf(a -> collectIds.contains(a));
        if (listTemp.size() > 0) {
            collectIds.addAll(listTemp);
            TemplateUtilsOld.getSubLeverIds(listTemp, collectIds);
        }
    }

    public static DynamicObject getTemplateObjectById(String templateType, String templateId) {
        QFilter qFilter1 = new QFilter("type", "=", (Object)templateType);
        QFilter qFilter2 = new QFilter("id", "=", (Object)Long.valueOf(templateId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_template_old", (String)"id,number,content,content_tag,html_tag", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (collection != null && !collection.isEmpty()) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public static DynamicObject getTemplateObject(String templateType, Date startDate, Date endDate) {
        QFilter qFilter1 = new QFilter("type", "=", (Object)templateType);
        QFilter qFilter2 = new QFilter("startdate", "<=", (Object)startDate);
        QFilter qFilter3 = QFilter.isNull((String)"enddate").or(new QFilter("enddate", ">=", (Object)endDate));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_template_old", (String)"id,number,content,content_tag,html_tag", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        if (collection != null && !collection.isEmpty()) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public static DynamicObject getTemplateObjectPartCover(String templateType, Date startDate, Date endDate, int model) {
        QFilter qFilter3;
        QFilter qFilter1 = new QFilter("type", "=", (Object)templateType);
        Date modelDate = model == 1 || endDate == null ? startDate : endDate;
        QFilter qFilter2 = new QFilter("startdate", "<=", (Object)modelDate);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_template_old", (String)"id,number,content,content_tag,html_tag", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3 = QFilter.isNull((String)"enddate").or(new QFilter("enddate", ">=", (Object)modelDate))});
        if (collection != null && !collection.isEmpty()) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public static Map<String, String> getAllFieldToShow(Map<String, String> listTab) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (listTab != null) {
            Iterator<String> iterator = listTab.keySet().iterator();
            while (iterator.hasNext()) {
                map.putAll(TemplateUtilsOld.getFieldMap(iterator.next(), SPLIT_STRING_SAVE, SPLIT_STRING_SHOW));
            }
        }
        return map;
    }

    public static Map<String, String> getAllFieldToSave(Map<String, String> listTab) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<String> iterator = listTab.keySet().iterator();
        while (iterator.hasNext()) {
            map.putAll(TemplateUtilsOld.getFieldMap(iterator.next(), SPLIT_STRING_SHOW, SPLIT_STRING_SAVE));
        }
        return map;
    }

    public static Map<String, EntityField> getAllEntity(Map<String, String> entityMap) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        for (Map.Entry<String, String> entity : entityMap.entrySet()) {
            map.putAll(TemplateUtilsOld.getEntityFieldMap(entity.getKey(), SPLIT_STRING_SAVE, null));
        }
        return map;
    }

    public static Map<String, EntityField> getAllEntityByType(String type, String keySplit) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        Map<String, String> entityMap = TemplateUtilsOld.queryEntityByTypeId(type);
        for (Map.Entry<String, String> entity : entityMap.entrySet()) {
            map.putAll(TemplateUtilsOld.getEntityFieldMap(entity.getKey(), keySplit, null));
        }
        return map;
    }

    public static Map<String, String> getAllDataToShow(Map<String, String> dataMap, Map<String, EntityField> typeMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (dataMap != null) {
            dataMap.entrySet().stream().forEach(v -> {
                if (((String)v.getKey()).contains(SPLIT_STRING_SAVE)) {
                    String key = ((String)v.getKey()).replaceAll(SPLIT_STRING_SAVE, SPLIT_STRING_SHOW);
                    String ketTemp = ((String)v.getKey()).split(SPLIT_STRING_SAVE)[0] + "_1_" + ((String)v.getKey()).split(SPLIT_STRING_SAVE)[2];
                    map.put(key, TemplateUtilsOld.dataFormat(v.getValue(), (EntityField)typeMap.get(ketTemp)));
                } else {
                    map.put((String)v.getKey(), (String)v.getValue());
                }
            });
        }
        return map;
    }

    public static Map<String, String> getAllMapping(Map<String, String> dataMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (dataMap != null) {
            dataMap.entrySet().stream().forEach(v -> {
                if (((String)v.getKey()).contains(SPLIT_STRING_SAVE)) {
                    String key = ((String)v.getKey()).replaceAll(SPLIT_STRING_SAVE, SPLIT_STRING_SHOW);
                    map.put(key, (String)v.getKey());
                }
            });
        }
        return map;
    }

    public static Map<String, EntityField> getAllEntityShow(Map<String, String> listTab) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>(16);
        Iterator<String> iterator = listTab.keySet().iterator();
        while (iterator.hasNext()) {
            map.putAll(TemplateUtilsOld.getEntityFieldMap(iterator.next(), SPLIT_STRING_SAVE, SPLIT_STRING_SHOW));
        }
        return map;
    }

    public static Map<String, EntityField> getAllFieldTypeToShow(Map<String, String> listTab) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>();
        for (Map.Entry<String, String> entry : listTab.entrySet()) {
            EntityInfo entityInfo = MetadataUtil.getEntityById(entry.getKey());
            List<ValueMapItem> ewblxhItems = null;
            for (EntityField entityField : entityInfo.getFieldList()) {
                if (!EWBLXH.equals(entityField.getFieldId())) continue;
                ewblxhItems = entityField.getComboItems();
                break;
            }
            if (ewblxhItems == null) continue;
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String key = entityInfo.getEntityId() + SPLIT_STRING_SHOW + item.getValue() + SPLIT_STRING_SHOW + entityField.getFieldId();
                    map.put(key, entityField);
                }
            }
        }
        return map;
    }

    public static String dataFormat(Object dataObj, EntityField fieldType) {
        return TemplateUtilsOld.dataFormat(null, dataObj, fieldType);
    }

    public static String dataFormat(String entityId, Object dataObj, EntityField fieldType) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            Long orgId;
            QFilter qFilter;
            DynamicObject object;
            if ("Decimal".equals(fieldType.getFieldType())) {
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    DecimalFormat decimalFormat = new DecimalFormat(TemplateUtilsOld.getDecimalFormatByMetadataScale(fieldType, MICROMETER_DECIMAL_INIT_FORMAT, DEFAULT_DECIMAL_FORMAT));
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if ("DateTime".equals(fieldType.getFieldType()) || "Date".equals(fieldType.getFieldType())) {
                String format = "yyyy-MM-dd HH:mm:ss";
                if ("Date".equals(fieldType.getFieldType())) {
                    format = "yyyy-MM-dd";
                }
                SimpleDateFormat df = new SimpleDateFormat(format);
                try {
                    Date date = df.parse(String.valueOf(dataObj));
                    return DateUtils.format(date, format);
                }
                catch (Exception e) {
                    return "";
                }
            }
            if ("Integer".equals(fieldType.getFieldType())) {
                return TemplateUtilsOld.formatInteger(dataObj, MICROMETER_DECIMAL_INIT_FORMAT);
            }
            if (entityId != null && "tdm_finance_main".equals(entityId) && "org".equals(fieldType.getFieldId()) && (object = BusinessDataServiceHelper.loadSingle((String)entityId, (String)"id,org.number", (QFilter[])new QFilter[]{qFilter = new QFilter("org", "=", (Object)(orgId = Long.valueOf(Long.parseLong(dataObj.toString()))))})) != null) {
                return object.getString("org.number");
            }
        }
        return dataObj.toString();
    }

    public static String defaultDataFormat(Object dataObj, EntityField fieldType) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("Decimal".equals(fieldType.getFieldType())) {
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    DecimalFormat decimalFormat = new DecimalFormat(DEFAULT_DECIMAL_FORMAT);
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "DateTime".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd HH:mm:ss");
            }
            if (dataObj instanceof Date && "Date".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd");
            }
        }
        return dataObj.toString();
    }

    public static String dataFormatPreSave(Object dataObj, EntityField fieldType) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("Decimal".equals(fieldType.getFieldType())) {
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    DecimalFormat decimalFormat = new DecimalFormat(TemplateUtilsOld.getDecimalFormatByMetadataScale(fieldType, DECIMAL_INIT_FORMAT, DEFAULT_DECIMAL_FORMAT));
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "DateTime".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd HH:mm:ss");
            }
            if (dataObj instanceof Date && "Date".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd");
            }
            if ("Integer".equals(fieldType.getFieldType())) {
                return TemplateUtilsOld.formatInteger(dataObj, DECIMAL_INIT_FORMAT);
            }
        }
        return dataObj.toString();
    }

    public static String dataFormat(Object dataObj, EntityField fieldType, int expandedTimes) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("Decimal".equals(fieldType.getFieldType())) {
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    if (bd.compareTo(COMPARE_STANDARD_VALUE) <= 0) {
                        bd = bd.multiply(new BigDecimal(expandedTimes));
                    }
                    DecimalFormat decimalFormat = new DecimalFormat(TemplateUtilsOld.getDecimalFormatByMetadataScale(fieldType, DECIMAL_INIT_FORMAT, DEFAULT_DECIMAL_FORMAT));
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "DateTime".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd HH:mm:ss");
            }
            if (dataObj instanceof Date && "Date".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd");
            }
            if ("Integer".equals(fieldType.getFieldType())) {
                return TemplateUtilsOld.formatInteger(dataObj, DECIMAL_INIT_FORMAT);
            }
        }
        return dataObj.toString();
    }

    @Deprecated
    private static String formatInteger(Object dataObj, String initFormat) {
        try {
            String val = dataObj.toString();
            BigDecimal bd = new BigDecimal(val);
            StringBuilder format = new StringBuilder(initFormat);
            if (val.contains(".")) {
                String decimalPlace = val.substring(val.lastIndexOf(46) + 1);
                int scale = decimalPlace.length();
                for (int i = 0; i < scale; ++i) {
                    if (i == 0) {
                        format.append('.');
                    }
                    format.append('0');
                }
            }
            DecimalFormat decimalFormat = new DecimalFormat(format.toString());
            decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
            return decimalFormat.format(bd);
        }
        catch (Exception e) {
            return dataObj.toString();
        }
    }

    public static String getDecimalFormatByMetadataScale(EntityField fieldType, String initFormat, String defaultDecimalFormat) {
        if (null != fieldType) {
            StringBuilder format = new StringBuilder(initFormat);
            int scale = fieldType.getScale();
            for (int i = 0; i < scale; ++i) {
                if (i == 0) {
                    format.append('.');
                }
                format.append('0');
            }
            return format.toString();
        }
        return defaultDecimalFormat;
    }

    private static Map<String, String> getFieldMap(String entityId, String keySplit, String valSplit) {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        List<ValueMapItem> ewblxhItems = null;
        for (EntityField entityField : entityInfo.getFieldList()) {
            if (!EWBLXH.equals(entityField.getFieldId())) continue;
            ewblxhItems = entityField.getComboItems();
            break;
        }
        if (ewblxhItems != null) {
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String key = entityInfo.getEntityId() + keySplit + item.getValue() + keySplit + entityField.getFieldId();
                    String value = entityInfo.getEntityId() + valSplit + item.getValue() + valSplit + entityField.getFieldId();
                    map.put(key, value);
                }
            }
        }
        return map;
    }

    public static Map<String, EntityField> getEntityFieldMap(String entityId, String keySplit, String valSplit) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        List<ValueMapItem> ewblxhItems = null;
        for (EntityField entityField : entityInfo.getFieldList()) {
            if (!EWBLXH.equals(entityField.getFieldId())) continue;
            ewblxhItems = entityField.getComboItems();
            break;
        }
        if (ewblxhItems != null) {
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String key = entityInfo.getEntityId() + keySplit + item.getValue() + keySplit + entityField.getFieldId();
                    String value = entityInfo.getEntityId() + valSplit + item.getValue() + valSplit + entityField.getFieldId();
                    EntityField field = new EntityField();
                    field.setEntityId(entityField.getEntityId());
                    field.setEntityName(entityField.getEntityName());
                    if (valSplit == null) {
                        field.setFieldId(entityField.getFieldId());
                    } else {
                        field.setFieldId(value);
                    }
                    field.setFieldType(entityField.getFieldType());
                    field.setFieldName(entityField.getFieldName());
                    field.setMaxLength(entityField.getMaxLength());
                    field.setPrecision(entityField.getPrecision());
                    field.setScale(entityField.getScale());
                    field.setComboItems(entityField.getComboItems());
                    field.setBaseEntityId(entityField.getBaseEntityId());
                    field.setDisplayProp(entityField.getDisplayProp());
                    field.setEwblxh(item.getValue());
                    field.setFormat(entityField.getFormat());
                    if (item.getName() != null) {
                        field.setEwblName(item.getName().getLocaleValue());
                    }
                    map.put(key, field);
                }
            }
        }
        return map;
    }

    public static Map<String, EntityField> getEntityFieldMapForAllImportCheck(String entityId, String keySplit, String valSplit) {
        HashMap<String, EntityField> map = new HashMap<String, EntityField>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        List<ValueMapItem> ewblxhItems = null;
        for (EntityField entityField : entityInfo.getFieldList()) {
            if (!EWBLXH.equals(entityField.getFieldId())) continue;
            ewblxhItems = entityField.getComboItems();
            break;
        }
        if (ewblxhItems != null) {
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String key = "${" + entityInfo.getEntityId() + keySplit + item.getValue() + keySplit + entityField.getFieldId() + "}";
                    String value = entityInfo.getEntityId() + valSplit + item.getValue() + valSplit + entityField.getFieldId();
                    EntityField field = new EntityField();
                    field.setEntityId(entityField.getEntityId());
                    field.setEntityName(entityField.getEntityName());
                    if (valSplit == null) {
                        field.setFieldId(entityField.getFieldId());
                    } else {
                        field.setFieldId(value);
                    }
                    field.setFieldType(entityField.getFieldType());
                    field.setFieldName(entityField.getFieldName());
                    field.setMaxLength(entityField.getMaxLength());
                    field.setPrecision(entityField.getPrecision());
                    field.setScale(entityField.getScale());
                    field.setComboItems(entityField.getComboItems());
                    field.setBaseEntityId(entityField.getBaseEntityId());
                    field.setDisplayProp(entityField.getDisplayProp());
                    field.setEwblxh(item.getValue());
                    field.setFormat(entityField.getFormat());
                    if (item.getName() != null) {
                        field.setEwblName(item.getName().getLocaleValue());
                    }
                    map.put(key, field);
                }
            }
        }
        return map;
    }

    public static Map<String, String> getAllEntityFieldMap(Map<String, String> listTab) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<String> iterator = listTab.keySet().iterator();
        while (iterator.hasNext()) {
            map.putAll(TemplateUtilsOld.getEntityFieldMap(iterator.next()));
        }
        return map;
    }

    private static Map<String, String> getEntityFieldMap(String entityId) {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        List<ValueMapItem> ewblxhItems = null;
        for (EntityField entityField : entityInfo.getFieldList()) {
            if (!EWBLXH.equals(entityField.getFieldId())) continue;
            ewblxhItems = entityField.getComboItems();
            break;
        }
        if (ewblxhItems != null) {
            for (ValueMapItem item : ewblxhItems) {
                for (EntityField entityField : entityInfo.getFieldList()) {
                    if (BASE_FIELD_LAST.contains(entityField.getFieldId())) continue;
                    String key = entityInfo.getEntityId() + SPLIT_STRING_SAVE + item.getValue() + SPLIT_STRING_SAVE + entityField.getFieldId();
                    String value = entityInfo.getEntityName() + SPLIT_STRING_SAVE + TemplateUtilsOld.getFieldName(item.getName().getLocaleValue()) + SPLIT_STRING_SAVE + TemplateUtilsOld.getFieldName(entityField.getFieldName());
                    map.put(key, value);
                }
            }
        }
        return map;
    }

    public static String getFieldName(String fieldName) {
        if (fieldName == null) {
            return fieldName;
        }
        Matcher matcher = FIELDNAME_Pattern.matcher(fieldName);
        return matcher.replaceAll("").trim();
    }

    public static void handleTaxRateOnFormShowByTypeAndField(String type, Map<String, String> dataMap) {
        Map<String, EntityField> allEntityByType = TemplateUtilsOld.getAllEntityByType(type, SPLIT_STRING_SHOW);
        if (TemplateUtilsOld.checkTemplateType(type)) {
            for (Map.Entry<String, String> entry : dataMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!TemplateUtilsOld.checkRateColumnByCellKey(key)) continue;
                dataMap.put(key, TemplateUtilsOld.dataFormat((Object)value, allEntityByType.get(key), 100));
            }
        }
    }

    public static void handleSpecialFieldValuePreSave(String templateType, Map<String, String> newMap) {
        if (newMap.containsKey(TCVAT_NSRXX_EWBLXH)) {
            newMap.put(TCVAT_NSRXX_MODIFYTIME, DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
            newMap.put(TCVAT_NSRXX_MODIFIER, RequestContext.get().getUserId());
        }
        if (StringUtils.equals((CharSequence)"fjsf", (CharSequence)templateType)) {
            newMap.put(TCVAT_NSRXX_BQYBTSE, newMap.get(TCVAT_SB_FJSF_BQYBSE));
        }
        if (TemplateUtilsOld.checkTemplateType(templateType)) {
            Map<String, EntityField> allEntityByType = TemplateUtilsOld.getAllEntityByType(templateType, SPLIT_STRING_SAVE);
            for (Map.Entry<String, String> entry : newMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!TemplateUtilsOld.checkRateColumnByCellKey(key)) continue;
                newMap.put(key, StringUtils.isNotBlank((CharSequence)value) ? (new BigDecimal(value).compareTo(COMPARE_STANDARD_VALUE) <= 0 ? value : BigDecimalUtil.divideObject(value, 100, null == allEntityByType.get(key) ? 4 : allEntityByType.get(key).getScale()).toString()) : DEFAULT_VALUE.toString());
            }
        }
    }

    private static boolean checkTemplateType(String type) {
        return StringUtils.equals((CharSequence)"qysdsnb", (CharSequence)type) || StringUtils.equals((CharSequence)"qysdsjb", (CharSequence)type) || StringUtils.equals((CharSequence)"yhs", (CharSequence)type) || StringUtils.equals((CharSequence)"fcscztdsys", (CharSequence)type);
    }

    private static boolean checkRateColumnByCellKey(String key) {
        return key.contains("tccit_qysds_a105050_3_") || key.contains("tccit_qysds_a105050#3#") || key.contains("tccit_qysds_a100000") && key.contains("sl1") || key.contains("tccit_qysds_a105060") && key.contains("ssgdkce") || key.contains("tccit_qysds_zb") && key.contains("sl") || key.contains("tcsd_zb") && key.contains("applicablerate") || (key.contains("tcret_housetax_price") || key.contains("tcret_housetax_hire")) && key.contains("taxrate") || key.contains("tcret_housetax_price") && key.contains("taxationratio") || (key.contains("tcret_housetax_p_info") || key.contains("tcret_housetax_h_info")) && key.contains("taxrate") || key.contains("tcret_housetax_p_info") && key.contains("taxationratio");
    }

    public static String formatMicrometer(String text) {
        DecimalFormat df = null;
        df = text.indexOf(46) > 0 ? (text.length() - text.indexOf(46) - 1 == 0 ? new DecimalFormat("###,##0.") : (text.length() - text.indexOf(46) - 1 == 1 ? new DecimalFormat("###,##0.0") : (text.length() - text.indexOf(46) - 1 == 4 ? new DecimalFormat("###,##0.0000") : new DecimalFormat("###,##0.00")))) : new DecimalFormat(MICROMETER_DECIMAL_INIT_FORMAT);
        double number = 0.0;
        try {
            number = Double.parseDouble(text);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

    public static DynamicObject getDynamicTemplateObject(Long baseTemplateId, String orgId, String startDate, String endDate) {
        QFilter qFilter4;
        QFilter qFilter3;
        QFilter qFilter2;
        QFilter qFilter1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_template_float", (String)"id,content,content_tag,html_tag", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("skssqq", "=", (Object)DateUtils.addMonth(DateUtils.stringToDate(startDate), 0)), qFilter3 = new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endDate), 0))), qFilter4 = new QFilter("basetemplateid", "=", (Object)baseTemplateId)});
        if (collection != null && !collection.isEmpty()) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public static DynamicObjectCollection getTemplateFloatSetting(Long baseTemplateId) {
        QFilter qFilter = new QFilter("basetemplateid", "=", (Object)baseTemplateId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_template_floatset", (String)"id,basetemplateid,type,tableentity,direct,maxrow,startrowindex,endrowindex,createrfield,createdatefield,modifierfield,modifydatefield,enable", (QFilter[])new QFilter[]{qFilter});
        return collection;
    }

    public static DynamicObject getTemplateFloatSettingByPrimaryKey(Object primaryKey) {
        QFilter qFilter = new QFilter("id", "=", primaryKey);
        DynamicObject collection = QueryServiceHelper.queryOne((String)"tpo_template_floatset", (String)"id,basetemplateid,type,tableentity,direct,maxrow,startrowindex,endrowindex,createrfield,createdatefield,modifierfield,modifydatefield,enable", (QFilter[])new QFilter[]{qFilter});
        return collection;
    }

    static {
        BASE_FIELD_LAST.add("id");
        BASE_FIELD_LAST.add(EWBLXH);
        BASE_FIELD_LAST.add("ewblname");
        BASE_FIELD_LAST.add("sbbid");
    }
}

