/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxsource.delete;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.taxsource.delete.IDeleteService;
import kd.taxc.bdtaxr.common.taxsource.delete.MappingDeleteService;

public class MasterSlaveDeleteService
implements IDeleteService {
    @Override
    public void deleteSourceData(Long sbbId, List<DynamicObject> sourceRelations) {
        for (DynamicObject sourceRelation : sourceRelations) {
            String entity = sourceRelation.getString("source");
            if ("tcret_yhs_tax_source_info".equals(entity) || "tcret_zys_collect".equals(entity)) {
                MappingDeleteService service = new MappingDeleteService();
                service.deleteSourceData(sbbId, Collections.singletonList(sourceRelation));
                continue;
            }
            DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)});
        }
    }

    @Override
    public void deleteTemporarySourceData(Long sbbId, List<DynamicObject> sourceRelations) {
        this.deleteTemporarySourceData(sbbId, sourceRelations, null);
    }

    @Override
    public void deleteTemporarySourceData(Long sbbId, List<DynamicObject> sourceRelations, String excludeEntity) {
        for (DynamicObject sourceRelation : sourceRelations) {
            String entity = sourceRelation.getString("sourcetemp");
            if (Objects.equals(excludeEntity, entity)) continue;
            DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)});
        }
    }
}

