/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxsource.save;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.SourceRelationConstant;
import kd.taxc.bdtaxr.common.taxsource.save.ISaveService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class MappingSaveService
implements ISaveService {
    @Override
    public void saveSourceData(Long sbbId, List<DynamicObject> sourceRelations) {
        for (DynamicObject sourceRelation : sourceRelations) {
            QFilter q1 = new QFilter("sbbid", "=", (Object)sbbId);
            String source = sourceRelation.getString("source");
            QFilter q2 = new QFilter("taxsourcetype", "=", (Object)source);
            DynamicObject[] mappingedTaxSources = BusinessDataServiceHelper.load((String)source, (String)"sbbid", (QFilter[])new QFilter[]{q1});
            for (int i = 0; i < mappingedTaxSources.length; ++i) {
                DynamicObject taxsource = mappingedTaxSources[i];
                taxsource.set("sbbid", (Object)0L);
            }
            SaveServiceHelper.save((DynamicObject[])mappingedTaxSources);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)SourceRelationConstant.BDTAXR_SOURCE_MAPPING, (String)"taxsourcetype,taxsourceid,sbbid", (QFilter[])new QFilter[]{q1, q2});
            if (!EmptyCheckUtils.isNotEmpty(collection)) continue;
            List taxsourceid = collection.stream().map(d -> d.getLong("taxsourceid")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", taxsourceid);
            DynamicObject[] taxsources = BusinessDataServiceHelper.load((String)source, (String)"sbbid", (QFilter[])new QFilter[]{qFilter});
            for (int i = 0; i < taxsources.length; ++i) {
                DynamicObject taxsource = taxsources[i];
                taxsource.set("sbbid", (Object)sbbId);
            }
            SaveServiceHelper.save((DynamicObject[])taxsources);
        }
    }

    @Override
    public void saveTemporarySourceData(Long sbbId, List<DynamicObject> sourceRelations) {
    }
}

