/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.taxsource.save;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxsource.delete.MappingDeleteService;
import kd.taxc.bdtaxr.common.taxsource.save.ISaveService;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;

public class MasterSlaveSaveService
implements ISaveService {
    @Override
    public void saveSourceData(Long sbbId, List<DynamicObject> sourceRelations) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)};
        for (DynamicObject sourceRelation : sourceRelations) {
            String sourceEntity = sourceRelation.getString("source");
            String sourceEntityTemp = sourceRelation.getString("sourcetemp");
            if ("tcret_yhs_tax_source_info".equals(sourceEntity) || "tcret_zys_collect".equals(sourceEntity)) {
                new MappingDeleteService().deleteSourceData(sbbId, Collections.singletonList(sourceRelation));
            } else {
                DeleteServiceHelper.delete((String)sourceEntity, (QFilter[])qFilters);
            }
            this.saveEntry(sourceEntity, sourceEntityTemp, qFilters);
        }
    }

    @Override
    public void saveTemporarySourceData(Long sbbId, List<DynamicObject> sourceRelations) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)};
        for (DynamicObject sourceRelation : sourceRelations) {
            String sourceEntity = sourceRelation.getString("source");
            String sourceEntityTemp = sourceRelation.getString("sourcetemp");
            DeleteServiceHelper.delete((String)sourceEntityTemp, (QFilter[])qFilters);
            this.saveEntry(sourceEntityTemp, sourceEntity, qFilters);
        }
    }

    private void saveEntry(String toEntity, String fromEntity, QFilter[] qFilters) {
        List pkids = QueryServiceHelper.queryPrimaryKeys((String)fromEntity, (QFilter[])qFilters, null, (int)-1);
        DeleteServiceHelper.delete((String)toEntity, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)});
        DynamicObject[] sources = BusinessDataServiceHelper.load((Object[])pkids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)fromEntity));
        ArrayList<DynamicObject> targetList = new ArrayList<DynamicObject>(sources.length);
        for (DynamicObject source : sources) {
            DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)toEntity);
            BeanCopyUtils.copyDynamicObject(source, target);
            targetList.add(target);
        }
        SaveServiceHelper.save((DynamicObject[])targetList.toArray(new DynamicObject[0]));
    }
}

