/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.tctb.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OrgCheckUtil {
    private static final String TCTB_ORG_TAKEDATA = "tctb_org_takedata";

    public static boolean checkById(IFormView view, String orgId, String appid, String entityid) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(appid, entityid, "4715a0df000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            return true;
        }
        if (LicenseCheckServiceHelper.check(orgId, view, appid)) {
            return true;
        }
        return OrgCheckUtil.orgEnable(view, org, true);
    }

    public static boolean checkByElseForm(IFormView view, String orgId, String appid, String categoryType, String formid) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        if (EmptyCheckUtils.isEmpty(orgId) || Objects.equals("0", orgId)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(appid, formid, "47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            return true;
        }
        if (LicenseCheckServiceHelper.check(orgId, view, appid)) {
            return true;
        }
        if (OrgCheckUtil.orgEnable(view, org, true)) {
            return true;
        }
        if (OrgCheckUtil.isTaxPayerAuth(view, orgId, true)) {
            return true;
        }
        if (null != categoryType) {
            String categoryent = OrgCheckUtil.getCategoryentName(categoryType);
            QFilter qFilter = null;
            if (!TaxAppEnum.TCRET.getAppid().equalsIgnoreCase(appid)) {
                qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)categoryType);
            }
            QFilter taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
            DynamicObjectCollection list = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.name,categoryentryentity.taxpayertype,categoryentryentity.enable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), qFilter, taxationsys});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    return true;
                }
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public static Long setDefaultOrg(IFormView getView, Long orgid, DynamicObjectCollection permOrgs) {
        if (permOrgs.isEmpty()) {
            return null;
        }
        return OrgCheckUtil.setDefaultOrg(getView, orgid, permOrgs.stream().map(p -> p.getLong("id")).collect(Collectors.toList()));
    }

    public static Long setDefaultOrg(Long orgid, Long userId, IFormView view) {
        String entityid = view.getEntityId();
        String appid = view.getFormShowParameter().getAppId();
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)userId, (String)appid, (String)entityid, (String)"47150e89000000ac");
        if (taxResult.isSuccess()) {
            List data = (List)taxResult.getData();
            if (data.contains(orgid)) {
                return orgid;
            }
            if (data.size() > 0) {
                return (Long)data.get(0);
            }
            return null;
        }
        view.showErrorNotification(taxResult.getMessage());
        return null;
    }

    public static Long setDefaultOrg(IFormView getView, Long orgid, List<Long> orgList) {
        if (CollectionUtils.isEmpty(orgList)) {
            return null;
        }
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"setDefaultOrg", (Object[])new Object[]{orgid, orgList});
        if (ObjectUtils.isEmpty(map.get("orgid"))) {
            if (getView != null) {
                getView.showErrorNotification((String)map.get("failInfo"));
            }
            return null;
        }
        return (Long)map.get("orgid");
    }

    public static boolean check(IFormView view, String orgId, String appid, String categoryType) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        return OrgCheckUtil.check(view, orgId, appid, categoryType, hasPermOrgResult);
    }

    public static boolean check(IFormView view, String orgId, String appid, String categoryType, HasPermOrgResult hasPermOrgResult) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        if (EmptyCheckUtils.isEmpty(orgId) || Objects.equals("0", orgId)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        String entityId = view.getEntityId();
        boolean isNoPermView = "rdesd_hzb_gx_declare".equalsIgnoreCase(entityId);
        if (!(isNoPermView || hasPermOrgResult.hasAllOrgPerm() || hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId)))) {
            String orgname = "";
            DynamicObject bosorg = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(orgId))});
            if (bosorg != null) {
                orgname = bosorg.getString("name");
            }
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgname));
            return true;
        }
        if (LicenseCheckServiceHelper.check(orgId, view, appid)) {
            return true;
        }
        if (OrgCheckUtil.orgEnable(view, org, true)) {
            return true;
        }
        if (OrgCheckUtil.isTaxPayerAuth(view, orgId, true)) {
            return true;
        }
        if (null != categoryType) {
            String categoryent = OrgCheckUtil.getCategoryentName(categoryType);
            QFilter qFilter = null;
            if (TaxAppEnum.TCRET.getCategoryCode().equals(categoryType)) {
                return false;
            }
            qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)categoryType);
            QFilter taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
            DynamicObjectCollection list = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.name,categoryentryentity.taxpayertype,categoryentryentity.enable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), qFilter, taxationsys});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    return true;
                }
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public static boolean check(IFormView view, String orgId, String appid, String categoryType, String taxType) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        if (EmptyCheckUtils.isEmpty(orgId) || Objects.equals("0", orgId)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            return true;
        }
        if (LicenseCheckServiceHelper.check(orgId, view, appid)) {
            return true;
        }
        if (OrgCheckUtil.orgEnable(view, org, true)) {
            return true;
        }
        if (OrgCheckUtil.isTaxPayerAuth(view, orgId, true)) {
            return true;
        }
        if (null != categoryType) {
            QFilter taxationsys;
            String categoryent = OrgCheckUtil.getCategoryentName(taxType);
            QFilter taxTypeFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)categoryType);
            QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
            DynamicObjectCollection list = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.name,categoryentryentity.taxpayertype,categoryentryentity.enable,categoryentryentity.fcsenable,categoryentryentity.cztdsysenable", (QFilter[])new QFilter[]{orgFilter, taxTypeFilter, taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId())});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    return true;
                }
                if ("fcs".equals(taxType) && Objects.equals("5", dy.getString("categoryentryentity.fcsenable"))) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    return true;
                }
                if ("cztdsys".equals(taxType) && Objects.equals("6", dy.getString("categoryentryentity.cztdsysenable"))) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    return true;
                }
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8bbe\u7f6e-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public static String getCategoryentName(String categoryType) {
        switch (categoryType) {
            case "qysds": {
                return ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"OrgCheckUtil_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "yhs": {
                return ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"OrgCheckUtil_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "fcscztdsys": {
                return ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"OrgCheckUtil_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "fcs": {
                return ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"OrgCheckUtil_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "cztdsys": {
                return ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"OrgCheckUtil_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "fjsf": {
                return ResManager.loadKDString((String)"\u9644\u52a0\u7a0e", (String)"OrgCheckUtil_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "tcvat": 
            case "zzs": {
                return ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"OrgCheckUtil_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "xfs": {
                return ResManager.loadKDString((String)"\u6d88\u8d39\u7a0e", (String)"OrgCheckUtil_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "szys": {
                return ResManager.loadKDString((String)"\u6c34\u8d44\u6e90\u7a0e", (String)"OrgCheckUtil_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "qtsf": {
                return ResManager.loadKDString((String)"\u5176\u4ed6\u7a0e\u8d39", (String)"OrgCheckUtil_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "hjbhs": {
                return ResManager.loadKDString((String)"\u73af\u5883\u4fdd\u62a4\u7a0e", (String)"OrgCheckUtil_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            case "ccs": {
                return ResManager.loadKDString((String)"\u8f66\u8239\u7a0e", (String)"OrgCheckUtil_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
        }
        return "xxxx";
    }

    public static boolean searchCheck(TreeNode node, IFormView view, boolean needErrorMsg) {
        String orgId = node.getId();
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            if (needErrorMsg) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            }
            return false;
        }
        String appid = view.getFormShowParameter().getAppId();
        TaxAppEnum taxEnum = TaxAppEnum.getEnumInstanceByAppid(appid);
        if (null == taxEnum) {
            return true;
        }
        if (needErrorMsg ? LicenseCheckServiceHelper.check(orgId, view, taxEnum.getAppid()) : LicenseCheckServiceHelper.check(orgId, null, taxEnum.getAppid())) {
            return false;
        }
        if (OrgCheckUtil.orgEnable(view, org, needErrorMsg)) {
            return false;
        }
        if (null != taxEnum.getCategoryCode()) {
            QFilter qFilter = null;
            if (!TaxAppEnum.TCRET.getAppid().equalsIgnoreCase(appid)) {
                qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)taxEnum.getCategoryCode());
            }
            QFilter taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
            DynamicObjectCollection list = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.name,taxorg.istaxpayer as isentity,categoryentryentity.taxpayertype,categoryentryentity.enable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), qFilter, taxationsys});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    if (needErrorMsg) {
                        view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dy.getString("orgid.name"), taxEnum.getName()));
                    }
                    return false;
                }
            } else {
                if (needErrorMsg) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean licenseCheckByAppid(TreeNode node, String appid) {
        String orgId = node.getId();
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"licenseCheckByAppid", (Object[])new Object[]{orgId, appid});
    }

    public static boolean withoutLicenseCheck(IFormView view, String orgId, String appid, String categoryType) {
        return OrgCheckUtil.withoutLicenseCheck(view, orgId, appid, categoryType, true);
    }

    public static boolean withoutLicenseCheck(IFormView view, String orgId, String appid, String categoryType, boolean needErrorMsg) {
        return OrgCheckUtil.checkOrgAndEnable(view, orgId, needErrorMsg) || OrgCheckUtil.checkTaxcMainEnable(view, orgId, needErrorMsg) || OrgCheckUtil.isTaxPayerAuth(view, orgId, needErrorMsg) || OrgCheckUtil.taxCategoryEnable(orgId, view, appid, categoryType, needErrorMsg);
    }

    public static boolean checkTaxcMainEnable(IFormView view, String orgId, boolean needErrorMsg) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData()).booleanValue()) {
            if (needErrorMsg) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"OrgCheckUtil_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            }
            return true;
        }
        return false;
    }

    public static boolean checkOrgAndEnable(IFormView view, String orgId) {
        return OrgCheckUtil.checkOrgAndEnable(view, orgId, true);
    }

    public static boolean checkOrgAndEnable(IFormView view, String orgId, boolean needErrorMsg) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        if (OrgCheckUtil.orgAuth(orgId, view, org, needErrorMsg)) {
            return true;
        }
        return OrgCheckUtil.orgEnable(view, org, needErrorMsg);
    }

    public static boolean isTaxPayerAuth(IFormView view, String orgId, boolean needErrorMsg) {
        Map map;
        String entityName = view.getEntityId();
        if (view instanceof ListView) {
            entityName = ((ListView)view).getBillFormId();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)(map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"isTaxPayerAuth", (Object[])new Object[]{orgId, entityName, needErrorMsg})).get("code")), (CharSequence)"true")) {
            if (needErrorMsg && null != view) {
                view.showErrorNotification((String)map.get("failInfo"));
            }
            return true;
        }
        return false;
    }

    public static boolean orgAuth(String orgId, IFormView view, DynamicObjectCollection org) {
        return OrgCheckUtil.orgAuth(orgId, view, org, true);
    }

    public static boolean orgAuth(String orgId, IFormView view, DynamicObjectCollection org, boolean needErrorMsg) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            if (needErrorMsg) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"OrgCheckUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            }
            return true;
        }
        return false;
    }

    public static boolean orgEnable(IFormView view, DynamicObjectCollection org, boolean needErrorMsg) {
        Map map;
        if (null != org && !org.isEmpty() && StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)(map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"orgEnable", (Object[])new Object[]{((DynamicObject)org.get(0)).getLong("id"), needErrorMsg})).get("code")), (CharSequence)"true")) {
            if (needErrorMsg && null != view) {
                view.showErrorNotification((String)map.get("failInfo"));
            }
            return true;
        }
        return false;
    }

    public static boolean orgEnable(IFormView view, Long orgId, boolean needErrorMsg) {
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"orgEnable", (Object[])new Object[]{orgId, needErrorMsg});
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)map.get("code")), (CharSequence)"true")) {
            if (needErrorMsg && null != view) {
                view.showErrorNotification((String)map.get("failInfo"));
            }
            return true;
        }
        return false;
    }

    public static boolean taxCategoryEnable(String orgId, IFormView view, String appid, String taxType, boolean needErrorMsg) {
        if (null != taxType) {
            String categoryent = OrgCheckUtil.getCategoryentName(taxType);
            String category = OrgCheckUtil.getCategory(taxType);
            QFilter qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)category);
            QFilter taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
            DynamicObjectCollection list = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.name,maincompany,categoryentryentity.taxpayertype,categoryentryentity.enable,categoryentryentity.fcsenable,categoryentryentity.cztdsysenable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), qFilter, taxationsys});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    if (needErrorMsg) {
                        view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    }
                    return true;
                }
                if ("fcs".equals(taxType) && Objects.equals("5", dy.getString("categoryentryentity.fcsenable"))) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    return true;
                }
                if ("cztdsys".equals(taxType) && Objects.equals("6", dy.getString("categoryentryentity.cztdsysenable"))) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    return true;
                }
            } else {
                if (needErrorMsg) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                }
                return true;
            }
        }
        return false;
    }

    private static String getCategory(String categoryType) {
        if ("fcs".equals(categoryType) || "cztdsys".equals(categoryType)) {
            return "fcscztdsys";
        }
        return categoryType;
    }

    public static DynamicObject getFJSFCategory(Long orgid) {
        DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype(orgid, "fjsf");
        if (category == null || Objects.equals("0", category.getString("enable"))) {
            return null;
        }
        return category;
    }

    public static String findTaxOrg(IFormView view, String orgField, IPageCache pageCache) {
        Long unitOrgId = RequestContext.get().getOrgId();
        TreeNode treeNode = new TreeNode();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(view);
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        pageCache.put("orgList", SerializationUtils.toJsonString((Object)col));
        if (!CollectionUtils.isEmpty((Collection)col)) {
            ArrayList<Long> orgids = new ArrayList<Long>(10);
            for (DynamicObject obj : col) {
                Long orgid = obj.getLong("id");
                treeNode.setId(String.valueOf(orgid));
                if (!OrgCheckUtil.searchCheck(treeNode, view, false)) continue;
                orgids.add(orgid);
                if (!unitOrgId.equals(orgid)) continue;
                return String.valueOf(orgid);
            }
            if (EmptyCheckUtils.isNotEmpty(orgids)) {
                return String.valueOf(orgids.get(0));
            }
        }
        return null;
    }

    public static String findTaxOrg(IFormView view, IPageCache pageCache) {
        Long unitOrgId = RequestContext.get().getOrgId();
        TreeNode treeNode = new TreeNode();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(view);
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        pageCache.put("orgList", SerializationUtils.toJsonString((Object)col));
        if (!CollectionUtils.isEmpty((Collection)col)) {
            for (DynamicObject obj : col) {
                if (!unitOrgId.equals(obj.getLong("id"))) continue;
                treeNode.setId(String.valueOf(unitOrgId));
                break;
            }
            if (treeNode.getId().length() == 0) {
                treeNode.setId(((DynamicObject)col.get(0)).getString("id"));
            }
            return OrgCheckUtil.searchCheck(treeNode, view, false) ? null : treeNode.getId();
        }
        view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        return null;
    }

    public static boolean checkRelation(Long accountOrg, Date startDate, Date endDate) {
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"checkRelation", (Object[])new Object[]{accountOrg, startDate, endDate});
    }

    public static DynamicObject getTaxOrgInfo(Long accountOrg, Date startDate, Date endDate) {
        return OrgCheckUtil.getTaxOrgInfo(accountOrg, startDate);
    }

    public static DynamicObject getTaxOrgInfo(Long accountOrg, Date startDate) {
        List<Long> taxOrgByAccountingOrg = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrg(accountOrg, startDate);
        if (taxOrgByAccountingOrg.size() == 0) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)TCTB_ORG_TAKEDATA);
        DynamicObject orgStructure = new DynamicObject((DynamicObjectType)entityType);
        orgStructure.set("taxorg", (Object)taxOrgByAccountingOrg.get(0));
        return orgStructure;
    }

    public static DynamicObject getTaxOrgNsrxx(Long accountOrg, Date startDate, Date endDate, String appid) {
        DynamicObject taxOrg = OrgCheckUtil.getTaxOrgInfo(accountOrg, startDate, endDate);
        if (null == taxOrg) {
            return null;
        }
        TaxAppEnum taxEnum = TaxAppEnum.getEnumInstanceByAppid(appid);
        return TaxBaseDataUtils.queryCategoryByTaxtype(taxOrg.getLong("taxorg"), taxEnum.getCategoryCode());
    }

    public static boolean isTaxPayer(Long orgid) {
        QFilter qFilter = new QFilter("istaxpayer", "=", (Object)Boolean.TRUE);
        QFilter qFilter2 = new QFilter("org", "=", (Object)orgid);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{qFilter, qFilter2});
        return EmptyCheckUtils.isNotEmpty(dynamicObjects);
    }

    public static boolean draftLicenseCheck(IFormView view, String orgId, String appId, String type) {
        LicenseCheckResult result = LicenseCheckServiceHelper.checkTxftPerformGroup("tcdrs");
        Boolean hasLicense = result.getHasLicense();
        if (!hasLicense.booleanValue()) {
            view.showErrorNotification(result.getMsg());
        }
        return hasLicense == false;
    }

    public static boolean zeroDeclareCheck(IFormView view, String orgId, String appId, String type) {
        boolean isLogout = LicenseCheckServiceHelper.checkOrgIsLogout(Long.parseLong(orgId), view);
        boolean isEnable = OrgCheckUtil.withoutLicenseCheck(view, orgId, appId, type);
        return isLogout || isEnable;
    }

    public static List<Long> hasPermOrgList(HasPermOrgResult hasPermOrgs) {
        List hasPermOrgList = hasPermOrgs.getHasPermOrgs();
        if (hasPermOrgs.hasAllOrgPerm()) {
            DynamicObjectCollection orgLists = TreeUtils.getOrgLists();
            if (orgLists.isEmpty()) {
                return hasPermOrgList;
            }
            hasPermOrgList = orgLists.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        }
        return hasPermOrgList;
    }
}

