/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.tctb.common.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import org.apache.commons.lang3.ObjectUtils;

public class OrgUtils {
    private static Comparator<Object> CHINA_COMPARATOR;
    private static final boolean DISABLED_FILTER = true;
    public static final String FORM_ORG_GROUP = "tctb_org_group_latest";
    public static final String TCCIT_NSSB_POLICY = "tccit_seasonal_policy";
    public static final String FORM_ORG = "tctb_org_entity";
    public static final String FORM_ORG_GROUP_ENTRY = "orgrow";
    private static final String FIELD_EFFECTDATE = "effectdate";
    private static final String FIELD_INVALIDDATE = "invaliddate";
    public static final Set<String> MUST_IS_TAXPAYER;
    public static Set<String> TCVAT_RULE_NEED_CUSTOM_PLUGIN;
    private static final String BASTAX_TAXORG = "bastax_taxorg";

    public static Boolean checkOrgDeclaration(Long orgid, Date startDate, Date endDate, String declaration) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter summaryorgtype = new QFilter("summaryorgtype", "=", (Object)"1");
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter q3 = new QFilter("orgrow.declaration", "=", (Object)declaration);
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        return QueryServiceHelper.exists((String)FORM_ORG_GROUP, (QFilter[])new QFilter[]{statusFilter, summaryorgtype, q1, q2, q3, q4, q5});
    }

    public static String getOrgGroupDeclaration(Long orgid, String taxtype, Date startDate, Date endDate) {
        QFilter q1 = new QFilter("status", "=", (Object)"2");
        QFilter q2 = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter q3 = new QFilter("taxtype", "=", (Object)taxtype);
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        QFilter q7 = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject object = QueryServiceHelper.queryOne((String)FORM_ORG_GROUP, (String)"orgrow.declaration as declaration", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q7});
        if (object != null) {
            return object.getString("declaration");
        }
        return "1";
    }

    public static Map<Long, String> getOrgGroupDeclaration(List<Long> orgList, String taxtype, Date startDate, Date endDate) {
        QFilter q1 = new QFilter("status", "=", (Object)"2");
        QFilter q2 = new QFilter("orgrow.orgid", "in", orgList);
        QFilter q3 = new QFilter("taxtype", "=", (Object)taxtype);
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        QFilter q6 = new QFilter("status", "=", (Object)"2");
        QFilter q7 = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)"orgrow.orgid as orgid,orgrow.declaration as declaration", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        HashMap<Long, String> declarationMap = new HashMap<Long, String>(collection.size());
        for (DynamicObject object : collection) {
            declarationMap.put(object.getLong("orgid"), object.getString("declaration"));
        }
        return declarationMap;
    }

    public static List<Long> getOrgGroupDetails(Long orgid, String taxtype, Date startDate, Date endDate) {
        QFilter q1 = new QFilter("status", "=", (Object)"2");
        QFilter q2 = new QFilter("orgrow.collectorg", "=", (Object)String.valueOf(orgid));
        QFilter q3 = new QFilter("taxtype", "=", (Object)taxtype);
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)"orgrow.orgid as orgid", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        return dynamicObjects.stream().map(d -> d.getLong("orgid")).collect(Collectors.toList());
    }

    public static List<Long> getAuditOrgGroupDetails(Long orgid, String taxtype, Date startDate, Date endDate) {
        QFilter q1 = new QFilter("status", "=", (Object)"2");
        QFilter q2 = new QFilter("orgrow.collectorg", "=", (Object)String.valueOf(orgid));
        QFilter q3 = new QFilter("taxtype", "=", (Object)taxtype);
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        QFilter q7 = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)"orgrow.orgid as orgid", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        return dynamicObjects.stream().map(d -> d.getLong("orgid")).collect(Collectors.toList());
    }

    public static List<Long> filterOrgGroupSubOrg(List<Long> orgIds, String taxtype, Date startDate, Date endDate) {
        QFilter q0 = new QFilter("orgrow.declaration", "=", (Object)"3");
        QFilter q1 = new QFilter("orgrow.orgid", "in", orgIds);
        QFilter q2 = new QFilter("taxtype", "=", (Object)taxtype);
        QFilter q6 = new QFilter("status", "=", (Object)"2");
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        QFilter q7 = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)"orgrow.orgid as orgid", (QFilter[])new QFilter[]{q0, q1, q2, q4, q5, q7});
        return dynamicObjects.stream().map(d -> d.getLong("orgid")).collect(Collectors.toList());
    }

    public static DynamicObject getOrgDeclarePlan(Long orgid, Date startDate, Date endDate) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        QFilter q7 = new QFilter("billstatus", "=", (Object)"C");
        return BusinessDataServiceHelper.loadSingle((String)FORM_ORG_GROUP, (String)"id, summaryorgtype,prelevyrate, summaryway,orgrow.levelname,orgrow.orgid,orgrow.orgname,orgrow.declaration,orgrow.parentid,orgrow.collectorg,orgrow.issuesbb", (QFilter[])new QFilter[]{statusFilter, q1, q2, q4, q5, q7});
    }

    public static StringBuilder getfzybqyMessage(String type, String orgid, String skssqq, String skssqz, StringBuilder message) {
        if (!"zzsybnsr_ybhz".equals(type)) {
            return message;
        }
        DynamicObject orgDeclarePlan = OrgUtils.getOrgDeclarePlan(Long.valueOf(orgid), DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz));
        if (null == orgDeclarePlan) {
            return message;
        }
        DynamicObjectCollection orgrow = orgDeclarePlan.getDynamicObjectCollection(FORM_ORG_GROUP_ENTRY);
        String declareType = null;
        String hzOrgName = "";
        String currentOrgName = "";
        for (DynamicObject object : orgrow) {
            if (orgid.equals(object.getDynamicObject("orgid").getString("id"))) {
                declareType = object.getString("declaration");
                currentOrgName = object.getString("orgname");
            }
            if (!"2".equals(object.getString("declaration"))) continue;
            hzOrgName = object.getString("orgname");
        }
        if ("3".equals(declareType)) {
            message.append(String.format(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u3010%1$s\u3011\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u3010%2$s\u3011\u7a0e\u52a1\u7ec4\u7ec7\u7684\u88ab\u6c47\u603b\u7ec4\u7ec7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed?", (String)"OrgUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), currentOrgName, hzOrgName)).append("\r\n");
        }
        return message;
    }

    public static void buildOrgGroupDetailTree(IFormView view, TreeView treeView, IPageCache pageCache, String type) {
        OrgUtils.buildOrgGroupDetailTree(view, treeView, pageCache, Boolean.TRUE, type);
    }

    public static void buildOrgGroupDetailTree(IFormView view, TreeView treeView, IPageCache pageCache, Boolean checkFirst, String type) {
        List<TreeNode> nodeList = OrgUtils.getOrgGroupAllNodeList(type);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            ArrayList<TreeNode> nodeList2 = new ArrayList<TreeNode>();
            for (TreeNode node : nodeList) {
                if (!hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(node.getId()))) continue;
                nodeList2.add(node);
            }
            if (nodeList.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u7ec4\u7ec7\u4e2d\u5f15\u5165\u7ec4\u7ec7", (String)"OrgUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (!nodeList.isEmpty() && nodeList2.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bf9\u7ec4\u7ec7\u6388\u6743", (String)"OrgUtils_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            TreeUtils.build(treeView, nodeList2, pageCache, true);
        } else {
            TreeUtils.build(treeView, nodeList, pageCache, true);
        }
        if (checkFirst.booleanValue()) {
            TreeUtils.checkFirstNode(pageCache, treeView);
        }
    }

    public static void buildOrgTree(IFormView view, TreeView treeView, IPageCache pageCache) {
        List<TreeNode> nodeList = OrgUtils.getOrgNodeList();
        if (nodeList.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u7ec4\u7ec7\u4e2d\u5f15\u5165\u7ec4\u7ec7", (String)"OrgUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        TreeUtils.build(treeView, nodeList, pageCache, true);
    }

    public static List<TreeNode> getOrgNodeList() {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection collection = TreeUtils.getOrgLists();
        if (collection != null) {
            for (DynamicObject entry : collection) {
                String orgId = entry.getString("id");
                String orgName = entry.getString("name");
                String parentid = entry.getString("parentid");
                String status = entry.getString("status");
                TreeNode leftRoot = new TreeNode();
                leftRoot.setParentid(parentid);
                leftRoot.setId(orgId);
                leftRoot.setText(orgName);
                leftRoot.setType(status);
                HashMap<String, String> data = new HashMap<String, String>(8);
                data.put("number", entry.getString("number").toLowerCase());
                leftRoot.setData(data);
                nodeList.add(leftRoot);
            }
        }
        return nodeList;
    }

    public static List<TreeNode> getAllPermNodes(String appNumber, String entityId, String type) {
        String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getAllPermNodes", (Object[])new Object[]{appNumber, entityId, type});
        List list = SerializationUtils.fromJsonStringToList((String)result, TreeNode.class);
        return list;
    }

    public static List<TreeNode> getOrgGroupAllNodeList(String type) {
        List<TreeNode> nodeList = OrgUtils.getOrgGroupDetailNodeList(type);
        Map<String, String> orgMap = OrgUtils.queryOrgMap();
        for (TreeNode node : nodeList) {
            if ("2".endsWith(node.getType())) continue;
            orgMap.remove(node.getId());
        }
        ArrayList<TreeNode> nodeList2 = new ArrayList<TreeNode>(orgMap.size());
        for (Map.Entry<String, String> entry : orgMap.entrySet()) {
            TreeNode node = new TreeNode();
            node.setId(entry.getKey());
            node.setText(entry.getValue());
            nodeList2.add(node);
        }
        return nodeList2;
    }

    public static List<TreeNode> getOrgGroupDetailNodeList(String type) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection collection = OrgUtils.queryOrgGroupDetailList(type);
        if (collection != null) {
            for (DynamicObject entry : collection) {
                String orgId = entry.getString("orgid");
                String orgName = entry.getString("orgname");
                String parentid = entry.getString("parentid");
                String declaration = entry.getString("declaration");
                TreeNode leftRoot = new TreeNode();
                leftRoot.setParentid(parentid);
                leftRoot.setId(orgId);
                leftRoot.setText(orgName);
                leftRoot.setType(declaration);
                nodeList.add(leftRoot);
            }
        }
        return nodeList;
    }

    public static DynamicObjectCollection queryOrgGroupDetailList(String type) {
        String fields = "id,status,number,name,orgrow.orgid as orgid,orgrow.orgcode as orgcode,orgrow.orgname as orgname,orgrow.parentid as parentid,orgrow.declaration as declaration";
        Date now = new Date();
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter filteType = new QFilter("taxtype", "=", (Object)type);
        QFilter[] filters = new QFilter[]{statusFilter, filteType, OrgUtils.getQFilter(now)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)fields, (QFilter[])filters);
        return collection;
    }

    public static DynamicObjectCollection queryOrgGroupDetailForCollected(String type) {
        String fields = "orgrow.orgid as orgid";
        Date now = new Date();
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter typeFilter = new QFilter("taxtype", "=", (Object)type);
        QFilter declaration = new QFilter("orgrow.declaration", "=", (Object)"3");
        QFilter[] filters = new QFilter[]{statusFilter, typeFilter, declaration, OrgUtils.getQFilter(now)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)fields, (QFilter[])filters);
        return collection;
    }

    public static DynamicObjectCollection queryOrgGroupDetailForCollectedOrg(String type, String orgid, String enddate) {
        String fields = "orgrow.orgid as orgid, orgrow.declaration as declaration,orgrow.levelname as levelname,orgrow.issuesbb as issuesbb";
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter typeFilter = new QFilter("taxtype", "=", (Object)type);
        QFilter collectorg = new QFilter("orgrow.collectorg", "=", (Object)orgid);
        QFilter[] filters = new QFilter[]{statusFilter, typeFilter, collectorg, OrgUtils.getQFilter(DateUtils.stringToDate(enddate))};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)fields, (QFilter[])filters, (String)"orgrow.declaration asc");
        return collection;
    }

    public static String queryOrgGroupDetailForAggregator(String type, String shareid, String orgid, Date startdate, Date enddate) {
        return (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"queryOrgGroupDetailForAggregator", (Object[])new Object[]{type, shareid, orgid, startdate, enddate});
    }

    public static Map<String, String> queryOrgMap() {
        DynamicObjectCollection collection = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("status", "1"));
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (DynamicObject obj : collection) {
            map.put(obj.getString("id"), obj.getString("name"));
        }
        return map;
    }

    public static String getOrgNameById(String orgid) {
        return (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getOrgNameById", (Object[])new Object[]{orgid});
    }

    public static String getOrgStatusById(String orgid) {
        return (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getOrgStatusById", (Object[])new Object[]{orgid});
    }

    public static Long getDefaultViewSchemaInfoId() {
        return (Long)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getDefaultViewSchemaInfoId", (Object[])new Object[0]);
    }

    public static QFilter[] getDefaultViewSchemaQFilter() {
        QFilter f = new QFilter("isdefault", "=", (Object)"1");
        QFilter qf = new QFilter("treetype", "=", (Object)"40");
        return new QFilter[]{f, qf};
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId) {
        return OrgUtils.getAllOrgByViewId(orgViewSchemaId, null);
    }

    public static List<Map<String, Object>> getOrglists() {
        List list = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getOrgLists", (Object[])new Object[0]);
        return list;
    }

    public static List<Long> getOrgIdlists() {
        List list = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getOrgLists", (Object[])new Object[0]);
        return list != null ? list.stream().map(a -> Long.valueOf(a.get("id").toString())).collect(Collectors.toList()) : new ArrayList<Long>(0);
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId, QFilter qFilter) {
        HashMap<String, Map<String, String>> map = new HashMap();
        String qFilterJson = null;
        if (null != qFilter) {
            qFilterJson = SerializationUtils.toJsonString((Object)qFilter);
        }
        String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getAllOrgByViewId", (Object[])new Object[]{orgViewSchemaId, qFilterJson});
        map = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        return map;
    }

    public static Map<String, DynamicObject> getAllOrgByView(Long orgViewSchemaId, QFilter qFilter) {
        QFilter orgIdFilter;
        DynamicObject[] ordDynamicObjects;
        List ids;
        HashMap<String, DynamicObject> orgTreeMap = new HashMap<String, DynamicObject>();
        String qFilterJson = null;
        if (null != qFilter) {
            qFilterJson = SerializationUtils.toJsonString((Object)qFilter);
        }
        if (ObjectUtils.isNotEmpty((Object)(ids = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getAllOrgByView", (Object[])new Object[]{orgViewSchemaId, qFilterJson}))) && Objects.nonNull(ordDynamicObjects = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,uniformsocialcreditcode,orgpattern,registeredcapital,establishmentdate,frepresentative", (QFilter[])new QFilter[]{orgIdFilter = new QFilter("id", "in", (Object)ids)})) && ordDynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : ordDynamicObjects) {
                String orgId = dynamicObject.getString("id");
                orgTreeMap.put(orgId, dynamicObject);
            }
        }
        return orgTreeMap;
    }

    public static Map<String, List<Map<String, String>>> getOrgTreeMap(Map<String, Map<String, String>> orgMap) {
        HashMap<String, List<Map<String, String>>> orgTreeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map.Entry<String, Map<String, String>> orgId : orgMap.entrySet()) {
            OrgUtils.buildOrgTree(orgId.getValue(), orgMap, orgTreeMap);
        }
        return orgTreeMap;
    }

    public static void buildOrgTree(Map<String, String> org, Map<String, Map<String, String>> orgMap, Map<String, List<Map<String, String>>> orgTreeMap) {
        List<Map<String, String>> parentList;
        String orgid = org.get("id");
        if (orgid == null || orgid.equalsIgnoreCase("0")) {
            return;
        }
        String parentid = org.get("parentid");
        Map<String, String> parentOrg = orgMap.get(parentid);
        if (orgTreeMap.get(orgid) == null) {
            orgTreeMap.put(orgid, new ArrayList());
        }
        if (parentOrg == null) {
            return;
        }
        if (orgTreeMap.get(parentid) == null) {
            OrgUtils.buildOrgTree(parentOrg, orgMap, orgTreeMap);
        }
        if ((parentList = orgTreeMap.get(parentid)) == null) {
            return;
        }
        if (!parentList.contains(org)) {
            parentList.add(org);
        }
    }

    public static TreeNode createTreeNode(Map<String, Map<String, String>> orgTreeMap) {
        Map<String, Map> rootIdMap = orgTreeMap.entrySet().stream().filter(v -> "0".equals(((Map)v.getValue()).get("parentid"))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Map)e.getValue()));
        Set<String> rootIdSet = rootIdMap.keySet();
        if (rootIdSet.isEmpty()) {
            return null;
        }
        String rootId = rootIdSet.toArray(new String[0])[0];
        String rootName = orgTreeMap.get(rootId).get("name");
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootId);
        root.setText(rootName);
        root.setIsOpened(true);
        root.setLongNumber(orgTreeMap.get(rootId).get("longnumber"));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", rootName);
        root.setData(dataMap);
        return root;
    }

    public static TreeNode createChildNodes(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode root) {
        if (orgTreeMap == null || rootId == null || orgTreeMap.size() == 0 || root == null) {
            return null;
        }
        OrgUtils.buildTreeNode(orgTreeMap, rootId, root);
        return root;
    }

    public static void buildTreeNode(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode treeNode) {
        List<Map<String, String>> childList = orgTreeMap.get(rootId);
        HashMap dataMap = (HashMap)treeNode.getData();
        if (childList == null || childList.size() == 0) {
            dataMap.put("isleaf", "1");
            return;
        }
        String parentLongNumber = treeNode.getLongNumber();
        int parentLevel = Integer.parseInt((String)dataMap.get("level"));
        String parentName = (String)dataMap.get("fullname");
        for (Map<String, String> org : childList) {
            TreeNode childrenTree = new TreeNode();
            String orgid = org.get("id");
            if ("0".equals(orgid) || StringUtils.isEmpty((CharSequence)org.get("name"))) continue;
            childrenTree.setParentid(org.get("parentid"));
            childrenTree.setId(orgid);
            childrenTree.setText(org.get("name"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(parentLongNumber + "!" + orgid);
            HashMap<String, String> childDataMap = new HashMap<String, String>();
            childDataMap.put("isleaf", "0");
            childDataMap.put("level", String.valueOf(parentLevel + 1));
            childDataMap.put("fullname", parentName + "_" + org.get("name"));
            childrenTree.setData(childDataMap);
            treeNode.addChild(childrenTree);
            OrgUtils.buildTreeNode(orgTreeMap, orgid, childrenTree);
        }
        OrgUtils.sortTreeNode(treeNode.getChildren());
    }

    public static void sortTreeNode(List<TreeNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            Collections.sort(nodes, (node1, node2) -> CHINA_COMPARATOR.compare(node1.getText(), node2.getText()));
        }
    }

    public static TreeNode getTreeNodeById(String nodeId, TreeNode unitTreeNode) {
        int j = unitTreeNode.getNodeLevel(nodeId, 0);
        return unitTreeNode.getTreeNode(nodeId, j);
    }

    public static List<TreeNode> buildTreeNodeByList(TreeNode parentTreeNode, List<Map<String, Object>> leftNodes) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(leftNodes.size());
        HashMap parentData = (HashMap)parentTreeNode.getData();
        for (Map<String, Object> treeNode : leftNodes) {
            if (parentTreeNode.getId().equals(treeNode.get("id"))) continue;
            TreeNode childrenTree = new TreeNode();
            childrenTree.setParentid(parentTreeNode.getId());
            childrenTree.setId((String)treeNode.get("id"));
            childrenTree.setText((String)treeNode.get("text"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(parentTreeNode.getLongNumber() + "!" + treeNode.get("id"));
            HashMap<String, String> childDataMap = new HashMap<String, String>();
            childDataMap.put("isleaf", "1");
            int level = Integer.parseInt((String)parentData.get("level")) + 1;
            childDataMap.put("level", String.valueOf(level));
            childDataMap.put("fullname", parentTreeNode.getText() + "_" + treeNode.get("text"));
            childrenTree.setData(childDataMap);
            treeNodes.add(childrenTree);
        }
        return treeNodes;
    }

    public static Long getLocalDefaultViewId() {
        return (Long)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getLocalDefaultViewId", (Object[])new Object[0]);
    }

    public static QFilter getQFilter(Date enddate) {
        QFilter q = new QFilter(FIELD_EFFECTDATE, "<=", (Object)DateUtils.getLastDateOfMonth1(enddate)).and(FIELD_INVALIDDATE, ">=", (Object)DateUtils.getLastDateOfMonth1(enddate));
        q = q.or(new QFilter(FIELD_EFFECTDATE, "<=", (Object)DateUtils.getLastDateOfMonth1(enddate)).and(QFilter.isNull((String)FIELD_INVALIDDATE)));
        return q;
    }

    public static final List<String> getOrgIdByStructurePkids(List<String> structureIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", structureIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()))});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("org")).collect(Collectors.toList());
    }

    public static final List<String> getStructurePkidsByOrgId(List<String> orgIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"id", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList())), OrgUtils.getDefaultTaxOrgStructureViewQfilter()});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("id")).distinct().collect(Collectors.toList());
    }

    public static List<Long> mergeOrgIds(List<Long> idList, String status) {
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"mergeOrgIds", (Object[])new Object[]{idList, status});
    }

    public static List<Long> queryTaxOrgListByStatus(String status) {
        QFilter statusFilter = new QFilter("status", "=", (Object)status);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"org.id as orgid", (QFilter[])new QFilter[]{statusFilter});
        List<Long> orgList = collection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        return orgList;
    }

    public static void addFilterByConditionBeforeF7Select(Object event, IFormView view, String[] excludeFormArray, String permissionEntiyId, String permissionConstant) {
        if (BeforeF7SelectEvent.class.isAssignableFrom(event.getClass())) {
            BeforeF7SelectEvent beforeF7SelectEvent = (BeforeF7SelectEvent)event;
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
            formShowParameter.getCustomParams().put("orgFuncId", "40");
            if (TCVAT_RULE_NEED_CUSTOM_PLUGIN.contains(PageShowCommon.getMetadataNumberByView(view))) {
                formShowParameter.addCustPlugin("kd.taxc.bdtaxr.common.plugin.OrgF7CustomPlugin");
                formShowParameter.setAppId("tcvat");
                formShowParameter.getCustomParams().put("ServiceAppId", "tcvat");
            }
            List<Long> orgList = new ArrayList<Long>();
            if (MUST_IS_TAXPAYER.contains(PageShowCommon.getMetadataNumberByView(view))) {
                List<Long> notTaxPayerOrgList = OrgUtils.filterByIsTaxpayer(Boolean.FALSE);
                orgList.addAll(notTaxPayerOrgList);
                orgList = orgList.stream().distinct().collect(Collectors.toList());
            }
            QFilter idsFilter = new QFilter("id", "not in", orgList);
            TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIds();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", listTaxResult.getData()));
            formShowParameter.getListFilterParameter().getQFilters().add(idsFilter);
        }
        if (BeforeFilterF7SelectEvent.class.isAssignableFrom(event.getClass())) {
            QFilter idsFilter;
            HasPermOrgResult permOrgResult;
            BeforeFilterF7SelectEvent beforeFilterF7SelectEvent = (BeforeFilterF7SelectEvent)event;
            List<Long> orgList = new ArrayList<Long>();
            if (ReportView.class.isAssignableFrom(view.getClass()) && EmptyCheckUtils.isNotEmpty(permOrgResult = PermissionUtils.getAllPermOrgs(view)) && !permOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty(permOrgResult.getHasPermOrgs())) {
                orgList = permOrgResult.getHasPermOrgs();
            }
            if (EmptyCheckUtils.isNotEmpty(excludeFormArray) && Arrays.stream(excludeFormArray).anyMatch(v -> v.equals(PageShowCommon.getMetadataNumberByView(view)))) {
                orgList = ReportView.class.isAssignableFrom(view.getClass()) ? OrgUtils.mergeOrgIds(orgList, "3") : OrgUtils.queryTaxOrgListByStatus("0");
            } else {
                QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
                beforeFilterF7SelectEvent.getCustomQFilters().add(statusFilter);
            }
            if (ReportView.class.isAssignableFrom(view.getClass())) {
                idsFilter = new QFilter("id", "in", orgList);
                beforeFilterF7SelectEvent.getCustomQFilters().add(idsFilter);
            } else {
                idsFilter = new QFilter("id", "not in", orgList);
                beforeFilterF7SelectEvent.getCustomQFilters().add(idsFilter);
            }
        }
    }

    public static void listFilterByIsTaxpayerAndEnableAndAudit(BeforeFilterF7SelectEvent args) {
        BeforeFilterF7SelectEvent beforeFilterF7SelectEvent = args;
        List<Long> orgList = new ArrayList<Long>();
        List<Long> notTaxPayerOrgList = OrgUtils.filterByIsTaxpayer(Boolean.FALSE);
        orgList.addAll(notTaxPayerOrgList);
        orgList = orgList.stream().distinct().collect(Collectors.toList());
        QFilter idsFilter = new QFilter("id", "not in", orgList);
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIds();
        beforeFilterF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", listTaxResult.getData()));
        beforeFilterF7SelectEvent.getCustomQFilters().add(idsFilter);
    }

    private static List<Long> filterByIsTaxpayer(Boolean istaxpayer) {
        DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"org.id as id", (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)istaxpayer)});
        return CollectionUtils.isEmpty((Collection)taxOrgs) ? new ArrayList<Long>() : taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    private static List<Long> excludeByTaxPayer(List<Long> orgList) {
        List<Long> orgIds = OrgUtils.filterByIsTaxpayer(Boolean.FALSE);
        orgList.removeIf(s -> orgIds.contains(s));
        return orgList;
    }

    public static List<Map<String, String>> queryOrgListForInitOrgComboItems(IFormView view, String[] excludeFormArray, String permissionEntiyId, String permissionConstant) {
        DynamicObjectCollection collection;
        ArrayList<Map<String, String>> orgItems = new ArrayList<Map<String, String>>();
        HasPermOrgResult hasPermOrgResult = StringUtils.isBlank((CharSequence)permissionEntiyId) ? PermissionUtils.getAllPermOrgs(view) : PermissionUtils.getAllPermOrgs(view, permissionEntiyId, permissionConstant);
        if (EmptyCheckUtils.isNotEmpty(hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            List<Long> orgList = hasPermOrgResult.getHasPermOrgs();
            HashMap<String, List<Object>> convertParam = new HashMap<String, List<Object>>(2);
            if (EmptyCheckUtils.isNotEmpty(excludeFormArray) && Arrays.stream(excludeFormArray).anyMatch(v -> v.equals(PageShowCommon.getMetadataNumberByView(view)))) {
                orgList = OrgUtils.mergeOrgIds(orgList, "3");
            }
            TreeUtils.convertParam("id", orgList, convertParam);
            collection = TreeUtils.queryOrgListByCondition(convertParam);
        } else {
            collection = TreeUtils.getOrgLists();
        }
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            collection.stream().forEach(v -> {
                HashMap<String, String> item = new HashMap<String, String>(16);
                item.put("id", v.getString("id"));
                item.put("number", v.getString("number"));
                item.put("name", v.getString("name"));
                item.put("parentid", v.getString("parentid"));
                item.put("status", v.getString("status"));
                item.put("longnumber", v.getString("longnumber"));
                orgItems.add(item);
            });
        }
        return orgItems;
    }

    public static List<ComboItem> getComboItems(List<Map<String, String>> orgList) {
        String orgID = String.valueOf(RequestContext.get().getOrgId());
        int index = -1;
        int orgIndex = -1;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(orgList.size());
        for (Map<String, String> map : orgList) {
            ++index;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(map.get("name")));
            item.setValue(map.get("id"));
            combos.add(item);
            if (!orgID.equals(item.getValue())) continue;
            orgIndex = index;
        }
        if (orgIndex > 0) {
            Collections.swap(combos, 0, orgIndex);
        }
        return combos;
    }

    public static QFilter getDefaultTaxOrgStructureViewQfilter() {
        return new QFilter("view.treetype", "=", (Object)String.valueOf(OrgUtils.getDefaultViewSchemaInfoId())).and("view.number", "=", (Object)"40");
    }

    public static DynamicObjectCollection queryEnableOrgs(String selectFields, QFilter filter) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        String filterJson = StringUtils.isNotBlank((Object)filter) ? SerializationUtils.toJsonString((Object)filter) : null;
        List list = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"queryEnableOrgs", (Object[])new Object[]{selectFields, filterJson});
        list.stream().forEach(map -> {
            DynamicObject row = BusinessDataServiceHelper.newDynamicObject((String)BASTAX_TAXORG);
            DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
            map.keySet().stream().forEach(key -> row.set(key, map.get(key)));
            collection.add((Object)row);
        });
        return collection;
    }

    public static DynamicObjectCollection queryTaxOrg(String selectFields, QFilter filter) {
        DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)"tctb_tax_main", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return taxOrgs;
    }

    static {
        MUST_IS_TAXPAYER = new HashSet<String>(Arrays.asList("tccit_seasonal_declare", "tccit_seasonal_declare2", "tccit_mainpage", "tccit_newmainpage", "tcvat_draft_page", "tcvat_draft_page_sjjt", "tcnfep_withhold_remit", "tcvat_declare_home", "tcvat_declare_edit", "tcret_pbt_declare_home", "tcret_generate_sbb", "tcct_draft_edit", "tcct_declare_new", "tcvat_apphome", "tccit_apphome", "tcret_apphome_new", "tcct_apphome", "tsate_declare_config", "tcnfep_dkdj_declare", "tcnfep_kjqysds_declare", "totf_ghjfsljs_declare", "totf_tyfsssr_declare", "totf_whsyjsf_declare", "tam_hand_add", "tcret_wp_declare", "tcret_yj_declare", "tcret_qs_declare", "itp_papers_edit", "itp_accrual_declare_than", "tcvat_ncp_draft_main", "tcvat_jzjt_product", "tcvat_fdc_xsqr_tz", "tcvat_fdc_djdjxx_tz", "tdm_develop_land_info"));
        TCVAT_RULE_NEED_CUSTOM_PLUGIN = new HashSet<String>(Arrays.asList("tcvat_rule_deduct", "tcvat_rule_rollout", "tcvat_rule_perpre", "tcvat_rule_mdts", "tcvat_rule_apportion", "tcvat_rule_wkpsr", "tcvat_ncp_product_rule", "tcvat_ncp_rule", "tcvat_rule_refund", "tcvat_rule_incomeproject", "tcvat_rule_outputproject"));
        CHINA_COMPARATOR = Collator.getInstance(Locale.CHINA);
    }
}

