/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.tctb.common.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import org.apache.commons.lang3.StringUtils;

public class TreeUtils {
    private static final String SEPARATOR = ",";
    private static Log logger = LogFactory.getLog(TreeUtils.class);
    public static final String DEFAULT_ROOT_ID = "-1";
    private static final String LEVEL = "level";

    public static void expandAll(TreeView treeView, TreeNode treeNode) {
        if (treeNode != null) {
            if (treeNode.getChildren() != null) {
                treeNode.setIsOpened(true);
                TreeUtils.expandChild(treeView, treeNode, 10);
            }
            treeView.deleteNode(treeNode.getId());
            treeView.addNode(treeNode);
        }
    }

    public static void expand(TreeView treeView, IPageCache pageCache, int expendLevel) {
        TreeNode treeNode = TreeUtils.getCache(pageCache, treeView.getKey(), TreeNode.class);
        if (treeNode != null && treeNode.getChildren() != null) {
            if (DEFAULT_ROOT_ID.equals(treeNode.getId())) {
                for (TreeNode node : treeNode.getChildren()) {
                    if (node.getChildren() != null) {
                        node.setIsOpened(true);
                        TreeUtils.expandChild(treeView, node, expendLevel);
                    }
                    treeView.deleteNode(node.getId());
                    treeView.addNode(node);
                }
            } else {
                if (treeNode.getChildren() != null) {
                    treeNode.setIsOpened(true);
                    TreeUtils.expandChild(treeView, treeNode, expendLevel);
                }
                treeView.deleteNode(treeNode.getId());
                treeView.addNode(treeNode);
            }
        }
    }

    public static void expandChild(final TreeView treeView, TreeNode treeNode, final int expendLevel) {
        if (treeNode != null) {
            Map data = (Map)treeNode.getData();
            int currentLevel = 0;
            if (data != null) {
                currentLevel = Integer.parseInt(data.getOrDefault(LEVEL, "0"));
            }
            if (currentLevel < expendLevel) {
                treeNode.getChildren().forEach(new Consumer<TreeNode>(){

                    @Override
                    public void accept(TreeNode t) {
                        if (t.getChildren() != null) {
                            t.setIsOpened(true);
                            TreeUtils.expandChild(treeView, t, expendLevel);
                        }
                    }
                });
            }
        }
    }

    public static void putCache(IPageCache pageCache, String cacheName, Object cacheObj) {
        if (cacheObj != null) {
            pageCache.put(cacheName, SerializationUtils.toJsonString((Object)cacheObj));
        }
    }

    public static void removeCache(IPageCache pageCache, String cacheName) {
        pageCache.remove(cacheName);
    }

    public static <T> T getCache(IPageCache pageCache, String cacheName, Class<T> dstClazz) {
        String cacheStr = pageCache.get(cacheName);
        if (StringUtils.isNotEmpty((CharSequence)cacheStr)) {
            Object dstObject = SerializationUtils.fromJsonString((String)cacheStr, dstClazz);
            return (T)dstObject;
        }
        return null;
    }

    public static void build(TreeView treeView, List<TreeNode> treeNodes, IPageCache pageCache, boolean expand) {
        List<TreeNode> roots = TreeUtils.findRoot(treeNodes);
        for (TreeNode root : roots) {
            root.setLongNumber(root.getId());
            TreeUtils.findChildren(root, treeNodes, TreeUtils.getSonItems(root, treeNodes));
            treeView.addNode(root);
            if (!expand) continue;
            TreeUtils.expandAll(treeView, root);
        }
        if (pageCache != null && !roots.isEmpty()) {
            if (roots.size() > 1) {
                TreeNode node = new TreeNode();
                node.setId(DEFAULT_ROOT_ID);
                node.setText("");
                node.setChildren(roots);
                TreeUtils.putCache(pageCache, treeView.getKey(), node);
            } else {
                TreeUtils.putCache(pageCache, treeView.getKey(), roots.get(0));
            }
        }
    }

    public static List<TreeNode> buildWithChildren(List<TreeNode> nodeList) {
        List<TreeNode> roots = TreeUtils.findRoot(nodeList);
        for (TreeNode root : roots) {
            TreeUtils.buildChildren(nodeList, root);
        }
        return roots;
    }

    public static TreeNode buildChildren(List<TreeNode> treeNodes, TreeNode treeNode) {
        for (TreeNode it : treeNodes) {
            if (!treeNode.getId().equals(it.getParentid())) continue;
            if (treeNode.getChildren() == null) {
                treeNode.setChildren(new ArrayList());
            }
            TreeNode child = TreeUtils.buildChildren(treeNodes, it);
            child.setParentid(treeNode.getId());
            treeNode.getChildren().add(child);
        }
        return treeNode;
    }

    public static void checkFirstNode(IPageCache pageCache, TreeView treeView) {
        TreeNode node = TreeUtils.getCache(pageCache, treeView.getKey(), TreeNode.class);
        if (node == null) {
            return;
        }
        if (DEFAULT_ROOT_ID.equals(node.getId())) {
            List list = node.getChildren();
            if (list != null && !list.isEmpty()) {
                treeView.focusNode((TreeNode)list.get(0));
                treeView.treeNodeClick(((TreeNode)list.get(0)).getParentid(), ((TreeNode)list.get(0)).getId());
            }
        } else {
            treeView.focusNode(node);
            treeView.treeNodeClick(node.getParentid(), node.getId());
        }
    }

    public static void checkNode(IPageCache pageCache, TreeView treeView, String nodeId) {
        TreeNode node;
        TreeNode root;
        if (nodeId != null && (root = TreeUtils.getCache(pageCache, treeView.getKey(), TreeNode.class)) != null && (node = root.getTreeNode(nodeId, 20)) != null) {
            treeView.focusNode(node);
            treeView.treeNodeClick(node.getParentid(), node.getId());
        }
    }

    public static TreeNode getTreeNode(IPageCache pageCache, TreeView treeView, String nodeId) {
        TreeNode root = TreeUtils.getCache(pageCache, treeView.getKey(), TreeNode.class);
        if (root != null) {
            TreeNode node = root.getTreeNode(nodeId, 20);
            return node;
        }
        return null;
    }

    public static List<TreeNode> findRoot(List<TreeNode> treeNodes) {
        ArrayList<String> idList = new ArrayList<String>(treeNodes.size());
        for (TreeNode node : treeNodes) {
            idList.add(node.getId());
        }
        ArrayList<TreeNode> trees = new ArrayList<TreeNode>();
        for (TreeNode node : treeNodes) {
            HashMap<String, String> data = (HashMap<String, String>)node.getData();
            if (data == null) {
                data = new HashMap<String, String>();
            }
            data.put(LEVEL, "1");
            if (StringUtils.isEmpty((CharSequence)node.getParentid())) {
                node.setParentid("");
                node.setData(data);
                trees.add(node);
                continue;
            }
            if (idList.contains(node.getParentid())) continue;
            node.setParentid("");
            node.setData(data);
            trees.add(node);
        }
        return trees;
    }

    public static TreeNode findChildren(TreeNode treeNode, List<TreeNode> allNodes, List<TreeNode> sonItems) {
        int parLevel = TreeUtils.getLevel(treeNode);
        for (TreeNode it : sonItems) {
            HashMap<String, String> data;
            if (treeNode.getChildren() == null) {
                treeNode.setChildren(new ArrayList());
            }
            if ((data = (HashMap<String, String>)it.getData()) == null) {
                data = new HashMap<String, String>();
            }
            data.put(LEVEL, String.valueOf(parLevel + 1));
            it.setData(data);
            it.setLongNumber(treeNode.getLongNumber() + "." + it.getId());
            TreeNode child = TreeUtils.findChildren(it, allNodes, TreeUtils.getSonItems(it, allNodes));
            child.setParentid(treeNode.getId());
            treeNode.getChildren().add(child);
        }
        return treeNode;
    }

    public static List<TreeNode> getSonItems(TreeNode root, List<TreeNode> allNodes) {
        ArrayList<TreeNode> sonItems = new ArrayList<TreeNode>();
        for (TreeNode treeNode : allNodes) {
            if (!root.getId().equals(treeNode.getParentid())) continue;
            sonItems.add(treeNode);
        }
        allNodes.removeAll(sonItems);
        return sonItems;
    }

    private static int getLevel(TreeNode treeNode) {
        Map data = (Map)treeNode.getData();
        int currentLevel = Integer.parseInt(data.getOrDefault(LEVEL, "1"));
        return currentLevel;
    }

    public static void checkChilds(TreeView treeView, TreeNode treeNode) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        TreeUtils.getChildNodes(list, treeNode);
        treeView.checkNodes(list);
    }

    public static void unCheckChilds(TreeView treeView, TreeNode treeNode) {
        ArrayList<String> list = new ArrayList<String>();
        TreeUtils.getChildIds(list, treeNode);
        treeView.uncheckNodes(list);
    }

    private static void getChildNodes(List<TreeNode> list, TreeNode treeNode) {
        List childs = treeNode.getChildren();
        if (childs != null && !childs.isEmpty()) {
            for (TreeNode node : childs) {
                try {
                    TreeNode node1 = TreeUtils.convert(TreeNode.class, node);
                    node1.setChildren(null);
                    list.add(node1);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                TreeUtils.getChildNodes(list, node);
            }
        }
    }

    private static void getChildIds(List<String> list, TreeNode treeNode) {
        List childs = treeNode.getChildren();
        if (childs != null && !childs.isEmpty()) {
            for (TreeNode node : childs) {
                if (!list.contains(node.getId())) {
                    list.add(node.getId());
                }
                TreeUtils.getChildIds(list, node);
            }
        }
    }

    public static List<String> getNodeIdList(TreeNode treeNode) {
        ArrayList<String> list = new ArrayList<String>();
        if (treeNode != null) {
            if (!treeNode.getId().equals(DEFAULT_ROOT_ID)) {
                list.add(treeNode.getId());
            }
            TreeUtils.getChildIds(list, treeNode);
        }
        return list;
    }

    public static List<TreeNode> getNodeList(TreeNode treeNode) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        if (treeNode != null) {
            try {
                TreeNode node = TreeUtils.convert(TreeNode.class, treeNode);
                node.setChildren(null);
                list.add(node);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            TreeUtils.getChildNodes(list, treeNode);
        }
        return list;
    }

    public static TreeNode copyNode(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        TreeNode newNode = new TreeNode();
        newNode.setId(treeNode.getId());
        newNode.setParentid(treeNode.getParentid());
        newNode.setText(treeNode.getText());
        newNode.setIsOpened(treeNode.getIsOpened());
        newNode.setColor(treeNode.getColor());
        newNode.setLongNumber(treeNode.getLongNumber());
        Object data = treeNode.getData();
        if (data instanceof HashMap) {
            HashMap srcMap = (HashMap)data;
            HashMap tarMap = new HashMap(srcMap);
            newNode.setData(tarMap);
        }
        return newNode;
    }

    public static List<String> getChildIdList(TreeNode treeNode) {
        ArrayList<String> idlist = new ArrayList<String>();
        if (treeNode != null && !CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode node : treeNode.getChildren()) {
                idlist.addAll(TreeUtils.childList(node));
            }
        }
        return idlist;
    }

    private static List<String> childList(TreeNode treeNode) {
        ArrayList<String> idlist = new ArrayList<String>();
        if (treeNode != null) {
            idlist.add(treeNode.getId());
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                for (TreeNode node : treeNode.getChildren()) {
                    idlist.addAll(TreeUtils.childList(node));
                }
            }
        }
        return idlist;
    }

    public static <T> T convert(Class<T> dstClazz, Object srcObj) throws InstantiationException, IllegalAccessException {
        Object value;
        String name;
        Object value2;
        T dstObject = null;
        Class<?> srcClazz = srcObj.getClass();
        dstObject = dstClazz.newInstance();
        AccessibleObject[] fields = dstClazz.getDeclaredFields();
        AccessibleObject[] srcFields = srcClazz.getDeclaredFields();
        AccessibleObject[] srcParFields = srcClazz.getSuperclass().getDeclaredFields();
        HashMap<String, Object> srcFieldsMap = new HashMap<String, Object>(srcFields.length + srcParFields.length);
        AccessibleObject.setAccessible(srcParFields, true);
        for (AccessibleObject field : srcParFields) {
            value2 = ((Field)field).get(srcObj);
            srcFieldsMap.put(((Field)field).getName(), value2);
        }
        AccessibleObject.setAccessible(srcFields, true);
        for (AccessibleObject field : srcFields) {
            value2 = ((Field)field).get(srcObj);
            String name2 = ((Field)field).getName();
            srcFieldsMap.put(name2, value2);
        }
        Class<T> parentClass = dstClazz.getSuperclass();
        AccessibleObject[] parFields = parentClass.getDeclaredFields();
        AccessibleObject.setAccessible(parFields, true);
        for (AccessibleObject field : parFields) {
            name = ((Field)field).getName();
            value = srcFieldsMap.get(name);
            if (value == null) continue;
            ((Field)field).set(dstObject, value);
        }
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            name = ((Field)field).getName();
            value = srcFieldsMap.get(name);
            if (value == null || Modifier.isFinal(((Field)field).getModifiers())) continue;
            ((Field)field).set(dstObject, value);
        }
        return dstObject;
    }

    public static String getParentIdByLongNumber(String longNumber) {
        if (StringUtils.isEmpty((CharSequence)longNumber)) {
            return DEFAULT_ROOT_ID;
        }
        int index = longNumber.lastIndexOf(46);
        if (index < 1) {
            return DEFAULT_ROOT_ID;
        }
        String sub = longNumber.substring(0, index);
        int in = sub.lastIndexOf(46);
        return longNumber.substring(in + 1, index);
    }

    public static DynamicObjectCollection getOrgLists() {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        List list = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"getOrgLists", (Object[])new Object[0]);
        list.stream().forEach(map -> {
            DynamicObject row = BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity");
            DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
            map.keySet().stream().forEach(key -> row.set(key, map.get(key)));
            dynamicObjectCollection.add((Object)row);
        });
        return dynamicObjectCollection;
    }

    public static DynamicObjectCollection queryOrgListByCondition(Map<String, List<Object>> condition) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        List list = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"queryOrgListByCondition", (Object[])new Object[]{condition});
        list.stream().forEach(map -> {
            DynamicObject row = BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity");
            map.keySet().stream().forEach(key -> row.set(key, map.get(key)));
            dynamicObjectCollection.add((Object)row);
        });
        return dynamicObjectCollection;
    }

    public static DynamicObjectCollection queryOrgListHasPermission(HasPermOrgResult hasPermOrgResult, boolean isQueryEnabled) {
        DynamicObjectCollection col;
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(16);
            List hasPermOrgsList = hasPermOrgResult.getHasPermOrgs();
            TreeUtils.convertParam("id", hasPermOrgsList, map);
            if (isQueryEnabled) {
                TreeUtils.convertParam("status", "1", map);
            }
            col = TreeUtils.queryOrgListByCondition(map);
        } else {
            col = TreeUtils.getOrgLists();
        }
        return col;
    }

    private static Long getDefaultViewId() {
        return Long.parseLong("40");
    }

    private static DynamicObject getOrgDynamicObject(Map<String, Object> map) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity");
        obj.set("id", (Object)map.getOrDefault("FID", 0).toString());
        obj.set("number", (Object)map.getOrDefault("FNUMBER", "").toString());
        obj.set("name", (Object)map.getOrDefault("FNAME", "").toString());
        obj.set("parentid", (Object)map.getOrDefault("FPARENTID", "").toString());
        obj.set("status", (Object)("1".equalsIgnoreCase(map.getOrDefault("FENABLE", "").toString()) ? "2" : "3"));
        obj.set("longnumber", (Object)map.getOrDefault("FLONGNUMBER", "").toString());
        return obj;
    }

    private static DynamicObject initOrgObject() {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"tctb_org_entity");
        obj.set("id", (Object)0);
        obj.set("number", (Object)"");
        obj.set("name", (Object)"");
        obj.set("parentid", (Object)-1);
        obj.set("status", (Object)2);
        obj.set("longnumber", (Object)"");
        return obj;
    }

    public static Map<String, List<Object>> convertParam(String key, Object value, Map<String, List<Object>> map) {
        if (List.class.isAssignableFrom(value.getClass())) {
            map.put(key, (List)value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            map.put(key, list);
        }
        return map;
    }

    public static Map<String, List<Object>> convertParam(String key, Object value) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(16);
        if (List.class.isAssignableFrom(value.getClass())) {
            map.put(key, (List)value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            map.put(key, list);
        }
        return map;
    }

    private static StringBuilder getBaseStringBuilderByViewId(Long defaultViewId) {
        StringBuilder where = new StringBuilder();
        where.append("select a.flongnumber,b.fid, b.fnumber, c.fname, a.fparentid, b.fenable from t_org_structure a, t_org_org b,t_org_org_l c where a.forgid = b.fid  and b.fid = c.fid and c.Flocaleid = 'zh_CN' and b.fenable = '1'  and a.fviewid = ").append(defaultViewId);
        return where;
    }

    private static DynamicObjectCollection getOrgCollection(String where) {
        List<Map<String, Object>> list = DBUtils.query(DBRoute.basedata.getRouteKey(), where);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        if (!CollectionUtils.isEmpty(list)) {
            for (Map<String, Object> map : list) {
                DynamicObject obj = TreeUtils.getOrgDynamicObject(map);
                dynamicObjectCollection.add((Object)obj);
            }
        } else {
            dynamicObjectCollection.add((Object)TreeUtils.initOrgObject());
        }
        return dynamicObjectCollection;
    }

    private static void extractQueryCondition(Map<String, List<Object>> condition, StringBuilder where) {
        List<Object> orgIdList = condition.get("id");
        List<Object> numberList = condition.get("number");
        List<Object> nameList = condition.get("name");
        List<Object> statusList = condition.get("status");
        if (!CollectionUtils.isEmpty(orgIdList)) {
            where.append(" and b.fid in (").append(StringUtils.join(orgIdList, (String)SEPARATOR)).append(')');
        }
        if (!CollectionUtils.isEmpty(numberList)) {
            where.append(" and b.fnumber in (").append(numberList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(SEPARATOR))).append(')');
        }
        if (!CollectionUtils.isEmpty(nameList)) {
            where.append(" and c.fname in (").append(nameList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(SEPARATOR))).append(')');
        }
        if (!CollectionUtils.isEmpty(statusList)) {
            where.append(" and b.fenable in (").append(statusList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(SEPARATOR))).append(')');
        }
    }
}

