/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.tctb.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.license.api.LicenseCheckResult;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;

public class LicenseCheckServiceHelper {
    public static boolean check(Object orgid, IFormView e, String appid) {
        TaxResult result = TaxcLicenseCheckDataServiceHelper.check((Long)Long.parseLong(String.valueOf(orgid)), (String)appid);
        if (result != null && Boolean.TRUE.equals(result.getData())) {
            if (null != e) {
                e.showConfirm(result.getMessage(), null);
            }
            return true;
        }
        return false;
    }

    public static LicenseCheckResult checkTxftPerformGroup(String appid) {
        LicenseCheckResult licenseCheckResult = new LicenseCheckResult();
        licenseCheckResult.setHasLicense(Boolean.valueOf(true));
        return licenseCheckResult;
    }

    public static List<Long> getOrgByAppId(String appid, String licensestatus) {
        TaxResult result = TaxcLicenseCheckDataServiceHelper.getOrgByAppId((String)appid, (String)licensestatus);
        return result == null ? new ArrayList() : (List)result.getData();
    }

    public static boolean checkOrgIsLogout(Long orgId, IFormView e) {
        return false;
    }

    public static void checkOrgAuthNeedZero(IDataModel model, IFormView view) {
        boolean notAuthorize;
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null && (notAuthorize = LicenseCheckServiceHelper.isOrgNotAuthorize(org.getLong("id"), view, view.getFormShowParameter().getAppId(), "zerodeclare"))) {
            model.setValue("org", null);
        }
    }

    public static void checkOrgAuth(IDataModel model, IFormView view) {
        boolean notAuthorize;
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null && (notAuthorize = LicenseCheckServiceHelper.check(org.getLong("id"), view, view.getFormShowParameter().getAppId()))) {
            model.setValue("org", null);
        }
    }

    public static boolean isOrgNotAuthorize(Long orgid, IFormView view, String appId, String zeroDeclareKey) {
        boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter(appId, zeroDeclareKey, orgid);
        if (zeroDeclare) {
            return LicenseCheckServiceHelper.checkOrgIsLogout(orgid, view);
        }
        return LicenseCheckServiceHelper.check(orgid, view, appId);
    }
}

