/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.tctb.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.constant.OrgFuncEnum;
import kd.taxc.bdtaxr.common.tctb.common.vo.OrgTakeRelationVo;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class TaxOrgTakeRelationServiceHelper {
    public static List<DynamicObject> getOrgTakeRelation(Long taxOrgId, Date date) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        List resultList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxOrgTakeRelationService", (String)"getOrgTakeRelation", (Object[])new Object[]{taxOrgId, date});
        if (null != resultList) {
            resultList.stream().forEach(map -> {
                DynamicObject taxOrg = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                map.keySet().stream().forEach(key -> taxOrg.set(key, map.get(key)));
                list.add(taxOrg);
            });
        }
        return list;
    }

    public static List<Long> getOrgTakeRelation(List<Long> taxOrgId, Date startdate, Date enddate) {
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxOrgTakeRelationService", (String)"getOrgTakeRelation", (Object[])new Object[]{taxOrgId, startdate, enddate});
    }

    public static List<Long> getTaxOrgByAccountingOrgs(List<Long> accountingOrg, Date date) {
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxOrgTakeRelationService", (String)"getTaxOrgByAccountingOrgs", (Object[])new Object[]{accountingOrg, date});
    }

    public static List<Long> getTaxOrgByAccountingOrg(Long accountingOrg, Date date) {
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxOrgTakeRelationService", (String)"getTaxOrgByAccountingOrg", (Object[])new Object[]{accountingOrg, date});
    }

    public static List<OrgTakeRelationVo> getAccountingOrgByTaxOrg(Long taxOrgId, Date startDate, Date endDate) {
        String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxOrgTakeRelationService", (String)"getAccountingOrgByTaxOrg", (Object[])new Object[]{taxOrgId, startDate, endDate});
        return SerializationUtils.fromJsonStringToList((String)result, OrgTakeRelationVo.class);
    }

    public static List<OrgTakeRelationVo> getAccountingOrgByTaxOrgBatch(List<OrgTakeRelationVo> relationVos) {
        if (ObjectUtils.isEmpty(relationVos)) {
            return new ArrayList<OrgTakeRelationVo>();
        }
        String relationVosJson = SerializationUtils.toJsonString(relationVos);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxOrgTakeRelationService", (String)"getAccountingOrgByTaxOrgBatch", (Object[])new Object[]{relationVosJson});
        return SerializationUtils.fromJsonStringToList((String)result, OrgTakeRelationVo.class);
    }

    public static List<Long> getTaxOrgByAccountingOrgNew(Long accountingOrg, Date date) {
        if (ObjectUtils.isEmpty((Object)accountingOrg)) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        list.addAll(OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"40", (Long)accountingOrg));
        return list;
    }

    public static List<Long> getTaxOrgByMetaOrgFunc(Long taxOrg, Date start, Date end, String entityId, String entityKey, String fieldName) {
        HashSet<Long> set = new HashSet<Long>();
        ArrayList<Long> list = new ArrayList<Long>();
        String orgFun = MetadataUtil.getOrgFun(entityId, entityKey, fieldName);
        OrgFuncEnum orgFuncEnum = OrgFuncEnum.getEnumByNumber(orgFun);
        if (orgFuncEnum != null) {
            switch (orgFuncEnum) {
                case TAX: {
                    List<Long> orgTakeRelation = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxOrg), start, end);
                    set.addAll(orgTakeRelation);
                    break;
                }
                case ACCOUNT: {
                    break;
                }
                default: {
                    set.add(taxOrg);
                }
            }
        }
        list.addAll(set);
        return list;
    }

    public static Map<String, List<Long>> getOrgRelationMapByTaxOrgs(List<Long> taxOrgs, Date start, Date end) {
        HashMap<String, List<Long>> resultMap = new HashMap<String, List<Long>>(16);
        for (Long org : taxOrgs) {
            for (OrgFuncEnum orgFuncEnum : OrgFuncEnum.values()) {
                HashSet<Long> set = new HashSet<Long>(8);
                ArrayList<Long> list = new ArrayList<Long>(8);
                switch (orgFuncEnum) {
                    case TAX: {
                        break;
                    }
                    case ACCOUNT: {
                        List<Long> orgTakeRelation = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(org), start, end);
                        set.addAll(orgTakeRelation);
                        break;
                    }
                }
                list.addAll(set);
                resultMap.put(TaxOrgTakeRelationServiceHelper.getRelationMapKey(org, orgFuncEnum.getNumber()), list);
            }
        }
        return resultMap;
    }

    public static String getRelationMapKey(Long org, String orgFuncEnumNumber) {
        return org.toString() + "_" + orgFuncEnumNumber;
    }

    public static Map<String, Object> getDataSourceMappingListByTaxorg(Long dataSourceId, List<Long> taxorgs, Date skssqq, Date skssqz) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxOrgMappingService", (String)"getDataSourceMappingListByTaxorg", (Object[])new Object[]{dataSourceId, taxorgs, skssqq, skssqz});
    }
}

