/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.threadpools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.taxc.bdtaxr.common.formula.context.Content;
import kd.taxc.bdtaxr.common.formula.sql.ParseSqlUtils;
import kd.taxc.bdtaxr.common.formula.sql.SqlVo;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.UnionSqlGetValue;

public class UnionSqlTask
extends Task {
    private Map<String, String> sql;
    private Content content;
    private static final String[] EXCLUDE_KEYWORDS = new String[]{" distinct ", " DISTINCT "};
    private static final int SQL_SIZE = 5;

    public UnionSqlTask(Map<String, String> sql, Content content) {
        this.sql = sql;
        this.content = content;
    }

    public List<Object> getValue() {
        List<Object> list = new ArrayList<Object>();
        ParseSqlUtils utils = new ParseSqlUtils();
        for (Map.Entry<String, String> entry : this.sql.entrySet()) {
            if (Arrays.stream(EXCLUDE_KEYWORDS).anyMatch(v -> ((String)entry.getKey()).contains((CharSequence)v))) continue;
            utils.parseSql(entry.getValue(), entry.getKey());
        }
        Map<String, SqlVo> data = utils.getData();
        HashMap<String, ArrayList<SqlVo>> table = new HashMap<String, ArrayList<SqlVo>>();
        for (Map.Entry<String, SqlVo> entry : data.entrySet()) {
            SqlVo value = entry.getValue();
            ArrayList<SqlVo> temp = (ArrayList<SqlVo>)table.get(value.getTable());
            if (null == temp) {
                temp = new ArrayList<SqlVo>();
                table.put(value.getTable(), temp);
                list.add(temp);
            }
            temp.add(value);
        }
        list = this.reBuildList(list);
        return list;
    }

    public Object executor(Object ex) {
        UnionSqlGetValue s = new UnionSqlGetValue(this.content);
        return s.getValue(ex);
    }

    private List<Object> reBuildList(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : list) {
            List sqlVoList = (List)obj;
            if (sqlVoList != null && sqlVoList.size() >= 5) {
                this.listSplit(sqlVoList, result);
                continue;
            }
            result.add(sqlVoList);
        }
        return result;
    }

    private void listSplit(List<SqlVo> list, List<Object> result) {
        int rows = list.size();
        int pageSum = rows % 5 == 0 ? rows / 5 : rows / 5 + 1;
        for (int i = 0; i < pageSum; ++i) {
            if (i == 0) {
                result.add(list.subList(0, 5));
                continue;
            }
            if (i == pageSum - 1) {
                result.add(list.subList(5 * i, rows));
                continue;
            }
            result.add(list.subList(5 * i, 5 * i + 5));
        }
    }
}

