/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.upgrade;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;

public class UpdConstant {
    public static final String TPO_SBMODEL_UPDATE_CONF = "tpo_sbmodel_update_conf";
    public static final String TYPE_SUFFIX = "_sbmx3sj";
    public static final String UPDATE_TABLE = "t_tctb_declare_main";
    public static final String UPD_RECORD_ENTITY = "bdtaxr_plugin_upgrade";
    public static final String TPO_DECLARE_MAIN_TSC = "tpo_declare_main_tsc";
    public static final String TPO_DECLARE_DETAIL_TSC = "tpo_declare_detail_tsc";
    public static final String TCVAT_NSRXX = "tcvat_nsrxx";
    public static final String DYNROWSET_ENTITY_NAME = "bdtaxr_template_dynrow";
    public static final String TPO_ROWCOL_MAPPING = "tpo_rowcol_mapping";
    public static final String BDTAXR_TEMPLATE_MAIN = "bdtaxr_template_main";
    public static final String TPO_TEMPLATE = "tpo_template";
    public static final String MEMBER_KEY_FORMAT = "%s_%s";
    public static final String REPORTITEM_KEY_FORMAT = "%s#%s";
    public static final Map<String, String> NSRXX_FIELD_MAP = new HashMap<String, String>(){
        {
            this.put("id", "id");
            this.put("billno", "billno");
            this.put("billstatus", "billstatus");
            this.put("creator", "creator");
            this.put("auditor", "auditor");
            this.put("auditdate", "auditdate");
            this.put("modifier", "modifier");
            this.put("modifytime", "modifytime");
            this.put("createtime", "createtime");
            this.put("nsrsbh", "nsrsbh");
            this.put("nsrmc", "nsrmc");
            this.put("type", "templatetype");
            this.put("skssqq", "skssqq");
            this.put("skssqz", "skssqz");
            this.put("org", "org");
            this.put("taxauthority", "taxauthority");
            this.put("templateid", "templateid");
            this.put("sshymc", "sshymc");
            this.put("fddbrxm", "fddbrxm");
            this.put("zcdz", "zcdz");
            this.put("scjydz", "scjydz");
            this.put("khyh", "khyh");
            this.put("yhzh", "yhzh");
            this.put("registertype", "registertype");
            this.put("phonenum", "phonenum");
            this.put("datatype", "datatype");
            this.put("apanage", "apanage");
            this.put("taxlimit", "taxlimit");
            this.put("sbrq", "sbrq");
            this.put("sblx", "sblx");
            this.put("serialno", "serialno");
            this.put("yssr", "yssr");
            this.put("declaretype", "declaremethod");
            this.put("paytype", "paytype");
            this.put("paydate", "paydate");
            this.put("declarestatus", "declarestatus");
            this.put("paystatus", "paystatus");
            this.put("declaredate", "declaredate");
            this.put("declarer", "declarer");
            this.put("payer", "payer");
            this.put("deferpayapply", "deferpayapply");
            this.put("qjje", "qjje");
            this.put("sjje", "sjje");
            this.put("riskstatus", "riskstatus");
            this.put("riskcontent", "riskcontent");
            this.put("operator", "operator");
            this.put("operatorno", "operatorno");
            this.put("jbrphone", "jbrphone");
            this.put("jbrysfzjlx", "jbrysfzjlx");
            this.put("ismodified", "ismodified");
            this.put("tcrettype", "tcrettype");
            this.put("groupid", "groupid");
            this.put("bqybtse", "bqybtse");
            this.put("maindataid", "maindataid");
            this.put("businessno", "businessno");
            this.put("zerodeclare", "zerodeclare");
            this.put("archivestatus", "archivestatus");
            this.put("archivetime", "archivetime");
            this.put("taxsourcetype", "taxsourcetype");
            this.put("taxsourceid", "taxsourceid");
            this.put("sbbid", "sbbid");
            this.put("versiontype", "versiontype");
            this.put("remark", "remark");
        }
    };
    public static final Map<String, String> NSRXX_DB_FIELD_MAP = new LinkedHashMap<String, String>(){
        {
            this.put("id", "fid");
            this.put("billno", "fbillno");
            this.put("billstatus", "fbillstatus");
            this.put("creator", "fcreatorid");
            this.put("auditor", "fauditorid");
            this.put("auditdate", "fauditdate");
            this.put("modifier", "fmodifierid");
            this.put("modifytime", "fmodifytime");
            this.put("createtime", "fcreatetime");
            this.put("nsrsbh", "fnsrsbh");
            this.put("nsrmc", "fnsrmc");
            this.put("type", "ftemplatetype");
            this.put("skssqq", "fskssqq");
            this.put("skssqz", "fskssqz");
            this.put("org", "forgid");
            this.put("taxauthority", "ftaxauthority");
            this.put("templateid", "ftemplateid");
            this.put("sshymc", "fsshymc");
            this.put("fddbrxm", "ffddbrxm");
            this.put("zcdz", "fzcdz");
            this.put("scjydz", "fscjydz");
            this.put("khyh", "fkhyh");
            this.put("yhzh", "fyhzh");
            this.put("registertype", "fregistertype");
            this.put("phonenum", "fphonenum");
            this.put("datatype", "fdatatype");
            this.put("apanage", "fapanage");
            this.put("taxlimit", "ftaxlimit");
            this.put("sbrq", "fsbrq");
            this.put("sblx", "fsblx");
            this.put("serialno", "fserialno");
            this.put("yssr", "fyssr");
            this.put("declaretype", "fdeclaremethod");
            this.put("paytype", "fpaytype");
            this.put("paydate", "fpaydate");
            this.put("declarestatus", "fdeclarestatus");
            this.put("paystatus", "fpaystatus");
            this.put("declaredate", "fdeclaredate");
            this.put("declarer", "fdeclarer");
            this.put("payer", "fpayer");
            this.put("deferpayapply", "fdeferpayapply");
            this.put("qjje", "fqjje");
            this.put("sjje", "fsjje");
            this.put("riskstatus", "friskstatus");
            this.put("riskcontent", "friskcontent");
            this.put("operator", "foperator");
            this.put("operatorno", "foperatorno");
            this.put("jbrphone", "fjbrphone");
            this.put("jbrysfzjlx", "fjbrysfzjlx");
            this.put("ismodified", "fismodified");
            this.put("tcrettype", "ftcrettype");
            this.put("groupid", "fgroupid");
            this.put("bqybtse", "fbqybtse");
            this.put("maindataid", "fmaindataid");
            this.put("businessno", "fbusinessno");
            this.put("zerodeclare", "fzerodeclare");
            this.put("archivestatus", "farchivestatus");
            this.put("archivetime", "farchivetime");
            this.put("taxsourcetype", "ftaxsourcetype");
            this.put("taxsourceid", "ftaxsourceid");
            this.put("sbbid", "fsbbid");
            this.put("versiontype", "fversiontype");
            this.put("remark", "fremark");
        }
    };
    public static final Map<String, Object> NSRXX_DB_FIELD_DEFAULT_MAP = new LinkedHashMap<String, Object>(){
        {
            this.put("creator", 0L);
            this.put("auditor", 0L);
            this.put("modifier", 0L);
            this.put("nsrsbh", " ");
            this.put("nsrmc", " ");
            this.put("type", " ");
            this.put("org", 0L);
            this.put("taxauthority", 0L);
            this.put("templateid", 0L);
            this.put("sshymc", " ");
            this.put("fddbrxm", " ");
            this.put("zcdz", " ");
            this.put("scjydz", " ");
            this.put("khyh", " ");
            this.put("yhzh", " ");
            this.put("registertype", " ");
            this.put("phonenum", " ");
            this.put("datatype", " ");
            this.put("apanage", " ");
            this.put("taxlimit", " ");
            this.put("sblx", " ");
            this.put("serialno", " ");
            this.put("yssr", BigDecimal.ZERO);
            this.put("declaretype", " ");
            this.put("paytype", " ");
            this.put("declarestatus", " ");
            this.put("paystatus", " ");
            this.put("declarer", 0L);
            this.put("payer", 0L);
            this.put("deferpayapply", "0");
            this.put("qjje", BigDecimal.ZERO);
            this.put("sjje", BigDecimal.ZERO);
            this.put("riskstatus", " ");
            this.put("riskcontent", " ");
            this.put("operator", " ");
            this.put("operatorno", " ");
            this.put("jbrphone", " ");
            this.put("jbrysfzjlx", " ");
            this.put("ismodified", "0");
            this.put("tcrettype", " ");
            this.put("groupid", 0L);
            this.put("bqybtse", BigDecimal.ZERO);
            this.put("maindataid", 0L);
            this.put("businessno", " ");
            this.put("zerodeclare", "0");
            this.put("archivestatus", " ");
            this.put("taxsourcetype", " ");
            this.put("taxsourceid", 0L);
            this.put("sbbid", 0L);
        }
    };
    private static final Map<String, String[]> APP_TYPE_MAP = new LinkedHashMap<String, String[]>();
    public static List<String> model2DraftTemplateTypes;
    public static final String DECLAREMAINTABLE_SYNC = "DeclareMainTableSync";
    public static final String EXTEXCLUDETEMPLATETYPES = "extExcludeTemplateTypes";
    public static final String EXTFILTER = "extFilter";

    public static List<String> getTemplateTypeByApp(String app) {
        ArrayList<String> templateTypes = new ArrayList<String>(8);
        String[] taxtypes = APP_TYPE_MAP.get(app);
        if (taxtypes != null) {
            Map<String, String[]> typeMap = TemplateTypeConstant.getTypeMap();
            for (String taxtype : taxtypes) {
                String[] templateType = typeMap.get(taxtype);
                templateTypes.addAll(Arrays.stream(templateType).collect(Collectors.toList()));
            }
        }
        return templateTypes;
    }

    static {
        APP_TYPE_MAP.put("tcvat", new String[]{"zzs", "fjsf"});
        APP_TYPE_MAP.put("tccit", new String[]{"qysds"});
        APP_TYPE_MAP.put("tcret", new String[]{"ccxws", "tcwat"});
        APP_TYPE_MAP.put("totf", new String[]{"qtsf_ty", "whsyjsf"});
        APP_TYPE_MAP.put("tcnfep", new String[]{"tcnfep"});
        APP_TYPE_MAP.put("tcetr", new String[]{"drawback"});
        APP_TYPE_MAP.put("tcvvt", new String[]{"cwbbnd", "cwbbfnd", "qhjtydbs", "zdsybs_new"});
        model2DraftTemplateTypes = Lists.newArrayList((Object[])new String[]{"draft_zzsxgmnsr", "draft_zzsxgmnsr_sjjt", "draft_zzsybnsr", "draft_zzsybnsr_sjjt", "draft_zzsybnsr_ybhz", "draft_zzsybnsr_ybhz_sjjt", "zzsaccount", "zzsaccountmonth", "zzsaccountmonth_sjjt", "zzsaccount_sjjt", "zzstz", "draft_qysdsjb", "draft_zzsybnsr_hz_zjg_sjjt", "draft_zzsybnsr_yz_zjg_sjjt", "gljydg", "jzjt_tsjsdg", "ncpdg", "qysds_draft_calc", "qysdsnb_dg", "VAT_RTA"});
    }
}

