/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareCustomParamsHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OperateCodeEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.history.BaseDataHistoryService;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.oversea.DeclareEditAndListEnum;
import kd.taxc.bdtaxr.common.util.DevprotalBizAppUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.RiskControlUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class DeclareUtils {
    public static final String AUDIT = "audit";
    public static final String SUBMIT = "submit";
    public static final String UNAUDIT = "unaudit";
    public static final String UNSUBMIT = "unsubmit";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static Log logger = LogFactory.getLog(DeclareUtils.class);
    public static Map<String, String> RISK_CONTENT_MAP = new HashMap<String, String>(4);

    private static HashBasedTable<String, String, String> getWorkFlowConfigBill() {
        HashBasedTable table = HashBasedTable.create();
        table.put((Object)"tccit", (Object)"tccit_seasonal_declare2", (Object)"tccit_query_report");
        table.put((Object)"tccit", (Object)"tccit_newmainpage", (Object)"tccit_quarterly_report");
        return table;
    }

    public static boolean submit(IFormView view, List<Object> pklist) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx");
        DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        String msg = "";
        if (loadResult == null || loadResult.length < 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u518d\u63d0\u4ea4\u3002", (String)"DeclareUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        for (DynamicObject obj : loadResult) {
            String billstatus = obj.getString("billstatus");
            if ("A".equals(billstatus)) {
                updateList.add(obj);
                continue;
            }
            String nsrmc = obj.getString("nsrmc");
            Date skssqq = obj.getDate("skssqq");
            msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002", (String)"DeclareUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
        }
        if (CollectionUtils.isEmpty(updateList)) {
            view.showTipNotification(msg, Integer.valueOf(2000));
            return false;
        }
        QFilter qFilter1 = new QFilter("entrabill", "=", (Object)"tcvat_nsrxx");
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"enable");
        DynamicObject processdefinition = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (processdefinition == null) {
            for (DynamicObject obj : updateList) {
                obj.set("billstatus", (Object)"C");
                obj.set("auditdate", (Object)new Date());
                obj.set("auditor", (Object)RequestContext.get().getUserId());
                obj.set("modifier", (Object)RequestContext.get().getUserId());
                obj.set("modifytime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        } else {
            OperationResult result = OperationServiceHelper.executeOperate((String)SUBMIT, (String)"tcvat_nsrxx", (DynamicObject[])updateList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                view.showOperationResult(result);
                return false;
            }
        }
        for (DynamicObject dObj : updateList) {
            DynamicObject org = dObj.getDynamicObject("org");
            long orgId = org.getLong("id");
            Date startDate = (Date)dObj.get("skssqq");
            Date endDate = (Date)dObj.get("skssqz");
            String type = dObj.getString("type");
            if (!StringUtils.trimToEmpty((String)type).startsWith("zzs") && !StringUtils.trimToEmpty((String)type).startsWith("qysds")) continue;
            BaseDataHistoryService.saveBaseDataHistory(orgId, startDate, endDate);
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"DeclareUtils_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        return true;
    }

    public static ValidDataResultVo submit(List<Object> pklist, String operationKey, String entryName, boolean isQueryList) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
        List<Object> updateList = new ArrayList<DynamicObject>();
        String msg = "";
        if (loadResult == null || loadResult.length < 1) {
            msg = isQueryList ? ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DeclareUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"DeclareUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            return ValidDataResultVo.fail(msg);
        }
        for (DynamicObject obj : loadResult) {
            String billstatus = obj.getString("billstatus");
            String declareStatus = obj.getString("declarestatus");
            String datatype = obj.getString("datatype");
            logger.info("billstatusdeclarestatusdatatype: " + billstatus + declareStatus + datatype);
            if (DeclareUtils.undoCondition(billstatus, operationKey, datatype, declareStatus)) {
                updateList.add(obj);
                String billno = obj.getString("billno");
                String nsrtype = obj.getString("type");
                logger.info("billstatusdeclarestatusdatatype: " + billstatus + declareStatus + datatype);
                if (StringUtils.trimToEmpty((String)nsrtype).startsWith("zzs")) {
                    OperatorDialogUtils.operateDialog("zzs", TemplateEnum.getEnumByDeclareType(nsrtype).getDeclarePage(), OperateCodeEnum.getByCode(operationKey), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u7533\u62a5\u8868%2$s\u6210\u529f\u3002", (String)"DeclareUtils_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode(operationKey)));
                    continue;
                }
                if (!StringUtils.trimToEmpty((String)nsrtype).startsWith("qysds")) continue;
                OperatorDialogUtils.operateDialog("qysds", TemplateEnum.getEnumByDeclareType(nsrtype).getDeclarePage(), OperateCodeEnum.getByCode(operationKey), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u7533\u62a5\u8868%2$s\u6210\u529f\u3002", (String)"DeclareUtils_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode(operationKey)));
                continue;
            }
            String nsrmc = obj.getDynamicObject("org").getString("name");
            if ("tcret_declare_main".equals(entryName)) {
                String billno = obj.getString("billno");
                msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u7f16\u53f7\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DeclareUtils_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, billno);
                if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "declared".equals(declareStatus)) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u7f16\u53f7\u7533\u62a5\u8868\u5df2\u7533\u62a5\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DeclareUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, billno);
                } else if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "B".equals(billstatus)) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u7f16\u53f7\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"DeclareUtils_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, billno);
                }
                logger.info("billstatusdeclarestatusdatatype: " + billstatus + declareStatus + datatype);
                continue;
            }
            Date skssqq = obj.getDate("skssqq");
            msg = DeclareUtils.undoMsg(billstatus, operationKey, datatype, declareStatus, nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
        }
        logger.info("updateList:" + updateList.toString());
        if (CollectionUtils.isEmpty(updateList)) {
            return ValidDataResultVo.fail(msg);
        }
        StringBuilder builderstr = DeclareUtils.checkTaxRefundApply(updateList, operationKey);
        TaxResult<List<DynamicObject>> riskControlResult = RiskControlUtils.checkRiskControlResult(updateList, operationKey, entryName);
        logger.info("\u98ce\u63a7\u63a5\u53e3\u8c03\u7528\u7ed3\u679c\uff1a", (Object)riskControlResult.isSuccess());
        if (!riskControlResult.isSuccess()) {
            builderstr.append(riskControlResult.getMessage()).append(SEPARATOR);
            updateList = (List)riskControlResult.getData();
        }
        if (updateList.size() == 0 && StringUtil.isNotBlank((CharSequence)builderstr)) {
            return ValidDataResultVo.fail(builderstr.toString());
        }
        QFilter qFilter1 = new QFilter("entrabill", "=", (Object)entryName);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"enable");
        DynamicObject processdefinition = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (processdefinition == null) {
            DeclareUtils.updateData(updateList, operationKey);
        } else {
            try {
                OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)entryName, (DynamicObject[])updateList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                logger.info("DeclareUtils\u4e2d\u5de5\u4f5c\u6d41\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a{},{},{}", new Object[]{result, operationKey, entryName});
                if (!result.isSuccess()) {
                    return ValidDataResultVo.fail(result.getMessage(), result);
                }
            }
            catch (Exception e) {
                logger.error(String.format("workflowError:%s", e.getMessage()));
            }
        }
        if ("tcvat_prepay_declare_bill".equals(entryName)) {
            MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx");
            List ids = updateList.stream().map(u -> u.getLong("id")).collect(Collectors.toList());
            DynamicObject[] mainData = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntity);
            DeclareUtils.updateData(Arrays.asList(mainData), operationKey);
        }
        DeclareUtils.saveRuleHistory(operationKey, entryName, updateList.toArray(new DynamicObject[0]));
        if (AUDIT.equals(operationKey) || UNAUDIT.equals(operationKey)) {
            DeclareUtils.refreshElement(loadResult, operationKey, null);
            DeclareUtils.createTaxRefund(loadResult, operationKey);
        }
        if (EmptyCheckUtils.isNotEmpty(updateList)) {
            DynamicObject[] saveObjects = updateList.toArray(new DynamicObject[updateList.size()]);
            DeclareMainServiceHelper.fireModel2DeclareMainChangeEvent((DynamicObject[])saveObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operationKey));
        }
        List successPkids = updateList.stream().map(s -> s.get("id")).collect(Collectors.toList());
        if (StringUtil.isNotBlank((CharSequence)builderstr)) {
            return ValidDataResultVo.fail(builderstr.toString());
        }
        return ValidDataResultVo.success(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"DeclareUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), successPkids);
    }

    public static ValidDataResultVo submit(List<Object> pklist, String operationKey, String entryName, boolean isQueryList, String listEntityName) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
        List<Object> updateList = new ArrayList<DynamicObject>();
        StringBuilder msg = new StringBuilder();
        if (loadResult == null || loadResult.length < 1) {
            if (isQueryList) {
                msg.append(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DeclareUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            } else {
                msg.append(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"DeclareUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            return ValidDataResultVo.fail(msg.toString());
        }
        for (DynamicObject obj : loadResult) {
            String billstatus = obj.getString("billstatus");
            String declareStatus = obj.getString("declarestatus");
            String datatype = obj.getString("datatype");
            logger.info("billstatusdeclarestatusdatatype: " + billstatus + declareStatus + datatype);
            if (DeclareUtils.undoCondition(billstatus, operationKey, datatype, declareStatus)) {
                updateList.add(obj);
                String billno = obj.getString("billno");
                String nsrtype = obj.getString("type");
                logger.info("billstatusdeclarestatusdatatype: " + billstatus + declareStatus + datatype);
                if (StringUtils.trimToEmpty((String)nsrtype).startsWith("zzs")) {
                    OperatorDialogUtils.operateDialog("zzs", TemplateEnum.getEnumByDeclareType(nsrtype).getDeclarePage(), OperateCodeEnum.getByCode(operationKey), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u7533\u62a5\u8868%2$s\u6210\u529f\u3002", (String)"DeclareUtils_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode(operationKey)));
                    continue;
                }
                if (!StringUtils.trimToEmpty((String)nsrtype).startsWith("qysds")) continue;
                OperatorDialogUtils.operateDialog("qysds", TemplateEnum.getEnumByDeclareType(nsrtype).getDeclarePage(), OperateCodeEnum.getByCode(operationKey), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u7533\u62a5\u8868%2$s\u6210\u529f\u3002", (String)"DeclareUtils_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode(operationKey)));
                continue;
            }
            String nsrmc = obj.getDynamicObject("org").getString("name");
            if ("tcret_declare_main".equals(entryName)) {
                String billno = obj.getString("billno");
                msg.append(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u7f16\u53f7\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DeclareUtils_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, billno)).append(SEPARATOR);
                if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "declared".equals(declareStatus)) {
                    msg.append(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u7f16\u53f7\u7533\u62a5\u8868\u5df2\u7533\u62a5\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DeclareUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, billno)).append(SEPARATOR);
                } else if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "B".equals(billstatus)) {
                    msg.append(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u7f16\u53f7\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"DeclareUtils_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, billno)).append(SEPARATOR);
                }
                logger.info("billstatusdeclarestatusdatatype: " + billstatus + declareStatus + datatype);
                continue;
            }
            Date skssqq = obj.getDate("skssqq");
            msg.append(DeclareUtils.undoMsg(billstatus, operationKey, datatype, declareStatus, nsrmc, DateUtils.format(skssqq, "yyyy-MM"))).append(SEPARATOR);
        }
        logger.info("updateList:" + updateList.toString());
        if (CollectionUtils.isEmpty(updateList)) {
            return ValidDataResultVo.fail(msg.toString());
        }
        StringBuilder builderstr = DeclareUtils.checkTaxRefundApply(updateList, operationKey);
        TaxResult<List<DynamicObject>> riskControlResult = RiskControlUtils.checkRiskControlResult(updateList, operationKey, entryName);
        logger.info("\u98ce\u63a7\u63a5\u53e3\u8c03\u7528\u7ed3\u679c\uff1a", (Object)riskControlResult.isSuccess());
        if (!riskControlResult.isSuccess()) {
            builderstr.append(riskControlResult.getMessage()).append(SEPARATOR);
            updateList = (List)riskControlResult.getData();
        }
        if (updateList.size() == 0 && StringUtil.isNotBlank((CharSequence)builderstr)) {
            return ValidDataResultVo.fail(builderstr.toString());
        }
        QFilter qFilter1 = new QFilter("entrabill", "=", (Object)entryName);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"enable");
        DynamicObject processdefinition = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        List ids = updateList.stream().map(u -> u.getLong("id")).collect(Collectors.toList());
        if (processdefinition == null) {
            DeclareUtils.updateData(updateList, operationKey);
        } else {
            try {
                OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)entryName, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
                logger.info("DeclareUtils\u4e2d\u5de5\u4f5c\u6d41\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a{},{},{}", new Object[]{result, operationKey, entryName});
                if (!result.isSuccess()) {
                    return ValidDataResultVo.fail(result.getMessage(), result);
                }
            }
            catch (Exception e) {
                logger.error(String.format("workflowError:%s", e.getMessage()));
            }
        }
        if ("tcvat_prepay_declare_bill".equals(entryName)) {
            MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx");
            DynamicObject[] mainData = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)mainEntity);
            DeclareUtils.updateData(Arrays.asList(mainData), operationKey);
        }
        DeclareUtils.saveRuleHistory(operationKey, entryName, updateList.toArray(new DynamicObject[0]));
        if (AUDIT.equals(operationKey) || UNAUDIT.equals(operationKey)) {
            loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
            DeclareUtils.refreshElement(loadResult, operationKey, listEntityName);
            DeclareUtils.createTaxRefund(loadResult, operationKey);
        }
        if (EmptyCheckUtils.isNotEmpty(updateList)) {
            DynamicObject[] saveObjects = updateList.toArray(new DynamicObject[updateList.size()]);
            DeclareMainServiceHelper.fireModel2DeclareMainChangeEvent((DynamicObject[])saveObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operationKey));
        }
        List successPkids = updateList.stream().map(s -> s.get("id")).collect(Collectors.toList());
        if (StringUtil.isNotBlank((CharSequence)builderstr)) {
            return ValidDataResultVo.fail(builderstr.toString());
        }
        return ValidDataResultVo.success(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"DeclareUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), successPkids);
    }

    private static StringBuilder checkTaxRefundApply(List<DynamicObject> loadResult, String operationKey) {
        StringBuilder builderstr = new StringBuilder();
        if (!UNAUDIT.equals(operationKey)) {
            return builderstr;
        }
        Iterator<DynamicObject> iterator = loadResult.iterator();
        while (iterator.hasNext()) {
            DynamicObject taxRefundApply;
            DynamicObject entity = iterator.next();
            String entityType = entity.getString("type");
            if (!DeclareUtils.ybnsrAndZjg(entityType) || null == (taxRefundApply = DeclareUtils.queryTaxRefundApply(entity.getDynamicObject("org").getLong("id"), entity.getDate("skssqq"), entity.getDate("skssqz")))) continue;
            builderstr.append(String.format(ResManager.loadKDString((String)"%s:\u5b58\u5728\u7559\u62b5\u9000\u7a0e\u7533\u8bf7\u8868\u3002", (String)"DeclareUtils_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entity.getString("billno")));
            iterator.remove();
        }
        return builderstr;
    }

    public static void createTaxRefund(DynamicObject[] loadResult, String operationKey) {
        for (DynamicObject entity : loadResult) {
            String entityType = entity.getString("type");
            if (!Arrays.asList((Object[])TemplateTypeConstant.getTypeMap().get("zzs")).contains(entityType)) continue;
            DeclareMQMessage message = DeclareMQSender.buildMessage(entity, DateUtils.getFirstDateOfMonth(entity.getDate("skssqq")), DateUtils.getLastDateOfMonth(entity.getDate("skssqz")), DeclareMQType.DECLARE.name(), operationKey);
            DeclareMQSender.send("taxc.tcvat.formplugin.taxrefund", JsonUtil.toJson(message));
        }
    }

    private static boolean ybnsrAndZjg(String entityType) {
        return "zzsybnsr".equals(entityType) || "zzsybnsr_ybhz".equals(entityType) || "zzsybnsr_yz_zjg".equals(entityType) || "zzsybnsr_hz_zjg".equals(entityType);
    }

    public static DynamicObject queryTaxRefundApply(Long orgid, Date skssqq, Date skssqz) {
        QFilter filter = new QFilter("org", "=", (Object)orgid).and("skssqq", ">=", (Object)skssqq).and("skssqz", "<=", (Object)skssqz).and("type", "=", (Object)"tcvat_taxrefund");
        return BusinessDataServiceHelper.loadSingle((String)"tcvat_tax_refund_apply", (String)"billstatus,entryentity,entryentity.bljd", (QFilter[])new QFilter[]{filter});
    }

    public static void saveRuleHistory(String operationKey, String entryName, DynamicObject[] updateList) {
        if (StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operationKey) && !"tcvat_prepay_declare_bill".equals(entryName) && !"tcret_declare_main".equals(entryName)) {
            for (DynamicObject dObj : updateList) {
                DynamicObject org = dObj.getDynamicObject("org");
                long orgId = org.getLong("id");
                Date startDate = (Date)dObj.get("skssqq");
                Date endDate = (Date)dObj.get("skssqz");
                String type = dObj.getString("type");
                if (!StringUtils.trimToEmpty((String)type).startsWith("zzs") && !StringUtils.trimToEmpty((String)type).startsWith("qysds")) continue;
                BaseDataHistoryService.saveBaseDataHistory(orgId, startDate, endDate);
            }
        }
    }

    private static boolean undoCondition(String billstatus, String operationKey, String datatype, String declareStatus) {
        boolean declareCondition;
        boolean bl = declareCondition = "C".equals(billstatus) && !"3".equals(datatype) && StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("editing".equals(declareStatus) || "declarefailed".equals(declareStatus));
        return "A".equals(billstatus) && StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operationKey) || "B".equals(billstatus) && StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey) || "B".equals(billstatus) && StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey) || declareCondition;
    }

    private static String undoMsg(String billstatus, String operationKey, String datatype, String declareStatus, String nsrmc, String skssqq) {
        logger.info("billstatusdeclarestatusdatatype: " + billstatus + declareStatus + datatype);
        String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DeclareUtils_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("declared".equals(declareStatus) || "declaring".equals(declareStatus) || "submitted".equals(declareStatus) || "importing".equals(declareStatus))) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u7533\u62a5\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DeclareUtils_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        } else if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("B".equals(billstatus) || "A".equals(billstatus))) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"DeclareUtils_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        } else if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "3".equals(datatype)) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u7a0e\u5c40\u4e0b\u8f7d\u7684\u7533\u62a5\u8868\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DeclareUtils_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        } else if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey) && "A".equals(billstatus)) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"DeclareUtils_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        } else if (StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey) && !"B".equals(billstatus)) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"DeclareUtils_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        }
        return msg;
    }

    public static boolean submit(IFormView view, List<Object> pklist, String operationKey, String entryName, boolean isQueryList) {
        QFilter qFilter2;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
        List<Object> updateList = new ArrayList<DynamicObject>();
        String msg = "";
        if (loadResult == null || loadResult.length < 1) {
            if (isQueryList) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DeclareUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), Integer.valueOf(2000));
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"DeclareUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            return false;
        }
        for (DynamicObject obj : loadResult) {
            String billstatus = obj.getString("billstatus");
            String declareStatus = obj.getString("declarestatus");
            String datatype = null;
            datatype = "tcvat_prepay_declare_bill".equals(entryName) ? "1" : obj.getString("datatype");
            if (DeclareUtils.undoCondition(billstatus, operationKey, datatype, declareStatus)) {
                updateList.add(obj);
                String billno = obj.getString("billno");
                String appId = view.getFormShowParameter().getAppId();
                String string = view.getFormShowParameter().getFormId();
                String operateName = ResManager.loadKDString((String)String.format(ResManager.loadKDString((String)"%s", (String)"DeclareUtils_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), OperateCodeEnum.getByCode(operationKey)), (String)"DeclareUtils_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u7533\u62a5\u8868%2$s\u6210\u529f\u3002", (String)"DeclareUtils_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode(operationKey));
                OperatorDialogUtils.operateDialogByAppid(DevprotalBizAppUtil.getTaxcAppByNumber(appId), string, operateName, operateDescription);
                continue;
            }
            String nsrmc = obj.getDynamicObject("org").getString("name");
            if ("tcret_declare_main".equals(entryName)) {
                String billno = obj.getString("billno");
                msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u7f16\u53f7\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DeclareUtils_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, billno);
                if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "declared".equals(declareStatus)) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u7f16\u53f7\u7533\u62a5\u8868\u5df2\u7533\u62a5\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DeclareUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, billno);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) || !"B".equals(billstatus)) continue;
                msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u7f16\u53f7\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"DeclareUtils_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, billno);
                continue;
            }
            if ("tcvat_wkpsr_query_list".equals(entryName)) {
                if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("B".equals(billstatus) || "A".equals(billstatus))) {
                    msg = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u7684\u5355\u636e\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"DeclareUtils_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                    continue;
                }
                if (StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operationKey) && ("B".equals(billstatus) || "C".equals(billstatus))) {
                    msg = ResManager.loadKDString((String)"\u4ec5\u6682\u5b58\u5355\u636e\u65b9\u53ef\u63d0\u4ea4\u3002", (String)"DeclareUtils_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                    continue;
                }
                if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey) && ("A".equals(billstatus) || "C".equals(billstatus))) {
                    msg = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u63d0\u4ea4\u7684\u5355\u636e\u8fdb\u884c\u5ba1\u6838\u3002", (String)"DeclareUtils_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey) || "B".equals(billstatus)) continue;
                msg = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u63d0\u4ea4\u7684\u5355\u636e\u8fdb\u884c\u64a4\u9500\u3002", (String)"DeclareUtils_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                continue;
            }
            Date skssqq = obj.getDate("skssqq");
            msg = DeclareUtils.undoMsg(billstatus, operationKey, datatype, declareStatus, nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
        }
        if (CollectionUtils.isEmpty(updateList)) {
            view.showErrorNotification(msg);
            return false;
        }
        StringBuilder builderstr = DeclareUtils.checkTaxRefundApply(updateList, operationKey);
        TaxResult<List<DynamicObject>> riskControlResult = RiskControlUtils.checkRiskControlResult(updateList, operationKey, entryName);
        logger.info("\u98ce\u63a7\u63a5\u53e3\u8c03\u7528\u7ed3\u679c\uff1a", (Object)riskControlResult.isSuccess());
        if (!riskControlResult.isSuccess()) {
            builderstr.append(riskControlResult.getMessage()).append(SEPARATOR);
            updateList = (List)riskControlResult.getData();
        }
        if (updateList.size() == 0 && StringUtil.isNotBlank((CharSequence)builderstr)) {
            view.showErrorNotification(builderstr.toString());
            return false;
        }
        String appId = view.getFormShowParameter().getAppId();
        String formId = view.getFormShowParameter().getFormId();
        String billList = (String)DeclareUtils.getWorkFlowConfigBill().get((Object)appId, (Object)formId);
        QFilter qFilter1 = StringUtil.isNotEmpty((CharSequence)billList) ? new QFilter("entrabill", "in", (Object)Lists.newArrayList((Object[])new String[]{entryName, billList})) : new QFilter("entrabill", "=", (Object)entryName);
        DynamicObject processdefinition = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id,entrabill", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("enable", "=", (Object)"enable")});
        if (processdefinition == null) {
            DeclareUtils.updateData(updateList, operationKey);
        } else {
            List ids = updateList.stream().map(u -> u.getLong("id")).collect(Collectors.toList());
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)processdefinition.getString("entrabill"), (Object[])ids.toArray(), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                view.showOperationResult(operationResult);
                return false;
            }
        }
        if ("tcvat_prepay_declare_bill".equals(entryName)) {
            MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx");
            List list = updateList.stream().map(u -> u.getLong("id")).collect(Collectors.toList());
            DynamicObject[] mainData = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)mainEntity);
            DeclareUtils.updateData(Arrays.asList(mainData), operationKey);
        }
        if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey) && !"tcvat_prepay_declare_bill".equals(entryName) && !"tcret_declare_main".equals(entryName)) {
            for (DynamicObject dynamicObject : updateList) {
                DynamicObject org = dynamicObject.getDynamicObject("org");
                long orgId = org.getLong("id");
                Date startDate = (Date)dynamicObject.get("skssqq");
                Date endDate = (Date)dynamicObject.get("skssqz");
                String type = dynamicObject.getString("type");
                if (!StringUtils.trimToEmpty((String)type).startsWith("zzs") && !StringUtils.trimToEmpty((String)type).startsWith("qysds")) continue;
                BaseDataHistoryService.saveBaseDataHistory(orgId, startDate, endDate);
            }
        }
        if ("tcvat_wkpsr_query_list".equals(entryName) || "tcvat_prepay_declare_bill".equals(entryName)) {
            if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey)) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"DeclareUtils_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            } else if (StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operationKey)) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"DeclareUtils_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            } else if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey)) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"DeclareUtils_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            } else if (StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey)) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"DeclareUtils_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        } else {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"DeclareUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (AUDIT.equals(operationKey) || UNAUDIT.equals(operationKey)) {
            loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
            DeclareEditAndListEnum declareEditAndListEnum = DeclareEditAndListEnum.valueOfCode(view.getFormShowParameter().getFormId());
            DeclareUtils.refreshElement(loadResult, operationKey, EmptyCheckUtils.isNotEmpty((Object)declareEditAndListEnum) ? declareEditAndListEnum.getListForm() : "");
            DeclareUtils.createTaxRefund(loadResult, operationKey);
        }
        if (EmptyCheckUtils.isNotEmpty(updateList)) {
            DynamicObject[] saveObjects = updateList.toArray(new DynamicObject[updateList.size()]);
            DeclareMainServiceHelper.fireModel2DeclareMainChangeEvent((DynamicObject[])saveObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operationKey));
        }
        if (StringUtil.isNotBlank((CharSequence)builderstr)) {
            view.showErrorNotification(builderstr.toString());
            return false;
        }
        return true;
    }

    private static void refreshElement(DynamicObject[] loadResult, String operationKey, String entityName) {
        for (DynamicObject entity : loadResult) {
            String entityType = entity.getString("type");
            if ("ccxws".equals(entityType)) {
                String sbbid = entity.getString("id");
                DynamicObject[] zbList = BusinessDataServiceHelper.load((String)"tcret_ccxws_zb_hb", (String)"id,ewblxh,ewblname,sbbid,seqno,taxtype,sm,sl,startdate,enddate,jsyj,ynse,jmse,yjse,ybse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
                DeclareMQSender.sendTcretMQ(entity, zbList, DeclareMQType.DECLARE.name(), operationKey, entityName);
                continue;
            }
            DeclareMQSender.sendMQ(entity, null, DeclareMQType.DECLARE.name(), operationKey, entityName);
        }
    }

    private static void updateData(List<DynamicObject> updateList, String operationKey) {
        for (DynamicObject obj : updateList) {
            if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey)) {
                obj.set("billstatus", (Object)"C");
                obj.set("auditdate", (Object)new Date());
                obj.set("auditor", (Object)RequestContext.get().getUserId());
            }
            if (StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operationKey)) {
                obj.set("billstatus", (Object)"B");
            }
            if (StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey)) {
                obj.set("billstatus", (Object)"A");
            }
            if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey)) {
                obj.set("billstatus", (Object)"A");
                obj.set("auditdate", null);
                obj.set("auditor", (Object)0L);
            }
            obj.set("modifier", (Object)RequestContext.get().getUserId());
            obj.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    public static boolean checkDeclareDataInWorkFlowProcessFinished(String businessKey, String operationKey) {
        Map bizProcessStatus = WorkflowServiceHelper.getBizProcessStatus((String[])new String[]{businessKey});
        return EmptyCheckUtils.isEmpty(bizProcessStatus);
    }

    public static void showRiskDialog(String sbbid, IFormView view) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bdtaxr_declare_risk_view");
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put("sbbid", sbbid);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(param);
    }

    public static String getRiskContentNormalStr() {
        return ResManager.loadKDString((String)"\u6b63\u5e38", (String)"DeclareUtils_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    public static String getRiskContentAbnormalStr() {
        return ResManager.loadKDString((String)"\u5f02\u5e38", (String)"DeclareUtils_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    public static String getBillNo(String orgid, Date startDate, Date endDate, String type) {
        DynamicObject declareMain = DeclareUtils.getDeclareMain(orgid, startDate, endDate, type);
        if (declareMain != null) {
            return declareMain.getString("billno");
        }
        switch (type) {
            case "qysdsjb": {
                return DeclareUtils.generateDraftNo("tccit_query_report", orgid);
            }
            case "qysds_hdzs_jb": {
                return DeclareUtils.generateDraftNo("tccit_query_report", orgid);
            }
            case "qysdsnb": {
                return DeclareUtils.generateDraftNo("tccit_quarterly_report", orgid);
            }
            case "qysdsnb_fzjg": {
                return DeclareUtils.generateDraftNo("tccit_quarterly_report", orgid);
            }
            case "qysds_hdzs_nb": {
                return DeclareUtils.generateDraftNo("tccit_quarterly_report", orgid);
            }
            case "zzsybnsr": {
                return DeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
            }
            case "zzsxgmnsr": {
                String billno = DeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VATSS");
            }
            case "zzsybnsr_ybhz": {
                String billno = DeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VATSUM");
            }
            case "zzsybnsr_hz_zjg": {
                String billno = DeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VAT-HZ");
            }
            case "zzsybnsr_yz_zjg": {
                String billno = DeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VAYSUM-HOYZ");
            }
            case "zzsybnsr_yz_fzjg": {
                String billno = DeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VAYSUM-BOYZ");
            }
            case "zzstz": {
                return DeclareUtils.generateDraftNo("tcvat_wkpsr_query_list", orgid);
            }
        }
        return null;
    }

    private static String generateDraftNo(String entityName, String orgid) {
        return DeclareServiceHelper.generateSBBNo(entityName, null, orgid);
    }

    private static DynamicObject getDeclareMain(String orgid, Date startDate, Date endDate, Object type) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("skssqq", "=", (Object)startDate);
        QFilter q3 = new QFilter("skssqz", "=", (Object)endDate);
        QFilter q4 = new QFilter("type", "=", type);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billstatus,billno,zerodeclare", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        return object;
    }

    public static void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus, DynamicObject object, IFormView view) {
        String billstatus;
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(type);
        String datatype = object != null ? object.getString("datatype") : null;
        String string = billstatus = object != null ? object.getString("billstatus") : null;
        if ("ccxws".equals(type)) {
            if ("declared".equals(declarestatus) || "2".equals(datatype)) {
                if ("2".equals(datatype) && "A".equals(billstatus)) {
                    param.setFormId("tcret_declare_import_edit");
                } else {
                    param.setFormId(templateEnum.getDeclareShowPage());
                    param.setCaption(TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
                }
            } else {
                param.setFormId(templateEnum.getDeclarePage());
            }
        } else if ("declared".equals(declarestatus)) {
            param.setFormId(templateEnum.getDeclareShowPage());
            param.setCaption(TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
            DeclareCustomParamsHelper.setDeclareRequestData(object, customParams);
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(param);
    }

    public static String getVersionType(String reportId, String mainTable) {
        if (!"tcvat_nsrxx".equals(mainTable)) {
            return "";
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)mainTable, (String)"versiontype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(reportId))});
        return null == dynamicObject ? "zcsb" : dynamicObject.getString("versiontype");
    }

    public static String checkGzZfInfo(String operateKey, Object pkValue) {
        String keyStr;
        DynamicObject declares = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"tcvat_nsrxx");
        String declarestatus = declares.getString("declarestatus");
        String paystatus = declares.getString("paystatus");
        String string = keyStr = "invalid".equals(operateKey) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"DeclareUtils_28", (String)"taxc-bdtaxr-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"DeclareUtils_29", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        if (!"declared".equals(declarestatus)) {
            return String.format(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u7533\u62a5\u6210\u529f\u201d\u7684\u6570\u636e\uff0c\u624d\u80fd%s\u7533\u62a5\u3002", (String)"DeclareUtils_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), keyStr);
        }
        if ("invalid".equals(operateKey)) {
            if (!"unpaid".equals(paystatus) && !"nopay".equals(paystatus)) {
                return ResManager.loadKDString((String)"\u53ea\u6709\u201c\u672a\u7f34\u6b3e\u201d\u6216\u201c\u65e0\u9700\u7f34\u6b3e\u201d\u7684\u6570\u636e\uff0c\u624d\u80fd\u4f5c\u5e9f\u7533\u62a5\u3002", (String)"DeclareUtils_31", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            if (DeclareUtils.judgeGenerCert(pkValue.toString())) {
                return ResManager.loadKDString((String)"\u7a0e\u91d1\u7f34\u7eb3\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u518d\u64cd\u4f5c\u3002", (String)"DeclareUtils_32", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
            if ("gzsb".equals(declares.getString("versiontype"))) {
                return ResManager.loadKDString((String)"\u7248\u672c\u7c7b\u578b\u4e3a\u201c\u66f4\u6b63\u7533\u62a5\u201d\u7684\u6570\u636e\u4e0d\u652f\u6301\u201c\u4f5c\u5e9f\u7533\u62a5\u201d\u3002", (String)"DeclareUtils_33", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static boolean judgeGenerCert(String sbbid) {
        QFilter filter = new QFilter("sbbid", "=", (Object)sbbid).and("isvoucher", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{filter});
    }

    public static String convertDate2DeadLine(Date startdate, Date enddate) {
        if (startdate != null && enddate != null) {
            int monthDiff = Math.abs(DateUtils.getMonthOfDate(startdate) - DateUtils.getMonthOfDate(enddate));
            if (startdate.compareTo(enddate) == 0) {
                return "acsb";
            }
            if (monthDiff == 0) {
                return "aysb";
            }
            if (monthDiff == 2) {
                return "ajsb";
            }
        }
        return "";
    }

    static {
        RISK_CONTENT_MAP.put("normal", DeclareUtils.getRiskContentNormalStr());
        RISK_CONTENT_MAP.put("abnormal", DeclareUtils.getRiskContentAbnormalStr());
        RISK_CONTENT_MAP.put(DeclareUtils.getRiskContentNormalStr(), "normal");
        RISK_CONTENT_MAP.put(DeclareUtils.getRiskContentAbnormalStr(), "abnormal");
    }
}

