/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DiscountHelper {
    public static BigDecimal calculateDiscountRate(DynamicObject deductioncode, String isXxwlqy) {
        String deductiontype = null;
        if (deductioncode != null) {
            deductiontype = deductioncode.getString("deductiontype");
        }
        return DiscountHelper.calculateDiscountRate(deductiontype, isXxwlqy);
    }

    public static BigDecimal calculateDiscountRate(String deductiontype, String isXxwlqy) {
        BigDecimal jmrate = BigDecimal.valueOf(0L);
        if (EmptyCheckUtils.isNotEmpty(deductiontype)) {
            if ("1".equals(deductiontype)) {
                jmrate = BigDecimal.valueOf(1L);
            } else if ("2".equals(deductiontype)) {
                jmrate = "1".equals(isXxwlqy) || "true".equalsIgnoreCase(isXxwlqy) ? BigDecimal.valueOf(0.75) : BigDecimal.valueOf(0.5);
            }
        } else if ("1".equals(isXxwlqy) || "true".equalsIgnoreCase(isXxwlqy)) {
            jmrate = BigDecimal.valueOf(0.5);
        }
        return jmrate;
    }

    public static BigDecimal ajustJmse(String reliefPolicyType, DynamicObject changeRecord, Date skssqq, Date skssqz, BigDecimal jmhse) {
        Date taxstartdate = changeRecord.getDate("taxstartdate");
        if (StringUtil.isBlank((CharSequence)reliefPolicyType) && taxstartdate != null && taxstartdate.compareTo(skssqq) > 0 && taxstartdate.compareTo(skssqz) < 0) {
            int monthLength = DateUtils.getMonthDiff(skssqz, skssqq) + 1;
            int count = DateUtils.getMonthDiff(skssqz, taxstartdate) + 1;
            return BigDecimalUtil.divideObject(BigDecimalUtil.multiplyObject(jmhse, count, 2), monthLength, 2, 4);
        }
        return jmhse;
    }
}

