/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import java.io.InputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FileEncryptorUtil {
    private static final Log LOGGER = LogFactory.getLog(FileEncryptorUtil.class);

    public static SecretKey getKeyGenerator(String para) {
        SecretKey secretKey = null;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(para.getBytes("UTF-8"));
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128, secureRandom);
            secretKey = keyGenerator.generateKey();
        }
        catch (Exception e) {
            LOGGER.error("getKeyGenerator ERROR!", (Throwable)e);
        }
        return secretKey;
    }

    public static byte[] encryptDecryptFile(byte[] param) {
        byte[] bytes = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] iv = new byte[12];
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)FileEncryptorUtil.getKeyGenerator("fixed_seed_taxc"), gcmSpec);
            bytes = cipher.doFinal(param);
        }
        catch (Exception e) {
            LOGGER.error("encryptDecryptFile ERROR!", (Throwable)e);
        }
        return bytes;
    }

    public static InputStream decryptDecryptFile(InputStream param) {
        CipherInputStream stream = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] iv = new byte[12];
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)FileEncryptorUtil.getKeyGenerator("fixed_seed_taxc"), gcmSpec);
            stream = new CipherInputStream(param, cipher);
        }
        catch (Exception e) {
            LOGGER.error("encryptDecryptFile ERROR!", (Throwable)e);
        }
        return stream;
    }
}

