/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.FilterFields;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.taxc.bdtaxr.common.vo.FieldsColumnVo;

public class FilterFieldsUtil {
    private static final String ADMIN_DIVISION_PROP = "AdminDivisionProp";
    private static final String MUL_BASEDATA_PROP = "MulBasedataProp";

    public static Map<String, FieldsColumnVo> getFilterColumns(String entityNumber) {
        List<FieldsColumnVo> list = FilterFieldsUtil.getEntityAllFields(entityNumber, 2, 1, null);
        Map<String, FieldsColumnVo> filterColumnsMap = list.stream().collect(Collectors.toMap(FieldsColumnVo::getFieldNumber, columnVo -> columnVo, (key, value) -> key));
        return filterColumnsMap;
    }

    public static List<FieldsColumnVo> getEntityAllFields(String billNumber, int totalLevel, int currentLevel, FieldsColumnVo parentField) {
        ArrayList<FieldsColumnVo> fieldList = new ArrayList<FieldsColumnVo>();
        if (StringUtils.isBlank((CharSequence)billNumber)) {
            return fieldList;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        Map entityMap = mainEntityType.getAllEntities();
        String billName = mainEntityType.getDisplayName().getLocaleValue();
        for (Map.Entry entry : entityMap.entrySet()) {
            DataEntityPropertyCollection pros = ((EntityType)entry.getValue()).getProperties();
            for (IDataEntityProperty property : pros) {
                if (property.getDisplayName() == null) continue;
                FieldsColumnVo billField = FilterFieldsUtil.getFieldProperty(billNumber, billName, property, parentField, currentLevel);
                fieldList.add(billField);
                if (totalLevel <= currentLevel || property.getPropertyType() == null || !StringUtils.isNotBlank((CharSequence)billField.getBaseEntityId())) continue;
                fieldList.addAll(FilterFieldsUtil.getEntityAllFields(billField.getBaseEntityId(), totalLevel, currentLevel + 1, billField));
            }
        }
        return fieldList;
    }

    private static FieldsColumnVo getFieldProperty(String billNumber, String billName, IDataEntityProperty property, FieldsColumnVo parentField, int currentLevel) {
        FieldsColumnVo billField = new FieldsColumnVo();
        billField.setEntryEntity(billNumber);
        billField.setEntryEntityName(billName);
        StringBuilder numberBuilder = new StringBuilder();
        StringBuilder nameBuilder = new StringBuilder();
        billField.setLevel(currentLevel);
        if (parentField != null) {
            numberBuilder.append(parentField.getFieldNumber()).append('.');
            nameBuilder.append(parentField.getFieldName()).append('.');
        }
        FilterFieldsUtil.setParentProperty(billNumber, numberBuilder, nameBuilder, property.getParent());
        numberBuilder.append(property.getName());
        nameBuilder.append(property.getDisplayName().getLocaleValue());
        billField.setFieldNumber(numberBuilder.toString());
        billField.setFieldName(nameBuilder.toString());
        billField.setFieldEntityProperty(property);
        Class<?> propertyClass = property.getClass();
        String className = propertyClass.getName().substring(propertyClass.getName().lastIndexOf(46) + 1);
        billField.setBaseEntityId(FilterFieldsUtil.getEntityKeyByType(className, property));
        return billField;
    }

    private static void setParentProperty(String billNumber, StringBuilder numberBuilder, StringBuilder nameBuilder, IDataEntityType entryType) {
        if (entryType != null && !billNumber.equals(entryType.getName())) {
            FilterFieldsUtil.setParentProperty(billNumber, numberBuilder, nameBuilder, entryType.getParent());
            numberBuilder.append(entryType.getName()).append('.');
            nameBuilder.append(entryType.getDisplayName().getLocaleValue()).append('.');
        }
    }

    private static String getEntityKeyByType(String fieldType, IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            return ((BasedataProp)property).getBaseEntityId();
        }
        switch (fieldType) {
            case "MulBasedataProp": {
                return ((MulBasedataProp)property).getBaseEntityId();
            }
            case "AdminDivisionProp": {
                return "bd_admindivision";
            }
        }
        return "";
    }
}

