/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class PayDateUtils {
    private static final String TPO_TAX_CALENDAR = "tpo_tax_calendar";
    private static String TPO_TAX_CALENDAR_ALL_FIELDS = "year,description,creatorid,createtime,modifierid,modifytime,entryentity.taxtype,entryentity.methods,entryentity.january,entryentity.february,entryentity.march,entryentity.april,entryentity.may,entryentity.june,entryentity.july,entryentity.august,entryentity.september,entryentity.october,entryentity.november,entryentity.december,entryentity.provinces,entryentity.city,id,entryentity.id,entryentity.seq";
    private static Map<Integer, String> monthMap = new HashMap<Integer, String>();
    public static List<String> sbbTypeList_0 = Arrays.asList("zzsybnsr", "zzsxgmnsr", "fjsf", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "ccxws", "qysdsjb", "qysds_hdzs_jb", "szys_a", "fcs", "cztdsys", "yhs", "tcept", "yys", "tcrt", "tvpt", "zzsyjskb");
    public static List<String> sbbTypeList_1 = Arrays.asList("qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_nb");

    public static Date getPayDate(Date applyDate, Long taxauthorityId, String sbbtype, Date skssqz) {
        List<Long> directCity = Arrays.asList(123L, 141L, 2675L, 3134L);
        DynamicObject calendarObject = null;
        Long taxorganaddress = null;
        Date paydate = null;
        int year = 0;
        int month = 0;
        if (sbbTypeList_0.contains(sbbtype)) {
            year = DateUtils.getYearOfDate(skssqz);
            month = DateUtils.getMonthOfDate(skssqz);
            if (12 == month) {
                ++year;
                month = 1;
            } else {
                ++month;
            }
        }
        if (sbbTypeList_1.contains(sbbtype)) {
            int yearOfDate = DateUtils.getYearOfDate(skssqz) + 1;
            return DateUtils.stringToDate(yearOfDate + "-05-31");
        }
        if ("ccxws".equals(sbbtype)) {
            year = DateUtils.getYearOfDate(applyDate);
            month = DateUtils.getMonthOfDate(applyDate);
        }
        if ("tcvvt".equals(sbbtype)) {
            return skssqz;
        }
        DynamicObject taxorgObject = QueryServiceHelper.queryOne((String)"bastax_taxorgan", (String)"taxorganaddress,parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxauthorityId)});
        if (null != taxorgObject) {
            taxorganaddress = PayDateUtils.getTaxOrganAddress(taxorgObject, directCity);
            QFilter provinceFilter = new QFilter("entryentity.provinces", "=", (Object)taxorganaddress);
            QFilter cityFilter = new QFilter("entryentity.city", "=", (Object)0L);
            QFilter yearFilter = new QFilter("year", "=", (Object)String.valueOf(year));
            QFilter taxTypeFilter = new QFilter("entryentity.taxtype", "=", (Object)"1");
            QFilter methodsFilter = new QFilter("entryentity.methods", "=", (Object)"2");
            calendarObject = directCity.contains(taxorganaddress) ? QueryServiceHelper.queryOne((String)TPO_TAX_CALENDAR, (String)TPO_TAX_CALENDAR_ALL_FIELDS, (QFilter[])new QFilter[]{provinceFilter, taxTypeFilter, methodsFilter, yearFilter}) : QueryServiceHelper.queryOne((String)TPO_TAX_CALENDAR, (String)TPO_TAX_CALENDAR_ALL_FIELDS, (QFilter[])new QFilter[]{provinceFilter, cityFilter, taxTypeFilter, methodsFilter, yearFilter});
            if (null != calendarObject) {
                String currentMonth = calendarObject.getString("entryentity." + monthMap.get(month));
                String Date2 = year + "-" + currentMonth.replace(ResManager.loadKDString((String)"\u6708", (String)"PayDateUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "-").replace(ResManager.loadKDString((String)"\u65e5", (String)"PayDateUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "");
                paydate = DateUtils.stringToDate(Date2);
            } else {
                paydate = null;
            }
        } else {
            paydate = null;
        }
        return paydate;
    }

    private static Long getTaxOrganAddress(DynamicObject taxorgObject, List<Long> directCity) {
        if (taxorgObject == null) {
            return 0L;
        }
        Long taxorganaddress = 0L;
        long parentid = taxorgObject.getLong("parent");
        long addressid = taxorgObject.getLong("taxorganaddress");
        if (0L != parentid) {
            DynamicObject parent = QueryServiceHelper.queryOne((String)"bastax_taxorgan", (String)"taxorganaddress,parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentid)});
            taxorganaddress = PayDateUtils.getTaxOrganAddress(parent, directCity);
        } else {
            taxorganaddress = 194L == addressid ? Long.valueOf(179L) : (407L == addressid ? Long.valueOf(382L) : (2530L == addressid ? Long.valueOf(2517L) : (2232L == addressid ? Long.valueOf(2215L) : (3547L == addressid ? Long.valueOf(3533L) : (directCity.contains(addressid) || 1073L == addressid ? Long.valueOf(addressid) : Long.valueOf(addressid - 1L))))));
        }
        return taxorganaddress;
    }

    static {
        monthMap.put(1, "january");
        monthMap.put(2, "february");
        monthMap.put(3, "march");
        monthMap.put(4, "april");
        monthMap.put(5, "may");
        monthMap.put(6, "june");
        monthMap.put(7, "july");
        monthMap.put(8, "august");
        monthMap.put(9, "september");
        monthMap.put(10, "october");
        monthMap.put(11, "november");
        monthMap.put(12, "december");
    }
}

