/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;

public class PayRecordUtils {
    public static boolean havePayRecord(DynamicObject nsrxx) {
        String billno = nsrxx.getString("billno");
        return QueryServiceHelper.exists((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{new QFilter("sbbno", "=", (Object)billno)});
    }

    public static Long calcuZnj(Date deadline, String syqjje) {
        BigDecimal gsznj = BigDecimal.ZERO;
        int dayDiff = DateUtils.getDayDiff(deadline, new Date());
        if (dayDiff > 0) {
            gsznj = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)dayDiff, (Object)BigDecimalUtil.toBigDecimal((Object)syqjje), (int)2), (Object)"0.0005", (int)2);
        }
        return gsznj.longValue();
    }

    public static BigDecimal getDelayMoney(DynamicObject rowData, int dayDiff) {
        BigDecimal result = BigDecimal.ZERO;
        Object syqjje = rowData.get("yjje");
        String paystatus = rowData.getString("paystatus");
        if ("2".equals(paystatus)) {
            syqjje = rowData.get("syqjje");
        }
        if (Objects.nonNull(syqjje)) {
            result = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)dayDiff, (Object)BigDecimalUtil.toBigDecimal((Object)syqjje), (int)2), (Object)"0.0005", (int)2);
        }
        return result;
    }

    public static Integer getDelayNum(DynamicObject rowData) {
        Integer dayDiff = null;
        Object deadline = rowData.get("deadline");
        Object paydate = rowData.get("paydate");
        if (Objects.isNull(deadline)) {
            return dayDiff;
        }
        String paystatus = rowData.getString("paystatus");
        if ("2".equals(paystatus)) {
            dayDiff = DateUtils.getDayDiff((Date)deadline, new Date());
        } else if ("1".equals(paystatus) && Objects.nonNull(paydate)) {
            dayDiff = DateUtils.getDayDiff((Date)deadline, (Date)paydate);
        }
        return dayDiff;
    }

    public static void setZnj(DynamicObject payrecord) {
        String paystatus = payrecord.getString("paystatus");
        payrecord.set("operatetime", (Object)new Date());
        if ("1".equals(paystatus)) {
            PayRecordUtils.setYjkZnj(payrecord);
        } else {
            PayRecordUtils.setWjkZnj(payrecord);
        }
    }

    public static void setYjkZnj(DynamicObject payrecord) {
        Object deadline = payrecord.get("deadline");
        Object syqjje = payrecord.get("sjje");
        Object paydate = payrecord.get("paydate");
        BigDecimal mrsjznj = payrecord.getBigDecimal("sjznj");
        if (Objects.nonNull(deadline) && Objects.nonNull(syqjje) && Objects.nonNull(paydate) && mrsjznj.compareTo(BigDecimal.ZERO) == 0) {
            int dayDiff = DateUtils.getDayDiff((Date)deadline, (Date)paydate);
            BigDecimal syqjjexs = BigDecimalUtil.toBigDecimal((Object)syqjje);
            if (dayDiff > 0 && syqjjexs.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal gsznj = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)dayDiff, (Object)BigDecimalUtil.toBigDecimal((Object)syqjje), (int)2), (Object)"0.0005", (int)2);
                if (gsznj.compareTo(BigDecimal.ONE) < 0) {
                    return;
                }
                payrecord.set("sjznj", (Object)gsznj);
                DynamicObjectCollection entryentity = payrecord.getDynamicObjectCollection("entryentity");
                if (!CollectionUtils.isEmpty((Collection)entryentity)) {
                    BigDecimal sjznjmxTotil = BigDecimal.ZERO;
                    BigDecimal sjznjmxMax = BigDecimal.ZERO;
                    Long maxId = 0L;
                    for (DynamicObject dynamicObject : entryentity) {
                        Object sjjemx = dynamicObject.get("sjjemx");
                        if (!Objects.nonNull(sjjemx) || BigDecimalUtil.toBigDecimal((Object)sjjemx).compareTo(BigDecimal.ZERO) == 0) continue;
                        BigDecimal sjznjmx = BigDecimalUtil.toBigDecimal((Object)sjjemx).divide(syqjjexs, 2, 4).multiply(gsznj).setScale(2, 4);
                        dynamicObject.set("delaypay", (Object)sjznjmx);
                        sjznjmxTotil = sjznjmxTotil.add(sjznjmx);
                        if (sjznjmx.compareTo(sjznjmxMax) <= 0) continue;
                        sjznjmxMax = sjznjmx;
                        maxId = dynamicObject.getLong("id");
                    }
                    if (sjznjmxTotil.compareTo(sjznjmxMax) != 0 && sjznjmxTotil.compareTo(gsznj) != 0) {
                        BigDecimal divide = gsznj.divide(sjznjmxTotil, 2, 4);
                        for (DynamicObject dynamicObj : entryentity) {
                            if (!maxId.equals(dynamicObj.getLong("id"))) continue;
                            BigDecimal delaypay = dynamicObj.getBigDecimal("delaypay");
                            dynamicObj.set("delaypay", (Object)delaypay.add(divide));
                        }
                    }
                }
            }
        }
    }

    public static void setWjkZnj(DynamicObject payrecord) {
        payrecord.set("sjznj", (Object)0);
        DynamicObjectCollection entryentity = payrecord.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            for (DynamicObject dynamicObject : entryentity) {
                dynamicObject.set("delaypay", (Object)0.0);
            }
        }
    }
}

