/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OperateCodeEnum;
import kd.taxc.bdtaxr.common.helper.tctrc.RiskResultHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.LowTimer;

public class RiskControlUtils {
    private static Log logger = LogFactory.getLog(RiskControlUtils.class);
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static List<String> supportOpers = Lists.newArrayList((Object[])new String[]{"submit", "audit"});

    public static TaxResult<List<DynamicObject>> checkRiskControlResult(List<DynamicObject> declares, String operationKey, String entityName) {
        TaxResult result = new TaxResult();
        result.setSuccess(true);
        result.setData(declares);
        try {
            LowTimer lowTimer = new LowTimer();
            if (EmptyCheckUtils.isEmpty(declares) || !supportOpers.contains(operationKey)) {
                return result;
            }
            StringBuilder errorMessage = new StringBuilder();
            ArrayList<Long> failureObjs = new ArrayList<Long>(10);
            List<Map<String, Object>> riskControlParams = RiskControlUtils.buildRiskControlParams(declares, operationKey);
            TaxResult riskControlResult = RiskResultHelper.getRiskControlResult(riskControlParams);
            if (riskControlResult.isSuccess()) {
                List data = (List)riskControlResult.getData();
                if (EmptyCheckUtils.isNotEmpty(data)) {
                    Map<String, Map> declareResultMap = data.stream().collect(Collectors.toMap(k -> (String)k.get("id"), v -> v, (v1, v2) -> v2));
                    for (DynamicObject declare2 : declares) {
                        Map declareResult = declareResultMap.get(declare2.getString("id"));
                        if (!EmptyCheckUtils.isNotEmpty(declareResult) || !"0".equals(declareResult.get("verifyResult"))) continue;
                        String msg = (String)declareResult.get("tipMsg");
                        if (errorMessage.length() > 0) {
                            errorMessage.append(SEPARATOR);
                        }
                        errorMessage.append(msg);
                        if (StringUtil.isNotBlank((CharSequence)entityName) && EmptyCheckUtils.isNotEmpty(declare2)) {
                            OperatorDialogUtils.operateDialog(RiskControlUtils.getTemplateType(declare2), entityName, OperateCodeEnum.getByCode(operationKey), msg);
                        }
                        failureObjs.add(declare2.getLong("id"));
                    }
                    if (failureObjs.size() > 0) {
                        List updateList = declares.stream().filter(declare -> !failureObjs.contains(declare.getLong("id"))).collect(Collectors.toList());
                        result.setData(updateList);
                        result.setMessage(errorMessage.toString());
                        result.setSuccess(false);
                    }
                } else {
                    logger.info("\u8c03\u7528\u98ce\u63a7\u670d\u52a1\u5f02\u5e38\uff0c\u8fd4\u56dedata\u4e3a\u7a7a\u3002");
                }
            } else {
                logger.info("\u8c03\u7528\u98ce\u63a7\u670d\u52a1\u5f02\u5e38{}\u3002", (Object)riskControlResult.getMessage());
            }
            logger.info("RiskControlUtils.checkRiskControlResult \u8017\u65f6:{}", (Object)lowTimer.msValue());
        }
        catch (Exception e) {
            logger.error("RiskControlUtils.checkRiskControlResult error:" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static TaxResult<Map<String, String>> checkRiskControlResultForValidator(List<DynamicObject> declares, String operationKey, String entityName) {
        HashMap<String, String> errorMap = new HashMap<String, String>(10);
        TaxResult result = new TaxResult();
        result.setSuccess(true);
        result.setData(errorMap);
        try {
            LowTimer lowTimer = new LowTimer();
            if (EmptyCheckUtils.isEmpty(declares) || !supportOpers.contains(operationKey)) {
                return result;
            }
            StringBuilder errorMessage = new StringBuilder();
            ArrayList<Long> failureObjs = new ArrayList<Long>(10);
            List<Map<String, Object>> riskControlParams = RiskControlUtils.buildRiskControlParams(declares, operationKey);
            TaxResult riskControlResult = RiskResultHelper.getRiskControlResult(riskControlParams);
            if (riskControlResult.isSuccess()) {
                List data = (List)riskControlResult.getData();
                if (EmptyCheckUtils.isNotEmpty(data)) {
                    Map<String, Map> declareResultMap = data.stream().collect(Collectors.toMap(k -> (String)k.get("id"), v -> v, (v1, v2) -> v2));
                    for (DynamicObject declare : declares) {
                        Map declareResult = declareResultMap.get(declare.getString("id"));
                        if (!EmptyCheckUtils.isNotEmpty(declareResult) || !"0".equals(declareResult.get("verifyResult"))) continue;
                        String msg = (String)declareResult.get("tipMsg");
                        errorMap.put(declare.getString("id"), msg);
                        if (errorMessage.length() > 0) {
                            errorMessage.append(SEPARATOR);
                        }
                        errorMessage.append(msg);
                        if (StringUtil.isNotBlank((CharSequence)entityName) && EmptyCheckUtils.isNotEmpty(declare)) {
                            OperatorDialogUtils.operateDialog(RiskControlUtils.getTemplateType(declare), entityName, OperateCodeEnum.getByCode(operationKey), msg);
                        }
                        failureObjs.add(declare.getLong("id"));
                    }
                    if (failureObjs.size() > 0) {
                        result.setData(errorMap);
                        result.setMessage(errorMessage.toString());
                        result.setSuccess(false);
                    }
                } else {
                    logger.info("\u8c03\u7528\u98ce\u63a7\u670d\u52a1\u5f02\u5e38\uff0c\u8fd4\u56dedata\u4e3a\u7a7a\u3002");
                }
            } else {
                logger.info("\u8c03\u7528\u98ce\u63a7\u670d\u52a1\u5f02\u5e38{}\u3002", (Object)riskControlResult.getMessage());
            }
            logger.info("RiskControlUtils.checkRiskControlResult \u8017\u65f6:{}", (Object)lowTimer.msValue());
        }
        catch (Exception e) {
            logger.error("RiskControlUtils.checkRiskControlResult error:" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static List<Map<String, Object>> buildRiskControlParams(List<DynamicObject> declares, String operateKey) {
        ArrayList<Map<String, Object>> riskControlParams = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject declare : declares) {
            HashMap<String, Object> riskControlParam = new HashMap<String, Object>(10);
            if ("tcvat_nsrxx".equals(declare.getDataEntityType().getName())) {
                riskControlParam.put("id", RiskControlUtils.getStringValue(declare, "id"));
                riskControlParam.put("number", RiskControlUtils.getStringValue(declare, "billno"));
                riskControlParam.put("templateTypeNumber", RiskControlUtils.getStringValue(declare, "type"));
                riskControlParam.put("skssqq", RiskControlUtils.getDateStringValue(declare, "skssqq"));
                riskControlParam.put("skssqz", RiskControlUtils.getDateStringValue(declare, "skssqz"));
                riskControlParam.put("orgId", RiskControlUtils.getDynamicObjectValue(declare, "org"));
                riskControlParam.put("draftPurpose", RiskControlUtils.getStringValue(declare, "draftpurpose"));
                riskControlParam.put("taxTypeId", RiskControlUtils.getDynamicObjectValue(declare, "taxtype"));
                riskControlParam.put("operateType", operateKey);
            } else {
                riskControlParam.put("id", RiskControlUtils.getStringValue(declare, "id"));
                riskControlParam.put("number", RiskControlUtils.getStringValue(declare, "billno"));
                riskControlParam.put("templateTypeNumber", declare.getString("templatetype.number"));
                riskControlParam.put("skssqq", RiskControlUtils.getDateStringValue(declare, "skssqq"));
                riskControlParam.put("skssqz", RiskControlUtils.getDateStringValue(declare, "skssqz"));
                riskControlParam.put("orgId", RiskControlUtils.getDynamicObjectValue(declare, "org"));
                riskControlParam.put("draftPurpose", RiskControlUtils.getStringValue(declare, "draftpurpose"));
                riskControlParam.put("taxTypeId", RiskControlUtils.getDynamicObjectValue(declare, "taxtype"));
                riskControlParam.put("operateType", operateKey);
            }
            riskControlParams.add(riskControlParam);
        }
        return riskControlParams;
    }

    private static String getTemplateType(DynamicObject declare) {
        if ("tcvat_nsrxx".equals(declare.getDataEntityType().getName())) {
            return RiskControlUtils.getStringValue(declare, "type");
        }
        return declare.getString("templatetype.number");
    }

    private static String getDateStringValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key) || entity.getDate(key) == null) {
            return "";
        }
        return DateUtils.format(entity.getDate(key));
    }

    private static String getStringValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key)) {
            return "";
        }
        return entity.getString(key);
    }

    private static Long getDynamicObjectValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key)) {
            return null;
        }
        Object value = entity.get(key);
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getLong("id");
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return null;
    }
}

