/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.finance.TcvvtCategoryInfoBusinessImpl;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxBaseDataUtils {
    public static final String BASTAX_TAXORG = "bastax_taxorg";
    public static final String TCCIT_QYSDS_A000000 = "tccit_qysds_a000000";
    private static HashSet<String> gtgsh = Sets.newHashSet((Object[])new String[]{"410", "411", "412", "413"});

    public static DynamicObject getTaxMainInfo(Long orgid) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQysdsByOrgIds(Collections.singletonList(orgid));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty(result.getData())) {
            return (DynamicObject)((List)result.getData()).get(0);
        }
        return null;
    }

    public static String getTaxLimit(String taxType, Long orgid) {
        DynamicObjectCollection categoryentryentity;
        Optional<DynamicObject> taxtype;
        DynamicObject taxMainInfo = TaxBaseDataUtils.getTaxMainInfo(orgid);
        if (taxMainInfo != null && (taxtype = (categoryentryentity = taxMainInfo.getDynamicObjectCollection("categoryentryentity")).stream().filter(a -> StringUtil.equals((CharSequence)taxType, (CharSequence)a.getString("taxtype"))).filter(a -> StringUtil.equals((CharSequence)"1", (CharSequence)a.getString("enable"))).findFirst()).isPresent()) {
            return taxtype.get().getString("deadline");
        }
        return null;
    }

    public static String getReliefPolicyType(Long orgId, Date skssqq, Date skssqz, boolean isCcxws) {
        DynamicObject changeRecord = OrgChangeRecordUtil.loadChangeRecord(orgId.toString(), skssqq, skssqz);
        if (changeRecord != null && "xgmnsr".equals(changeRecord.getString("taxpayertype"))) {
            return "xgmnsr";
        }
        DynamicObject taxMainInfo = TaxBaseDataUtils.getTaxMainInfo(orgId);
        if (null != taxMainInfo) {
            String registerTypeNumber;
            String string = registerTypeNumber = taxMainInfo.getDynamicObject("registertype") != null ? taxMainInfo.getDynamicObject("registertype").getString("number") : "";
            if (gtgsh.contains(registerTypeNumber)) {
                return "gtgsh";
            }
            if (isCcxws) {
                String xxwlqy = TaxBaseDataUtils.queryQysdsXxwlqy(orgId, skssqq, skssqz, changeRecord, taxMainInfo);
                return "1".equals(xxwlqy) ? "xxwlqy" : "";
            }
            return "xxwlqy";
        }
        return "";
    }

    public static String queryQysdsXxwlqy(Long orgId, Date skssqq, Date skssqz, DynamicObject changeRecord, DynamicObject taxMainInfo) {
        Date registertime = taxMainInfo.getDate("registertime");
        if (registertime != null) {
            DynamicObject a000000;
            int registerYear = DateUtils.getYearOfDate(registertime);
            int year = DateUtils.getYearOfDate(skssqz);
            if (year <= registerYear) {
                return TaxBaseDataUtils.checkXxwlqyByTaxMainInfo(taxMainInfo);
            }
            int month = DateUtils.getMonthOfDate(skssqz);
            HashMap<String, Object> extendParams = new HashMap<String, Object>();
            extendParams.put("billstatus", "C");
            extendParams.put("declarestatus", "declared");
            String start = null;
            String end = null;
            if (month > 6) {
                start = year - 1 + "-01-01";
                end = year - 1 + "-12-31";
            } else {
                start = year - 2 + "-01-01";
                end = year - 2 + "-12-31";
            }
            DynamicObject ybnsr = YbnsrService.queryYbnsr(orgId.toString(), "qysdsnb", start, end, extendParams);
            if (ybnsr != null && (a000000 = QueryServiceHelper.queryOne((String)TCCIT_QYSDS_A000000, (String)"xxwlqy", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)ybnsr.getString("id"))})) != null) {
                return a000000.getString("xxwlqy");
            }
        }
        return "";
    }

    public static String checkXxwlqyByTaxMainInfo(DynamicObject taxMainInfo) {
        int registernumber = taxMainInfo.getInt("registernumber");
        BigDecimal registerassets = taxMainInfo.getBigDecimal("registerassets");
        boolean restrictbanindustry = taxMainInfo.getBoolean("restrictbanindustry");
        if (!restrictbanindustry && registernumber <= 300 && registerassets.compareTo(new BigDecimal("50000000")) <= 0) {
            return "1";
        }
        return "0";
    }

    public static String isXxwlqy(String orgId, Date skssqq, Date skssqz) {
        DynamicObject taxMainInfo = TaxBaseDataUtils.getTaxMainInfo(Long.valueOf(orgId));
        DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord(orgId, skssqq, skssqz);
        String isXxwlqy = "";
        if (taxMainInfo != null) {
            isXxwlqy = TaxBaseDataUtils.queryQysdsXxwlqy(Long.valueOf(orgId), skssqq, skssqz, dynamicObject, taxMainInfo);
        }
        return isXxwlqy;
    }

    public static List<Long> getTaxEnableFromTaxMain(List<Long> filteOrgList, String appid) {
        if (appid.equals(TaxAppEnum.TCVVT.getAppid())) {
            List<Long> ids = TcvvtCategoryInfoBusinessImpl.querycwbbCategoryInfoByOrgIds(filteOrgList);
            DynamicObjectCollection list = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.id", (QFilter[])new QFilter[]{new QFilter("orgid", "in", ids)});
            List<Long> collect = list.stream().map(b -> b.getLong("orgid.id")).distinct().collect(Collectors.toList());
            return collect;
        }
        TaxAppEnum taxAppEnum = TaxAppEnum.getEnumInstanceByAppid(appid);
        String taxtype = null;
        if (taxAppEnum != null) {
            taxtype = taxAppEnum.getCategoryCode();
        }
        return TaxBaseDataUtils.filterEnableOrgsByTaxType(filteOrgList, taxtype);
    }

    public static DynamicObject queryCategoryByTaxtype(Long orgId, String taxtype) {
        DynamicObject taxMain;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainCategoryByOrgIdsAndTaxtype(Collections.singletonList(orgId), (String)taxtype);
        if (EmptyCheckUtils.isNotEmpty(result.getData()) && EmptyCheckUtils.isNotEmpty((taxMain = (DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            return (DynamicObject)taxMain.getDynamicObjectCollection("categoryentryentity").get(0);
        }
        return null;
    }

    public static List<Long> filterEnableOrgsByTaxType(List<Long> orgList, String taxtype) {
        ArrayList<Long> enableOrgList = new ArrayList<Long>();
        TaxResult taxResult = TaxcMainDataServiceHelper.isTaxcMainCategoryEnableByOrgIds(orgList);
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty(taxResult.getData())) {
            Map map = (Map)taxResult.getData();
            for (Map.Entry entry : map.entrySet()) {
                if (!((Map)entry.getValue()).getOrDefault(taxtype, Boolean.TRUE).booleanValue()) continue;
                enableOrgList.add((Long)entry.getKey());
            }
        }
        return enableOrgList;
    }

    public static String getDeadLine(Long orgId, String tax, Date newValue) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxVerByOrgId((Long)orgId, (String)tax, (Date)newValue);
        if (!result.isSuccess() || Objects.isNull(result.getData())) {
            return null;
        }
        DynamicObject data = (DynamicObject)result.getData();
        if (CollectionUtils.isEmpty((Collection)data.getDynamicObjectCollection("entryentity"))) {
            return null;
        }
        DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : entryentity) {
            if (!"deadline".equals(object.get("modifycontexttitleysjbs"))) continue;
            String modifycontexafter = object.getString("modifycontexaftercode");
            return "aysb".equals(modifycontexafter) ? "month" : ("ajsb".equals(modifycontexafter) ? "season" : null);
        }
        return null;
    }
}

