/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.calculate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.taxc.bdtaxr.common.refactor.formula.cal.FelService;
import kd.taxc.bdtaxr.common.util.calculate.PropertyPlaceholderHelper;

public class CalculateUtil {
    public static Map<String, String> resetFormulas(Map<String, String> params, Map<String, String> formulas) {
        if (params == null || params.isEmpty() || formulas == null || formulas.isEmpty()) {
            return formulas;
        }
        PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("{", "}");
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        HashMap<String, String> newFormulas = new HashMap<String, String>(formulas.size());
        for (Map.Entry<String, String> entry : formulas.entrySet()) {
            String newFormula = helper.replacePlaceholders(entry.getValue(), props);
            newFormulas.put(entry.getKey(), newFormula);
        }
        return newFormulas;
    }

    public static Map<String, String> getCalResult(Map<String, String> formulas) {
        if (formulas == null || formulas.isEmpty()) {
            return formulas;
        }
        HashMap<String, String> result = new HashMap<String, String>(formulas.size());
        for (Map.Entry<String, String> entry : formulas.entrySet()) {
            Object r = FelService.eval(entry.getValue());
            result.put(entry.getKey(), String.valueOf(r));
        }
        return result;
    }

    public static List<String> getParamsKeyFromFormula(String formula) {
        ArrayList<String> list = new ArrayList<String>();
        char[] formulaChars = formula.toCharArray();
        boolean keySwitch = false;
        StringBuilder keyStr = new StringBuilder();
        for (int i = 0; i < formulaChars.length; ++i) {
            char str = formulaChars[i];
            if (str == '{') {
                keySwitch = true;
                continue;
            }
            if (str == '}') {
                keySwitch = false;
                list.add(keyStr.toString());
                keyStr = new StringBuilder();
                continue;
            }
            if (!keySwitch) continue;
            keyStr.append(str);
        }
        return list;
    }
}

