/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.file;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.BaseRowModel;
import kd.taxc.bdtaxr.common.dto.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.util.file.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    private static final Log logger = LogFactory.getLog(ExcelUtils.class);
    private static Sheet initSheet = new Sheet(1, 0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createExcelFile(Map<String, String> headData, String jsonString, String fileName, List<String> dynRowList, Map<String, String> sheetNameMap, List<String> hideSheets) {
        String templateName = UUID.randomUUID().toString() + ".xlsx";
        File file = new File(FilenameUtils.normalize((String)(TemplateShowUtils.BASE_PATH + FilenameUtils.getName((String)templateName))));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        ExcelUtils.createExcel(headData, jsonString, dynRowList, wb, sheetNameMap, hideSheets);
        FileInputStream in = null;
        FileOutputStream fout = null;
        String urls = "";
        try {
            fout = new FileOutputStream(file);
            wb.write((OutputStream)fout);
            in = new FileInputStream(file);
            urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)in, 5000);
            logger.info("draftExport urls: {}", (Object)urls);
        }
        catch (Exception e) {
            try {
                logger.error("\u751f\u6210\u6a21\u677f\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.safeCloseOutputStream(fout);
                FileUtils.safeClose(in);
                throw throwable;
            }
            FileUtils.safeCloseOutputStream(fout);
            FileUtils.safeClose(in);
        }
        FileUtils.safeCloseOutputStream(fout);
        FileUtils.safeClose(in);
        return urls;
    }

    private static void createExcel(Map<String, String> headData, String jsonString, List<String> dynRowList, XSSFWorkbook wb, Map<String, String> sheetNameMap, List<String> hideSheets) {
        LinkedHashMap<String, LinkedHashMap> jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString(jsonString);
        Iterator<Map.Entry<String, LinkedHashMap>> iterator = jsonMap.entrySet().iterator();
        TreeMap<Integer, Map.Entry<String, LinkedHashMap>> sheetMap = new TreeMap<Integer, Map.Entry<String, LinkedHashMap>>();
        while (iterator.hasNext()) {
            Map.Entry<String, LinkedHashMap> entry = iterator.next();
            if (null == entry || SpreadUtils.isSheetInvisible(entry, hideSheets)) continue;
            sheetMap.put(Integer.valueOf(entry.getValue().getOrDefault("index", "0").toString()), entry);
        }
        Set rowSet = headData.keySet().stream().filter(e -> e.contains("_")).map(s -> s.substring(0, s.lastIndexOf(95))).collect(Collectors.toSet());
        for (Map.Entry sheetEntry : sheetMap.entrySet()) {
            Map.Entry entry = (Map.Entry)sheetEntry.getValue();
            String name = (String)((LinkedHashMap)entry.getValue()).get("name");
            if (null != sheetNameMap && null != sheetNameMap.get(name)) {
                name = sheetNameMap.get(name);
            }
            XSSFSheet sheet = wb.createSheet(name);
            Map<String, List<Cell>> dataMap = SpreadUtils.getDataCell(entry, SpreadUtils.parseStyles(JSONObject.parseObject((String)jsonString)), dynRowList);
            HashMap<Integer, List> rowTemplateRowMap = new HashMap<Integer, List>();
            int index = -1;
            for (Map.Entry<String, List<Cell>> data : dataMap.entrySet()) {
                int createRow;
                String dataRow = data.getKey();
                boolean isDynRow = false;
                if (dataRow.contains("#")) {
                    createRow = Integer.parseInt(dataRow.substring(dataRow.indexOf(35) + 1));
                    isDynRow = true;
                } else {
                    createRow = Integer.parseInt(dataRow);
                }
                if (index == -1) {
                    index = createRow;
                }
                List<Cell> cells = data.getValue();
                if (isDynRow) {
                    Cell cell = cells.get(cells.size() - 1);
                    String text = cell.getText();
                    String dynRowNo = text.substring(text.indexOf(35) + 1);
                    if (!StringUtils.isNotBlank((CharSequence)dynRowNo)) continue;
                    String[] split = dynRowNo.split("#");
                    int ewblxh = Integer.parseInt(split[1]);
                    String dynRowId = split[0] + "_" + ewblxh;
                    cells.remove(cells.size() - 1);
                    while (rowSet.contains(dynRowId)) {
                        ExcelUtils.createRow(headData, wb, sheet, index, cells, ewblxh);
                        List integers = rowTemplateRowMap.computeIfAbsent(createRow, k -> new ArrayList());
                        integers.add(index);
                        ++index;
                        dynRowId = split[0] + "_" + ++ewblxh;
                    }
                    continue;
                }
                ExcelUtils.createRow(headData, wb, sheet, index, cells, null);
                List integers = rowTemplateRowMap.computeIfAbsent(createRow, k -> new ArrayList());
                integers.add(index);
                ++index;
            }
            List<Cell> spanList = SpreadUtils.getSpanCell(entry);
            ArrayList rowList = new ArrayList();
            for (Cell cell : spanList) {
                rowList.clear();
                int row = cell.getRow();
                int rowCount = cell.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    List integers = (List)rowTemplateRowMap.get(row);
                    if (integers == null) continue;
                    rowList.addAll(integers);
                }
                if (rowList.size() <= 0) continue;
                Integer firstRow = (Integer)rowList.get(0);
                if (rowCount == 1) {
                    for (Integer fr : rowList) {
                        CellRangeAddress region = new CellRangeAddress(fr.intValue(), fr.intValue(), cell.getCol(), cell.getCol() + cell.getColCount() - 1);
                        sheet.addMergedRegion(region);
                    }
                    continue;
                }
                int lastRow = firstRow + rowList.size() - 1;
                CellRangeAddress region = new CellRangeAddress(firstRow.intValue(), lastRow, cell.getCol(), cell.getCol() + cell.getColCount() - 1);
                sheet.addMergedRegion(region);
            }
        }
    }

    private static void createRow(Map<String, String> headData, XSSFWorkbook wb, XSSFSheet sheet, int index, List<Cell> cells, Integer ewblxh) {
        XSSFRow row = sheet.createRow(index);
        for (Cell cell : cells) {
            XSSFCell hSSFCell = row.createCell(cell.getCol());
            String text = cell.getText();
            String value = StringUtils.isNotEmpty((CharSequence)text) && text.startsWith("${") && text.endsWith("}") ? headData.getOrDefault(text.replace("${", "").replace("}", "").replace("#", "_").replace("1", String.valueOf(ewblxh)), text) : headData.getOrDefault(text, text);
            hSSFCell.setCellStyle((CellStyle)TemplateShowUtils.getCellStyle(wb, null, cell.getStyle()));
            hSSFCell.setCellValue(value);
        }
    }

    public static File exportExcel(List<? extends BaseRowModel> data) {
        return ExcelUtils.writeWithTemplate(data);
    }

    public static File writeWithTemplate(List<? extends BaseRowModel> data) {
        return ExcelUtils.writeWithTemplateAndSheet(data, null);
    }

    public static File writeWithTemplateAndSheet(List<? extends BaseRowModel> data, Sheet sheet) {
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        sheet = sheet != null ? sheet : initSheet;
        sheet.setClazz(data.get(0).getClass());
        String templateHtml = UUID.randomUUID().toString() + ".xlsx";
        logger.info("exportFile Path: {}", (Object)FilenameUtils.normalize((String)TemplateShowUtils.BASE_PATH), (Object)FilenameUtils.normalize((String)FilenameUtils.getName((String)templateHtml)));
        File file = new File(FilenameUtils.normalize((String)TemplateShowUtils.BASE_PATH), FilenameUtils.normalize((String)FilenameUtils.getName((String)templateHtml)));
        logger.info("exportFile file: {}, parentFileExist: {}, fileExist: {}", new Object[]{JSONObject.toJSONString((Object)file), file.getParentFile().exists(), file.exists()});
        if (file.exists()) {
            return file;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            EasyExcel.write((File)file, data.get(0).getClass()).sheet(sheet.getSheetName()).doWrite(data);
        }
        catch (Exception e) {
            logger.error("\u627e\u4e0d\u5230\u6587\u4ef6\u6216\u6587\u4ef6\u8def\u5f84\u9519\u8bef, \u6587\u4ef6\uff1a{}", (Object)file);
        }
        logger.info("exportFile exist: {}", (Object)file.exists());
        return file;
    }

    public static File writeWithMultipleSheel(List<MultipleSheelPropety> multipleSheelPropetys) {
        if (CollectionUtils.isEmpty(multipleSheelPropetys)) {
            return null;
        }
        String templateHtml = UUID.randomUUID().toString() + ".xlsx";
        File file = new File(FilenameUtils.normalize((String)TemplateShowUtils.BASE_PATH), FilenameUtils.normalize((String)FilenameUtils.getName((String)templateHtml)));
        if (file.exists()) {
            return file;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (ExcelWriter excelWriter = EasyExcel.write((File)file).build();){
            int i = 0;
            for (MultipleSheelPropety multipleSheelPropety : multipleSheelPropetys) {
                Sheet sheet;
                Sheet sheet2 = sheet = multipleSheelPropety.getSheet() != null ? multipleSheelPropety.getSheet() : initSheet;
                if (!CollectionUtils.isEmpty(multipleSheelPropety.getData())) {
                    sheet.setClazz(multipleSheelPropety.getData().get(0).getClass());
                }
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)i, (String)sheet.getSheetName()).head(multipleSheelPropety.getData().get(0).getClass())).build();
                excelWriter.write(multipleSheelPropety.getData(), writeSheet);
                ++i;
            }
        }
        catch (Exception e) {
            logger.error("\u627e\u4e0d\u5230\u6587\u4ef6\u6216\u6587\u4ef6\u8def\u5f84\u9519\u8bef, \u6587\u4ef6\uff1a{}", (Object)file);
        }
        return file;
    }

    static {
        initSheet.setSheetName("sheet");
        initSheet.setAutoWidth(Boolean.TRUE);
    }

    public static class MultipleSheelPropety {
        private List<? extends BaseRowModel> data;
        private Sheet sheet;

        public List<? extends BaseRowModel> getData() {
            return this.data;
        }

        public void setData(List<? extends BaseRowModel> data) {
            this.data = data;
        }

        public Sheet getSheet() {
            return this.sheet;
        }

        public void setSheet(Sheet sheet) {
            this.sheet = sheet;
        }
    }
}

