/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.file;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.annotation.ExcelProperty;
import kd.taxc.bdtaxr.common.dto.BaseRowModel;
import kd.taxc.bdtaxr.common.dto.ExportExcelPropertyDto;
import kd.taxc.bdtaxr.common.dto.MultipleSheetPropety;
import kd.taxc.bdtaxr.common.dto.Sheet;
import kd.taxc.bdtaxr.common.enums.DraftExportFileDataEnum;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.util.file.FileUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportExcelUtils {
    private static final Log logger = LogFactory.getLog(ExportExcelUtils.class);
    private static Sheet initSheet = new Sheet(1, 0);

    public static File exportExcelWithMultipleSheet(List<MultipleSheetPropety> sheetDataList, OutputStream stream) {
        File file = ExportExcelUtils.newFile();
        if (CollectionUtils.isEmpty(sheetDataList)) {
            return file;
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        for (MultipleSheetPropety sheetPropety : sheetDataList) {
            Sheet sheet = sheetPropety.getSheet();
            if (CollectionUtils.isEmpty(sheetPropety.getData())) continue;
            Class<?> cl = sheetPropety.getData().get(0).getClass();
            sheet.setClazz(cl);
            List<? extends BaseRowModel> data = sheetPropety.getData();
            file = ExportExcelUtils.exportExcelWithSheet(file, wb, sheet, data, cl);
        }
        return file;
    }

    private static List<ExportExcelPropertyDto> getApiModelProperty(String classPath) {
        ArrayList<ExportExcelPropertyDto> propertyList = new ArrayList<ExportExcelPropertyDto>();
        try {
            Class<?> c = Class.forName(classPath);
            Field[] declaredFields = c.getDeclaredFields();
            if (declaredFields.length != 0) {
                for (Field field : declaredFields) {
                    if (field.getAnnotation(ExcelProperty.class) == null) continue;
                    String[] value = field.getAnnotation(ExcelProperty.class).value();
                    StringBuilder valueString = new StringBuilder();
                    for (int i = 0; i < value.length; ++i) {
                        if (i > 0 && value[i].equals(value[i - 1])) continue;
                        String newValue = DraftExportFileDataEnum.getNameByValue(value[i]);
                        if (StringUtil.isNotBlank((CharSequence)newValue)) {
                            value[i] = DraftExportFileDataEnum.getNameByValue(value[i]);
                        }
                        valueString.append(value[i]);
                        if (i >= value.length - 1) continue;
                        valueString.append("-");
                    }
                    String valueStr = valueString.toString();
                    if (valueStr.endsWith("-")) {
                        valueStr = valueStr.substring(0, valueStr.length() - 1);
                    }
                    ExportExcelPropertyDto prop = new ExportExcelPropertyDto();
                    prop.setFieldName(field.getName());
                    prop.setPropertyValue(valueStr);
                    int index = field.getAnnotation(ExcelProperty.class).index();
                    prop.setIndex(index);
                    propertyList.add(prop);
                }
                return propertyList;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("\u6ca1\u6709\u8be5\u7c7b");
        }
        return propertyList;
    }

    private static File newFile() {
        String templateHtml = UUID.randomUUID().toString() + ".xlsx";
        File file = new File(FilenameUtils.concat((String)FilenameUtils.normalize((String)TemplateShowUtils.BASE_PATH), (String)FilenameUtils.getName((String)templateHtml)));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File exportExcelWithSheet(File file, XSSFWorkbook wb, Sheet sheet, List<?> data, Class<?> clazz) {
        if (file == null) {
            file = ExportExcelUtils.newFile();
        }
        if (wb == null) {
            wb = new XSSFWorkbook();
        }
        if (sheet == null) {
            sheet = initSheet;
        }
        if (CollectionUtils.isEmpty(data)) {
            return file;
        }
        int dataSize = data.size();
        ArrayList<Map<String, String>> dataListMap = new ArrayList<Map<String, String>>(dataSize + 16);
        for (int i = 0; i < dataSize; ++i) {
            Map map = (Map)JSON.parseObject((String)JSON.toJSONString(data.get(i)), Map.class);
            dataListMap.add(map);
        }
        List<ExportExcelPropertyDto> properties = ExportExcelUtils.getApiModelProperty(clazz.getName());
        properties = properties.stream().sorted(Comparator.comparing(a -> a.getIndex())).collect(Collectors.toList());
        ExportExcelUtils.createSheet(wb, sheet.getSheetName(), properties, dataListMap);
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            wb.write((OutputStream)stream);
        }
        catch (IOException e) {
            try {
                logger.error("\u6570\u636e\u5199\u5165\u5931\u8d25");
            }
            catch (Throwable throwable) {
                FileUtils.safeCloseOutputStream(stream);
                throw throwable;
            }
            FileUtils.safeCloseOutputStream(stream);
        }
        FileUtils.safeCloseOutputStream(stream);
        return file;
    }

    public static File exportExcelWithSheet(XSSFWorkbook wb, Sheet sheet, List<?> data, Class<?> clazz) {
        return ExportExcelUtils.exportExcelWithSheet(null, wb, sheet, data, clazz);
    }

    public static void createSheet(XSSFWorkbook wb, String sheetName, List<ExportExcelPropertyDto> propertiesList, List<Map<String, String>> listData) {
        XSSFSheet sheet = wb.createSheet(sheetName);
        XSSFCellStyle titleStyle = wb.createCellStyle();
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont titleFont = wb.createFont();
        titleFont.setBold(true);
        titleFont.setFontName("Times New Roman");
        titleFont.setFontHeightInPoints((short)18);
        titleStyle.setFont((Font)titleFont);
        XSSFCellStyle headerXStyle = wb.createCellStyle();
        headerXStyle.setBorderTop(BorderStyle.THIN);
        headerXStyle.setBorderBottom(BorderStyle.THIN);
        headerXStyle.setBorderLeft(BorderStyle.THIN);
        headerXStyle.setBorderRight(BorderStyle.THIN);
        XSSFFont headerFont = wb.createFont();
        headerFont.setBold(true);
        headerXStyle.setFont((Font)headerFont);
        headerXStyle.setAlignment(HorizontalAlignment.CENTER);
        String[] titles = new String[propertiesList.size()];
        for (int i = 0; i < propertiesList.size(); ++i) {
            titles[i] = propertiesList.get(i).getPropertyValue();
        }
        int rowInd = 0;
        XSSFRow headerRow = sheet.createRow(rowInd);
        headerRow.setHeightInPoints(16.0f);
        for (int i = 0; i < titles.length; ++i) {
            XSSFCell cell = headerRow.createCell(i);
            cell.setCellValue(titles[i]);
            cell.setCellStyle((CellStyle)headerXStyle);
        }
        XSSFCellStyle headerCStyle = wb.createCellStyle();
        headerCStyle.setBorderTop(BorderStyle.THIN);
        headerCStyle.setBorderBottom(BorderStyle.THIN);
        headerCStyle.setBorderLeft(BorderStyle.THIN);
        headerCStyle.setBorderRight(BorderStyle.THIN);
        titles = new String[propertiesList.size()];
        for (int i = 0; i < propertiesList.size(); ++i) {
            titles[i] = propertiesList.get(i).getFieldKey();
        }
        if (listData != null) {
            for (Map<String, String> map : listData) {
                XSSFRow _row = sheet.createRow(++rowInd);
                _row.setHeightInPoints(16.0f);
                for (int j = 0; j < titles.length; ++j) {
                    XSSFCell cell = _row.createCell(j);
                    cell.setCellStyle((CellStyle)headerCStyle);
                    cell.setCellValue(map.get(titles[j]));
                }
            }
        }
    }

    public static boolean checkFormat(XSSFWorkbook wb, List<String> colName) {
        XSSFSheet sheet = wb.getSheetAt(0);
        int lastRow = sheet.getLastRowNum();
        if (lastRow < 1) {
            return false;
        }
        XSSFRow row = sheet.getRow(0);
        short cellF = row.getFirstCellNum();
        int cellL = row.getLastCellNum();
        if (cellF >= 0 && cellL >= colName.size()) {
            for (int i = 0; i < cellL; ++i) {
                String colString;
                String xlsColString = row.getCell(i).getStringCellValue();
                if (xlsColString.equals(colString = colName.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        initSheet.setSheetName("sheet");
        initSheet.setAutoWidth(Boolean.TRUE);
    }
}

