/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.finance;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.FinanceAccountingStandardsEnum;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.finance.TcvvtCategoryInfoBusinessImpl;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.taxdeclare.NsrxxValidatorUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DeclareCheckFacility {
    private static final String[] TAX_LIMITS = new String[]{"month", "season", "year"};
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String NSRTYPE = "type";
    public static final String SUBMIT = "submit";
    public static final String UNSUBMIT = "unsubmit";
    public static final String AUDIT = "audit";
    public static final String UNAUDIT = "unaudit";
    public static final String APPLY = "apply";
    public static final String CANCELAPPLY = "cancelapply";
    private static final String BILLSTATUS = "billstatus";
    private static final String DECLARESTATUS = "declarestatus";
    private static final String ORG = "org";
    private static final String TYPE = "type";
    private static final String DECLARETYPE = "declaretype";
    public static final String TCVAT_NSRXX = "tcvat_nsrxx";
    private static final String ENTITY_TEMPLATE = "bdtaxr_template_main";
    private static final String CANCEL_SUBMIT = "cancel_submit";
    private static final String TAXLIMIT = "taxlimit";
    private static Map<String, String> NSR_TYPE_MAP = TemplateTypeConstant.getMap();
    private static Map<String, String> canNotUnAuditOrApplyMap = new HashMap<String, String>();
    public static final List<String> TEMPALTE_TYPE = Arrays.asList("FR0001", "FR0002", "FR0003", "FR0004", "FR0011");
    private static final List<String> provinces;

    public static void setErrorMsgListWhenNSRXXOpt(List<String> msgList, String operationKey, DynamicObject dynamicObject) {
        String billStatus = dynamicObject.getString(BILLSTATUS);
        String declareStatus = dynamicObject.getString(DECLARESTATUS);
        String errorMsg = null;
        String orgName = dynamicObject.getDynamicObject(ORG).getString("name");
        String startDate = DateUtils.format(dynamicObject.getDate(SKSSQQ), DateUtils.YYYYMMDD_CHINESE);
        String endDate = DateUtils.format(dynamicObject.getDate(SKSSQZ), DateUtils.YYYYMMDD_CHINESE);
        String declareType = dynamicObject.getString(DECLARETYPE);
        String declareTypeStr = NSR_TYPE_MAP.get(dynamicObject.getString("type"));
        if (SUBMIT.equals(operationKey)) {
            if ("C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u8bf7\u5148\u53d6\u6d88\u5ba1\u6838\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareCheckFacility_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if ("B".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u63d0\u4ea4\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareCheckFacility_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
        } else if (CANCEL_SUBMIT.equals(operationKey)) {
            if (!"B".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u672a\u63d0\u4ea4\uff0c\u65e0\u6cd5\u64a4\u9500\u63d0\u4ea4\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareCheckFacility_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
        } else if (AUDIT.equals(operationKey)) {
            if ("C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u65e0\u9700\u91cd\u590d\u5ba1\u6838\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareCheckFacility_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
        } else if (UNAUDIT.equals(operationKey)) {
            if (!"C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u4ec5\u5df2\u5ba1\u6838\u6570\u636e\u53ef\u53cd\u5ba1\u6838\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareCheckFacility_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if (canNotUnAuditOrApplyMap.containsKey(declareStatus)) {
                String declareStatusChiStr = canNotUnAuditOrApplyMap.get(declareStatus);
                errorMsg = String.format(ResManager.loadKDString((String)"%1$s %2$s\u5c5e\u671f\u62a5\u8868 %3$s\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838", (String)"DeclareCheckFacility_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, startDate + "-" + endDate, declareStatusChiStr);
            }
        } else if (APPLY.equals(operationKey)) {
            if (!"C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u80fd\u786e\u8ba4\u7533\u62a5\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareCheckFacility_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if (canNotUnAuditOrApplyMap.containsKey(declareStatus)) {
                String declareStatusChiStr = canNotUnAuditOrApplyMap.get(declareStatus);
                errorMsg = String.format(ResManager.loadKDString((String)"%1$s %2$s\u5c5e\u671f\u62a5\u8868 %3$s\uff0c\u4e0d\u80fd\u786e\u8ba4\u7533\u62a5", (String)"DeclareCheckFacility_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, startDate + "-" + endDate, declareStatusChiStr);
            }
        } else if (CANCELAPPLY.equals(operationKey)) {
            if (!"declared".equals(declareStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u6210\u529f\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7533\u62a5\uff1a %1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareCheckFacility_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if (!"0".equals(declareType)) {
                msgList.add(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u65b9\u5f0f\u4e3a\u624b\u5de5\u7533\u62a5\u624d\u80fd\u53d6\u6d88\u7533\u62a5\uff1a %1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"DeclareCheckFacility_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate));
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(errorMsg)) {
            msgList.add(errorMsg);
        }
    }

    public static void updateData(List<DynamicObject> updateList, String operationKey) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        for (DynamicObject obj : updateList) {
            if (AUDIT.equalsIgnoreCase(operationKey)) {
                obj.set(BILLSTATUS, (Object)"C");
                obj.set("auditdate", (Object)new Date());
                obj.set("auditor", (Object)RequestContext.get().getCurrUserId());
            }
            if (SUBMIT.equals(operationKey)) {
                obj.set(BILLSTATUS, (Object)"B");
            }
            if (UNSUBMIT.equals(operationKey)) {
                obj.set(BILLSTATUS, (Object)"A");
            }
            if (UNAUDIT.equals(operationKey)) {
                obj.set(BILLSTATUS, (Object)"A");
                obj.set("auditdate", null);
                obj.set("auditor", null);
            }
            if (APPLY.equals(operationKey)) {
                obj.set(DECLARESTATUS, (Object)"declared");
                obj.set(DECLARETYPE, (Object)"0");
                obj.set("sbrq", (Object)new Date());
                obj.set("declarer", (Object)RequestContext.get().getCurrUserId());
            }
            if (CANCELAPPLY.equals(operationKey)) {
                obj.set(DECLARESTATUS, (Object)"editing");
                obj.set("paystatus", null);
                obj.set(DECLARETYPE, null);
                obj.set("paytype", null);
                obj.set("sbrq", null);
                obj.set("paydate", null);
                obj.set("payer", null);
                obj.set("declarer", null);
            }
            obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            obj.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    public static void checkOrgAndDate(DynamicObject template, String orgId, String reporttype, Date startDate, Date endDate) throws KDBizException {
        String enddateStr;
        String startdateStr;
        DynamicObjectCollection collection;
        if (StringUtil.isEmpty((CharSequence)orgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"DeclareCheckFacility_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (startDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u8d77\u4e0d\u5b58\u5728", (String)"DeclareCheckFacility_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (endDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u6b62\u4e0d\u5b58\u5728", (String)"DeclareCheckFacility_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (!DeclareCheckFacility.checkIsTaxpayer(orgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u975e\u53ef\u7528\u7eb3\u7a0e\u4e3b\u4f53\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u4fe1\u606f\u7684\u6b63\u786e\u6027\u3002", (String)"DeclareCheckFacility_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        NsrxxValidatorUtils.nsrxxReviewed(Long.parseLong(orgId));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        DynamicObject dTctb = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"accountingstandards,newrule,registertime", (QFilter[])new QFilter[]{orgFilter});
        if (dTctb != null) {
            String newrule = dTctb.getString("newrule");
            long accountingstandards = dTctb.getLong("accountingstandards");
            if (accountingstandards == 1072508277482326016L && (StringUtil.isEmpty((CharSequence)newrule) || "empty".equalsIgnoreCase(newrule))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u9009\u62e9\u7ef4\u62a4\u201c\u6267\u884c\u65b0\u51c6\u5219\u201d\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u518d\u8fdb\u884c\u586b\u62a5", (String)"DeclareCheckFacility_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DeclareCheckFacility_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        boolean isOpenTaxMainFinancial = DeclareCheckFacility.isOpenTaxMainFinancial(orgId);
        if (!isOpenTaxMainFinancial) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8d22\u52a1\u62a5\u8868\u62a5\u9001\u672a\u542f\u7528\uff0c\u8bf7\u5230\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u3002", (String)"DeclareCheckFacility_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        DeclareCheckFacility.allRequiredFieldValidator(orgId);
        if (Objects.isNull(template) && null == (template = DeclareCheckFacility.getTemplateType(orgId, startDate, endDate)) && (collection = DeclareCheckFacility.queryYbnsr(orgId, TEMPALTE_TYPE, startdateStr = DateUtils.format(startDate, "yyyy-MM-dd"), enddateStr = DateUtils.format(endDate, "yyyy-MM-dd"), Collections.emptyMap())).size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u5b58\u5728\u591a\u4efd\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DeclareCheckFacility_28", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (Objects.isNull(template)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\u6216\u8be5\u51c6\u5219\u9002\u7528\u7684\u8d22\u52a1\u62a5\u8868\u529f\u80fd\u5c1a\u672a\u4e0a\u7ebf\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"DeclareCheckFacility_29", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (startDate.compareTo(endDate) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\u3002", (String)"DeclareCheckFacility_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        Date now = new Date();
        if (now.compareTo(startDate) <= 0 || now.compareTo(endDate) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u5f97\u665a\u4e8e\u5f53\u524d\u65f6\u95f4", (String)"DeclareCheckFacility_31", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        Date tempStartDate = template.getDate("startdate");
        Date tempEndDate = template.getDate("enddate");
        if (tempStartDate.compareTo(endDate) > 0 || tempEndDate != null && tempEndDate.compareTo(startDate) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u5728\u6a21\u677f\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"DeclareCheckFacility_32", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        Date fregistertime = dTctb.getDate("registertime");
        if (fregistertime != null && fregistertime.after(endDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u3002", (String)"DeclareCheckFacility_33", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (reporttype == null) {
            reporttype = DeclareCheckFacility.getReportType(startDate, endDate);
        }
        if (reporttype != null) {
            String taxLimit = DeclareCheckFacility.getTaxLimits(reporttype);
            boolean validDateRangeResult = DateUtils.validDateRange(taxLimit, startDate, endDate);
            if (!validDateRangeResult) {
                String showDateErrorMsg = DeclareCheckFacility.showDateErrorMsg(reporttype);
                throw new KDBizException(showDateErrorMsg);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6708\u5ea6\u3001\u5b63\u5ea6\u6216\u5e74\u5ea6\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u6240\u5c5e\u65f6\u671f\u7684\u6b63\u786e\u6027\u3002", (String)"DeclareCheckFacility_34", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        QFilter orgIdFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId));
        boolean exists = false;
        QFilter typeFilter = new QFilter("type", "in", (Object)Lists.newArrayList((Object[])new String[]{"FR0001", "FR0002", "FR0003", "FR0004", "FR0011"}));
        if ("aysb".equalsIgnoreCase(reporttype)) {
            QFilter taxLimitFilter = new QFilter(TAXLIMIT, "=", (Object)"season");
            QFilter skssqqzFilter = new QFilter(SKSSQQ, "<=", (Object)startDate).and(new QFilter(SKSSQZ, ">=", (Object)startDate));
            exists = QueryServiceHelper.exists((String)TCVAT_NSRXX, (QFilter[])new QFilter[]{orgIdFilter, typeFilter, taxLimitFilter, skssqqzFilter});
        } else if ("ajsb".equalsIgnoreCase(reporttype)) {
            QFilter taxLimitFilter = new QFilter(TAXLIMIT, "=", (Object)"month");
            QFilter skssqqzFilter = new QFilter(SKSSQQ, ">=", (Object)startDate).and(new QFilter(SKSSQZ, "<=", (Object)endDate));
            exists = QueryServiceHelper.exists((String)TCVAT_NSRXX, (QFilter[])new QFilter[]{orgIdFilter, typeFilter, taxLimitFilter, skssqqzFilter});
        }
        if (exists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6309\u6708\u6216\u5b63\u7533\u62a5\u65f6\uff0c\u6240\u5c5e\u7a0e\u671f\u4e0d\u80fd\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539", (String)"DeclareCheckFacility_35", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if ("ansb".equalsIgnoreCase(reporttype) && "FR0003".equalsIgnoreCase(template.getString("type.number"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5c0f\u4f01\u4e1a\u4f1a\u8ba1\u5236\u5ea6\u6309\u5e74\u7533\u62a5\u65b9\u5f0f", (String)"DeclareCheckFacility_36", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    private static boolean checkIsTaxpayer(String orgId) {
        return DeclareCheckFacility.isTaxcOrgExistByOrgIdAndIsTaxpayer(Long.parseLong(orgId));
    }

    private static boolean checkIsAudit(String orgId) {
        return (Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
    }

    private static String getReportType(Date startDate, Date endDate) {
        int dayDiff = DateUtils.getDayDiff(startDate, endDate);
        if (dayDiff > 366) {
            return null;
        }
        for (String taxLimit : TAX_LIMITS) {
            if (!DateUtils.validDateRange(taxLimit, startDate, endDate)) continue;
            return DeclareCheckFacility.getReportType(taxLimit);
        }
        return null;
    }

    public static String getReportType(String taxLimit) {
        if ("season".equals(taxLimit)) {
            return "ajsb";
        }
        if ("year".equals(taxLimit)) {
            return "ansb";
        }
        if ("month".equals(taxLimit)) {
            return "aysb";
        }
        return null;
    }

    private static String showDateErrorMsg(String reporttype) {
        String errorMsg = null;
        String taxLimit = DeclareCheckFacility.getTaxLimits(reporttype);
        if ("season".equals(taxLimit)) {
            errorMsg = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u5b63\u5ea6\u3002", (String)"DeclareCheckFacility_37", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        } else if ("month".equals(taxLimit)) {
            errorMsg = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u6708\u3002", (String)"DeclareCheckFacility_38", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        } else if ("year".equals(taxLimit)) {
            errorMsg = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u5e74\u3002", (String)"DeclareCheckFacility_39", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    private static String getTaxLimits(String reporttype) {
        if ("ajsb".equals(reporttype)) {
            return "season";
        }
        if ("ansb".equals(reporttype)) {
            return "year";
        }
        if ("aysb".equals(reporttype)) {
            return "month";
        }
        return " ";
    }

    private static DynamicObject getTemplateTypeFromTp(String orgid, Date sksqq, Date sksqz) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        QFilter startFilter = new QFilter("startdate", "=", (Object)sksqq);
        QFilter endFilter = new QFilter("enddate", "=", (Object)sksqz);
        DynamicObject massageTp = BusinessDataServiceHelper.loadSingle((String)"tcvvt_message", (String)"id,accountingstandards,newrule,registeraddress", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
        if (massageTp != null) {
            return DeclareCheckFacility.getTemplateType(massageTp.getLong("accountingstandards.id"), massageTp.getString("newrule"), orgid, sksqq, sksqz);
        }
        return null;
    }

    public static boolean isOpenTaxMainFinancial(String orgId) {
        boolean isOpen = false;
        if (StringUtil.isBlank((CharSequence)orgId)) {
            return isOpen;
        }
        DynamicObject dynamicObject = TcvvtCategoryInfoBusinessImpl.querycwbbCategoryInfoByOrgId(orgId);
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return isOpen;
        }
        if (dynamicObject.getBoolean("enable")) {
            isOpen = true;
        }
        return isOpen;
    }

    public static DynamicObject getTemplateType(Long accountingStandardId, String newrule, String orgid, Date sksqq, Date sksqz) {
        String templateType = null;
        QFilter accountingStandardIdFilter = new QFilter("id", "=", (Object)accountingStandardId);
        DynamicObject accountingStandard = QueryServiceHelper.queryOne((String)"tpo_tccit_bizdef_kjzz", (String)"id,projectname", (QFilter[])new QFilter[]{accountingStandardIdFilter});
        if (accountingStandard == null) {
            return null;
        }
        String projectname = accountingStandard.getString("projectname");
        if (ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"DeclareCheckFacility_40", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(projectname) && "no".equalsIgnoreCase(newrule)) {
            templateType = "FR0001";
        }
        if (ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"DeclareCheckFacility_40", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(projectname) && "yes".equalsIgnoreCase(newrule)) {
            DynamicObject templateObj = TemplateUtils.getTemplateObjectByConfig("FR0002", orgid, sksqq, sksqz);
            if (Objects.isNull(templateObj)) {
                return null;
            }
            templateType = templateObj.getString("number");
        }
        if (ResManager.loadKDString((String)"\u5c0f\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"DeclareCheckFacility_41", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(projectname)) {
            templateType = "FR0003";
        }
        if (ResManager.loadKDString((String)"\u4f01\u4e1a\u4f1a\u8ba1\u5236\u5ea6", (String)"DeclareCheckFacility_42", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(projectname)) {
            templateType = "FR0004";
        }
        QFilter typeFilter = new QFilter("number", "=", (Object)templateType);
        return QueryServiceHelper.queryOne((String)ENTITY_TEMPLATE, (String)"id,number,name,type,startdate,enddate,conditionjson,general", (QFilter[])new QFilter[]{typeFilter});
    }

    public static void allRequiredFieldValidator(String orgId) {
        DynamicObject taxMain;
        if (StringUtils.isNotBlank((CharSequence)orgId) && (taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData()) != null) {
            DynamicObject taxorg = taxMain.getDynamicObject("taxorg");
            String orgname = taxorg.getString("org.name");
            String taxoffice = taxMain.getString("taxoffice.id");
            String registertype = taxMain.getString("registertype.id");
            String registertime = taxMain.getString("registertime");
            String registeraddress = taxMain.getString("registeraddress");
            String codeandname = taxMain.getString("codeandname.id");
            String actualaddress = taxMain.getString("actualaddress");
            String admindivisionObject = taxMain.getString("accountingstandards.id");
            if (StringUtils.isEmpty((CharSequence)registeraddress) || "0".equalsIgnoreCase(admindivisionObject) || "0".equalsIgnoreCase(taxoffice) || "0".equalsIgnoreCase(registertype) || StringUtils.isEmpty((CharSequence)registertime) || "0".equalsIgnoreCase(codeandname) || StringUtils.isEmpty((CharSequence)actualaddress)) {
                ErrorCode errorCode = new ErrorCode("allRequiredField", String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"DeclareCheckFacility_43", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgname));
                throw new KDBizException(errorCode, new Object[0]);
            }
        }
    }

    public static boolean isTaxcOrgExistByOrgIdAndIsTaxpayer(Long orgid) {
        TaxResult taxResult = TaxcOrgDataServiceHelper.isTaxcOrgExistByOrgIdAndIsTaxpayer((Long)orgid);
        boolean isExist = false;
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            isExist = (Boolean)taxResult.getData();
        }
        return isExist;
    }

    public static DynamicObjectCollection queryYbnsr(String orgid, List<String> stype, String startData, String endData, Map<String, Object> extendParams) {
        List<QFilter> qFilters = DeclareCheckFacility.getQFilters(orgid, stype, startData, endData, 0, false, extendParams);
        String allFieldString = MetadataUtil.getAllFieldToQuery(TCVAT_NSRXX);
        QFilter[] qFilterArr = new QFilter[qFilters.size()];
        return QueryServiceHelper.query((String)TCVAT_NSRXX, (String)allFieldString, (QFilter[])qFilters.toArray(qFilterArr));
    }

    public static List<QFilter> getQFilters(String orgid, List<String> stype, String startData, String endData, int month, boolean dateRange, Map<String, Object> extendParams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(ORG, "=", (Object)Long.parseLong(orgid)));
        qFilters.add(new QFilter("type", "in", stype));
        if (dateRange) {
            qFilters.add(new QFilter(SKSSQQ, ">=", (Object)DateUtils.addMonth(DateUtils.stringToDate2(startData), month)));
        } else {
            qFilters.add(new QFilter(SKSSQQ, "=", (Object)DateUtils.addMonth(DateUtils.stringToDate2(startData), month)));
        }
        qFilters.add(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate2(endData), month))));
        qFilters.add(new QFilter(TAXLIMIT, "=", (Object)DateUtils.getTaxLimit(DateUtils.stringToDate2(startData), DateUtils.stringToDate2(endData))));
        return qFilters;
    }

    public static DynamicObject getTemplateType(String orgid, Date sksqq, Date sksqz) {
        String enddateStr;
        QFilter orgIdFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        DynamicObject taxMainInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"tctb_tax_main", (QFilter[])new QFilter[]{orgIdFilter});
        if (null == taxMainInfo) {
            return null;
        }
        String startdateStr = DateUtils.format(sksqq, "yyyy-MM-dd");
        DynamicObjectCollection collection = DeclareCheckFacility.queryYbnsr(orgid, TEMPALTE_TYPE, startdateStr, enddateStr = DateUtils.format(sksqz, "yyyy-MM-dd"), Collections.emptyMap());
        if (collection.size() == 1) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)collection.get(0)).getLong("templateid"), (String)ENTITY_TEMPLATE);
            return dynamicObject;
        }
        if (collection.size() > 1) {
            return null;
        }
        String projectname = taxMainInfo.getString("accountingstandards.projectname");
        String newrule = taxMainInfo.getString("newrule");
        Long registeraddress = taxMainInfo.getLong("registeraddress");
        long accountingstandards = taxMainInfo.getLong("accountingstandards.id");
        if (accountingstandards == 1072508277482326016L && (StringUtil.isEmpty((CharSequence)newrule) || "empty".equalsIgnoreCase(newrule))) {
            ErrorCode errorCode = new ErrorCode("allRequiredField", ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u9009\u62e9\u7ef4\u62a4\u201c\u6267\u884c\u65b0\u51c6\u5219\u201d\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u518d\u8fdb\u884c\u586b\u62a5", (String)"DeclareCheckFacility_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            throw new KDBizException(errorCode, new Object[0]);
        }
        DynamicObject admindivisionObject = BusinessDataServiceHelper.loadSingleFromCache((Object)registeraddress, (String)"bd_admindivision");
        DeclareCheckFacility.allRequiredFieldValidator(orgid);
        String registeraddressName = admindivisionObject.getString("fullname");
        String templateNumber = "";
        if (ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"DeclareCheckFacility_40", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(projectname) && "no".equalsIgnoreCase(newrule)) {
            templateNumber = "FR0001";
        }
        if (ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"DeclareCheckFacility_40", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(projectname) && "yes".equalsIgnoreCase(newrule)) {
            templateNumber = "FR0002";
            Object registeraddressInProvinces = DeclareCheckFacility.registeraddressInProvinces(registeraddressName);
            if (((Boolean)registeraddressInProvinces).booleanValue()) {
                templateNumber = "FR0005";
            }
        }
        if (ResManager.loadKDString((String)"\u5c0f\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"DeclareCheckFacility_41", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(projectname)) {
            templateNumber = "FR0003";
        }
        if (ResManager.loadKDString((String)"\u4f01\u4e1a\u4f1a\u8ba1\u5236\u5ea6", (String)"DeclareCheckFacility_42", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(projectname)) {
            templateNumber = "FR0004";
        }
        if (ResManager.loadKDString((String)"\u94f6\u884c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"DeclareCheckFacility_44", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(projectname)) {
            templateNumber = "FR0011";
        }
        if (DeclareCheckFacility.isZeroDeclareOrg(orgid)) {
            switch (templateNumber) {
                case "FR0001": {
                    templateNumber = "FR0006";
                    break;
                }
                case "FR0002": {
                    templateNumber = "FR0007";
                    break;
                }
                case "FR0003": {
                    templateNumber = "FR0008";
                    break;
                }
                case "FR0004": {
                    templateNumber = "FR0009";
                    break;
                }
                case "FR0005": {
                    templateNumber = "FR0010";
                }
            }
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)templateNumber);
        return BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_TEMPLATE, (QFilter[])new QFilter[]{numberFilter});
    }

    public static boolean isZeroDeclareOrg(String orgId) {
        boolean isZeroDeclareOrg = false;
        Boolean temp = (Boolean)SystemParamUtil.getAppParameter("tcvvt", "zerodeclare", Long.parseLong(orgId));
        if (ObjectUtils.isNotEmpty((Object)temp) && temp.booleanValue()) {
            isZeroDeclareOrg = true;
        }
        return isZeroDeclareOrg;
    }

    public static Boolean registeraddressInProvinces(String registeraddress) {
        for (String province : provinces) {
            if (!registeraddress.contains(province)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void checkExcelTemplate(long templateId, Map<String, String> excelDataMap, List<String> sheetNameList) {
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)ENTITY_TEMPLATE);
        if (Objects.isNull(templateObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u6a21\u677f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u5408\u6cd5\u6027", (String)"DeclareCheckFacility_45", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        String number = templateObject.getString("number");
        String jsonString = templateObject.getString("content_tag");
        LinkedHashMap<String, LinkedHashMap> jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString(jsonString);
        for (Map.Entry<String, LinkedHashMap> entry : jsonMap.entrySet()) {
            String tableName = entry.getKey();
            if (!"FR0005".equals(number) || sheetNameList.contains(tableName)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6a21\u677f\u7684\u6b63\u786e\u6027", (String)"DeclareCheckFacility_46", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        LinkedHashMap<String, String> templateTextCellMap = DeclareCheckFacility.getTempTextCell(jsonString, jsonMap, sheetNameList);
        if (CollectionUtils.isEmpty(templateTextCellMap) || CollectionUtils.isEmpty(excelDataMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u6a21\u677f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u5408\u6cd5\u6027", (String)"DeclareCheckFacility_45", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        for (Map.Entry<String, String> entry : templateTextCellMap.entrySet()) {
            String tableName = entry.getKey().split("#")[0];
            String excelValue = excelDataMap.get(entry.getKey()) == null ? "" : excelDataMap.get(entry.getKey());
            String temValue = entry.getValue() == null ? "" : entry.getValue();
            excelValue = excelValue.replace(" ", "").replace("  ", "").replace(" ", "");
            if ("--".equalsIgnoreCase(temValue = temValue.replace(" ", "").replace("  ", "").replace(" ", "")) || excelValue.equalsIgnoreCase(temValue)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5b58\u5728\u4e0e\u539fEXCEL\u6a21\u677f\u6587\u5b57\u4e0d\u7b26\u7684\u5355\u5143\u683c\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u6a21\u677f\u518d\u586b\u62a5", (String)"DeclareCheckFacility_47", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), tableName));
        }
    }

    public static LinkedHashMap<String, String> getTempTextCell(String jsonString, LinkedHashMap<String, LinkedHashMap> jsonMap, List<String> sheetNameList) {
        LinkedHashMap<String, String> temMap = new LinkedHashMap<String, String>(1024);
        for (Map.Entry<String, LinkedHashMap> entry : jsonMap.entrySet()) {
            String tableName = entry.getKey();
            if (!sheetNameList.contains(tableName)) continue;
            Map<Integer, List<Cell>> dataMap = SpreadUtils.getDataCell(entry, SpreadUtils.parseStyles(JSONObject.parseObject((String)jsonString)));
            for (Map.Entry<Integer, List<Cell>> data : dataMap.entrySet()) {
                for (Cell cell : data.getValue()) {
                    String text = cell.getText();
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)text)) {
                        text = text.replace(" ", "");
                    }
                    int col = cell.getCol();
                    int row = cell.getRow();
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)text) || text.startsWith("${")) continue;
                    String key = tableName + "#" + row + "#" + col;
                    temMap.put(key, text);
                }
            }
        }
        return temMap;
    }

    public static void checkAccountstandard(String templateNumber, Long orgId) {
        TaxResult tctbMain = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        String accountstandard = "";
        String newRule = "";
        String result = "";
        String orgNumber = "";
        if (!ObjectUtils.isEmpty((Object)tctbMain) && !ObjectUtils.isEmpty((Object)tctbMain.getData())) {
            if (!ObjectUtils.isEmpty((Object)((DynamicObject)tctbMain.getData()).getDynamicObject("accountingstandards")) && !ObjectUtils.isEmpty((Object)((DynamicObject)tctbMain.getData()).getDynamicObject("accountingstandards").getString("projectname"))) {
                accountstandard = ((DynamicObject)tctbMain.getData()).getDynamicObject("accountingstandards").getString("projectname");
            }
            if (!ObjectUtils.isEmpty((Object)((DynamicObject)tctbMain.getData()).getString("newRule"))) {
                newRule = ((DynamicObject)tctbMain.getData()).getString("newRule");
            }
        }
        for (FinanceAccountingStandardsEnum value : FinanceAccountingStandardsEnum.values()) {
            if (!value.getTemplateNumber().equalsIgnoreCase(templateNumber)) continue;
            result = value.getAccountStandard().getDescription() + value.getNewrule();
        }
        if (!result.equalsIgnoreCase(accountstandard + newRule)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9002\u7528\u4f1a\u8ba1\u51c6\u5219\u6216\u4f1a\u8ba1\u5236\u5ea6\u7684\u6b63\u786e\u6027\u3002", (String)"DeclareCheckFacility_48", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    public static void queryExistsbb(Long orgid, String orgName, Date skssqq, Date skssqz, DynamicObject template) {
        QFilter skssqqf = new QFilter(SKSSQQ, "=", (Object)skssqq);
        QFilter skssqzf = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter orgf = new QFilter(ORG, "=", (Object)orgid);
        QFilter teplateidf = new QFilter("id", "!=", (Object)template.getLong("id"));
        QFilter templateTypef = new QFilter("type", "like", (Object)"FR%");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TCVAT_NSRXX, (String)"templateid", (QFilter[])new QFilter[]{skssqqf, skssqzf, orgf, teplateidf, templateTypef});
        if (!ObjectUtils.isEmpty((Object)dynamicObject)) {
            QFilter idf = new QFilter("id", "=", (Object)dynamicObject.getLong("templateid"));
            DynamicObject templateDyo = QueryServiceHelper.queryOne((String)ENTITY_TEMPLATE, (String)"name", (QFilter[])new QFilter[]{idf});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u7684\u3010%4$s\u3011\u8d22\u52a1\u62a5\u8868\u3002", (String)"DeclareCheckFacility_54", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, DateUtils.format(skssqq, "yyyy-MM-dd"), DateUtils.format(skssqz, "yyyy-MM-dd"), templateDyo.getString("name")));
        }
    }

    static {
        canNotUnAuditOrApplyMap.put("declaring", ResManager.loadKDString((String)"\u7533\u62a5\u4e2d", (String)"DeclareCheckFacility_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        canNotUnAuditOrApplyMap.put("declared", ResManager.loadKDString((String)"\u7533\u62a5\u6210\u529f", (String)"DeclareCheckFacility_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        canNotUnAuditOrApplyMap.put("submitted", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u5f85\u7533\u62a5", (String)"DeclareCheckFacility_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        canNotUnAuditOrApplyMap.put("importing", ResManager.loadKDString((String)"\u5df2\u7533\u62a5\u672a\u5bfc\u5165", (String)"DeclareCheckFacility_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces = new ArrayList<String>();
        provinces.add(ResManager.loadKDString((String)"\u5c71\u897f\u7701", (String)"DeclareCheckFacility_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5317\u4eac\u5e02", (String)"DeclareCheckFacility_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u8d35\u5dde\u7701", (String)"DeclareCheckFacility_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a", (String)"DeclareCheckFacility_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6e56\u5317\u7701", (String)"DeclareCheckFacility_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6cb3\u5357\u7701", (String)"DeclareCheckFacility_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u9655\u897f\u7701", (String)"DeclareCheckFacility_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6c5f\u82cf\u7701", (String)"DeclareCheckFacility_49", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5e7f\u4e1c\u7701", (String)"DeclareCheckFacility_50", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u798f\u5efa\u7701", (String)"DeclareCheckFacility_51", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u9752\u6d77\u7701", (String)"DeclareCheckFacility_52", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u5929\u6d25\u5e02", (String)"DeclareCheckFacility_53", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6c5f\u897f\u7701", (String)"DeclareCheckFacility_55", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a", (String)"DeclareCheckFacility_56", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        provinces.add(ResManager.loadKDString((String)"\u6e56\u5357\u7701", (String)"DeclareCheckFacility_57", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }
}

