/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.multideclarelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OperateCodeEnum;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.history.BaseDataHistoryService;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.mq.oversea.DraftEditAndListEnum;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.RiskControlUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class MultiDeclareUtils {
    private static final String SEPARATOR = System.getProperty("line.separator");
    public static final String AUDIT = "audit";
    public static final String SUBMIT = "submit";
    public static final String UNAUDIT = "unaudit";
    public static final String UNSUBMIT = "unsubmit";
    public static Map<String, String> RISK_CONTENT_MAP = new HashMap<String, String>(4);

    public static boolean submit(IFormView view, List<Object> pklist) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx");
        DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        String msg = "";
        if (loadResult == null || loadResult.length < 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u518d\u63d0\u4ea4\u3002", (String)"MultiDeclareUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        for (DynamicObject obj : loadResult) {
            String billstatus = obj.getString("billstatus");
            if ("A".equals(billstatus)) {
                updateList.add(obj);
                continue;
            }
            String nsrmc = obj.getString("nsrmc");
            Date skssqq = obj.getDate("skssqq");
            msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002", (String)"MultiDeclareUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
        }
        if (CollectionUtils.isEmpty(updateList)) {
            view.showTipNotification(msg, Integer.valueOf(2000));
            return false;
        }
        QFilter qFilter1 = new QFilter("entrabill", "=", (Object)"tcvat_nsrxx");
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"enable");
        DynamicObject processdefinition = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (processdefinition == null) {
            for (DynamicObject obj : updateList) {
                obj.set("billstatus", (Object)"C");
                obj.set("auditdate", (Object)new Date());
                obj.set("auditor", (Object)RequestContext.get().getUserId());
                obj.set("modifier", (Object)RequestContext.get().getUserId());
                obj.set("modifytime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        } else {
            OperationResult result = OperationServiceHelper.executeOperate((String)SUBMIT, (String)"tcvat_nsrxx", (DynamicObject[])updateList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                view.showOperationResult(result);
                return false;
            }
        }
        for (DynamicObject dObj : updateList) {
            DynamicObject org = dObj.getDynamicObject("org");
            long orgId = org.getLong("id");
            Date startDate = (Date)dObj.get("skssqq");
            Date endDate = (Date)dObj.get("skssqz");
            String type = dObj.getString("type");
            if (!StringUtils.trimToEmpty((String)type).startsWith("zzs") && !StringUtils.trimToEmpty((String)type).startsWith("qysds")) continue;
            BaseDataHistoryService.saveBaseDataHistory(orgId, startDate, endDate);
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"MultiDeclareUtils_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        return true;
    }

    public static ValidDataResultVo submit(List<Object> pklist, String operationKey, String entryName, List<Long> errorIds, boolean isQueryList, String entityName) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
        List<Object> updateList = new ArrayList<DynamicObject>();
        String msg = "";
        StringBuilder errorMessage = new StringBuilder();
        if (loadResult == null || loadResult.length < 1) {
            msg = isQueryList ? ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MultiDeclareUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"MultiDeclareUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            return ValidDataResultVo.fail(msg);
        }
        QFilter qFilter1 = new QFilter("entrabill", "=", (Object)entryName);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"enable");
        DynamicObject processdefinition = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        for (DynamicObject obj : loadResult) {
            String nsrmc;
            String billno;
            DynamicObject jtysbbd;
            String billstatus = obj.getString("billstatus");
            String datatype = obj.getString("datatype");
            String templatetype = obj.getString("templatetype.number");
            boolean adjuest = false;
            if (("jtysbbd_bd".equals(templatetype) || "jtysbbd_jt".equals(templatetype)) && !ObjectUtils.isEmpty((Object)(jtysbbd = BusinessDataServiceHelper.loadSingle((String)"itp_accrualdec_than_list", (String)"id,taxsystem,accountsettype,billno,billstatus,org,skssqq,skssqz,templatetype,remarks,entryentity.isadjuest,entryentity,entryentity.seq", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)obj.getLong("id"))}))) && !ObjectUtils.isEmpty((Object)jtysbbd.getDynamicObjectCollection("entryentity"))) {
                String isadjuest = ((DynamicObject)jtysbbd.getDynamicObjectCollection("entryentity").get(0)).getString("isadjuest");
                if ("C".equals(billstatus) && StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "yes".equals(isadjuest)) {
                    adjuest = true;
                }
            }
            if (MultiDeclareUtils.operateCondition(entryName, billstatus, operationKey, obj)) {
                DynamicObject object;
                QFilter checkFilter;
                boolean checkResult = true;
                if (entryName.equals("tpo_declare_main_tsd") && StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "sdbd".equals(obj.getString("comparisontype")) && QueryServiceHelper.exists((String)entryName, (QFilter[])new QFilter[]{checkFilter = new QFilter("org", "=", (Object)obj.getLong("org.id")).and("taxsystem", "=", (Object)obj.getLong("taxsystem.id")).and("accountsettype", "=", (Object)obj.getString("accountsettype")).and("skssqq", "=", (Object)obj.getDate("skssqq")).and("skssqz", "=", (Object)obj.getDate("skssqz")).and("templatetype", "=", (Object)templatetype).and("comparisontype", "=", (Object)"hjbd")})) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s:\u8ba1\u63d0\u4e0e\u5ba1\u5b9a\u6570\u3001\u6c47\u7f34\u6570\u6bd4\u5bf9\u53c2\u6570\u8bbe\u7f6e\u5206\u5f00\u6bd4\u5bf9\u65f6\uff0c\u8bf7\u5148\u5220\u9664\u6c47\u7f34\u6bd4\u5bf9\u7c7b\u578b\u6bd4\u5bf9\u8868\u3002", (String)"MultiDeclareUtils_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), obj.getString("billno"));
                    errorMessage.append(msg).append(SEPARATOR);
                    OperatorDialogUtils.operateDialog(templatetype, entityName, OperateCodeEnum.getByCode(operationKey), msg);
                    checkResult = false;
                }
                if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("USA_CIT".equals(templatetype) || "Overseas_CIT".equals(templatetype) || "Overseas_VAT".equals(templatetype)) && null != (object = BusinessDataServiceHelper.loadSingle((String)"gtcp_normal_draft_list", (String)"id,billno,taxsystem,entryentity.declarestatus,entryentity", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)obj.getLong("id"))})) && !ObjectUtils.isEmpty((Object)object.getDynamicObjectCollection("entryentity"))) {
                    String declarestatus = ((DynamicObject)object.getDynamicObjectCollection("entryentity").get(0)).getString("declarestatus");
                    if ("C".equals(billstatus) && StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "declared".equals(declarestatus)) {
                        msg = String.format(ResManager.loadKDString((String)"\u4ec5\u7533\u62a5\u72b6\u6001\u4e3a\u672a\u7533\u62a5\u7684\u6570\u636e\u53ef\u53cd\u5ba1\u6838\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a%1$s", (String)"MultiDeclareUtils_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), obj.getString("billno"));
                        errorMessage.append(msg).append(SEPARATOR);
                        OperatorDialogUtils.operateDialog(templatetype, entityName, OperateCodeEnum.getByCode(operationKey), msg);
                        checkResult = false;
                    }
                }
                if (("jtysbbd_bd".equals(templatetype) || "jtysbbd_jt".equals(templatetype)) && adjuest) {
                    String nsrmc2 = obj.getDynamicObject("org").getString("name");
                    Date skssqq = obj.getDate("skssqq");
                    msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f:\u5355\u636e\u5df2\u6821\u51c6\u5e95\u7a3f\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc2, DateUtils.format(skssqq, "yyyy-MM"));
                    errorMessage.append(msg).append(SEPARATOR);
                    OperatorDialogUtils.operateDialog(templatetype, entityName, OperateCodeEnum.getByCode(operationKey), msg);
                    checkResult = false;
                }
                if (!checkResult) continue;
                updateList.add(obj);
                billno = obj.getString("billno");
                if (entryName.equals("tpo_declare_main_tsd")) {
                    OperatorDialogUtils.operateDialog(templatetype, entityName, OperateCodeEnum.getByCode(operationKey), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u5e95\u7a3f%2$s\u6210\u529f\u3002", (String)"MultiDeclareUtils_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode(operationKey)));
                    continue;
                }
                OperatorDialogUtils.operateDialog(templatetype, entityName, OperateCodeEnum.getByCode(operationKey), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u7533\u62a5\u8868%2$s\u6210\u529f\u3002", (String)"MultiDeclareUtils_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode(operationKey)));
                continue;
            }
            if ("tpo_declare_main_tsc".equals(entryName)) {
                nsrmc = obj.getDynamicObject("org").getString("name");
                billno = obj.getString("billno");
                String declareStatus = obj.getString("declarestatus");
                String skssqq = DateUtils.format(obj.getDate("skssqq"), "yyyy-MM");
                msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"MultiDeclareUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("declared".equals(declareStatus) || "declaring".equals(declareStatus) || "submitted".equals(declareStatus) || "importing".equals(declareStatus))) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u7533\u62a5\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                } else if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("B".equals(billstatus) || "A".equals(billstatus))) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                } else if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "3".equals(datatype)) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\uff1a\u7a0e\u5c40\u4e0b\u8f7d\u7684\u7533\u62a5\u8868\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                } else if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey) && "A".equals(billstatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                } else if (StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey) && !"B".equals(billstatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"MultiDeclareUtils_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                    errorIds.add(obj.getLong("id"));
                }
            } else {
                nsrmc = obj.getDynamicObject("org").getString("name");
                Date skssqq = obj.getDate("skssqq");
                msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"MultiDeclareUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("B".equals(billstatus) || "A".equals(billstatus))) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                } else if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "3".equals(datatype)) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\uff1a\u7a0e\u5c40\u4e0b\u8f7d\u7684\u7533\u62a5\u8868\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                } else if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey) && "A".equals(billstatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                } else if (StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey) && !"B".equals(billstatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"MultiDeclareUtils_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                    errorIds.add(obj.getLong("id"));
                } else if (entryName.equals("tpo_declare_main_tsd") && "C".equals(billstatus) && StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && Boolean.TRUE.equals(obj.getBoolean("generatebusinessdoc"))) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u5df2\u751f\u6210\u8ba1\u63d0\u5355\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                }
            }
            errorMessage.append(msg).append(SEPARATOR);
            OperatorDialogUtils.operateDialog(templatetype, entityName, OperateCodeEnum.getByCode(operationKey), msg);
        }
        TaxResult<List<DynamicObject>> riskControlResult = RiskControlUtils.checkRiskControlResult(updateList, operationKey, entityName);
        if (!riskControlResult.isSuccess()) {
            errorMessage.append(riskControlResult.getMessage()).append(SEPARATOR);
            updateList = (List)riskControlResult.getData();
        }
        if (CollectionUtils.isEmpty(updateList)) {
            return ValidDataResultVo.fail(errorMessage.toString());
        }
        if (processdefinition == null) {
            MultiDeclareUtils.updateData(updateList, operationKey);
        } else {
            OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)entryName, (DynamicObject[])updateList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                return ValidDataResultVo.fail(errorMessage.toString(), result);
            }
        }
        if (AUDIT.equals(operationKey) || UNAUDIT.equals(operationKey)) {
            OverSeaMQSender.sendMQ(Arrays.asList(loadResult), operationKey, entityName);
        }
        if (EmptyCheckUtils.isNotEmpty(updateList)) {
            DynamicObject[] updateObjects = updateList.toArray(new DynamicObject[updateList.size()]);
            MultiDeclareMQSender.sendMQ(updateObjects, operationKey);
            DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])updateObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operationKey));
        }
        if (errorMessage.length() > 0) {
            return ValidDataResultVo.fail(errorMessage.toString());
        }
        List successPkids = updateList.stream().map(s -> s.get("id")).collect(Collectors.toList());
        return ValidDataResultVo.success(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"MultiDeclareUtils_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), successPkids);
    }

    public static OperationResult submit(List<Object> pklist, String operationKey, String entryName, String entityName) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(12);
        for (DynamicObject dynamicObject : loadResult) {
            updateList.add(dynamicObject);
        }
        QFilter qFilter1 = new QFilter("entrabill", "=", (Object)entryName);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"enable");
        DynamicObject processdefinition = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (processdefinition == null) {
            MultiDeclareUtils.updateData(updateList, operationKey);
        } else {
            OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)entryName, (DynamicObject[])updateList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                return result;
            }
        }
        if (AUDIT.equals(operationKey) || UNAUDIT.equals(operationKey)) {
            OverSeaMQSender.sendMQ(Arrays.asList(loadResult), operationKey, entityName);
        }
        if (EmptyCheckUtils.isNotEmpty(updateList)) {
            DynamicObject[] updateObjects = updateList.toArray(new DynamicObject[updateList.size()]);
            MultiDeclareMQSender.sendMQ(updateObjects, operationKey);
            DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])updateObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operationKey));
        }
        return null;
    }

    public static boolean operateCondition(String entryName, String billstatus, String operationKey, DynamicObject mainDataObj) {
        if ("A".equals(billstatus) && StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operationKey)) {
            return true;
        }
        if ("B".equals(billstatus) && StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey)) {
            return true;
        }
        if ("B".equals(billstatus) && StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey)) {
            return true;
        }
        if ("C".equals(billstatus) && StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey)) {
            return !(entryName.equals("tpo_declare_main_tsd") ? Boolean.TRUE.equals(mainDataObj.getBoolean("generatebusinessdoc")) : entryName.equals("tpo_declare_main_tsc") && ("declared".equals(mainDataObj.getString("declarestatus")) || "declaring".equals(mainDataObj.getString("declarestatus")) || "submitted".equals(mainDataObj.getString("declarestatus")) || "importing".equals(mainDataObj.getString("declarestatus"))));
        }
        return false;
    }

    public static boolean submit(IFormView view, List<Object> pklist, String operationKey, String entryName, boolean isQueryList) {
        DraftEditAndListEnum draftEditAndListEnum;
        String formId = view.getFormShowParameter().getFormId();
        if ("tcvat_taxrefund_edit".equals(formId)) {
            entryName = "tcvat_tax_refund_apply";
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
        List<Object> updateList = new ArrayList<DynamicObject>();
        String msg = "";
        StringBuilder errorMessage = new StringBuilder();
        if (loadResult == null || loadResult.length < 1) {
            if (isQueryList) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MultiDeclareUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), Integer.valueOf(2000));
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"MultiDeclareUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            return false;
        }
        for (DynamicObject obj : loadResult) {
            String nsrmc;
            String billstatus = obj.getString("billstatus");
            Object var16_19 = null;
            String nsrtype = null;
            String string = obj.getString("datatype");
            nsrtype = obj.getString("templatetype.number");
            if (MultiDeclareUtils.operateCondition(entryName, billstatus, operationKey, obj)) {
                updateList.add(obj);
                String billno = obj.getString("billno");
                if (entryName.equals("tpo_declare_main_tsd")) {
                    OperatorDialogUtils.operateDialog(nsrtype, view.getFormShowParameter().getFormId(), OperateCodeEnum.getByCode(operationKey), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u5e95\u7a3f%2$s\u6210\u529f\u3002", (String)"MultiDeclareUtils_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode(operationKey)));
                    continue;
                }
                OperatorDialogUtils.operateDialog(nsrtype, view.getFormShowParameter().getFormId(), OperateCodeEnum.getByCode(operationKey), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u7533\u62a5\u8868%2$s\u6210\u529f\u3002", (String)"MultiDeclareUtils_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode(operationKey)));
                continue;
            }
            if ("tpo_declare_main_tsc".equals(entryName)) {
                nsrmc = obj.getDynamicObject("org").getString("name");
                String declareStatus = obj.getString("declarestatus");
                String skssqq = DateUtils.format(obj.getDate("skssqq"), "yyyy-MM");
                msg = MultiDeclareUtils.undoMsg(billstatus, operationKey, string, declareStatus, nsrmc, skssqq);
            } else {
                nsrmc = obj.getDynamicObject("org").getString("name");
                Date skssqq = obj.getDate("skssqq");
                msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"MultiDeclareUtils_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("B".equals(billstatus) || "A".equals(billstatus))) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                } else if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "3".equals(string)) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\uff1a\u7a0e\u5c40\u4e0b\u8f7d\u7684\u7533\u62a5\u8868\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                } else if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey) && "A".equals(billstatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                } else if (StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey) && !"B".equals(billstatus)) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"MultiDeclareUtils_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                } else if (entryName.equals("tpo_declare_main_tsd") && "C".equals(billstatus) && StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && Boolean.TRUE.equals(obj.getBoolean("generatebusinessdoc"))) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u5df2\u751f\u6210\u8ba1\u63d0\u5355\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format(skssqq, "yyyy-MM"));
                }
            }
            OperatorDialogUtils.operateDialog(nsrtype, view.getFormShowParameter().getFormId(), OperateCodeEnum.getByCode(operationKey), msg);
        }
        TaxResult<List<DynamicObject>> riskControlResult = RiskControlUtils.checkRiskControlResult(updateList, operationKey, view.getFormShowParameter().getFormId());
        if (!riskControlResult.isSuccess()) {
            msg = riskControlResult.getMessage();
            updateList = (List)riskControlResult.getData();
        }
        if (CollectionUtils.isEmpty(updateList)) {
            view.showErrorNotification(msg);
            return false;
        }
        QFilter qFilter1 = new QFilter("entrabill", "=", (Object)entryName);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"enable");
        DynamicObject processdefinition = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (processdefinition == null) {
            MultiDeclareUtils.updateData(updateList, operationKey);
        } else {
            OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)entryName, (DynamicObject[])updateList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                view.showOperationResult(result);
                return false;
            }
        }
        if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey)) {
            for (DynamicObject dynamicObject : updateList) {
                DynamicObject org = dynamicObject.getDynamicObject("org");
                long orgId = org.getLong("id");
                Date startDate = (Date)dynamicObject.get("skssqq");
                Date endDate = (Date)dynamicObject.get("skssqz");
                String type = dynamicObject.getString("templatetype.number");
                if (!StringUtils.trimToEmpty((String)type).startsWith("zzs") && !StringUtils.trimToEmpty((String)type).startsWith("qysds")) continue;
                BaseDataHistoryService.saveBaseDataHistory(orgId, startDate, endDate);
            }
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"MultiDeclareUtils_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        if ((AUDIT.equals(operationKey) || UNAUDIT.equals(operationKey)) && EmptyCheckUtils.isNotEmpty((Object)(draftEditAndListEnum = DraftEditAndListEnum.valueOfCode(formId)))) {
            OverSeaMQSender.sendMQ(Arrays.asList(loadResult), operationKey, draftEditAndListEnum.getListForm());
        }
        if (EmptyCheckUtils.isNotEmpty(updateList)) {
            DynamicObject[] updateObjects = updateList.toArray(new DynamicObject[updateList.size()]);
            MultiDeclareMQSender.sendMQ(updateObjects, operationKey);
            DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])updateObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operationKey));
        }
        return true;
    }

    public static String undoMsg(String billstatus, String operationKey, String datatype, String declareStatus, String nsrmc, String skssqq) {
        String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"MultiDeclareUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("declared".equals(declareStatus) || "declaring".equals(declareStatus) || "submitted".equals(declareStatus) || "importing".equals(declareStatus))) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u7533\u62a5\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        } else if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("B".equals(billstatus) || "A".equals(billstatus))) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        } else if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && "3".equals(datatype)) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\uff1a\u7a0e\u5c40\u4e0b\u8f7d\u7684\u7533\u62a5\u8868\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        } else if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey) && "A".equals(billstatus)) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        } else if (StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey) && !"B".equals(billstatus)) {
            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"MultiDeclareUtils_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
        }
        return msg;
    }

    private static void refreshElement(DynamicObject[] loadResult, String operationKey, String entityName) {
        for (DynamicObject entity : loadResult) {
            DeclareMQSender.sendMQ(entity, null, DeclareMQType.DECLARE.name(), operationKey, entityName);
        }
    }

    private static void updateData(List<DynamicObject> updateList, String operationKey) {
        for (DynamicObject obj : updateList) {
            if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey)) {
                obj.set("billstatus", (Object)"C");
                obj.set("auditdate", (Object)new Date());
                obj.set("auditor", (Object)RequestContext.get().getUserId());
            }
            if (StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operationKey)) {
                obj.set("billstatus", (Object)"B");
            }
            if (StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey)) {
                obj.set("billstatus", (Object)"A");
            }
            if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey)) {
                obj.set("billstatus", (Object)"A");
                obj.set("auditdate", null);
                obj.set("auditor", (Object)0L);
            }
            obj.set("modifier", (Object)RequestContext.get().getUserId());
            obj.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    public static boolean checkDeclareDataInWorkFlowProcessFinished(String businessKey, String operationKey) {
        Map bizProcessStatus = WorkflowServiceHelper.getBizProcessStatus((String[])new String[]{businessKey});
        return EmptyCheckUtils.isEmpty(bizProcessStatus);
    }

    public static void showRiskDialog(String sbbid, IFormView view) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bdtaxr_declare_risk_view");
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put("sbbid", sbbid);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(param);
    }

    public static String getRiskContentNormalStr() {
        return ResManager.loadKDString((String)"\u6b63\u5e38", (String)"MultiDeclareUtils_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    public static String getRiskContentAbnormalStr() {
        return ResManager.loadKDString((String)"\u5f02\u5e38", (String)"MultiDeclareUtils_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    public static String getBillNo(String orgid, Date startDate, Date endDate, String type) {
        DynamicObject declareMain = MultiDeclareUtils.getDeclareMain(orgid, startDate, endDate, type);
        if (declareMain != null) {
            return declareMain.getString("billno");
        }
        switch (type) {
            case "qysdsjb": {
                return MultiDeclareUtils.generateDraftNo("tccit_query_report", orgid);
            }
            case "qysds_hdzs_jb": {
                return MultiDeclareUtils.generateDraftNo("tccit_query_report", orgid);
            }
            case "qysdsnb": {
                return MultiDeclareUtils.generateDraftNo("tccit_quarterly_report", orgid);
            }
            case "qysdsnb_fzjg": {
                return MultiDeclareUtils.generateDraftNo("tccit_quarterly_report", orgid);
            }
            case "qysds_hdzs_nb": {
                return MultiDeclareUtils.generateDraftNo("tccit_quarterly_report", orgid);
            }
            case "zzsybnsr": {
                return MultiDeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
            }
            case "zzsxgmnsr": {
                String billno = MultiDeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VATSS");
            }
            case "zzsybnsr_ybhz": {
                String billno = MultiDeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VATSUM");
            }
            case "zzsybnsr_hz_zjg": {
                String billno = MultiDeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VAT-HZ");
            }
            case "zzsybnsr_yz_zjg": {
                String billno = MultiDeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VAYSUM-HOYZ");
            }
            case "zzsybnsr_yz_fzjg": {
                String billno = MultiDeclareUtils.generateDraftNo("tcvat_zzs_declare_list", orgid);
                return billno.replace("VAT", "VAYSUM-BOYZ");
            }
            case "zzstz": {
                return MultiDeclareUtils.generateDraftNo("tcvat_wkpsr_query_list", orgid);
            }
        }
        return null;
    }

    private static String generateDraftNo(String entityName, String orgid) {
        return DeclareServiceHelper.generateSBBNo(entityName, orgid);
    }

    private static DynamicObject getDeclareMain(String orgid, Date startDate, Date endDate, Object type) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("skssqq", "=", (Object)startDate);
        QFilter q3 = new QFilter("skssqz", "=", (Object)endDate);
        QFilter q4 = new QFilter("type", "=", type);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billstatus,billno,zerodeclare", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        return object;
    }

    static {
        RISK_CONTENT_MAP.put("normal", MultiDeclareUtils.getRiskContentNormalStr());
        RISK_CONTENT_MAP.put("abnormal", MultiDeclareUtils.getRiskContentAbnormalStr());
        RISK_CONTENT_MAP.put(MultiDeclareUtils.getRiskContentNormalStr(), "normal");
        RISK_CONTENT_MAP.put(MultiDeclareUtils.getRiskContentAbnormalStr(), "abnormal");
    }
}

