/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.number;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.CellFormatModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DataFormatUtils {
    private static Log logger = LogFactory.getLog(DataFormatUtils.class);
    private static String DATA_FORMAT = "#####0.############";
    public static final String DECIMAL_INIT_FORMAT = "#####0";
    public static final String MICROMETER_DECIMAL_INIT_FORMAT = "###,##0";
    public static final String DEFAULT_DECIMAL_FORMAT = "#####0.00";
    public static final List<String> NUMBERIC_TYPE = Lists.newArrayList((Object[])new String[]{"Decimal", "decimal", "Long", "long", "Integer", "integer", "Basedata"});
    public static final List<String> TEXT_TYPE = Lists.newArrayList((Object[])new String[]{"Text", "text", "Combo", "string", "String"});
    public static final List<String> DATE_TYPE = Lists.newArrayList((Object[])new String[]{"Time", "time", "DateTime", "datetime", "Date", "date", "CreateDate", "ModifyDate"});
    public static final String DEFAULT_DECIMAL_VALUE = "0.00";
    public static final Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");

    public static String decimalFormat(BigDecimal bd) {
        DecimalFormat decimalFormat = new DecimalFormat(DATA_FORMAT);
        return decimalFormat.format(bd);
    }

    public static String decimalFormat(BigDecimal bd, EntityField fieldType) {
        String dataFormat = DATA_FORMAT;
        if (null != fieldType && "Decimal".equals(fieldType.getFieldType())) {
            dataFormat = TemplateUtils.getDecimalFormatByMetadataScale(fieldType, DECIMAL_INIT_FORMAT, dataFormat);
        }
        DecimalFormat decimalFormat = new DecimalFormat(dataFormat);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat.format(bd);
    }

    public static String decimalFormat(BigDecimal bd, CellFormatModel cellFormat) {
        String dataFormat = DATA_FORMAT;
        if (null != cellFormat && "Decimal".equals(cellFormat.getFieldType())) {
            dataFormat = TemplateUtils.getDecimalFormatByMetadataScale(cellFormat, DECIMAL_INIT_FORMAT, dataFormat);
        }
        DecimalFormat decimalFormat = new DecimalFormat(dataFormat);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat.format(bd);
    }

    public static String formatMicrometer(String text) {
        DecimalFormat df = null;
        df = text.indexOf(46) > 0 ? (text.length() - text.indexOf(46) - 1 == 0 ? new DecimalFormat("###,##0.") : (text.length() - text.indexOf(46) - 1 == 1 ? new DecimalFormat("###,##0.0") : new DecimalFormat("###,##0.00"))) : new DecimalFormat(MICROMETER_DECIMAL_INIT_FORMAT);
        double number = 0.0;
        try {
            number = Double.parseDouble(text);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

    public static BigDecimal decimalFormat(Object data, String dataFormat) {
        if (data == null) {
            return null;
        }
        BigDecimal bd = new BigDecimal(data.toString());
        DecimalFormat decimalFormat = new DecimalFormat(dataFormat);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return new BigDecimal(decimalFormat.format(bd));
    }

    public static String formatInteger(Object dataObj, String initFormat) {
        try {
            String val = dataObj.toString();
            BigDecimal bd = new BigDecimal(val);
            StringBuilder format = new StringBuilder(initFormat);
            if (val.contains(".")) {
                String decimalPlace = val.substring(val.lastIndexOf(46) + 1);
                int scale = decimalPlace.length();
                for (int i = 0; i < scale; ++i) {
                    if (i == 0) {
                        format.append('.');
                    }
                    format.append('0');
                }
            }
            DecimalFormat decimalFormat = new DecimalFormat(format.toString());
            decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
            return decimalFormat.format(bd);
        }
        catch (Exception e) {
            return dataObj.toString();
        }
    }

    public static String getDecimalFormatByScale(int scale, String initFormat) {
        if (StringUtil.isEmpty((CharSequence)initFormat)) {
            initFormat = DECIMAL_INIT_FORMAT;
        }
        StringBuilder format = new StringBuilder(initFormat);
        for (int i = 0; i < scale; ++i) {
            if (i == 0) {
                format.append('.');
            }
            format.append('0');
        }
        return format.toString();
    }

    public static String dataToDbTypeFormat(Object dataObj, EntityField fieldType) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("decimal".equalsIgnoreCase(fieldType.getFieldType())) {
                try {
                    return dataObj.toString().replace(",", "");
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "time".equalsIgnoreCase(fieldType.getFieldType())) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
                return DateUtils.format((Date)dataObj, format);
            }
            if (dataObj instanceof Date && "date".equalsIgnoreCase(fieldType.getFieldType())) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                return DateUtils.format((Date)dataObj, format);
            }
            if ("integer".equalsIgnoreCase(fieldType.getFieldType())) {
                return dataObj.toString().replace(",", "");
            }
        }
        return dataObj.toString();
    }

    public static Map<String, String> batchDataToDbTypeFormat(Map<String, String> dataMap, Map<String, EntityField> typeMap) {
        if (dataMap == null || typeMap == null) {
            return dataMap;
        }
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            String value = DataFormatUtils.dataToDbTypeFormat(entry.getValue(), typeMap.get(entry.getKey()));
            dataMap.put(entry.getKey(), value);
        }
        return dataMap;
    }

    public static String dataFormatByFieldType(Object dataObj, EntityField fieldType) {
        if (dataObj == null && fieldType == null) {
            return null;
        }
        if (fieldType != null && fieldType.getFieldType() != null) {
            if (dataObj != null && fieldType.getDefaultValue() != null && !fieldType.getDefaultValue().equals("") && ("".equals(dataObj) || fieldType.getDefaultValue().equals(dataObj))) {
                return fieldType.getDefaultValue().toString();
            }
            String fieldTypeStr = fieldType.getFieldType().trim();
            if ("decimal".equalsIgnoreCase(fieldTypeStr)) {
                if (dataObj == null || StringUtil.isBlank((CharSequence)dataObj.toString())) {
                    dataObj = BigDecimal.ZERO;
                }
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    String format = fieldType.getFormatStr();
                    if (StringUtil.isBlank((CharSequence)format)) {
                        format = DEFAULT_DECIMAL_FORMAT;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    logger.error(String.format("\u503c\uff1a%s\u4e0e\u5176\u7c7b\u578b\uff1a%s\u4e0d\u5339\u914d\uff01", String.valueOf(dataObj), fieldType != null ? String.valueOf(fieldType.getFieldType()) : "null"), (Throwable)e);
                    return DEFAULT_DECIMAL_VALUE;
                }
            }
            if (dataObj instanceof Date && "time".equalsIgnoreCase(fieldTypeStr)) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
                return DateUtils.format((Date)dataObj, format);
            }
            if (dataObj instanceof Date && "date".equalsIgnoreCase(fieldTypeStr)) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                return DateUtils.format((Date)dataObj, format);
            }
            if (dataObj instanceof String && "date".equalsIgnoreCase(fieldTypeStr)) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                try {
                    dataObj = DateUtils.format(DateUtils.stringToDate(dataObj.toString(), format), format);
                }
                catch (Exception e) {
                    logger.error("{}format illigal! {}", dataObj, (Object)e);
                    return "";
                }
            } else {
                Object defaultValue;
                if ("integer".equalsIgnoreCase(fieldTypeStr) || "long".equalsIgnoreCase(fieldTypeStr)) {
                    if (dataObj == null || StringUtil.isBlank((CharSequence)dataObj.toString())) {
                        return "0";
                    }
                    return DataFormatUtils.formatInteger(dataObj, DECIMAL_INIT_FORMAT);
                }
                if ("string".equalsIgnoreCase(fieldTypeStr) || "text".equalsIgnoreCase(fieldTypeStr)) {
                    if (dataObj == null) {
                        return "";
                    }
                } else if ("basedata".equalsIgnoreCase(fieldTypeStr)) {
                    if (dataObj == null || StringUtil.isBlank((CharSequence)dataObj.toString())) {
                        return "0";
                    }
                } else if ("boolean".equalsIgnoreCase(fieldTypeStr) && (defaultValue = fieldType.getDefaultValue()) != null) {
                    return String.valueOf(defaultValue);
                }
            }
        }
        return dataObj == null ? null : dataObj.toString();
    }

    public static boolean isInteger(Object o) {
        if (o == null) {
            return false;
        }
        return pattern.matcher(o.toString()).matches();
    }
}

