/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class SystemParamUtil {
    private static final Log logger = LogFactory.getLog(SystemParamUtil.class);

    public static Object getAppParameter(String appNumber, String paramKey) {
        long orgId = RequestContext.get().getOrgId();
        return SystemParamUtil.getAppParameter(appNumber, paramKey, orgId);
    }

    public static Object getAppParameter(String appNumber, String paramKey, long orgId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        String appId = appInfo.getId();
        AppParam apm = new AppParam();
        apm.setAppId(appId);
        apm.setOrgId(Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)paramKey);
    }

    public static Map<Long, Object> getAppParameterBatch(String appNumber, String paramKey, List<Long> orgIds) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        String appId = appInfo.getId();
        AppParam apm = new AppParam();
        apm.setAppId(appId);
        Map orgFromCache = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)apm, orgIds);
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        if (orgFromCache != null) {
            for (Map.Entry entry : orgFromCache.entrySet()) {
                String k = (String)entry.getKey();
                Map v = (Map)entry.getValue();
                if (v == null || k == null) continue;
                try {
                    map.put(Long.parseLong(k), v.get(paramKey));
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return map;
    }

    public static boolean getZeroDeclareParameter(String appNumber, String paramKey, long orgId) {
        if (StringUtil.isBlank((CharSequence)appNumber)) {
            return false;
        }
        Object sysParams = SystemParamUtil.getAppParameter(appNumber, paramKey, orgId);
        return sysParams != null && (Boolean)sysParams != false;
    }

    public static boolean isOverseasTaxOrg(Long orgId) {
        boolean isEnable = false;
        Object overseasTax = SystemParamUtil.getAppParameter("tctb", "enableoverseastax", orgId);
        if (overseasTax instanceof Boolean && ((Boolean)overseasTax).booleanValue()) {
            isEnable = true;
        }
        return isEnable;
    }
}

