/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.util.tree;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;

public class SearchUtil {
    public static final String ResultList = "_resultlist";
    public static final String Focus = "_focus";
    private static final String TRUE = "true";
    private static final String NO_RIGHT = "noRight";

    public static List<TreeNode> getList(String text, TreeNode root) {
        return SearchUtil.getList(text, root, null);
    }

    public static List<TreeNode> getList(String text, TreeNode root, List<String> dataKey) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        Queue<TreeNode> queue = SearchUtil.getQueue(root);
        while (!queue.isEmpty()) {
            TreeNode node = queue.poll();
            if (node.getText().toLowerCase().contains(text.toLowerCase())) {
                nodes.add(node);
                continue;
            }
            if (dataKey == null) continue;
            Map data = (Map)node.getData();
            for (String key : dataKey) {
                if (data == null || data.get(key) == null || !((String)data.get(key)).contains(text.toLowerCase())) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public static Queue<TreeNode> getQueue(TreeNode root) {
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        LinkedList<TreeNode> result = new LinkedList<TreeNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.poll();
            result.add(node);
            List children = node.getChildren();
            if (children == null) continue;
            for (TreeNode child : children) {
                queue.add(child);
            }
        }
        return result;
    }

    public static void expand(String parentid, TreeView treeView, TreeNode root) {
        block0: while (!parentid.equals(root.getId()) && !parentid.equals("")) {
            treeView.expand(parentid);
            Queue<TreeNode> temp = SearchUtil.getQueue(root);
            while (!temp.isEmpty()) {
                TreeNode tempnode = temp.poll();
                if (!tempnode.getId().equals(parentid)) continue;
                parentid = tempnode.getParentid();
                continue block0;
            }
        }
        treeView.expand(root.getId());
    }

    public static void selectNode(TreeNode fnode, TreeView tree, TreeNode root, boolean setcolor, IPageCache pageCache) {
        if (setcolor) {
            TreeNode old;
            String oldnode = pageCache.get(tree.getKey() + "oldnode");
            TreeNode treeNode = old = oldnode == null ? null : (TreeNode)SerializationUtils.deSerializeFromBase64((String)oldnode);
            if (old != null) {
                old.setColor("");
                SearchUtil.updateNode(old, tree);
            }
            fnode.setColor("blue");
            SearchUtil.updateNode(fnode, tree);
            pageCache.put(tree.getKey() + "oldnode", SerializationUtils.serializeToBase64((Object)fnode));
        } else {
            tree.treeNodeClick(fnode.getParentid(), fnode.getId());
        }
        if (!TRUE.equals(pageCache.get(NO_RIGHT))) {
            tree.focusNode(fnode);
            SearchUtil.expand(fnode.getParentid(), tree, root);
        }
    }

    private static void updateNode(TreeNode node, TreeView tree) {
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        tree.updateNode(node);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(checkedNodeIds.size());
        for (String checkedNodeId : checkedNodeIds) {
            TreeNode e = new TreeNode();
            e.setId(checkedNodeId);
            list.add(e);
        }
        tree.checkNodesWithoutChild(list);
    }

    public static void searchMember(String text, boolean setcolor, IFormView view, IPageCache pageCache, TreeView treeView, String treeCacheName) {
        SearchUtil.searchMember(text, setcolor, view, pageCache, treeView, treeCacheName, null);
    }

    public static void searchMember(String text, boolean setcolor, IFormView view, IPageCache pageCache, TreeView treeView, String treeCacheName, List<String> dataKey) {
        String treeCache = pageCache.get(treeCacheName);
        if (treeCache == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SearchUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
        List<TreeNode> nodes = SearchUtil.getList(text, root, dataKey);
        if (!nodes.isEmpty()) {
            SearchUtil.selectNode(nodes.get(0), treeView, root, setcolor, pageCache);
            pageCache.put(treeView.getKey() + ResultList, SerializationUtils.serializeToBase64(nodes));
            pageCache.put(treeView.getKey() + Focus, "0");
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SearchUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    public static void searchMember(String text, boolean setcolor, IFormView view, IPageCache pageCache, TreeView treeView, String treeCacheName, String resultList, String focus) {
        String treeCache = pageCache.get(treeCacheName);
        if (treeCache == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SearchUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
        List<TreeNode> nodes = SearchUtil.getList(text, root);
        if (!nodes.isEmpty()) {
            SearchUtil.selectNode(nodes.get(0), treeView, root, setcolor, pageCache);
            pageCache.put(treeView.getKey() + ResultList, SerializationUtils.serializeToBase64(nodes));
            pageCache.put(treeView.getKey() + Focus, "0");
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SearchUtil_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    public static void getLeftOrRight(IPageCache pageCache, IFormView view, String key, TreeView treeView, String[] btns, String treeCacheName) {
        String rowcache = pageCache.get(treeView.getKey() + ResultList);
        if (rowcache == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"SearchUtil_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        List rowList = (List)SerializationUtils.deSerializeFromBase64((String)rowcache);
        int rowCount = Integer.parseInt(pageCache.get(treeView.getKey() + Focus));
        if (btns[0].equals(key)) {
            if (0 == rowCount) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"SearchUtil_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            --rowCount;
        } else {
            if (rowList.size() - 1 == rowCount) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"SearchUtil_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            ++rowCount;
        }
        pageCache.put(treeView.getKey() + Focus, String.valueOf(rowCount));
        TreeNode focusNode = (TreeNode)rowList.get(rowCount);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(treeCacheName), TreeNode.class);
        SearchUtil.selectNode(focusNode, treeView, root, false, pageCache);
        treeView.treeNodeClick(focusNode.getParentid(), focusNode.getId());
    }
}

