/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.accrual;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.accrual.AccrualListingService;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.bdtaxr.mservice.api.accrual.AccrualListQueryService;

public class AccrualListQueryServiceImpl
implements AccrualListQueryService {
    private static final Log LOGGER = LogFactory.getLog(AccrualListQueryServiceImpl.class);
    private AccrualListingService accrualListingService = new AccrualListingService();

    @Override
    public List<Map<String, Object>> query(List<Long> orgList, List<String> categoryList, Date accrualDate) {
        LOGGER.info("AccrualListQueryServiceImpl-query \u8bf7\u6c42\u53c2\u6570\uff1aorgList:{},baseTaxIds:{},accrualDate:{}", new Object[]{orgList.size(), categoryList.size(), accrualDate});
        List result = this.accrualListingService.query(orgList, categoryList, accrualDate);
        LOGGER.info("AccrualListQueryServiceImpl-query \u7ed3\u679c\uff1a{}", (Object)result.size());
        return result;
    }

    @Override
    public List<Map<String, Object>> queryTaxableList(List<Map<String, Object>> categoryOrgList, Date accrualDate) {
        LOGGER.info("AccrualListQueryServiceImpl-query \u8bf7\u6c42\u53c2\u6570\uff1acategoryOrgList:{},accrualDate:{}", (Object)categoryOrgList.size(), (Object)accrualDate);
        List result = this.accrualListingService.queryTaxableList(categoryOrgList, accrualDate);
        LOGGER.info("AccrualListQueryServiceImpl-query \u7ed3\u679c\uff1a{}", (Object)result.size());
        return result;
    }

    @Override
    public void updateAccrualListToDB() {
        this.accrualListingService.updateAccrualListToDB();
    }

    @Override
    public String updateToDBByCondition(Date declareDate, List<Long> orgList, List<String> sbbCategories) {
        EngineResponse engineResponse = new EngineResponse();
        try {
            this.accrualListingService.updateAccrualListToDB(declareDate, orgList, sbbCategories);
            return SerializationUtils.toJsonString((Object)EngineResponse.success((String)"success", null));
        }
        catch (Exception e) {
            LOGGER.error("yjtqd updateToDBByCondition Error!", (Throwable)e);
            engineResponse.setSuccess(Boolean.FALSE);
            engineResponse.setMessage(e.getMessage());
            return SerializationUtils.toJsonString((Object)engineResponse);
        }
    }
}

