/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.declare;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.formula.FormulaService;
import kd.taxc.bdtaxr.business.formula.impl.FormulaServiceImpl;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareRequestService;
import kd.taxc.bdtaxr.business.service.taxdeclare.SavetaxDeclareService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareRequestServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.SavetaxDeclareServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.business.subplugin.declare.DeclareBizExtendHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckFactory;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.mservice.api.declare.DeclareService;

public class DeclareServiceImpl
implements DeclareService {
    private DeclareRequestService declareRequestService = new DeclareRequestServiceImpl();
    private TaxDeclareDataService taxDeclareDataService = new TaxDeclareDataServiceImpl();
    private SavetaxDeclareService savetaxDeclareService = new SavetaxDeclareServiceImpl();
    private static FormulaService formulaService = new FormulaServiceImpl();
    private static final Log LOGGER = LogFactory.getLog(DeclareServiceImpl.class);

    @Override
    public String queryData(String declareModelJson) {
        DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)declareModelJson, DeclareRequestModel.class);
        DeclareResponseModel responseModel = DeclareServiceHelper.queryData((DeclareRequestModel)requestModel);
        return SerializationUtils.toJsonString((Object)responseModel);
    }

    @Override
    public String generateSbb(String declareRequestJson) {
        DeclareResponseModel declareResponseModel = new DeclareResponseModel();
        try {
            DeclareRequestModel requestModel = this.declareRequestService.build(declareRequestJson);
            Map typeMap = TaxDeclarePluginService.getAllFieldTypeToShow((Map)requestModel.getMetaDataMap());
            declareResponseModel = this.taxDeclareDataService.refreshData(requestModel, typeMap);
            BaseResult baseResult = TaxDeclareCheckFactory.createHandler((String)requestModel.getTemplateType()).beforeSaveCheck((Map)Maps.newHashMap(), declareResponseModel.getData(), declareResponseModel);
            if (!BaseResult.OK.equals(baseResult.getCode())) {
                declareResponseModel.setErrorMessage(baseResult.getMessage());
                return SerializationUtils.toJsonString((Object)declareResponseModel);
            }
            Map resultMap = this.savetaxDeclareService.saveTaxDeclare(declareResponseModel.getId().toString(), null, null, null, requestModel, declareResponseModel, declareResponseModel.getData());
            HashMap<String, Object> requestMap = new HashMap<String, Object>(1);
            if (requestModel.getExtendParams() != null) {
                requestMap.putAll(requestModel.getExtendParams());
            }
            requestMap.put("orgId", requestModel.getOrgId());
            requestMap.put("skssqq", requestModel.getSkssqq());
            requestMap.put("skssqz", requestModel.getSkssqz());
            requestMap.put("Id", requestModel.getId());
            requestMap.putAll(requestModel.getBusinessMap());
            requestMap.put("remarks", requestModel.getBusinessValue("remarks"));
            HashMap resultMap1 = new HashMap(resultMap);
            DeclareBizExtendHelper.saveBusinessData(requestMap, resultMap1);
            List checkFormulaList = formulaService.checkFormulasNew(requestModel, declareResponseModel.getData(), declareResponseModel.getParamMap(), declareResponseModel.getDynRowList());
            this.savetaxDeclareService.saveRiskItem(declareResponseModel.getId().toString(), checkFormulaList, null, 2);
        }
        catch (Exception e) {
            declareResponseModel.setErrorMessage(e.getMessage());
            LOGGER.error("\u751f\u6210\u7533\u62a5\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
        }
        return SerializationUtils.toJsonString((Object)declareResponseModel);
    }

    @Override
    public void resetBySbbId(String declareModelJson) {
        DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)declareModelJson, DeclareRequestModel.class);
        DeclareServiceHelper.resetBySbbId((DeclareRequestModel)requestModel);
    }
}

