/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.declare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.RequestResult;
import kd.taxc.bdtaxr.common.declare.helper.TaxBureauServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.mq.MQSender;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.mservice.api.declare.TaxBureauDeclareService;

public class TaxBureauDeclareServiceImpl
implements TaxBureauDeclareService {
    private static final Log logger = LogFactory.getLog(TaxBureauDeclareServiceImpl.class);
    private static final String ORG_KEY = "tcvat_nsrxx#1#org";
    private static final String TYPE_KEY = "tcvat_nsrxx#1#type";
    private static final String SKSSQQ_KEY = "tcvat_nsrxx#1#skssqq";
    private static final String SKSSQZ_KEY = "tcvat_nsrxx#1#skssqz";
    private static final String COMPARE_QUEUE = "taxc.bdtaxr.taxbureau_declare.compare";
    private static final String CONVERT_QUEUE = "taxc.bdtaxr.taxbureau_declare.convert";
    private final Set<String> ZZSSJYT47 = new HashSet<String>(Arrays.asList("tcvat_ybnsr_fb1#1#kjskzzszyfpxse,tcvat_ybnsr_fb1#1#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#1#kjqtfpxse,tcvat_ybnsr_fb1#1#kjqtfpxxynse", "tcvat_ybnsr_fb1#2#kjskzzszyfpxse,tcvat_ybnsr_fb1#2#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#2#kjqtfpxse,tcvat_ybnsr_fb1#2#kjqtfpxxynse", "tcvat_ybnsr_fb1#23#kjskzzszyfpxse,tcvat_ybnsr_fb1#23#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#23#kjqtfpxse,tcvat_ybnsr_fb1#23#kjqtfpxxynse", "tcvat_ybnsr_fb1#4#kjskzzszyfpxse,tcvat_ybnsr_fb1#4#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#4#kjqtfpxse,tcvat_ybnsr_fb1#4#kjqtfpxxynse", "tcvat_ybnsr_fb1#5#kjskzzszyfpxse,tcvat_ybnsr_fb1#5#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#5#kjqtfpxse,tcvat_ybnsr_fb1#5#kjqtfpxxynse", "tcvat_ybnsr_fb1#8#kjskzzszyfpxse,tcvat_ybnsr_fb1#8#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#8#kjqtfpxse,tcvat_ybnsr_fb1#8#kjqtfpxxynse", "tcvat_ybnsr_fb1#9#kjskzzszyfpxse,tcvat_ybnsr_fb1#9#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#9#kjqtfpxse,tcvat_ybnsr_fb1#9#kjqtfpxxynse", "tcvat_ybnsr_fb1#22#kjskzzszyfpxse,tcvat_ybnsr_fb1#22#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#22#kjqtfpxse,tcvat_ybnsr_fb1#22#kjqtfpxxynse", "tcvat_ybnsr_fb1#10#kjskzzszyfpxse,tcvat_ybnsr_fb1#10#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#10#kjqtfpxse,tcvat_ybnsr_fb1#10#kjqtfpxxynse", "tcvat_ybnsr_fb1#11#kjskzzszyfpxse,tcvat_ybnsr_fb1#11#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#11#kjqtfpxse,tcvat_ybnsr_fb1#11#kjqtfpxxynse", "tcvat_ybnsr_fb1#12#kjskzzszyfpxse,tcvat_ybnsr_fb1#12#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#12#kjqtfpxse,tcvat_ybnsr_fb1#12#kjqtfpxxynse", "tcvat_ybnsr_fb1#13#kjskzzszyfpxse,tcvat_ybnsr_fb1#13#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#13#kjqtfpxse,tcvat_ybnsr_fb1#13#kjqtfpxxynse", "tcvat_ybnsr_fb1#20#kjskzzszyfpxse,tcvat_ybnsr_fb1#20#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#20#kjqtfpxse,tcvat_ybnsr_fb1#20#kjqtfpxxynse", "tcvat_ybnsr_fb1#21#kjskzzszyfpxse,tcvat_ybnsr_fb1#21#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#21#kjqtfpxse,tcvat_ybnsr_fb1#21#kjqtfpxxynse", "tcvat_ybnsr_fb1#16#kjqtfpxse", "tcvat_ybnsr_fb1#17#kjqtfpxse", "tcvat_ybnsr_fb1#18#kjskzzszyfpxse,tcvat_ybnsr_fb1#18#kjskzzszyfpxxynse,tcvat_ybnsr_fb1#18#kjqtfpxse", "tcvat_ybnsr_fb1#19#kjqtfpxse", "tcvat_ybnsr_fb2#2#fs,tcvat_ybnsr_fb2#2#je,tcvat_ybnsr_fb2#2#se", "tcvat_ybnsr_fb2#3#fs,tcvat_ybnsr_fb2#3#je,tcvat_ybnsr_fb2#3#se", "tcvat_ybnsr_fb2#5#fs,tcvat_ybnsr_fb2#5#je,tcvat_ybnsr_fb2#5#se", "tcvat_ybnsr_fb2#6#fs,tcvat_ybnsr_fb2#6#je,tcvat_ybnsr_fb2#6#se", "tcvat_ybnsr_fb2#7#fs,tcvat_ybnsr_fb2#7#se", "tcvat_ybnsr_fb2#37#se", "tcvat_ybnsr_fb2#8#fs,tcvat_ybnsr_fb2#8#je,tcvat_ybnsr_fb2#8#se", "tcvat_ybnsr_fb2#9#fs,tcvat_ybnsr_fb2#9#je,tcvat_ybnsr_fb2#9#se", "tcvat_ybnsr_fb2#10#fs,tcvat_ybnsr_fb2#10#je,tcvat_ybnsr_fb2#10#se", "tcvat_ybnsr_fb2#11#se", "tcvat_ybnsr_fb2#14#se", "tcvat_ybnsr_fb2#15#se", "tcvat_ybnsr_fb2#16#se", "tcvat_ybnsr_fb2#17#se", "tcvat_ybnsr_fb2#18#se", "tcvat_ybnsr_fb2#19#se", "tcvat_ybnsr_fb2#20#se", "tcvat_ybnsr_fb2#21#se", "tcvat_ybnsr_fb2#22#se", "tcvat_ybnsr_fb2#23a#se", "tcvat_ybnsr_fb2#23#se", "tcvat_ybnsr_fb2#25#fs,tcvat_ybnsr_fb2#25#je,tcvat_ybnsr_fb2#25#se", "tcvat_ybnsr_fb2#26#fs,tcvat_ybnsr_fb2#26#je,tcvat_ybnsr_fb2#26#se", "tcvat_ybnsr_fb2#27#fs,tcvat_ybnsr_fb2#27#je,tcvat_ybnsr_fb2#27#se", "tcvat_ybnsr_fb2#28#fs,tcvat_ybnsr_fb2#28#je,tcvat_ybnsr_fb2#28#se", "tcvat_ybnsr_fb2#30#fs,tcvat_ybnsr_fb2#30#je,tcvat_ybnsr_fb2#30#se", "tcvat_ybnsr_fb2#31#fs,tcvat_ybnsr_fb2#31#je,tcvat_ybnsr_fb2#31#se", "tcvat_ybnsr_fb2#32#fs,tcvat_ybnsr_fb2#32#je,tcvat_ybnsr_fb2#32#se", "tcvat_ybnsr_fb2#33#fs,tcvat_ybnsr_fb2#33#je,tcvat_ybnsr_fb2#33#se"));

    @Override
    public String saveData(String declareModelJson, Map<String, String> data) {
        RequestResult result;
        try {
            DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)declareModelJson, DeclareRequestModel.class);
            Map map = requestModel.getBusinessMap();
            if ("zzsybnsr".equals(requestModel.getTemplateType()) && "0".equals(map.get("declaredatatype"))) {
                this.saveZzsDeclareDate(requestModel, data);
            }
            TaxBureauServiceHelper.saveData(null, (String)"bdtaxr_taxbureau_sbb", (DeclareRequestModel)requestModel, (String)JsonUtil.toJson(data));
            result = RequestResult.success(null);
        }
        catch (Exception e) {
            result = RequestResult.ex((Throwable)e);
        }
        return SerializationUtils.toJsonString((Object)result);
    }

    @Override
    public String compare(List<Long> sbbIds) {
        RequestResult result;
        try {
            DynamicObject[] sbbDatas = BusinessDataServiceHelper.load((Object[])sbbIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdtaxr_taxbureau_sbb"));
            Arrays.stream(sbbDatas).forEach(sbb -> {
                Map data = (Map)JsonUtil.fromJson((String)sbb.getString("declaredata_tag"), Map.class);
                if (!(data.containsKey(ORG_KEY) && data.containsKey(TYPE_KEY) && data.containsKey(SKSSQQ_KEY) && data.containsKey(SKSSQZ_KEY))) {
                    sbb.set("comparestatus", (Object)"nodata");
                } else {
                    sbb.set("comparestatus", (Object)"comparing");
                }
            });
            SaveServiceHelper.save((DynamicObject[])sbbDatas);
            Arrays.stream(sbbDatas).filter(a -> "comparing".equals(a.getString("comparestatus"))).forEach(sbb -> MQSender.send((String)COMPARE_QUEUE, (String)sbb.getString("id")));
            result = RequestResult.success(null);
        }
        catch (Exception e) {
            result = RequestResult.ex((Throwable)e);
        }
        return SerializationUtils.toJsonString((Object)result);
    }

    @Override
    public String convert(List<Long> sbbIds) {
        RequestResult result;
        try {
            DynamicObject[] sbbDatas = BusinessDataServiceHelper.load((Object[])sbbIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdtaxr_taxbureau_sbb"));
            List<DynamicObject> objects = Arrays.stream(sbbDatas).filter(d -> "diff".equals(d.getString("comparestatus"))).collect(Collectors.toList());
            objects.forEach(sbb -> sbb.set("convertstatus", (Object)"converting"));
            SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
            objects.forEach(sbb -> MQSender.send((String)CONVERT_QUEUE, (String)sbb.getString("id")));
            result = RequestResult.success(null);
        }
        catch (Exception e) {
            result = RequestResult.ex((Throwable)e);
        }
        return SerializationUtils.toJsonString((Object)result);
    }

    private void saveZzsDeclareDate(DeclareRequestModel model, Map<String, String> data) {
        this.deleHis(model);
        logger.info("saveZzsDeclareDate model:{}; data:{}", (Object)SerializationUtils.toJsonString((Object)model), data);
        ArrayList<DynamicObject> save = new ArrayList<DynamicObject>(64);
        for (String key : this.ZZSSJYT47) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_declare_sjyt");
            dynamicObject.set("org", (Object)model.getOrgId());
            dynamicObject.set("skssqq", (Object)DateUtils.stringToDate2((String)model.getSkssqq()));
            dynamicObject.set("skssqz", (Object)DateUtils.stringToDate2((String)model.getSkssqz()));
            dynamicObject.set("sbbid", (Object)data.get("tcvat_nsrxx#1#id"));
            dynamicObject.set("sbbhmc", (Object)key.split(",")[0].substring(0, key.split(",")[0].lastIndexOf(35)));
            dynamicObject.set("kjskzzszyfpxse", this.getValueByKey(key, "kjskzzszyfpxse", data));
            dynamicObject.set("kjskzzszyfpxxynse", this.getValueByKey(key, "kjskzzszyfpxxynse", data));
            dynamicObject.set("kjqtfpxse", this.getValueByKey(key, "kjqtfpxse", data));
            dynamicObject.set("kjqtfpxxynse", this.getValueByKey(key, "kjqtfpxxynse", data));
            dynamicObject.set("fs", this.getValueByKey(key, "fs", data));
            dynamicObject.set("je", this.getValueByKey(key, "je", data));
            dynamicObject.set("se", this.getValueByKey(key, "se", data));
            save.add(dynamicObject);
        }
        save.add(this.getDynamicObject(model, "tcvat_sb_fjsf#1#mdse", data));
        save.add(this.getDynamicObject(model, "tcvat_ybnsr_zb#1#mdtytse", data));
        SaveServiceHelper.save((DynamicObject[])save.toArray(new DynamicObject[0]));
    }

    private void deleHis(DeclareRequestModel model) {
        QFilter filter = new QFilter("org", "=", (Object)model.getOrgId()).and("skssqz", "=", (Object)DateUtils.stringToDate2((String)model.getSkssqz()));
        int num = DeleteServiceHelper.delete((String)"tcvat_declare_sjyt", (QFilter[])new QFilter[]{filter});
        logger.info("TaxBureauDeclareServiceImpl delete num:{},model:{}", (Object)num, (Object)SerializationUtils.toJsonString((Object)model));
    }

    private Object getValueByKey(String key, String field, Map<String, String> data) {
        List<String> list = Arrays.asList(key.split(","));
        Optional<String> first = list.stream().filter(o -> o.endsWith("#" + field)).findFirst();
        if (first.isPresent()) {
            String s = first.get();
            return data.get(s);
        }
        return null;
    }

    private DynamicObject getDynamicObject(DeclareRequestModel model, String key, Map<String, String> data) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_declare_sjyt");
        dynamicObject.set("org", (Object)model.getOrgId());
        dynamicObject.set("skssqq", (Object)DateUtils.stringToDate2((String)model.getSkssqq()));
        dynamicObject.set("skssqz", (Object)DateUtils.stringToDate2((String)model.getSkssqz()));
        dynamicObject.set("sbbid", (Object)data.get("tcvat_nsrxx#1#id"));
        dynamicObject.set("sbbhmc", (Object)key.split(",")[0].substring(0, key.split(",")[0].lastIndexOf(35)));
        dynamicObject.set("se", (Object)data.get(key));
        return dynamicObject;
    }
}

